/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene;

import de.jreality.math.Rn;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.Transformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SceneGraphPath
implements Cloneable {
    protected LinkedList<SceneGraphNode> path = new LinkedList();

    public SceneGraphPath() {
    }

    public SceneGraphPath(SceneGraphPath path) {
        this();
        this.path.addAll(path.path);
    }

    public SceneGraphPath(SceneGraphNode ... nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            this.push(nodes[i]);
        }
    }

    public static SceneGraphPath fromList(List<SceneGraphNode> list) {
        SceneGraphPath path = new SceneGraphPath();
        path.path.addAll(list);
        return path;
    }

    public String toString() {
        if (this.path.isEmpty()) {
            return "<< empty path >>";
        }
        StringBuffer sb = new StringBuffer();
        int n = this.path.size();
        for (int ix = 0; ix < n; ++ix) {
            sb.append(this.path.get(ix).getName()).append(" : ");
        }
        sb.setLength(sb.length() - 3);
        return sb.toString();
    }

    public Object clone() {
        SceneGraphPath path = new SceneGraphPath();
        path.path.addAll(this.path);
        return path;
    }

    public List<SceneGraphNode> toList() {
        return new ArrayList<SceneGraphNode>(this.path);
    }

    public ListIterator<SceneGraphNode> iterator() {
        return Collections.unmodifiableList(this.path).listIterator();
    }

    public ListIterator<SceneGraphNode> iterator(int start) {
        return Collections.unmodifiableList(this.path).listIterator(start);
    }

    public Iterator<SceneGraphNode> reverseIterator(int start) {
        final ListIterator<SceneGraphNode> iter = this.iterator(start);
        return new Iterator<SceneGraphNode>(){

            @Override
            public void remove() {
                iter.remove();
            }

            @Override
            public boolean hasNext() {
                return iter.hasPrevious();
            }

            @Override
            public SceneGraphNode next() {
                return (SceneGraphNode)iter.previous();
            }
        };
    }

    public Iterator<SceneGraphNode> reverseIterator() {
        return this.reverseIterator(this.path.size());
    }

    public int getLength() {
        return this.path.size();
    }

    public final void push(SceneGraphNode c) {
        this.path.add(c);
    }

    public final SceneGraphPath pushNew(SceneGraphNode c) {
        SceneGraphPath ret = SceneGraphPath.fromList(this.path);
        ret.push(c);
        return ret;
    }

    public final void pop() {
        this.path.removeLast();
    }

    public final SceneGraphPath popNew() {
        SceneGraphPath ret = SceneGraphPath.fromList(this.path);
        ret.path.removeLast();
        return ret;
    }

    public boolean contains(SceneGraphNode n) {
        return this.path.contains(n);
    }

    public SceneGraphNode getFirstElement() {
        return this.path.getFirst();
    }

    public SceneGraphNode getLastElement() {
        return this.path.getLast();
    }

    public SceneGraphComponent getLastComponent() {
        if (!(this.path.getLast() instanceof SceneGraphComponent)) {
            return (SceneGraphComponent)this.path.get(this.path.size() - 2);
        }
        return (SceneGraphComponent)this.path.getLast();
    }

    public void clear() {
        this.path.clear();
    }

    public SceneGraphNode get(int n) {
        return this.path.get(n);
    }

    public void replace(SceneGraphNode old, SceneGraphNode nnew) {
        int index = this.path.indexOf(old);
        if (index == -1) {
            throw new IllegalArgumentException("no such node in path: " + old.getName());
        }
        this.path.remove(index);
        this.path.add(index, nnew);
    }

    public void insertAfter(SceneGraphNode toInsert, SceneGraphNode exists) {
        int index = this.path.indexOf(exists);
        if (index == -1) {
            throw new IllegalArgumentException("no such node in path: " + exists.getName());
        }
        if (index < this.path.size() - 1) {
            this.path.add(index + 1, toInsert);
        } else {
            this.path.addLast(toInsert);
        }
    }

    public boolean isValid() {
        if (this.path.size() == 0) {
            return true;
        }
        Iterator i = this.path.iterator();
        SceneGraphNode parent = (SceneGraphNode)i.next();
        if (!(parent instanceof SceneGraphComponent)) {
            return false;
        }
        try {
            while (i.hasNext()) {
                SceneGraphNode child = (SceneGraphNode)i.next();
                if (!((SceneGraphComponent)parent).isDirectAncestor(child)) {
                    return false;
                }
                if (!i.hasNext()) continue;
                parent = child;
            }
        }
        catch (ClassCastException cce) {
            return false;
        }
        return true;
    }

    public boolean equals(Object p) {
        if (p instanceof SceneGraphPath) {
            return this.isEqual((SceneGraphPath)p);
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        for (SceneGraphNode element : this.path) {
            result = 31 * result + element.hashCode();
        }
        return result;
    }

    public boolean isEqual(SceneGraphPath anotherPath) {
        if (anotherPath == null || this.path.size() != anotherPath.getLength()) {
            return false;
        }
        for (int i = 0; i < this.path.size(); ++i) {
            if (this.path.get(i).equals(anotherPath.path.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(SceneGraphPath potentialPrefix) {
        if (this.getLength() < potentialPrefix.getLength()) {
            return false;
        }
        ListIterator<SceneGraphNode> i1 = this.iterator();
        ListIterator<SceneGraphNode> i2 = potentialPrefix.iterator();
        while (i2.hasNext()) {
            if (i1.next() == i2.next()) continue;
            return false;
        }
        return true;
    }

    public double[] getMatrix(double[] aMatrix) {
        return this.getMatrix(aMatrix, 0, this.path.size() - 1);
    }

    public double[] getMatrix(double[] aMatrix, int begin) {
        return this.getMatrix(aMatrix, begin, this.path.size() - 1);
    }

    public double[] getInverseMatrix(double[] invMatrix) {
        return this.getInverseMatrix(invMatrix, 0, this.path.size() - 1);
    }

    public double[] getInverseMatrix(double[] invMatrix, int begin) {
        return this.getInverseMatrix(invMatrix, begin, this.path.size() - 1);
    }

    public double[] getMatrix(double[] aMatrix, int begin, int end) {
        double[] myMatrix = aMatrix == null ? new double[16] : aMatrix;
        Rn.setIdentityMatrix(myMatrix);
        ListIterator<SceneGraphNode> it = this.path.listIterator(begin);
        while (it.nextIndex() <= end) {
            SceneGraphComponent currComp;
            Transformation tt;
            SceneGraphNode currObj = it.next();
            if (!(currObj instanceof SceneGraphComponent) || (tt = (currComp = (SceneGraphComponent)currObj).getTransformation()) == null) continue;
            Rn.times(myMatrix, myMatrix, tt.getMatrix());
        }
        return myMatrix;
    }

    public double[] getInverseMatrix(double[] aMatrix, int begin, int end) {
        double[] mat = this.getMatrix(aMatrix, begin, end);
        return Rn.inverse(mat, mat);
    }
}

