/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene;

import de.jreality.scene.Lock;
import de.jreality.scene.SceneGraphVisitor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SceneGraphNode {
    private final transient Lock nodeLock = new Lock();
    private boolean readOnly;
    private String name;
    private Object owner = null;
    private static boolean threadsafe = true;

    public SceneGraphNode(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadOnly() {
        this.startReader();
        try {
            boolean bl = this.readOnly;
            return bl;
        }
        finally {
            this.finishReader();
        }
    }

    public void setReadOnly(boolean newReadOnlyState) {
        this.startWriter();
        this.readOnly = newReadOnlyState;
        this.finishWriter();
    }

    protected final void checkReadOnly() {
        if (this.readOnly) {
            throw new IllegalStateException("readOnly");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        this.nodeLock.readLock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            this.nodeLock.readUnlock();
        }
    }

    public void setName(String string) {
        this.checkReadOnly();
        this.nodeLock.writeLock();
        this.name = string;
        this.nodeLock.writeUnlock();
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    protected final void startWriter() {
        this.nodeLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finishWriter() {
        if (!this.nodeLock.canSwitch()) {
            this.nodeLock.writeUnlock();
            return;
        }
        this.nodeLock.switchToReadLock();
        try {
            this.writingFinished();
        }
        finally {
            this.nodeLock.readUnlock();
        }
    }

    protected void writingFinished() {
    }

    protected final void startReader() {
        if (!threadsafe) {
            return;
        }
        this.nodeLock.readLock();
    }

    protected final void finishReader() {
        if (!threadsafe) {
            return;
        }
        this.nodeLock.readUnlock();
    }

    public void accept(SceneGraphVisitor v) {
        v.visit(this);
    }

    public String toString() {
        return this.getName() + " [" + this.getClass().getName() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toStringImpl(StringBuffer sb, HashSet<SceneGraphNode> trace) {
        trace.add(this);
        this.nodeLock.readLock();
        try {
            Class<?> idClass = this.getClass();
            sb.append(idClass.getName()).append('[');
            for (Class<?> cl = idClass; cl != null; cl = cl.getSuperclass()) {
                AccessibleObject[] f = cl.getDeclaredFields();
                AccessibleObject.setAccessible(f, true);
                int n = f.length;
                for (int i = 0; i < n; ++i) {
                    try {
                        Object value;
                        AccessibleObject field = f[i];
                        if (Modifier.isStatic(((Field)field).getModifiers()) || Modifier.isTransient(((Field)field).getModifiers()) || trace.contains(value = ((Field)field).get(this))) continue;
                        sb.append(((Field)field).getName()).append(" = ");
                        if (value instanceof SceneGraphNode) {
                            ((SceneGraphNode)value).toStringImpl(sb, trace);
                        } else {
                            sb.append(value);
                        }
                        sb.append(", ");
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        // empty catch block
                    }
                }
            }
            int l = sb.length();
            if (sb.charAt(l - 1) == ' ' && sb.charAt(l - 2) == ',') {
                sb.setLength(l - 2);
            }
            sb.append(']');
            trace.remove(this);
        }
        finally {
            this.nodeLock.readUnlock();
        }
    }

    public static void setThreadSafe(boolean b) {
        threadsafe = b;
    }

    public static boolean getThreadSafe() {
        return threadsafe;
    }
}

