/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene;

import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DataListSet;

public class IndexedFaceSet
extends IndexedLineSet {
    private static int UNNAMED_ID;
    protected DataListSet faceAttributes;

    public IndexedFaceSet(int numVertices, int numFaces) {
        this("face-set " + UNNAMED_ID++, numVertices, numFaces);
    }

    public IndexedFaceSet(String name, int numVertices, int numFaces) {
        super(name, numVertices);
        this.faceAttributes = new DataListSet(numFaces);
        this.geometryAttributeCategory.put("FACE", this.faceAttributes);
    }

    public IndexedFaceSet() {
        this("face-set " + UNNAMED_ID++);
    }

    public IndexedFaceSet(String name) {
        this(name, 0, 0);
    }

    public int getNumFaces() {
        return this.getNumEntries(this.faceAttributes);
    }

    public void setNumFaces(int numFaces) {
        this.setNumEntries(this.faceAttributes, numFaces);
    }

    public DataListSet getFaceAttributes() {
        return this.getAttributes(this.faceAttributes);
    }

    public DataList getFaceAttributes(Attribute attr) {
        return this.getAttributes(this.faceAttributes, attr);
    }

    public void setFaceAttributes(DataListSet dls) {
        this.setAttributes("FACE", this.faceAttributes, dls);
    }

    public void setFaceAttributes(Attribute attr, DataList dl) {
        this.setAttributes("FACE", this.faceAttributes, attr, dl);
    }

    public void setFaceCountAndAttributes(Attribute attr, DataList dl) {
        this.setCountAndAttributes("FACE", this.faceAttributes, attr, dl);
    }

    public void setFaceCountAndAttributes(DataListSet dls) {
        this.setCountAndAttributes("FACE", this.faceAttributes, dls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(SceneGraphVisitor v) {
        this.startReader();
        try {
            v.visit(this);
        }
        finally {
            this.finishReader();
        }
    }

    static void superAccept(IndexedFaceSet ifs, SceneGraphVisitor v) {
        ifs.superAccept(v);
    }

    private void superAccept(SceneGraphVisitor v) {
        super.accept(v);
    }
}

