/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene;

import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.data.SampleReader;
import de.jreality.scene.event.AudioEvent;
import de.jreality.scene.event.AudioEventMulticaster;
import de.jreality.scene.event.AudioListener;

public abstract class AudioSource
extends SceneGraphNode {
    protected transient AudioListener audioListener = null;
    protected transient Boolean hasChanged = false;
    protected State state = State.STOPPED;

    public AudioSource(String name) {
        super(name);
    }

    public abstract SampleReader createReader();

    protected void reset() {
    }

    public void setState(State state) {
        switch (state) {
            case RUNNING: {
                this.start();
                break;
            }
            case PAUSED: {
                this.pause();
                break;
            }
            case STOPPED: {
                this.stop();
                break;
            }
        }
    }

    public State getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.startWriter();
        try {
            if (this.state != State.RUNNING) {
                this.state = State.RUNNING;
                this.hasChanged = true;
            }
        }
        finally {
            this.finishWriter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.startWriter();
        try {
            if (this.state != State.STOPPED) {
                this.state = State.STOPPED;
                this.reset();
                this.hasChanged = true;
            }
        }
        finally {
            this.finishWriter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        this.startWriter();
        try {
            if (this.state != State.PAUSED) {
                this.state = State.PAUSED;
                this.hasChanged = true;
            }
        }
        finally {
            this.finishWriter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(SceneGraphVisitor v) {
        this.startReader();
        try {
            v.visit(this);
        }
        finally {
            this.finishReader();
        }
    }

    static void superAccept(AudioSource a, SceneGraphVisitor v) {
        a.superAccept(v);
    }

    private void superAccept(SceneGraphVisitor v) {
        super.accept(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAudioListener(AudioListener listener) {
        this.startReader();
        try {
            this.audioListener = AudioEventMulticaster.add(this.audioListener, listener);
        }
        finally {
            this.finishReader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAudioListener(AudioListener listener) {
        this.startReader();
        try {
            this.audioListener = AudioEventMulticaster.remove(this.audioListener, listener);
        }
        finally {
            this.finishReader();
        }
    }

    protected void writingFinished() {
        if (this.hasChanged.booleanValue() && this.audioListener != null) {
            this.audioListener.audioChanged(new AudioEvent(this));
        }
        this.hasChanged = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        RUNNING,
        STOPPED,
        PAUSED;

    }
}

