/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.renderman.shader;

import de.jreality.math.Rn;
import de.jreality.renderman.RIBVisitor;
import de.jreality.renderman.shader.DefaultPolygonShader;
import de.jreality.shader.EffectiveAppearance;
import java.awt.Color;

public class RopePolygonShader
extends DefaultPolygonShader {
    Color band1color = new Color(1.0f, 1.0f, 1.0f);
    Color band2color = new Color(0.8f, 0.8f, 0.8f);
    Color shadowcolor = new Color(0.0f, 0.0f, 0.0f);
    Color gapcolor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    Color blendcolor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    double bandwidth;
    double shadowwidth;
    double blendfactor;
    double gapalpha;
    double[] textureMatrix = Rn.identityMatrix(4);

    public RopePolygonShader(de.jreality.shader.DefaultPolygonShader attent) {
        super(attent);
    }

    public void setFromEffectiveAppearance(RIBVisitor ribv, EffectiveAppearance eap, String name) {
        super.setFromEffectiveAppearance(ribv, eap, name);
        this.shaderName = "ropeshader";
        this.bandwidth = eap.getAttribute(name + "." + "bandwidth", 0.7);
        this.shadowwidth = eap.getAttribute(name + "." + "shadowwidth", 0.12);
        this.blendfactor = eap.getAttribute(name + "." + "blendfactor", 1.0);
        this.gapalpha = eap.getAttribute(name + "." + "gapalpha", 0.0);
        this.band1color = (Color)eap.getAttribute(name + "." + "band1color", this.band1color);
        this.band2color = (Color)eap.getAttribute(name + "." + "band2color", this.band2color);
        this.shadowcolor = (Color)eap.getAttribute(name + "." + "shadowcolor", this.shadowcolor);
        this.gapcolor = (Color)eap.getAttribute(name + "." + "gapcolor", this.gapcolor);
        this.blendcolor = (Color)eap.getAttribute(name + "." + "blendcolor", this.blendcolor);
        this.textureMatrix = (double[])eap.getAttribute(name + "." + "textureMatrix", this.textureMatrix);
        this.map.put("bandwidth", new Float((float)this.bandwidth));
        this.map.put("shadowwidth", new Float((float)this.shadowwidth));
        this.map.put("blendfactor", new Float((float)this.blendfactor));
        this.map.put("gapalpha", new Float((float)this.gapalpha));
        this.map.put("band1color", this.band1color);
        this.map.put("band2color", this.band2color);
        this.map.put("shadowcolor", this.shadowcolor);
        this.map.put("gapcolor", this.gapcolor);
        this.map.put("blendcolor", this.blendcolor);
        this.map.put("textureMatrix", this.textureMatrix);
        this.map.remove("string texturename");
    }
}

