/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.renderman;

import de.jreality.geometry.BallAndStickFactory;
import de.jreality.geometry.GeometryUtility;
import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.geometry.IndexedLineSetUtility;
import de.jreality.geometry.PolygonalTubeFactory;
import de.jreality.geometry.TubeUtility;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.P3;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.renderman.LightCollector;
import de.jreality.renderman.RIBHelper;
import de.jreality.renderman.RenderScript;
import de.jreality.renderman.RendermanSkyBox;
import de.jreality.renderman.Ri;
import de.jreality.renderman.shader.SLShader;
import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.ClippingPlane;
import de.jreality.scene.Cylinder;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.Sphere;
import de.jreality.scene.Transformation;
import de.jreality.scene.Viewer;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.StorageModel;
import de.jreality.scene.pick.Graphics3D;
import de.jreality.shader.CommonAttributes;
import de.jreality.shader.CubeMap;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.DefaultPointShader;
import de.jreality.shader.DefaultPolygonShader;
import de.jreality.shader.DefaultTextShader;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ImageData;
import de.jreality.shader.PointShader;
import de.jreality.shader.PolygonShader;
import de.jreality.shader.RenderingHintsShader;
import de.jreality.shader.RootAppearance;
import de.jreality.shader.ShaderUtility;
import de.jreality.shader.Texture2D;
import de.jreality.util.CameraUtility;
import de.jreality.util.LoggingSystem;
import de.jreality.util.SceneGraphUtility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class RIBVisitor
extends SceneGraphVisitor {
    private SceneGraphComponent root;
    private SceneGraphPath cameraPath;
    protected transient double[] world2Camera;
    protected transient double[] object2worldTrafo;
    protected transient SceneGraphPath object2world = new SceneGraphPath();
    protected transient Graphics3D context;
    private transient Camera camera;
    private transient int width = 640;
    private transient int height = 480;
    private transient String ribFileName;
    private transient int[] maximumEyeSplits = new int[]{10};
    protected transient boolean shadowEnabled = false;
    private transient boolean fogEnabled = false;
    protected transient boolean fullSpotLight = false;
    protected transient boolean retainGeometry = false;
    protected transient boolean useProxyCommands = true;
    protected transient boolean useOldTransparency = false;
    protected transient Color cs = null;
    protected transient boolean opaqueTubes = false;
    protected transient boolean smooth = true;
    protected transient boolean drawSpheres = true;
    protected transient boolean drawTubes = true;
    protected transient float tubeRadius = 0.1f;
    protected transient float pointRadius = 0.1f;
    private transient boolean writeShadersToFile = true;
    private transient boolean hasPw = false;
    private transient String globalIncludeFile = "";
    private transient int rendererType = 1;
    private transient int currentMetric = 0;
    private transient String outputDisplayFormat = "rgb";
    protected transient String textureFileSuffix = "tex";
    protected transient boolean handlingProxyGeometry = false;
    transient String currentProxyCommand = null;
    transient SceneGraphComponent currentProxySGC = null;
    protected transient String shaderPath = null;
    public transient EffectiveAppearance eAppearance = EffectiveAppearance.create();
    private transient int textureCount = 0;
    private transient Map<ImageData, String> textures = new HashMap<ImageData, String>();
    private transient Hashtable<SceneGraphComponent, String> archivedSGCTable = new Hashtable();
    private transient Hashtable<PointSet, String> archivedPSTable = new Hashtable();
    private transient Hashtable<IndexedLineSet, String> archivedILSTable = new Hashtable();
    private transient Hashtable<IndexedFaceSet, String> archivedIFSTable = new Hashtable();
    transient int archiveCount = 0;
    protected transient Ri ri = new Ri();
    transient int whichEye = 0;
    private boolean raytracedReflectionsEnabled;
    private boolean raytracedVolumesEnabled;
    RenderScript renderScript;
    private float currentOpacity;
    private Appearance rootAppearance;
    private String outputFileName;
    protected boolean transparencyEnabled;
    protected boolean ignoreAlpha0 = true;
    private int cubeMapCount;
    private String cubeMapFileSuffix = "env";
    protected DefaultGeometryShader dgs;
    protected RenderingHintsShader rhs;
    private HashMap<ImageData, String> cubeMaps = new HashMap();
    private double[] zFlipMatrix;
    transient boolean insidePointset = false;
    float[] raw = new float[4];

    public void visit(Viewer viewer, String name) {
        this.ribFileName = name;
        if (!this.ribFileName.endsWith(".rib")) {
            this.ribFileName = this.ribFileName + ".rib";
        }
        File ribF = new File(this.ribFileName);
        File dir = ribF.getParentFile();
        this.renderScript = new RenderScript(dir, ribF.getName(), this.rendererType);
        this.renderScript.addShader("defaultpolygonshader.sl");
        this.renderScript.addShader("twosidepolygonshader.sl");
        this.renderScript.addShader("constantTexture.sl");
        int index = this.ribFileName.lastIndexOf(File.separatorChar);
        this.outputFileName = this.ribFileName.substring(index + 1, this.ribFileName.length() - 3) + "tif";
        this.root = viewer.getSceneRoot();
        this.cameraPath = viewer.getCameraPath();
        this.camera = CameraUtility.getCamera(viewer);
        this.rootAppearance = this.root.getAppearance();
        if (this.rootAppearance == null) {
            this.rootAppearance = new Appearance();
        }
        this.eAppearance = EffectiveAppearance.create();
        this.eAppearance = this.eAppearance.create(this.rootAppearance);
        this.context = new Graphics3D(this.cameraPath, this.object2world, (double)this.width / (double)this.height);
        this.world2Camera = this.cameraPath.getInverseMatrix(null);
        if (this.writeShadersToFile) {
            RIBVisitor.writeStandardShaders(this.ribFileName);
        }
        if (this.rootAppearance != null) {
            this.handleRootAppearance();
        }
        this.ri.begin(this.ribFileName);
        if (this.camera.isStereo()) {
            this.whichEye = 1;
            index = this.ribFileName.lastIndexOf(File.separator);
            this.outputFileName = this.ribFileName.substring(index + 1, this.ribFileName.length() - 4) + "L.tif";
            this.ri.frameBegin(0);
            this.render();
            this.ri.frameEnd();
            this.whichEye = 2;
            this.outputFileName = this.ribFileName.substring(index + 1, this.ribFileName.length() - 4) + "R.tif";
            this.ri.frameBegin(1);
            this.render();
            this.ri.frameEnd();
        } else {
            this.render();
        }
        this.ri.end();
        this.renderScript.finishScript();
    }

    private void render() {
        this.handleGlobalSettings();
        this.ri.clipping(this.camera.getNear(), this.camera.getFar() > 0.0 ? this.camera.getFar() : 1000.0);
        this.ri.depthOfField(this.camera.getFStop(), this.camera.getFocalLength(), this.camera.getFocus());
        boolean testCameraExplicit = false;
        double aspectRatio = (double)this.width / (double)this.height;
        this.zFlipMatrix = MatrixBuilder.euclidean().scale(1.0, 1.0, -1.0).getArray();
        if (testCameraExplicit) {
            this.ri.transform(RIBHelper.fTranspose(this.zFlipMatrix));
            this.ri.comment("Home-grown camera transformation");
            double[] c2ndc = CameraUtility.getCameraToNDC(this.camera, 1.0, this.currentMetric);
            this.ri.concatTransform(RIBHelper.fTranspose(c2ndc));
        } else if (this.camera.isStereo()) {
            double[] eyeP = CameraUtility.getEyePosition(this.camera, this.whichEye);
            Rectangle2D vp = CameraUtility.getOffAxisViewPort(this.camera, CameraUtility.getViewport(this.camera, aspectRatio), eyeP);
            this.ri.comment("Testing left eye stereo");
            this.ri.projection(this.camera.isPerspective() ? "perspective" : "orthographic", null);
            this.ri.screenWindow(vp);
            this.ri.concatTransform(RIBHelper.fTranspose(this.zFlipMatrix));
            double[] moveToEye = Rn.inverse(null, P3.makeTranslationMatrix(null, eyeP, this.currentMetric));
            this.ri.concatTransform(RIBHelper.fTranspose(moveToEye));
        } else {
            HashMap<String, Float> map = new HashMap<String, Float>();
            float fov = (float)this.camera.getFieldOfView();
            float a = 1.0f;
            if (this.camera.isPerspective()) {
                map.put("fov", new Float(fov));
                this.ri.projection("perspective", map);
            } else {
                this.ri.projection("orthographic", map);
                a = (float)(1.0 / (Math.tan(Math.PI / 180 * this.camera.getFieldOfView() / 2.0) * this.camera.getFocus()));
                this.ri.concatTransform(new float[]{a, 0.0f, 0.0f, 0.0f, 0.0f, a, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
            }
            this.ri.concatTransform(RIBHelper.fTranspose(this.zFlipMatrix));
        }
        if (this.whichEye == 1) {
            this.ri.archiveBegin("world");
        } else if (this.whichEye == 2) {
            this.ri.readArchive("world");
            return;
        }
        new LightCollector(this.root, this);
        this.ri.comment("world to camera");
        this.ri.concatTransform(RIBHelper.fTranspose(this.world2Camera));
        this.processClippingPlanes();
        this.ri.worldBegin();
        if (this.outputDisplayFormat != "rgba") {
            this.handleBackground();
        }
        this.handleFog();
        this.root.accept(this);
        this.ri.worldEnd();
        if (this.whichEye == 1) {
            this.ri.archiveEnd();
            this.ri.readArchive("world");
        }
    }

    private void handleRootAppearance() {
        this.maximumEyeSplits[0] = (Integer)this.eAppearance.getAttribute("rendermanMaxEyeSplits", new Integer(this.maximumEyeSplits[0]));
        this.shaderPath = (String)this.eAppearance.getAttribute("rendermanSearchpathShader", "");
        this.textureFileSuffix = (String)this.eAppearance.getAttribute("rendermanTextureFileSuffix", "tex");
        this.shadowEnabled = this.eAppearance.getAttribute("rendermanShadowsEnabled", false);
        this.raytracedReflectionsEnabled = this.eAppearance.getAttribute("rendermanRayTracingReflectionsEnabled", false);
        this.raytracedVolumesEnabled = this.eAppearance.getAttribute("rendermanRayTracingVolumesEnabled", false);
        this.currentMetric = this.eAppearance.getAttribute("metric", 0);
        this.outputDisplayFormat = (String)this.eAppearance.getAttribute("rendermanOutputDisplayFormat", "rgb");
        this.globalIncludeFile = (String)this.eAppearance.getAttribute("rendermanGlobalIncludeFile", "");
        this.useOldTransparency = this.eAppearance.getAttribute("useOldTransparency", false);
        if (!this.globalIncludeFile.equals("")) {
            System.err.println("Preamble is " + this.globalIncludeFile);
        }
        this.fogEnabled = this.eAppearance.getAttribute("fogEnabled", false);
    }

    private void handleGlobalSettings() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shader", ("".equals(this.shaderPath) ? "" : this.shaderPath + ":") + ".:&");
        this.ri.option("searchpath", map);
        map.clear();
        map.put("eyesplits", this.maximumEyeSplits);
        this.ri.option("limits", map);
        this.ri.display(new File(this.outputFileName).getName(), "tiff", this.outputDisplayFormat, null);
        this.ri.format(this.width, this.height, 1.0f);
        this.ri.shadingRate(1.0f);
        if (this.shadowEnabled) {
            if (this.rendererType == 2) {
                this.ri.verbatim("Attribute \"visibility\"  \"string transmission\" \"shader\"");
            } else {
                this.ri.verbatim("Attribute \"visibility\"  \"int transmission\" [1]");
                this.ri.verbatim("Option \"trace\"  \"int maxdepth\" [2]");
            }
        }
        if (this.raytracedReflectionsEnabled || this.raytracedVolumesEnabled) {
            if (this.rendererType == 2) {
                this.ri.verbatim("Attribute \"visibility\"  \"integer trace\" [1]");
                this.ri.verbatim("Attribute \"visibility\"  \"string diffuse\" \"shader\"");
                this.ri.verbatim("Attribute \"visibility\"  \"string specular\" \"shader\"");
                this.ri.verbatim("Option \"trace\"  \"integer maxdepth\" [2]");
            } else {
                this.ri.verbatim("Attribute \"visibility\"  \"int diffuse\" [1]");
                this.ri.verbatim("Attribute \"visibility\"  \"int specular\" [1]");
                this.ri.verbatim("Option \"trace\"  \"int maxdepth\" [2]");
            }
        }
        if (this.globalIncludeFile != "") {
            this.ri.readArchive(this.globalIncludeFile);
        }
    }

    private void handleBackground() {
        HashMap map = new HashMap();
        Appearance ap = this.root.getAppearance();
        this.updateShaders(this.eAppearance);
        if (ap != null) {
            if (AttributeEntityUtility.hasAttributeEntity(CubeMap.class, "skyBox", ap)) {
                CubeMap cm = (CubeMap)AttributeEntityUtility.createAttributeEntity(CubeMap.class, "skyBox", ap, true);
                RendermanSkyBox.render(this, this.world2Camera, cm);
            } else {
                Color[] clrs = new Color[1];
                Object o = this.eAppearance.getAttribute("backgroundColors", Appearance.DEFAULT, clrs.getClass());
                if (o != Appearance.DEFAULT && o instanceof Color[]) {
                    clrs = (Color[])o;
                    double sx = this.eAppearance.getAttribute("backgroundColorsStretchX", 1.0);
                    double sy = this.eAppearance.getAttribute("backgroundColorsStretchY", 1.0);
                    this.handleBackgroundColors(clrs, sx, sy, this.camera, this.cameraPath.getMatrix(null));
                } else {
                    Color clr = (Color)this.eAppearance.getAttribute("backgroundColor", CommonAttributes.BACKGROUND_COLOR_DEFAULT);
                    float[] f = clr.getRGBColorComponents(null);
                    clrs = new Color[4];
                    for (int i = 0; i < 4; ++i) {
                        clrs[i] = new Color(f[0], f[1], f[2]);
                    }
                    this.handleBackgroundColors(clrs, 1.0, 1.0, this.camera, this.cameraPath.getMatrix(null));
                }
            }
        }
    }

    private void handleBackgroundColors(Color[] colors, double sx, double sy, Camera camera, double[] w2c) {
        Rectangle2D vp = CameraUtility.getViewport(camera, (double)this.width / (double)this.height);
        double z = camera.getFar() - 0.001;
        double xmin = sx * vp.getMinX();
        double xmax = sx * vp.getMaxX();
        double ymin = sy * vp.getMinY();
        double ymax = sy * vp.getMaxY();
        double[][] pts = new double[][]{{z * xmin, z * ymin, -z}, {z * xmax, z * ymin, -z}, {z * xmax, z * ymax, -z}, {z * xmin, z * ymax, -z}};
        double[][] cd = new double[4][3];
        for (int i = 0; i < 4; ++i) {
            float[] foo = colors[i].getRGBComponents(null);
            for (int j = 0; j < 3; ++j) {
                cd[(i + 2) % 4][j] = foo[j];
            }
        }
        IndexedFaceSet bkgd = IndexedFaceSetUtility.constructPolygon(pts);
        bkgd.setVertexAttributes(Attribute.COLORS, StorageModel.DOUBLE_ARRAY.array(3).createReadOnly(cd));
        this.ri.attributeBegin();
        this.ri.concatTransform(RIBHelper.fTranspose(w2c));
        this.ri.comment("Disable shadows for background");
        if (this.rendererType == 2) {
            this.ri.verbatim("Attribute \"visibility\"  \"string transmission\" \"transparent\"");
        } else {
            this.ri.verbatim("Attribute \"visibility\"  \"int transmission\" [0]");
        }
        this.ri.surface("constant", null);
        this.pointPolygon(bkgd, null);
        this.ri.attributeEnd();
    }

    private static void writeStandardShaders(String name) {
        RIBHelper.writeShader(name, "defaultpolygonshader.sl");
        RIBHelper.writeShader(name, "twosidepolygonshader.sl");
        RIBHelper.writeShader(name, "noneuclideanpolygonshader.sl");
        RIBHelper.writeShader(name, "noneuclideanlight.sl");
        RIBHelper.writeShader(name, "constantTexture.sl");
    }

    private void handleFog() {
        Object obj = this.eAppearance.getAttribute("rendermanVolumeAtmosphereShader", Appearance.INHERITED, SLShader.class);
        if (obj != Appearance.INHERITED) {
            SLShader slShader = (SLShader)obj;
            this.ri.atmosphere(slShader.getName(), slShader.getParameters());
            return;
        }
        if (!this.fogEnabled) {
            return;
        }
        HashMap<String, Serializable> fogMap = new HashMap<String, Serializable>();
        obj = this.eAppearance.getAttribute("fogColor", Appearance.INHERITED);
        Color fogcolor = obj == Appearance.INHERITED ? (Color)this.eAppearance.getAttribute("backgroundColor", RootAppearance.BACKGROUND_COLOR_DEFAULT) : (Color)obj;
        fogMap.put("background", fogcolor);
        fogMap.put("distance", new Float(1.0 / this.eAppearance.getAttribute("fogDensity", 0.1)));
        this.ri.atmosphere("fog", fogMap);
        this.ri.exterior("fog", fogMap);
    }

    private void processClippingPlanes() {
        List<SceneGraphPath> clipPlanes = SceneGraphUtility.collectClippingPlanes(this.root);
        int n = clipPlanes.size();
        for (int i = 0; i < n; ++i) {
            SceneGraphPath lp = clipPlanes.get(i);
            SceneGraphNode cp = lp.getLastElement();
            if (!(cp instanceof ClippingPlane)) {
                LoggingSystem.getLogger(RIBHelper.class).log(Level.WARNING, "Invalid clipplane class " + cp.getClass().toString());
                continue;
            }
            double[] mat = lp.getMatrix(null);
            Matrix m = new Matrix(mat);
            double[] point = m.getColumn(3);
            double[] point3 = new double[3];
            double[] normal = m.getColumn(2);
            double[] normal3 = new double[3];
            Pn.dehomogenize(point3, point);
            Pn.dehomogenize(normal3, normal);
            Rn.times(normal3, -1.0, Pn.dehomogenize(normal3, normal));
            this.ri.clippingPlane((float)normal3[0], (float)normal3[1], (float)normal3[2], (float)point3[0], (float)point3[1], (float)point3[2]);
        }
    }

    public void visit(SceneGraphComponent c) {
        if (!c.isVisible()) {
            return;
        }
        Appearance a = c.getAppearance();
        boolean archive = false;
        String archiveName = null;
        if (a != null) {
            Object obj = a.getAttribute("rendermanArchiveCurrentNode", Boolean.class);
            if (obj instanceof Boolean) {
                archive = (Boolean)obj;
            }
            if (archive) {
                String which = this.archivedSGCTable.get(c);
                if (which != null) {
                    this.ri.readArchive(which);
                    return;
                }
                this.ri.comment("Retained SGC " + c.getName());
                archiveName = c.getName() + this.archiveCount;
                this.ri.archiveBegin(archiveName);
            }
        }
        EffectiveAppearance tmp = this.eAppearance;
        this.ri.attributeBegin(c.getName());
        if (a != null) {
            this.eAppearance = this.eAppearance.create(a);
        }
        this.readAttributesFromEffectiveAppearance(this.eAppearance);
        this.object2world.push(c);
        this.object2world.getMatrix(this.object2worldTrafo);
        if (this.hasProxy(c)) {
            RIBHelper.processShader(this.dgs.getPolygonShader(), this, "polygonShader");
            this.handleCurrentProxy();
        } else {
            c.childrenAccept(this);
        }
        this.object2world.pop();
        this.ri.attributeEnd(c.getName());
        if (archive) {
            this.ri.archiveEnd();
            this.ri.readArchive(archiveName);
            this.archivedSGCTable.put(c, archiveName);
            ++this.archiveCount;
        }
        this.eAppearance = tmp;
        this.readAttributesFromEffectiveAppearance(this.eAppearance);
    }

    public void visit(Transformation t) {
        double[] mat = t.getMatrix();
        boolean isIdentity = Rn.isIdentityMatrix(t.getMatrix(), 1.0E-7);
        if (!isIdentity) {
            this.ri.concatTransform(RIBHelper.fTranspose(mat));
        }
    }

    public void visit(Appearance a) {
    }

    private void readAttributesFromEffectiveAppearance(EffectiveAppearance eap) {
        SLShader slShader;
        Map m = (Map)eap.getAttribute("rendermanAttribute", null, Map.class);
        if (m != null) {
            for (String key : m.keySet()) {
                this.ri.attribute(key, (Map)m.get(key));
            }
        }
        this.updateShaders(eap);
        this.currentMetric = eap.getAttribute("metric", 0);
        this.retainGeometry = eap.getAttribute("rendermanRetainGeometry", false);
        this.opaqueTubes = this.rhs.getOpaqueTubesAndSpheres();
        this.transparencyEnabled = this.rhs.getTransparencyEnabled();
        this.ignoreAlpha0 = this.rhs.getIgnoreAlpha0();
        Object obj = eap.getAttribute("rendermanDisplacementShader", Appearance.INHERITED, SLShader.class);
        if (obj != Appearance.INHERITED) {
            slShader = (SLShader)obj;
            this.ri.displacement(slShader.getName(), slShader.getParameters());
        }
        if ((obj = eap.getAttribute("rendermanImagerShader", Appearance.INHERITED, SLShader.class)) != Appearance.INHERITED) {
            slShader = (SLShader)obj;
            this.ri.imager(slShader.getName(), slShader.getParameters());
        }
        if ((obj = eap.getAttribute("rendermanVolumeExteriorShader", Appearance.INHERITED, SLShader.class)) != Appearance.INHERITED) {
            slShader = (SLShader)obj;
            if (!this.raytracedVolumesEnabled) {
                System.err.println("CommonAttributes.RMAN_RAY_TRACING_VOLUMES must be set true for Exterior volume shaders");
            }
            this.ri.exterior(slShader.getName(), slShader.getParameters());
        }
        if ((obj = eap.getAttribute("rendermanVolumeInteriorShader", Appearance.INHERITED, SLShader.class)) != Appearance.INHERITED) {
            slShader = (SLShader)obj;
            if (!this.raytracedVolumesEnabled) {
                this.ri.verbatim("Attribute \"shade\" \"strategy\" [\"vpvolumes\"]");
            }
            this.ri.interior(slShader.getName(), slShader.getParameters());
        }
    }

    private void updateShaders(EffectiveAppearance eap) {
        this.dgs = ShaderUtility.createDefaultGeometryShader(eap);
        this.rhs = ShaderUtility.createRenderingHintsShader(eap);
        this.currentOpacity = 1.0f;
        if (!(this.handlingProxyGeometry && this.rhs.getOpaqueTubesAndSpheres().booleanValue() || !this.rhs.getTransparencyEnabled().booleanValue())) {
            double d = eap.getAttribute("transparency", 0.0);
            this.currentOpacity = 1.0f - (float)d;
        }
    }

    public String writeTexture(Texture2D tex) {
        String extSource = tex.getExternalSource();
        if (extSource != null) {
            return extSource + "." + this.textureFileSuffix;
        }
        ImageData data = tex.getImage();
        return this.writeTexture(data, tex.getRepeatS(), tex.getRepeatT());
    }

    public String writeTexture(ImageData data, int repeatS, int repeatT) {
        String noSuffix = this.textures.get(data);
        if (noSuffix == null) {
            String texFileName = "_texture" + this.textureCount++;
            noSuffix = this.ribFileName + texFileName;
            RIBHelper.writeTexture(data, noSuffix);
            this.textures.put(data, noSuffix);
            this.renderScript.addTexture(texFileName, repeatS, repeatT);
        }
        return noSuffix + "." + this.textureFileSuffix;
    }

    public void checkForProxy(Geometry g) {
        if (!this.useProxyCommands) {
            return;
        }
        Object proxy = g.getGeometryAttributes("rendermanProxyCommand");
        this.handleProxyObject(proxy);
    }

    private boolean hasProxy() {
        return this.currentProxyCommand != null || this.currentProxySGC != null;
    }

    public boolean hasProxy(Geometry g) {
        this.checkForProxy(g);
        return this.hasProxy();
    }

    public boolean hasProxy(SceneGraphComponent g) {
        if (!this.useProxyCommands || g.getAppearance() == null) {
            return false;
        }
        Object obj = g.getAppearance().getAttribute("rendermanProxyCommand");
        this.handleProxyObject(obj);
        return this.hasProxy();
    }

    private void handleProxyObject(Object obj) {
        this.currentProxyCommand = null;
        this.currentProxySGC = null;
        if (obj != null) {
            if (obj instanceof String) {
                this.currentProxyCommand = (String)obj;
            }
            if (obj instanceof SceneGraphComponent) {
                this.currentProxySGC = (SceneGraphComponent)obj;
            }
        }
    }

    private void handleCurrentProxy() {
        if (this.currentProxyCommand != null) {
            this.ri.verbatim(this.currentProxyCommand);
            this.currentProxyCommand = null;
        } else if (this.currentProxySGC != null) {
            this.visit(this.currentProxySGC);
            this.currentProxySGC = null;
        }
    }

    public void visit(Geometry g) {
        if (this.hasProxy(g)) {
            this.handleCurrentProxy();
        }
        super.visit(g);
    }

    public void visit(PointSet g) {
        boolean drawPoints = this.dgs.getShowPoints();
        if (drawPoints) {
            this.ri.attributeBegin();
            RIBHelper.processShader(this.dgs.getPointShader(), this, "pointShader");
            if (!this.insidePointset) {
                this.insidePointset = true;
                if (this.retainGeometry) {
                    String which = this.archivedPSTable.get(g);
                    if (which != null) {
                        this.ri.readArchive(which);
                    } else {
                        this.ri.comment("Retained point set " + g.getName());
                        String finalname = g.getName() + this.archiveCount;
                        this.ri.archiveBegin(finalname);
                        this._visit(g);
                        this.ri.archiveEnd();
                        this.ri.readArchive(finalname);
                        this.archivedPSTable.put(g, finalname);
                        ++this.archiveCount;
                    }
                } else {
                    this._visit(g);
                }
            } else {
                this._visit(g);
            }
            this.insidePointset = false;
            this.ri.attributeEnd();
        }
    }

    public void visit(IndexedLineSet g) {
        boolean drawLines = this.dgs.getShowLines();
        if (drawLines) {
            this.ri.attributeBegin();
            RIBHelper.processShader(this.dgs.getLineShader(), this, "lineShader");
            this.ri.comment("IndexedLineSet " + g.getName());
            this.checkForProxy(g);
            if (this.hasProxy(g)) {
                this.handleCurrentProxy();
                this.insidePointset = false;
            } else {
                if (!this.insidePointset) {
                    this.insidePointset = true;
                    if (this.retainGeometry) {
                        String which = this.archivedILSTable.get(g);
                        if (which != null) {
                            this.ri.readArchive(which);
                        } else {
                            this.ri.comment("Retained line set " + g.getName());
                            String finalname = g.getName() + this.archiveCount;
                            this.ri.archiveBegin(finalname);
                            this._visit(g);
                            this.ri.archiveEnd();
                            this.ri.readArchive(finalname);
                            this.archivedILSTable.put(g, finalname);
                            ++this.archiveCount;
                        }
                    } else {
                        this._visit(g);
                    }
                    this.visit((PointSet)g);
                    this.insidePointset = false;
                } else {
                    this._visit(g);
                }
                this.visit((PointSet)g);
            }
            this.ri.attributeEnd();
        } else {
            this.visit((PointSet)g);
        }
    }

    public void visit(IndexedFaceSet g) {
        boolean faceDraw = this.dgs.getShowFaces();
        if (faceDraw) {
            this.ri.attributeBegin();
            RIBHelper.processShader(this.dgs.getPolygonShader(), this, "polygonShader");
            this.checkForProxy(g);
            if (this.hasProxy(g)) {
                this.handleCurrentProxy();
                this.insidePointset = false;
            } else if (!this.insidePointset) {
                this.insidePointset = true;
                if (this.retainGeometry) {
                    String which = this.archivedIFSTable.get(g);
                    if (which != null) {
                        this.ri.readArchive(which);
                    } else {
                        this.ri.comment("Retained geometry " + g.getName());
                        String finalname = g.getName() + "_" + this.archiveCount;
                        this.ri.archiveBegin(finalname);
                        this._visit(g);
                        this.ri.archiveEnd();
                        this.ri.readArchive(finalname);
                        this.archivedIFSTable.put(g, finalname);
                        ++this.archiveCount;
                    }
                } else {
                    this._visit(g);
                }
                this.visit((IndexedLineSet)g);
                this.insidePointset = false;
            } else {
                this._visit(g);
            }
            this.ri.attributeEnd();
        } else {
            this.visit((IndexedLineSet)g);
        }
    }

    private void _visit(PointSet p) {
        PointShader ls;
        this.ri.comment("PointSet " + p.getName());
        int n = p.getNumPoints();
        DataList coord = p.getVertexAttributes(Attribute.COORDINATES);
        if (coord == null) {
            return;
        }
        this.ri.attributeBegin();
        DataList radii = p.getVertexAttributes(Attribute.RELATIVE_RADII);
        DoubleArray da = null;
        if (radii != null) {
            da = radii.toDoubleArray();
        }
        DataList ind = p.getVertexAttributes(Attribute.INDICES);
        int[] vind = null;
        if (ind != null) {
            vind = ind.toIntArray(null);
        }
        if (this.drawSpheres) {
            PolygonShader ps;
            this.handlingProxyGeometry = true;
            if (this.opaqueTubes) {
                this.ri.opacity(1.0f);
            }
            if ((ls = this.dgs.getPointShader()) instanceof DefaultPointShader && (ps = ((DefaultPointShader)ls).getPolygonShader()) instanceof DefaultPolygonShader) {
                Color pointColor = ((DefaultPolygonShader)ps).getDiffuseColor();
                float[] cc = new float[3];
                cc = pointColor.getRGBColorComponents(cc);
                this.ri.color(cc);
            }
            double[][] vColData = null;
            if (p.getVertexAttributes(Attribute.COLORS) != null) {
                vColData = p.getVertexAttributes(Attribute.COLORS).toDoubleArrayArray(null);
            }
            double[][] a = coord.toDoubleArrayArray(null);
            double[] trns = new double[16];
            for (int i = 0; i < n; ++i) {
                if (vind != null && vind[i] == 0) continue;
                float realR = this.pointRadius;
                if (radii != null) {
                    realR = (float)((double)realR * da.getValueAt(i));
                }
                if (a[i].length == 4 && a[i][3] == 0.0) continue;
                trns = MatrixBuilder.init(null, this.currentMetric).translate(a[i]).getArray();
                this.ri.transformBegin();
                this.ri.concatTransform(RIBHelper.fTranspose(trns));
                if (vColData != null && vColData[0] != null) {
                    if (vColData[0].length == 4 && !this.opaqueTubes) {
                        double[] dArray = vColData[i];
                        dArray[3] = dArray[3] * (double)this.currentOpacity;
                    }
                    this.ri.color(vColData[i]);
                }
                HashMap map = new HashMap();
                this.ri.sphere(realR, -realR, realR, 360.0f, map);
                this.ri.transformEnd();
            }
            this.handlingProxyGeometry = false;
        } else {
            ls = this.dgs.getPointShader();
            if (ls instanceof DefaultPointShader) {
                Color pointColor = ((DefaultPointShader)ls).getDiffuseColor();
                this.ri.color(pointColor);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            int fiber = GeometryUtility.getVectorLength(coord);
            double[][] pc = new double[n][fiber];
            coord.toDoubleArrayArray(pc);
            float[] pcf = new float[3 * n];
            double[] vector = new double[3];
            for (int i = 0; i < pc.length; ++i) {
                if (fiber == 4) {
                    Pn.dehomogenize(vector, pc[i]);
                } else {
                    vector = pc[i];
                }
                for (int k = 0; k < 3; ++k) {
                    pcf[i * 3 + k] = (float)vector[k];
                }
            }
            map.put("P", pcf);
            map.put("constant float constantwidth", new Float(this.pointRadius));
            DataList vCol = p.getVertexAttributes(Attribute.COLORS);
            if (vCol != null) {
                int vColLength = GeometryUtility.getVectorLength(vCol);
                float[] vCs = new float[3 * vCol.size()];
                float[] vOs = new float[3 * vCol.size()];
                for (int i = 0; i < vCol.size(); ++i) {
                    DoubleArray rgba = vCol.item(i).toDoubleArray();
                    vCs[3 * i] = (float)rgba.getValueAt(0);
                    vCs[3 * i + 1] = (float)rgba.getValueAt(1);
                    vCs[3 * i + 2] = (float)rgba.getValueAt(2);
                    if (vColLength != 4) continue;
                    vOs[3 * i] = (float)rgba.getValueAt(3);
                    vOs[3 * i + 1] = (float)rgba.getValueAt(3);
                    vOs[3 * i + 2] = (float)rgba.getValueAt(3);
                }
                map.put("varying color Cs", vCs);
                if (vColLength == 4) {
                    map.put("varying color Os", vOs);
                }
            }
            this.ri.points(n, map);
        }
        this.ri.attributeEnd();
        DataList labelsList = p.getVertexAttributes(Attribute.LABELS);
        if (labelsList != null) {
            if (this.dgs.getPointShader() instanceof DefaultPointShader) {
                RIBHelper.createRIBLabel(p, (DefaultTextShader)((DefaultPointShader)this.dgs.getPointShader()).getTextShader(), this);
            } else {
                System.err.println("textshaders only for defaultshaders");
            }
        }
    }

    private void _visit(IndexedLineSet g) {
        DataList labelsList;
        DataList dl = g.getEdgeAttributes(Attribute.INDICES);
        if (dl != null) {
            if (this.drawTubes) {
                DataList edgec = g.getEdgeAttributes(Attribute.COLORS);
                Object ga = g.getGeometryAttributes(GeometryUtility.QUAD_MESH_SHAPE);
                if (ga != null) {
                    System.err.println("GA = " + ga.toString());
                }
                if (ga == null || !(ga instanceof Dimension)) {
                    BallAndStickFactory bsf = new BallAndStickFactory(g);
                    bsf.setMetric(this.currentMetric);
                    bsf.setStickRadius(this.tubeRadius);
                    bsf.setShowBalls(false);
                    if (this.cs != null) {
                        bsf.setStickColor(this.cs);
                    }
                    bsf.update();
                    this.handlingProxyGeometry = true;
                    SceneGraphComponent sgc = bsf.getSceneGraphComponent();
                    sgc.setAppearance(RIBHelper.shiftTubesAppearance(this.dgs));
                    sgc.getAppearance().setAttribute("rendermanSurfaceShader", this.eAppearance.getAttribute("lineShader.polygonShader.rendermanSurfaceShader", Appearance.DEFAULT));
                    this.visit(sgc);
                    this.handlingProxyGeometry = false;
                } else {
                    int n = g.getNumEdges();
                    double[][] crossSection = TubeUtility.octagonalCrossSection;
                    Object lineShaderCrossSection = this.eAppearance.getAttribute("lineShader.crossSection", crossSection);
                    if (lineShaderCrossSection != crossSection) {
                        crossSection = (double[][])lineShaderCrossSection;
                    }
                    for (int i = 0; i < n; ++i) {
                        if (edgec != null) {
                            double[] edgecolor = edgec.item(i).toDoubleArray(null);
                            this.ri.comment("Edge color");
                            this.ri.color(edgecolor);
                        }
                        double[][] oneCurve = null;
                        oneCurve = IndexedLineSetUtility.extractCurve(oneCurve, g, i);
                        PolygonalTubeFactory ptf = new PolygonalTubeFactory(oneCurve);
                        ptf.setCrossSection(crossSection);
                        ptf.setMetric(this.currentMetric);
                        ptf.setRadius(this.tubeRadius);
                        ptf.update();
                        IndexedFaceSet tube = ptf.getTube();
                        this.handlingProxyGeometry = true;
                        this.pointPolygon(tube, null);
                        this.handlingProxyGeometry = false;
                    }
                }
            } else {
                HashMap<String, Object> mappo = new HashMap<String, Object>();
                mappo.put("constantwidth", Float.valueOf(this.tubeRadius));
                int[][] ei = g.getEdgeAttributes(Attribute.INDICES).toIntArrayArray(null);
                int numEdges = ei.length;
                int[] nvertices = new int[numEdges];
                double[][] dv = g.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null);
                int fiber = dv[0].length;
                int totalV = 0;
                for (int i = 0; i < numEdges; ++i) {
                    nvertices[i] = ei[i].length;
                    totalV += nvertices[i];
                }
                if (fiber == 4) {
                    dv = Pn.dehomogenize(new double[dv.length][3], dv);
                    fiber = 3;
                }
                float[] vertices = new float[fiber * totalV];
                int counter = 0;
                for (int i = 0; i < numEdges; ++i) {
                    for (int j = 0; j < ei[i].length; ++j) {
                        int k = ei[i][j];
                        for (int m = 0; m < fiber; ++m) {
                            vertices[counter + m] = (float)dv[k][m];
                        }
                        counter += fiber;
                    }
                }
                mappo.put(fiber == 3 ? "P" : "vertex hpoint P", vertices);
                DataList eCol = g.getEdgeAttributes(Attribute.COLORS);
                if (eCol != null) {
                    int eColLength = GeometryUtility.getVectorLength(eCol);
                    float[] eCs = new float[3 * eCol.size()];
                    float[] eOs = new float[3 * eCol.size()];
                    for (int i = 0; i < eCol.size(); ++i) {
                        DoubleArray rgba = eCol.item(i).toDoubleArray();
                        eCs[3 * i] = (float)rgba.getValueAt(0);
                        eCs[3 * i + 1] = (float)rgba.getValueAt(1);
                        eCs[3 * i + 2] = (float)rgba.getValueAt(2);
                        if (eColLength != 4) continue;
                        eOs[3 * i] = (float)rgba.getValueAt(3);
                        eOs[3 * i + 1] = (float)rgba.getValueAt(3);
                        eOs[3 * i + 2] = (float)rgba.getValueAt(3);
                    }
                    mappo.put("uniform color Cs", eCs);
                    if (eColLength == 4) {
                        mappo.put("uniform color Os", eOs);
                    }
                }
                this.ri.curves("linear", nvertices, "nonperiodic", mappo);
            }
        }
        if ((labelsList = g.getEdgeAttributes(Attribute.LABELS)) != null) {
            if (this.dgs.getLineShader() instanceof DefaultLineShader) {
                RIBHelper.createRIBLabel(g, (DefaultTextShader)((DefaultLineShader)this.dgs.getLineShader()).getTextShader(), this);
            } else {
                System.err.println("textshaders only for defaultshaders");
            }
        }
    }

    protected void _visit(IndexedFaceSet i) {
        this.ri.comment("IndexedFaceSet " + i.getName());
        DataList colors = i.getFaceAttributes(Attribute.COLORS);
        boolean opaqueColors = true;
        if (colors != null && GeometryUtility.getVectorLength(colors) >= 3) {
            double[][] colorArray = colors.toDoubleArrayArray(null);
            if (colorArray[0].length > 3) {
                opaqueColors = false;
            }
            if (!opaqueColors) {
                int nn = GeometryUtility.getVectorLength(colors);
                int numFaces = i.getNumFaces();
                float[][] colorArrayf = new float[numFaces][nn];
                for (int k = 0; k < numFaces; ++k) {
                    for (int j = 0; j < nn; ++j) {
                        colorArrayf[k][j] = (float)colorArray[k][j];
                    }
                }
                IndexedFaceSet[] faceList = IndexedFaceSetUtility.splitIfsToPrimitiveFaces(i);
                for (int k = 0; k < numFaces; ++k) {
                    this.pointPolygon(faceList[k], colorArrayf[k]);
                }
            } else {
                this.pointPolygon(i, null);
            }
        } else {
            this.pointPolygon(i, null);
        }
        DataList labelsList = i.getFaceAttributes(Attribute.LABELS);
        if (labelsList != null) {
            if (this.dgs.getPolygonShader() instanceof DefaultPolygonShader) {
                RIBHelper.createRIBLabel(i, (DefaultTextShader)((DefaultPolygonShader)this.dgs.getPolygonShader()).getTextShader(), this);
            } else {
                System.err.println("textshaders only for defaultshaders");
            }
        }
    }

    protected void pointPolygon(IndexedFaceSet ifs, float[] color) {
        int npolys = ifs.getNumFaces();
        if (color != null && color.length == 4 && (double)color[3] == 0.0 && this.ignoreAlpha0) {
            return;
        }
        if (npolys != 0) {
            int j;
            float[] vOp;
            DataList texCoords;
            float[] fcoords;
            boolean isQuadMesh = false;
            Dimension qmDim = null;
            Object foo = ifs.getGeometryAttributes(GeometryUtility.QUAD_MESH_SHAPE);
            if (foo != null && foo instanceof Dimension) {
                qmDim = (Dimension)foo;
                isQuadMesh = true;
            }
            HashMap<String, float[]> map = new HashMap<String, float[]>();
            DataList coords = ifs.getVertexAttributes(Attribute.COORDINATES);
            DoubleArrayArray da = coords.toDoubleArrayArray();
            int pointlength = GeometryUtility.getVectorLength(coords);
            double[] o2w = this.object2world.getMatrix(null);
            double[] rmanc = P3.makeScaleMatrix(null, 1.0, 1.0, -1.0);
            double[] o2c = Rn.times(null, Rn.times(null, rmanc, this.world2Camera), o2w);
            if (!this.hasPw || pointlength == 3) {
                fcoords = new float[3 * da.getLength()];
                for (int j2 = 0; j2 < da.getLength(); ++j2) {
                    if (pointlength == 4) {
                        float w = (float)da.getValueAt(j2, 3);
                        w = w != 0.0f ? 1.0f / w : 1.0E11f;
                        fcoords[3 * j2 + 0] = (float)da.getValueAt(j2, 0) * w;
                        fcoords[3 * j2 + 1] = (float)da.getValueAt(j2, 1) * w;
                        fcoords[3 * j2 + 2] = (float)da.getValueAt(j2, 2) * w;
                        continue;
                    }
                    fcoords[3 * j2 + 0] = (float)da.getValueAt(j2, 0);
                    fcoords[3 * j2 + 1] = (float)da.getValueAt(j2, 1);
                    fcoords[3 * j2 + 2] = (float)da.getValueAt(j2, 2);
                }
                map.put("P", fcoords);
                double[][] dpoints = da.toDoubleArrayArray(null);
            } else if (pointlength == 4) {
                fcoords = new float[4 * da.getLength()];
                for (int j3 = 0; j3 < da.getLength(); ++j3) {
                    fcoords[4 * j3 + 0] = (float)da.getValueAt(j3, 0);
                    fcoords[4 * j3 + 1] = (float)da.getValueAt(j3, 1);
                    fcoords[4 * j3 + 2] = (float)da.getValueAt(j3, 2);
                    fcoords[4 * j3 + 3] = (float)da.getValueAt(j3, 3);
                }
                map.put("vertex hpoint P", fcoords);
            }
            DataList normals = null;
            boolean vertexNormals = true;
            if (this.smooth && ifs.getVertexAttributes(Attribute.NORMALS) != null) {
                normals = ifs.getVertexAttributes(Attribute.NORMALS);
            } else if (ifs.getFaceAttributes(Attribute.NORMALS) != null) {
                vertexNormals = false;
                normals = ifs.getFaceAttributes(Attribute.NORMALS);
            }
            if (normals != null) {
                float[] fnormals;
                da = normals.toDoubleArrayArray();
                int n = da.getLengthAt(0);
                if (n != 4 || this.currentMetric == 0) {
                    // empty if block
                }
                if (this.currentMetric == 0) {
                    fnormals = new float[3 * da.getLength()];
                    for (int j4 = 0; j4 < da.getLength(); ++j4) {
                        fnormals[n * j4 + 0] = (float)da.getValueAt(j4, 0);
                        fnormals[n * j4 + 1] = (float)da.getValueAt(j4, 1);
                        fnormals[n * j4 + 2] = (float)da.getValueAt(j4, 2);
                    }
                    map.put(vertexNormals ? "N" : "uniform normal N", fnormals);
                } else {
                    fnormals = new float[4 * da.getLength()];
                    double[][] dnormals = da.toDoubleArrayArray(null);
                    double[] m = this.getCurrentObjectToCamera();
                    double[][] dnormals2 = Rn.matrixTimesVector((double[][])null, m, dnormals);
                    int nn = dnormals[0].length;
                    int[][] ind = ifs.getFaceAttributes(Attribute.INDICES).toIntArrayArray(null);
                    int ii = 0;
                    for (int j5 = 0; j5 < dnormals.length; ++j5) {
                        for (int k = 0; k < 4; ++k) {
                            fnormals[ii++] = k < nn ? (float)dnormals[j5][k] : 0.0f;
                        }
                    }
                    map.put((vertexNormals ? "vertex" : "uniform") + " float[4] Nw", fnormals);
                }
            }
            if ((texCoords = ifs.getVertexAttributes(Attribute.TEXTURE_COORDINATES)) != null) {
                float[] ftex = new float[2 * texCoords.size()];
                for (int j6 = 0; j6 < texCoords.size(); ++j6) {
                    DoubleArray l = texCoords.item(j6).toDoubleArray();
                    ftex[2 * j6] = (float)l.getValueAt(0);
                    ftex[2 * j6 + 1] = (float)l.getValueAt(1);
                }
                map.put("st", ftex);
            }
            DataList vertexColors = ifs.getVertexAttributes(Attribute.COLORS);
            DataList faceColors = ifs.getFaceAttributes(Attribute.COLORS);
            if ((this.smooth || color == null && faceColors == null) && vertexColors != null) {
                int vertexColorLength = GeometryUtility.getVectorLength(vertexColors);
                float[] vCol = new float[3 * vertexColors.size()];
                vOp = null;
                if (vertexColorLength == 4) {
                    vOp = new float[3 * vertexColors.size()];
                }
                for (j = 0; j < vertexColors.size(); ++j) {
                    DoubleArray rgba = vertexColors.item(j).toDoubleArray();
                    vCol[3 * j] = (float)rgba.getValueAt(0);
                    vCol[3 * j + 1] = (float)rgba.getValueAt(1);
                    vCol[3 * j + 2] = (float)rgba.getValueAt(2);
                    if (vertexColorLength != 4) continue;
                    vOp[3 * j] = (float)rgba.getValueAt(3) * this.currentOpacity;
                    vOp[3 * j + 1] = (float)rgba.getValueAt(3) * this.currentOpacity;
                    vOp[3 * j + 2] = (float)rgba.getValueAt(3) * this.currentOpacity;
                }
                map.put("varying color Cs", vCol);
                if (vertexColorLength == 4) {
                    map.put("varying color Os", vOp);
                }
            } else if (faceColors != null) {
                int faceColorLength = GeometryUtility.getVectorLength(faceColors);
                float[] vCol = new float[3 * faceColors.size()];
                vOp = null;
                if (faceColorLength == 4) {
                    vOp = new float[3 * faceColors.size()];
                }
                for (j = 0; j < faceColors.size(); ++j) {
                    float alpha;
                    DoubleArray rgba = faceColors.item(j).toDoubleArray();
                    vCol[3 * j] = (float)rgba.getValueAt(0);
                    vCol[3 * j + 1] = (float)rgba.getValueAt(1);
                    vCol[3 * j + 2] = (float)rgba.getValueAt(2);
                    if (faceColorLength != 4) continue;
                    float f = alpha = (float)rgba.getValueAt(3) * this.currentOpacity;
                    vOp[3 * j + 2] = f;
                    vOp[3 * j + 1] = f;
                    vOp[3 * j] = f;
                }
                map.put("uniform color Cs", vCol);
                if (faceColorLength == 4) {
                    map.put("Os", vOp);
                }
            }
            int[] nvertices = new int[npolys];
            int verticesLength = 0;
            for (int k = 0; k < npolys; ++k) {
                IntArray fi = ifs.getFaceAttributes(Attribute.INDICES).item(k).toIntArray();
                nvertices[k] = fi.getLength();
                verticesLength += nvertices[k];
            }
            int[] vertices = new int[verticesLength];
            int l = 0;
            for (int k = 0; k < npolys; ++k) {
                int m = 0;
                while (m < nvertices[k]) {
                    IntArray fi = ifs.getFaceAttributes(Attribute.INDICES).item(k).toIntArray();
                    vertices[l] = fi.getValueAt(m);
                    ++m;
                    ++l;
                }
            }
            if (color != null) {
                float[] f = new float[3];
                this.ri.color(new float[]{color[0], color[1], color[2]});
                float thisOpacity = this.currentOpacity;
                if (color.length == 4) {
                    f[1] = f[2] = (thisOpacity = color[3] * this.currentOpacity);
                    f[0] = f[2];
                    this.ri.opacity(f);
                }
            }
            if (isQuadMesh) {
                this.ri.patchMesh("bilinear", qmDim.width, false, qmDim.height, false, map);
            } else {
                this.ri.pointsPolygons(npolys, nvertices, vertices, map);
            }
        }
    }

    public void visit(ClippingPlane p) {
    }

    public void visit(Sphere s) {
        if (this.hasProxy(s)) {
            return;
        }
        RIBHelper.processShader(this.dgs.getPolygonShader(), this, "polygonShader");
        this.ri.sphere(1.0f, -1.0f, 1.0f, 360.0f, null);
    }

    public void visit(Cylinder c) {
        if (this.hasProxy(c)) {
            return;
        }
        RIBHelper.processShader(this.dgs.getPolygonShader(), this, "polygonShader");
        this.ri.cylinder(1.0f, -1.0f, 1.0f, 360.0f, null);
        this.ri.disk(-1.0f, 1.0f, 360.0f, null);
        this.ri.disk(1.0f, 1.0f, 360.0f, null);
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setMaximumEyeSplits(int maximumEyeSplits) {
        this.maximumEyeSplits[0] = maximumEyeSplits;
    }

    public void setRendererType(int rendererType) {
        this.rendererType = rendererType;
    }

    public int getRendererType() {
        return this.rendererType;
    }

    public String writeCubeMap(CubeMap reflectionMap) {
        String noSuffix = this.cubeMaps.get(reflectionMap.getTop());
        if (noSuffix == null) {
            String cubeMapFileName = "_cubeMap" + this.cubeMapCount++;
            noSuffix = this.ribFileName + cubeMapFileName;
            this.cubeMaps.put(reflectionMap.getTop(), noSuffix);
            String top = new File(this.writeTexture(reflectionMap.getTop(), 33071, 33071)).getName();
            String bottom = new File(this.writeTexture(reflectionMap.getBottom(), 33071, 33071)).getName();
            String left = new File(this.writeTexture(reflectionMap.getLeft(), 33071, 33071)).getName();
            String right = new File(this.writeTexture(reflectionMap.getRight(), 33071, 33071)).getName();
            String front = new File(this.writeTexture(reflectionMap.getFront(), 33071, 33071)).getName();
            String back = new File(this.writeTexture(reflectionMap.getBack(), 33071, 33071)).getName();
            this.renderScript.addReflectionMap(cubeMapFileName, back, front, bottom, top, left, right);
        }
        return noSuffix + "." + this.cubeMapFileSuffix;
    }

    public double[] getCurrentObjectToCamera() {
        double[] o2w = this.object2world.getMatrix(null);
        double[] rmanc = P3.makeScaleMatrix(null, 1.0, 1.0, -1.0);
        double[] o2c = Rn.times(null, Rn.times(null, rmanc, this.world2Camera), o2w);
        return o2c;
    }
}

