/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader.vrml;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.impl.BitSet;
import de.jreality.geometry.IndexedFaceSetFactory;
import de.jreality.geometry.IndexedLineSetFactory;
import de.jreality.geometry.Primitives;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.Rn;
import de.jreality.reader.vrml.DefUseData;
import de.jreality.reader.vrml.State;
import de.jreality.reader.vrml.VRMLHelper;
import de.jreality.reader.vrml.VRMLV1ParserTokenTypes;
import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.DirectionalLight;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.Light;
import de.jreality.scene.PointLight;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Sphere;
import de.jreality.scene.SpotLight;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.StringArray;
import java.awt.Color;

public class VRMLV1Parser
extends LLkParser
implements VRMLV1ParserTokenTypes {
    SceneGraphPath camPath = null;
    SceneGraphComponent root = null;
    final int INITIAL_SIZE = 10000;
    double[] ds = new double[10000];
    Color[] cs = new Color[10000];
    int[] ls = new int[10000];
    String[] strs = new String[10000];
    double[][] vecs = new double[10000][];
    boolean generateEdgesFromFaces = true;
    DefUseData defs = new DefUseData();
    int numOfSwitchNodes = 0;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "HEADER", "\"DEF\"", "\"USE\"", "\"WWWInline\"", "\"WWWAnchor\"", "\"LOD\"", "\"Separator\"", "OPEN_BRACE", "CLOSE_BRACE", "\"Switch\"", "\"AsciiText\"", "\"string\"", "\"spacing\"", "\"justification\"", "\"width\"", "\"Cone\"", "\"parts\"", "\"bottomRadius\"", "\"height\"", "\"Cube\"", "\"depth\"", "\"Cylinder\"", "\"radius\"", "\"IndexedFaceSet\"", "\"coordIndex\"", "\"materialIndex\"", "\"normalIndex\"", "\"textureCoordIndex\"", "\"IndexedLineSet\"", "\"PointSet\"", "\"startIndex\"", "\"numPoints\"", "\"Sphere\"", "\"FontStyle\"", "\"Coordinate3\"", "\"point\"", "\"Info\"", "\"Material\"", "\"ambientColor\"", "\"diffuseColor\"", "\"specularColor\"", "\"emissiveColor\"", "\"shininess\"", "\"transparency\"", "\"BaseColor\"", "\"rgb\"", "\"MaterialBinding\"", "\"value\"", "\"Normal\"", "\"vector\"", "\"NormalBinding\"", "\"Texture2\"", "\"filename\"", "\"image\"", "\"wrapS\"", "\"wrapT\"", "\"Texture2Transform\"", "\"translation\"", "\"rotation\"", "\"scaleFactor\"", "\"center\"", "\"TextureCoordinate2\"", "\"ShapeHints\"", "\"vertexOrdering\"", "\"shapeType\"", "\"faceType\"", "\"creaseAngle\"", "\"MatrixTransform\"", "\"matrix\"", "\"Rotation\"", "\"Scale\"", "\"Transform\"", "\"scaleOrientation\"", "\"Translation\"", "\"PerspectiveCamera\"", "\"position\"", "\"orientation\"", "\"focalDistance\"", "\"heightAngle\"", "\"OrthographicCamera\"", "\"PointLight\"", "\"on\"", "\"intensity\"", "\"color\"", "\"location\"", "\"SpotLight\"", "\"direction\"", "\"dropOffRate\"", "\"cutOffAngle\"", "\"DirectionalLight\"", "an identifier", "LPAREN", "T1", "RPAREN", "\"TRUE\"", "\"FALSE\"", "OPEN_BRACKET", "CLOSE_BRACKET", "COLON", "HEXDEC", "NUMBER", "STRING", "PLUS", "MINUS", "\"E\"", "\"e\"", "ID_LETTER", "HEXDIGIT", "DIGIT", "ESC", "RESTLINE", "HEADER1", "COMMENT", "WS_"};
    public static final BitSet _tokenSet_0 = new BitSet(VRMLV1Parser.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(VRMLV1Parser.mk_tokenSet_1());
    public static final BitSet _tokenSet_2 = new BitSet(VRMLV1Parser.mk_tokenSet_2());
    public static final BitSet _tokenSet_3 = new BitSet(VRMLV1Parser.mk_tokenSet_3());
    public static final BitSet _tokenSet_4 = new BitSet(VRMLV1Parser.mk_tokenSet_4());
    public static final BitSet _tokenSet_5 = new BitSet(VRMLV1Parser.mk_tokenSet_5());
    public static final BitSet _tokenSet_6 = new BitSet(VRMLV1Parser.mk_tokenSet_6());
    public static final BitSet _tokenSet_7 = new BitSet(VRMLV1Parser.mk_tokenSet_7());
    public static final BitSet _tokenSet_8 = new BitSet(VRMLV1Parser.mk_tokenSet_8());
    public static final BitSet _tokenSet_9 = new BitSet(VRMLV1Parser.mk_tokenSet_9());
    public static final BitSet _tokenSet_10 = new BitSet(VRMLV1Parser.mk_tokenSet_10());
    public static final BitSet _tokenSet_11 = new BitSet(VRMLV1Parser.mk_tokenSet_11());
    public static final BitSet _tokenSet_12 = new BitSet(VRMLV1Parser.mk_tokenSet_12());
    public static final BitSet _tokenSet_13 = new BitSet(VRMLV1Parser.mk_tokenSet_13());
    public static final BitSet _tokenSet_14 = new BitSet(VRMLV1Parser.mk_tokenSet_14());
    public static final BitSet _tokenSet_15 = new BitSet(VRMLV1Parser.mk_tokenSet_15());
    public static final BitSet _tokenSet_16 = new BitSet(VRMLV1Parser.mk_tokenSet_16());
    public static final BitSet _tokenSet_17 = new BitSet(VRMLV1Parser.mk_tokenSet_17());
    public static final BitSet _tokenSet_18 = new BitSet(VRMLV1Parser.mk_tokenSet_18());
    public static final BitSet _tokenSet_19 = new BitSet(VRMLV1Parser.mk_tokenSet_19());
    public static final BitSet _tokenSet_20 = new BitSet(VRMLV1Parser.mk_tokenSet_20());
    public static final BitSet _tokenSet_21 = new BitSet(VRMLV1Parser.mk_tokenSet_21());
    public static final BitSet _tokenSet_22 = new BitSet(VRMLV1Parser.mk_tokenSet_22());
    public static final BitSet _tokenSet_23 = new BitSet(VRMLV1Parser.mk_tokenSet_23());
    public static final BitSet _tokenSet_24 = new BitSet(VRMLV1Parser.mk_tokenSet_24());
    public static final BitSet _tokenSet_25 = new BitSet(VRMLV1Parser.mk_tokenSet_25());
    public static final BitSet _tokenSet_26 = new BitSet(VRMLV1Parser.mk_tokenSet_26());
    public static final BitSet _tokenSet_27 = new BitSet(VRMLV1Parser.mk_tokenSet_27());
    public static final BitSet _tokenSet_28 = new BitSet(VRMLV1Parser.mk_tokenSet_28());
    public static final BitSet _tokenSet_29 = new BitSet(VRMLV1Parser.mk_tokenSet_29());

    protected VRMLV1Parser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public VRMLV1Parser(TokenBuffer tokenBuf) {
        this(tokenBuf, 2);
    }

    protected VRMLV1Parser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public VRMLV1Parser(TokenStream lexer) {
        this(lexer, 2);
    }

    public VRMLV1Parser(ParserSharedInputState state) {
        super(state, 2);
        this.tokenNames = _tokenNames;
    }

    public final SceneGraphComponent vrmlFile() throws RecognitionException, TokenStreamException {
        SceneGraphComponent r = null;
        try {
            this.match(4);
            this.root = new SceneGraphComponent();
            SceneGraphPath p = new SceneGraphPath();
            p.push(this.root);
            Object t = null;
            State state = new State();
            state.diffuse = new Color[0];
            state.trafo = t;
            state.currNode = this.root;
            state.camPath = p;
            state.transparency = new double[]{1.0};
            switch (this.LA(1)) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 14: 
                case 19: 
                case 23: 
                case 25: 
                case 27: 
                case 32: 
                case 33: 
                case 36: 
                case 37: 
                case 38: 
                case 40: 
                case 41: 
                case 48: 
                case 50: 
                case 52: 
                case 54: 
                case 55: 
                case 60: 
                case 65: 
                case 66: 
                case 71: 
                case 73: 
                case 74: 
                case 75: 
                case 77: 
                case 78: 
                case 83: 
                case 84: 
                case 89: 
                case 93: 
                case 94: {
                    this.statement(state);
                    state.history = state.history + "*";
                    while (_tokenSet_0.member(this.LA(1))) {
                        this.statement(state);
                        state.history = state.history + "*";
                        System.err.println("Warning: multiple basic Nodesfound (and processed). This is not VRML-Standard !");
                    }
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            r = this.root;
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_1);
        }
        return r;
    }

    private final void statement(State state) throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 5: {
                    this.defNode(state);
                    break;
                }
                case 6: {
                    this.useNode(state);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 14: 
                case 19: 
                case 23: 
                case 25: 
                case 27: 
                case 32: 
                case 33: 
                case 36: 
                case 37: 
                case 38: 
                case 40: 
                case 41: 
                case 48: 
                case 50: 
                case 52: 
                case 54: 
                case 55: 
                case 60: 
                case 65: 
                case 66: 
                case 71: 
                case 73: 
                case 74: 
                case 75: 
                case 77: 
                case 78: 
                case 83: 
                case 84: 
                case 89: 
                case 93: 
                case 94: {
                    this.node(state);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void defNode(State state) throws RecognitionException, TokenStreamException {
        if (VRMLHelper.verbose) {
            System.err.print(state.history + "Def Node(");
        }
        String name = "";
        State fake = DefUseData.defState(state);
        try {
            this.match(5);
            name = this.sfstringValue();
            if (VRMLHelper.verbose) {
                System.err.println(name + "):");
            }
            this.statement(fake);
            this.defs.addDef(fake, name);
            if (VRMLHelper.verbose) {
                System.err.print("DEF End(");
            }
            this.defs.use(state, name, true);
            if (VRMLHelper.verbose) {
                System.err.println("DEF used)");
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void useNode(State state) throws RecognitionException, TokenStreamException {
        if (VRMLHelper.verbose) {
            System.err.print(state.history + "Use Node(");
        }
        String name = "";
        try {
            this.match(6);
            name = this.sfstringValue();
            if (VRMLHelper.verbose) {
                System.err.print(name);
            }
            this.defs.use(state, name, false);
            if (VRMLHelper.verbose) {
                System.err.println(")");
            }
            System.out.println("Attention: The USE-Statement is not completely supported and may be read incorrect!");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void node(State state) throws RecognitionException, TokenStreamException {
        if (VRMLHelper.verbose) {
            System.err.print(state.history + "Got Node: ");
        }
        try {
            switch (this.LA(1)) {
                case 8: 
                case 9: 
                case 10: 
                case 13: {
                    this.groupNode(state);
                    state.defTyp = 0;
                    break;
                }
                case 14: 
                case 19: 
                case 23: 
                case 25: 
                case 27: 
                case 32: 
                case 33: 
                case 36: {
                    this.shapeNode(state);
                    state.defTyp = 0;
                    break;
                }
                case 37: 
                case 38: 
                case 40: 
                case 41: 
                case 48: 
                case 50: 
                case 52: 
                case 54: 
                case 55: 
                case 60: 
                case 65: 
                case 66: {
                    this.propertyGeoNAppNode(state);
                    break;
                }
                case 71: 
                case 73: 
                case 74: 
                case 75: 
                case 77: {
                    this.propertyMatrixTransformNode(state);
                    state.defTyp = 6;
                    break;
                }
                case 7: 
                case 78: 
                case 83: 
                case 84: 
                case 89: 
                case 93: {
                    this.specialNode(state);
                    break;
                }
                case 94: {
                    this.strangeNode();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final String sfstringValue() throws RecognitionException, TokenStreamException {
        String s = "";
        Token g = null;
        Token h = null;
        try {
            switch (this.LA(1)) {
                case 94: {
                    g = this.LT(1);
                    this.match(94);
                    s = g.getText();
                    break;
                }
                case 105: {
                    h = this.LT(1);
                    this.match(105);
                    s = h.getText();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_3);
        }
        return s;
    }

    private final void groupNode(State state) throws RecognitionException, TokenStreamException {
        if (VRMLHelper.verbose) {
            System.err.print("group Node: ");
        }
        try {
            switch (this.LA(1)) {
                case 10: {
                    this.separatorNode(state);
                    break;
                }
                case 13: {
                    this.switchNode(state);
                    break;
                }
                case 8: {
                    this.match(8);
                    this.egal();
                    break;
                }
                case 9: {
                    this.match(9);
                    this.egal();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void shapeNode(State state) throws RecognitionException, TokenStreamException {
        if (VRMLHelper.verbose) {
            System.err.print("Shape Node: ");
        }
        State state2 = new State(state);
        Geometry geo = null;
        Appearance app = new Appearance();
        SceneGraphComponent sgc = new SceneGraphComponent();
        try {
            switch (this.LA(1)) {
                case 14: {
                    geo = this.asciiTextNode(state2, app);
                    break;
                }
                case 19: {
                    geo = this.coneNode(state2, app);
                    break;
                }
                case 23: {
                    geo = this.cubeNode(state2, app);
                    break;
                }
                case 25: {
                    geo = this.cylinderNode(state2, app);
                    break;
                }
                case 27: {
                    geo = this.indexedFaceSetNode(state2, app);
                    break;
                }
                case 32: {
                    geo = this.indexedLineSetNode(state2, app);
                    break;
                }
                case 33: {
                    geo = this.pointSetNode(state2, app);
                    break;
                }
                case 36: {
                    geo = this.sphereNode(state2, app);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            if (geo == null) {
                System.out.println("failure in geometry. Abort Node!");
            } else {
                sgc.setName(geo.getName());
                state2.currNode.addChild(sgc);
                sgc.setGeometry(geo);
                state2.setColorApp(app, false);
                sgc.setAppearance(app);
                state2.setTrafo(sgc);
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void propertyGeoNAppNode(State state) throws RecognitionException, TokenStreamException {
        if (VRMLHelper.verbose) {
            System.err.print("prop Geo Node: ");
        }
        try {
            switch (this.LA(1)) {
                case 38: {
                    this.coordinate3Node(state);
                    state.defTyp = 4;
                    break;
                }
                case 37: {
                    this.match(37);
                    this.egal();
                    break;
                }
                case 40: {
                    this.infoNode(state);
                    break;
                }
                case 41: {
                    this.materialNode(state);
                    state.defTyp = 1;
                    if (state.materialBinding == State.Binding.NONE) {
                        state.materialBinding = State.Binding.OVERALL;
                    }
                    break;
                }
                case 48: {
                    this.baseColorNode(state);
                    state.defTyp = 1;
                    if (state.materialBinding == State.Binding.NONE) {
                        state.materialBinding = State.Binding.OVERALL;
                    }
                    break;
                }
                case 50: {
                    this.materialBindingNode(state);
                    state.defTyp = 2;
                    break;
                }
                case 52: {
                    this.normalNode(state);
                    state.defTyp = 5;
                    break;
                }
                case 54: {
                    this.normalBindingNode(state);
                    state.defTyp = 3;
                    break;
                }
                case 55: {
                    this.texture2Node(state);
                    state.defTyp = 7;
                    break;
                }
                case 60: {
                    this.texture2TransformNode(state);
                    state.defTyp = 8;
                    break;
                }
                case 65: {
                    this.textureCoordinate2Node(state);
                    state.defTyp = 9;
                    break;
                }
                case 66: {
                    this.shapeHintsNode(state);
                    state.defTyp = 10;
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void propertyMatrixTransformNode(State state) throws RecognitionException, TokenStreamException {
        if (VRMLHelper.verbose) {
            System.err.print("Prop Matrix Node: ");
        }
        Transformation m = new Transformation();
        try {
            switch (this.LA(1)) {
                case 71: {
                    m = this.matrixTransformNode();
                    break;
                }
                case 73: {
                    m = this.rotationNode();
                    break;
                }
                case 74: {
                    m = this.scaleNode();
                    break;
                }
                case 75: {
                    m = this.transformNode();
                    break;
                }
                case 77: {
                    m = this.translationNode();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            if (state.trafo == null) {
                state.trafo = new Transformation();
            }
            state.trafo.multiplyOnRight(m.getMatrix());
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void specialNode(State state) throws RecognitionException, TokenStreamException {
        if (VRMLHelper.verbose) {
            System.err.print("special Node: ");
        }
        try {
            switch (this.LA(1)) {
                case 78: 
                case 83: {
                    this.camNode(state);
                    state.defTyp = 0;
                    System.out.println("def-Cam Problem?");
                    break;
                }
                case 84: 
                case 89: 
                case 93: {
                    this.lightNode(state);
                    state.defTyp = 0;
                    break;
                }
                case 7: {
                    this.match(7);
                    this.egal();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void strangeNode() throws RecognitionException, TokenStreamException {
        try {
            String s = this.id();
            this.egal();
            System.out.println("unknown Node:" + s + " -Node ignored!");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void camNode(State state) throws RecognitionException, TokenStreamException {
        if (VRMLHelper.verbose) {
            System.err.print("Cam Node: ");
        }
        Camera c = null;
        State state2 = new State(state);
        try {
            switch (this.LA(1)) {
                case 83: {
                    c = this.orthographicCameraNode(state2);
                    break;
                }
                case 78: {
                    c = this.perspectiveCameraNode(state2);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            SceneGraphComponent sgc = new SceneGraphComponent();
            state.currNode.addChild(sgc);
            sgc.setName(c.getName());
            if (c != null) {
                if (this.camPath == null) {
                    this.camPath = state.camPath;
                }
                sgc.setCamera(c);
                state2.setTrafo(sgc);
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void lightNode(State state) throws RecognitionException, TokenStreamException {
        if (VRMLHelper.verbose) {
            System.err.print("Light Node: ");
        }
        Light l = null;
        State state2 = new State(state);
        try {
            switch (this.LA(1)) {
                case 93: {
                    l = this.directionalLightNode(state2);
                    break;
                }
                case 84: {
                    l = this.pointLightNode(state2);
                    break;
                }
                case 89: {
                    l = this.spotLightNode(state2);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            SceneGraphComponent sgc = new SceneGraphComponent();
            state2.currNode.addChild(sgc);
            sgc.setName(l.getName());
            sgc.setLight(l);
            state2.setTrafo(sgc);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void egal() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 95: {
                    this.match(95);
                    while (_tokenSet_4.member(this.LA(1))) {
                        this.dumb();
                    }
                    this.match(97);
                    break;
                }
                case 11: {
                    this.match(11);
                    while (_tokenSet_4.member(this.LA(1))) {
                        this.dumb();
                    }
                    this.match(12);
                    break;
                }
                case 100: {
                    this.match(100);
                    while (_tokenSet_4.member(this.LA(1))) {
                        this.dumb();
                    }
                    this.match(101);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final String id() throws RecognitionException, TokenStreamException {
        Token n = null;
        String s = "";
        try {
            n = this.LT(1);
            this.match(94);
            s = n.getText();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_5);
        }
        return s;
    }

    private final void separatorNode(State state) throws RecognitionException, TokenStreamException {
        Token g = null;
        if (VRMLHelper.verbose) {
            System.err.println("Separator");
        }
        State state2 = new State(state);
        Transformation t = state2.trafo;
        Appearance app = null;
        if (state2.materialBinding == State.Binding.OVERALL || state2.materialBinding == State.Binding.DEFAULT) {
            app = new Appearance();
            state2.setColorApp(app, false);
            state2.materialBinding = State.Binding.NONE;
        }
        state2.trafo = null;
        state2.history = state.history + "|";
        if (VRMLHelper.verbose) {
            System.err.println(state.history + "\\");
        }
        try {
            g = this.LT(1);
            this.match(10);
            SceneGraphComponent sgc = new SceneGraphComponent();
            if (t != null) {
                sgc.setTransformation(t);
            }
            if (app != null) {
                sgc.setAppearance(app);
            }
            sgc.setName("Knot LineNo " + g.getLine());
            state2.currNode.addChild(sgc);
            state2.currNode = sgc;
            state2.camPath.push(sgc);
            this.match(11);
            while (_tokenSet_0.member(this.LA(1))) {
                this.statement(state2);
            }
            this.match(12);
            if (VRMLHelper.verbose) {
                System.err.println(state.history + "/");
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void switchNode(State state) throws RecognitionException, TokenStreamException {
        Token g = null;
        if (VRMLHelper.verbose) {
            System.err.println("switch");
        }
        State state2 = new State(state);
        Transformation t = state2.trafo;
        state2.trafo = null;
        state2.history = state.history + "-";
        if (VRMLHelper.verbose) {
            System.err.println(state.history + "\\");
        }
        try {
            g = this.LT(1);
            this.match(13);
            SceneGraphComponent sgc = new SceneGraphComponent();
            if (t != null) {
                sgc.setTransformation(t);
            }
            state2.currNode.addChild(sgc);
            state2.currNode = sgc;
            state2.camPath.push(sgc);
            if (this.numOfSwitchNodes > 0) {
                sgc.setVisible(false);
            }
            ++this.numOfSwitchNodes;
            sgc.setName("Switch Nr " + this.numOfSwitchNodes);
            this.match(11);
            switch (this.LA(1)) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 14: 
                case 19: 
                case 23: 
                case 25: 
                case 27: 
                case 32: 
                case 33: 
                case 36: 
                case 37: 
                case 38: 
                case 40: 
                case 41: 
                case 48: 
                case 50: 
                case 52: 
                case 54: 
                case 55: 
                case 60: 
                case 65: 
                case 66: 
                case 71: 
                case 73: 
                case 74: 
                case 75: 
                case 77: 
                case 78: 
                case 83: 
                case 84: 
                case 89: 
                case 93: 
                case 94: {
                    this.statement(state2);
                    break;
                }
                case 12: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(12);
            if (VRMLHelper.verbose) {
                System.err.println(state.history + "/");
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final PointSet asciiTextNode(State state, Appearance app) throws RecognitionException, TokenStreamException {
        PointSet label = null;
        if (VRMLHelper.verbose) {
            System.err.print("Label( ");
        }
        String just = "LEFT";
        String[] text = new String[]{""};
        double spacing = 1.0;
        String[] code = new String[]{"LEFT", "CENTER", "RIGHT"};
        double[] width = new double[]{0.0};
        try {
            this.match(14);
            this.match(11);
            block9: while (true) {
                switch (this.LA(1)) {
                    case 15: {
                        this.match(15);
                        if (VRMLHelper.verbose) {
                            System.err.print("String ");
                        }
                        text = this.mfstringValue();
                        continue block9;
                    }
                    case 16: {
                        this.match(16);
                        if (VRMLHelper.verbose) {
                            System.err.print("spacing ");
                        }
                        spacing = this.sffloatValue();
                        continue block9;
                    }
                    case 17: {
                        this.match(17);
                        if (VRMLHelper.verbose) {
                            System.err.print("justif. ");
                        }
                        just = this.sfenumValue();
                        continue block9;
                    }
                    case 18: {
                        this.match(18);
                        if (VRMLHelper.verbose) {
                            System.err.print("width ");
                        }
                        width = this.mffloatValue();
                        continue block9;
                    }
                    case 94: {
                        this.wrongAttribute();
                        continue block9;
                    }
                }
                break;
            }
            this.match(12);
            int justif = VRMLHelper.getEnum(code, just);
            String[] text2 = new String[]{VRMLHelper.mergeStrings(text)};
            label = new PointSet();
            label.setNumPoints(1);
            double[][] d = new double[][]{{0.0, 0.0, 0.0}};
            label.setVertexAttributes(Attribute.COORDINATES, new DoubleArrayArray.Array(d));
            label.setVertexAttributes(Attribute.LABELS, new StringArray(text2));
            label.setName("Label");
            if (VRMLHelper.verbose) {
                System.err.println(")");
            }
            state.extraGeoTrans = new Transformation();
            state.edgeDraw = 2;
            state.vertexDraw = 0;
            state.faceDraw = 2;
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
        return label;
    }

    private final IndexedFaceSet coneNode(State state, Appearance app) throws RecognitionException, TokenStreamException {
        IndexedFaceSet cone = null;
        if (VRMLHelper.verbose) {
            System.err.print("Cone( ");
        }
        String[] parts = new String[]{"SIDES", "BOTTOM", "ALL"};
        boolean[] partsMask = null;
        double r = 1.0;
        double h = 2.0;
        boolean sideDraw = false;
        boolean bottomDraw = false;
        try {
            this.match(19);
            this.match(11);
            block8: while (true) {
                switch (this.LA(1)) {
                    case 20: {
                        this.match(20);
                        if (VRMLHelper.verbose) {
                            System.err.print("parts ");
                        }
                        partsMask = this.sfbitmaskValue(parts);
                        continue block8;
                    }
                    case 21: {
                        this.match(21);
                        if (VRMLHelper.verbose) {
                            System.err.print("bottomRadius ");
                        }
                        r = this.sffloatValue();
                        continue block8;
                    }
                    case 22: {
                        this.match(22);
                        if (VRMLHelper.verbose) {
                            System.err.print("height ");
                        }
                        h = this.sffloatValue();
                        continue block8;
                    }
                    case 94: {
                        this.wrongAttribute();
                        continue block8;
                    }
                }
                break;
            }
            this.match(12);
            if (partsMask == null) {
                bottomDraw = true;
                sideDraw = true;
            } else {
                if (partsMask[2] | !(partsMask[0] | partsMask[1])) {
                    bottomDraw = true;
                    sideDraw = true;
                }
                if (partsMask[0]) {
                    sideDraw = true;
                }
                if (partsMask[1]) {
                    bottomDraw = true;
                }
            }
            cone = VRMLHelper.cone(sideDraw, bottomDraw, 20);
            cone.setName("cone");
            state.extraGeoTrans = new Transformation();
            state.edgeDraw = 2;
            state.vertexDraw = 2;
            state.faceDraw = 0;
            MatrixBuilder.euclidean().scale(r, h, r).translate(0.0, -0.5, 0.0).assignTo(state.extraGeoTrans);
            if (VRMLHelper.verbose) {
                System.err.println(")");
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
        return cone;
    }

    private final IndexedFaceSet cubeNode(State state, Appearance app) throws RecognitionException, TokenStreamException {
        IndexedFaceSet cube = null;
        if (VRMLHelper.verbose) {
            System.err.print("Cube( ");
        }
        double w = 2.0;
        double h = 2.0;
        double d = 2.0;
        try {
            this.match(23);
            this.match(11);
            block8: while (true) {
                switch (this.LA(1)) {
                    case 18: {
                        this.match(18);
                        if (VRMLHelper.verbose) {
                            System.err.print("width ");
                        }
                        w = this.sffloatValue();
                        continue block8;
                    }
                    case 22: {
                        this.match(22);
                        if (VRMLHelper.verbose) {
                            System.err.print("height ");
                        }
                        h = this.sffloatValue();
                        continue block8;
                    }
                    case 24: {
                        this.match(24);
                        if (VRMLHelper.verbose) {
                            System.err.print("depth ");
                        }
                        d = this.sffloatValue();
                        continue block8;
                    }
                    case 94: {
                        this.wrongAttribute();
                        continue block8;
                    }
                }
                break;
            }
            this.match(12);
            cube = Primitives.cube(false);
            cube.setName("cube");
            state.extraGeoTrans = new Transformation();
            state.edgeDraw = 2;
            state.vertexDraw = 2;
            state.faceDraw = 0;
            MatrixBuilder.euclidean().scale(w / 2.0, h / 2.0, d / 2.0).assignTo(state.extraGeoTrans);
            if (VRMLHelper.verbose) {
                System.err.println(")");
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
        return cube;
    }

    private final IndexedFaceSet cylinderNode(State state, Appearance app) throws RecognitionException, TokenStreamException {
        IndexedFaceSet cylinder = null;
        if (VRMLHelper.verbose) {
            System.err.print("Cylinder( ");
        }
        String[] parts = new String[]{"SIDES", "TOP", "BOTTOM", "ALL"};
        boolean[] partsMask = null;
        double r = 1.0;
        double h = 2.0;
        try {
            this.match(25);
            this.match(11);
            block8: while (true) {
                switch (this.LA(1)) {
                    case 20: {
                        this.match(20);
                        if (VRMLHelper.verbose) {
                            System.err.print("parts ");
                        }
                        partsMask = this.sfbitmaskValue(parts);
                        continue block8;
                    }
                    case 26: {
                        this.match(26);
                        if (VRMLHelper.verbose) {
                            System.err.print("radius ");
                        }
                        r = this.sffloatValue();
                        continue block8;
                    }
                    case 22: {
                        this.match(22);
                        if (VRMLHelper.verbose) {
                            System.err.print("height ");
                        }
                        h = this.sffloatValue();
                        continue block8;
                    }
                    case 94: {
                        this.wrongAttribute();
                        continue block8;
                    }
                }
                break;
            }
            this.match(12);
            cylinder = partsMask == null ? VRMLHelper.cylinder(true, true, true, 20) : (partsMask[3] ? VRMLHelper.cylinder(true, true, true, 20) : (!(partsMask[0] | partsMask[1] | partsMask[2]) ? VRMLHelper.cylinder(true, true, true, 20) : VRMLHelper.cylinder(partsMask[0], partsMask[1], partsMask[2], 20)));
            cylinder.setName("cylinder");
            state.extraGeoTrans = new Transformation();
            state.edgeDraw = 2;
            state.vertexDraw = 2;
            state.faceDraw = 0;
            MatrixBuilder.euclidean().scale(r, h, r).assignTo(state.extraGeoTrans);
            if (VRMLHelper.verbose) {
                System.err.println(")");
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
        return cylinder;
    }

    private final IndexedFaceSet indexedFaceSetNode(State state, Appearance app) throws RecognitionException, TokenStreamException {
        IndexedFaceSet ifs = null;
        if (VRMLHelper.verbose) {
            System.err.print("IndexedFaceSet( ");
        }
        int[] coordIndex = new int[]{0};
        int[] materialIndex = new int[]{};
        int[] normalIndex = new int[]{};
        int[] textureCoordIndex = new int[]{};
        try {
            this.match(27);
            this.match(11);
            block9: while (true) {
                switch (this.LA(1)) {
                    case 28: {
                        this.match(28);
                        if (VRMLHelper.verbose) {
                            System.err.print("coordIndex ");
                        }
                        coordIndex = this.mflongValue();
                        continue block9;
                    }
                    case 29: {
                        this.match(29);
                        if (VRMLHelper.verbose) {
                            System.err.print("materialIndex ");
                        }
                        materialIndex = this.mflongValue();
                        continue block9;
                    }
                    case 30: {
                        this.match(30);
                        if (VRMLHelper.verbose) {
                            System.err.print("normalIndex ");
                        }
                        normalIndex = this.mflongValue();
                        continue block9;
                    }
                    case 31: {
                        this.match(31);
                        if (VRMLHelper.verbose) {
                            System.err.print("textureCoordIndex ");
                        }
                        textureCoordIndex = this.mflongValue();
                        continue block9;
                    }
                    case 94: {
                        this.wrongAttribute();
                        continue block9;
                    }
                }
                break;
            }
            this.match(12);
            int[][] coordIndex2 = VRMLHelper.convertIndexList(coordIndex);
            int[][] materialIndex2 = VRMLHelper.convertIndexList(materialIndex);
            int[][] normalIndex2 = VRMLHelper.convertIndexList(normalIndex);
            int[][] textureCoordIndex2 = VRMLHelper.convertIndexList(textureCoordIndex);
            IndexedFaceSetFactory ifsf = new IndexedFaceSetFactory();
            ifsf.setVertexCount(state.coords.length);
            ifsf.setFaceCount(coordIndex2.length);
            ifsf.setVertexAttribute(Attribute.COORDINATES, new DoubleArrayArray.Array(state.coords));
            ifsf.setFaceIndices(coordIndex2);
            if (state.haveToSeparateVertices()) {
                int[] reffTab = VRMLHelper.separateVerticesAndVNormals(coordIndex2, state);
                ifsf = new IndexedFaceSetFactory();
                ifsf.setVertexCount(reffTab.length);
                ifsf.setFaceCount(coordIndex2.length);
                ifsf.setVertexAttribute(Attribute.COORDINATES, new DoubleArrayArray.Array(state.coords));
                ifsf.setFaceIndices(coordIndex2);
            }
            VRMLHelper.setNormals(ifsf, coordIndex2, normalIndex2, state);
            VRMLHelper.setColors(ifsf, coordIndex2, materialIndex2, state);
            ifsf.setGenerateEdgesFromFaces(this.generateEdgesFromFaces);
            ifsf.update();
            ifs = ifsf.getIndexedFaceSet();
            state.assignTexture(app, ifs);
            ifs.setName("Face Set");
            state.extraGeoTrans = new Transformation();
            state.faceDraw = 0;
            if (VRMLHelper.verbose) {
                System.err.println(")");
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
        return ifs;
    }

    private final IndexedLineSet indexedLineSetNode(State state, Appearance app) throws RecognitionException, TokenStreamException {
        IndexedLineSet ils = null;
        State state2 = new State(state);
        if (VRMLHelper.verbose) {
            System.err.print("IndexedLineSet( ");
        }
        int[] coordIndex = new int[]{0};
        int[] materialIndex = new int[]{};
        int[] normalIndex = new int[]{};
        int[] textureCoordIndex = new int[]{};
        try {
            this.match(32);
            this.match(11);
            block9: while (true) {
                switch (this.LA(1)) {
                    case 28: {
                        this.match(28);
                        if (VRMLHelper.verbose) {
                            System.err.print("coordIndex ");
                        }
                        coordIndex = this.mflongValue();
                        continue block9;
                    }
                    case 29: {
                        this.match(29);
                        if (VRMLHelper.verbose) {
                            System.err.print("materialIndex ");
                        }
                        materialIndex = this.mflongValue();
                        continue block9;
                    }
                    case 30: {
                        this.match(30);
                        if (VRMLHelper.verbose) {
                            System.err.print("normalIndex ");
                        }
                        normalIndex = this.mflongValue();
                        continue block9;
                    }
                    case 31: {
                        this.match(31);
                        if (VRMLHelper.verbose) {
                            System.err.print("textureCoordIndex ");
                        }
                        textureCoordIndex = this.mflongValue();
                        continue block9;
                    }
                    case 94: {
                        this.wrongAttribute();
                        continue block9;
                    }
                }
                break;
            }
            this.match(12);
            int[][] coordIndex2 = VRMLHelper.convertIndexList(coordIndex);
            int[][] materialIndex2 = VRMLHelper.convertIndexList(materialIndex);
            int[][] normalIndex2 = VRMLHelper.convertIndexList(normalIndex);
            int[][] textureCoordIndex2 = VRMLHelper.convertIndexList(textureCoordIndex);
            IndexedLineSetFactory ilsf = new IndexedLineSetFactory();
            ilsf.setVertexCount(state.coords.length);
            ilsf.setLineCount(coordIndex2.length);
            ilsf.setVertexAttribute(Attribute.COORDINATES, new DoubleArrayArray.Array(state2.coords));
            ilsf.setEdgeIndices(coordIndex2);
            VRMLHelper.setColors(ilsf, coordIndex2, materialIndex2, state2);
            ilsf.update();
            ils = ilsf.getIndexedLineSet();
            ils.setName("Line Set");
            state.extraGeoTrans = new Transformation();
            state.edgeDraw = 0;
            state.faceDraw = 0;
            if (VRMLHelper.verbose) {
                System.err.println(")");
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
        return ils;
    }

    private final PointSet pointSetNode(State state, Appearance app) throws RecognitionException, TokenStreamException {
        PointSet ps = null;
        if (VRMLHelper.verbose) {
            System.err.print("PointSet( ");
        }
        int start = 0;
        int num = -1;
        try {
            this.match(33);
            this.match(11);
            block7: while (true) {
                switch (this.LA(1)) {
                    case 34: {
                        this.match(34);
                        if (VRMLHelper.verbose) {
                            System.err.print("startIndex ");
                        }
                        start = this.sflongValue();
                        continue block7;
                    }
                    case 35: {
                        this.match(35);
                        if (VRMLHelper.verbose) {
                            System.err.print("numPoints ");
                        }
                        num = this.sflongValue();
                        continue block7;
                    }
                    case 94: {
                        this.wrongAttribute();
                        continue block7;
                    }
                }
                break;
            }
            this.match(12);
            double[][] coords2 = new double[num][];
            System.arraycopy(state.coords, start, coords2, 0, num);
            ps = new PointSet();
            ps.setNumPoints(num);
            ps.setVertexAttributes(Attribute.COORDINATES, new DoubleArrayArray.Array(coords2));
            VRMLHelper.setColors(ps, state, start, num);
            ps.setName("Point Set");
            state.extraGeoTrans = new Transformation();
            state.vertexDraw = 0;
            state.edgeDraw = 0;
            state.faceDraw = 0;
            if (VRMLHelper.verbose) {
                System.err.println(")");
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
        return ps;
    }

    private final Geometry sphereNode(State state, Appearance app) throws RecognitionException, TokenStreamException {
        Sphere sphere = null;
        if (VRMLHelper.verbose) {
            System.err.print("Sphere( ");
        }
        double r = 1.0;
        try {
            this.match(36);
            this.match(11);
            block6: while (true) {
                switch (this.LA(1)) {
                    case 26: {
                        this.match(26);
                        if (VRMLHelper.verbose) {
                            System.err.print("radius ");
                        }
                        r = this.sffloatValue();
                        continue block6;
                    }
                    case 94: {
                        this.wrongAttribute();
                        continue block6;
                    }
                }
                break;
            }
            this.match(12);
            sphere = new Sphere();
            sphere.setName("Sphere");
            state.extraGeoTrans = new Transformation();
            MatrixBuilder.euclidean().scale(r).assignTo(state.extraGeoTrans);
            state.edgeDraw = 2;
            state.vertexDraw = 2;
            state.faceDraw = 0;
            if (VRMLHelper.verbose) {
                System.err.println(")");
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
        return sphere;
    }

    private final String[] mfstringValue() throws RecognitionException, TokenStreamException {
        String[] strl = new String[]{};
        this.strs = new String[10000];
        int i = 0;
        try {
            block1 : switch (this.LA(1)) {
                case 100: {
                    this.match(100);
                    switch (this.LA(1)) {
                        case 101: {
                            this.match(101);
                            strl = new String[]{};
                            break block1;
                        }
                        case 94: 
                        case 105: {
                            String str;
                            this.strs[0] = str = this.sfstringValue();
                            ++i;
                            while (this.LA(1) == 102 && (this.LA(2) == 94 || this.LA(2) == 105)) {
                                this.match(102);
                                str = this.sfstringValue();
                                if (i == this.strs.length) {
                                    this.strs = VRMLHelper.reallocate(this.strs);
                                }
                                this.strs[i] = str;
                                ++i;
                            }
                            switch (this.LA(1)) {
                                case 102: {
                                    this.match(102);
                                    break;
                                }
                                case 101: {
                                    break;
                                }
                                default: {
                                    throw new NoViableAltException(this.LT(1), this.getFilename());
                                }
                            }
                            this.match(101);
                            strl = new String[i];
                            System.arraycopy(this.strs, 0, strl, 0, i);
                            break block1;
                        }
                    }
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                case 94: 
                case 105: {
                    String str = this.sfstringValue();
                    strl = new String[]{str};
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
        return strl;
    }

    private final double sffloatValue() throws RecognitionException, TokenStreamException {
        double d = 0.0;
        try {
            d = this.doubleThing();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
        return d;
    }

    private final String sfenumValue() throws RecognitionException, TokenStreamException {
        String s = "";
        try {
            s = this.id();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_8);
        }
        return s;
    }

    private final double[] mffloatValue() throws RecognitionException, TokenStreamException {
        double[] dl = null;
        this.ds = new double[10000];
        int i = 0;
        try {
            block1 : switch (this.LA(1)) {
                case 100: {
                    this.match(100);
                    switch (this.LA(1)) {
                        case 101: {
                            this.match(101);
                            dl = new double[]{};
                            break block1;
                        }
                        case 104: 
                        case 106: 
                        case 107: {
                            double d;
                            this.ds[0] = d = this.sffloatValue();
                            ++i;
                            while (this.LA(1) == 102 && (this.LA(2) == 104 || this.LA(2) == 106 || this.LA(2) == 107)) {
                                this.match(102);
                                d = this.sffloatValue();
                                if (i == this.ds.length) {
                                    this.ds = VRMLHelper.reallocate(this.ds);
                                }
                                this.ds[i] = d;
                                ++i;
                            }
                            switch (this.LA(1)) {
                                case 102: {
                                    this.match(102);
                                    break;
                                }
                                case 101: {
                                    break;
                                }
                                default: {
                                    throw new NoViableAltException(this.LT(1), this.getFilename());
                                }
                            }
                            this.match(101);
                            dl = new double[i];
                            System.arraycopy(this.ds, 0, dl, 0, i);
                            break block1;
                        }
                    }
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                case 104: 
                case 106: 
                case 107: {
                    double d = this.sffloatValue();
                    dl = new double[]{d};
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_9);
        }
        return dl;
    }

    private final void wrongAttribute() throws RecognitionException, TokenStreamException {
        Token g = null;
        try {
            g = this.LT(1);
            this.match(94);
            while (_tokenSet_4.member(this.LA(1)) && this.LA(2) >= 4 && this.LA(2) <= 117) {
                this.dumb();
            }
            System.out.println("unknown Attribute:" + g.getText() + " -following Attributes ignored!");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_10);
        }
    }

    private final boolean[] sfbitmaskValue(String[] code) throws RecognitionException, TokenStreamException {
        boolean[] mask = new boolean[code.length];
        for (int i = 0; i < code.length; ++i) {
            mask[i] = false;
        }
        String b = "";
        try {
            switch (this.LA(1)) {
                case 94: {
                    b = this.id();
                    VRMLHelper.checkFlag(code, mask, b);
                    break;
                }
                case 95: {
                    this.match(95);
                    b = this.id();
                    VRMLHelper.checkFlag(code, mask, b);
                    while (this.LA(1) == 96 && this.LA(2) == 94) {
                        this.match(96);
                        b = this.id();
                        VRMLHelper.checkFlag(code, mask, b);
                    }
                    switch (this.LA(1)) {
                        case 96: {
                            this.match(96);
                            break;
                        }
                        case 97: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.match(97);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_11);
        }
        return mask;
    }

    private final int[] mflongValue() throws RecognitionException, TokenStreamException {
        int[] ll = null;
        this.ls = new int[10000];
        int i = 0;
        try {
            block1 : switch (this.LA(1)) {
                case 100: {
                    this.match(100);
                    switch (this.LA(1)) {
                        case 101: {
                            this.match(101);
                            ll = new int[]{};
                            break block1;
                        }
                        case 104: 
                        case 106: 
                        case 107: {
                            int l;
                            this.ls[0] = l = this.sflongValue();
                            ++i;
                            while (this.LA(1) == 102 && (this.LA(2) == 104 || this.LA(2) == 106 || this.LA(2) == 107)) {
                                this.match(102);
                                l = this.sflongValue();
                                if (i == this.ls.length) {
                                    this.ls = VRMLHelper.reallocate(this.ls);
                                }
                                this.ls[i] = l;
                                ++i;
                            }
                            switch (this.LA(1)) {
                                case 102: {
                                    this.match(102);
                                    break;
                                }
                                case 101: {
                                    break;
                                }
                                default: {
                                    throw new NoViableAltException(this.LT(1), this.getFilename());
                                }
                            }
                            this.match(101);
                            ll = new int[i];
                            System.arraycopy(this.ls, 0, ll, 0, i);
                            break block1;
                        }
                    }
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                case 104: 
                case 106: 
                case 107: {
                    int l = this.sflongValue();
                    ll = new int[]{l};
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_12);
        }
        return ll;
    }

    private final int sflongValue() throws RecognitionException, TokenStreamException {
        int i = 0;
        try {
            i = this.intThing();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_13);
        }
        return i;
    }

    private final void coordinate3Node(State state) throws RecognitionException, TokenStreamException {
        if (VRMLHelper.verbose) {
            System.err.println("Coordinate3");
        }
        Object d = new double[][]{};
        try {
            this.match(38);
            this.match(11);
            switch (this.LA(1)) {
                case 39: {
                    this.match(39);
                    d = this.mfvec3fValue();
                    break;
                }
                case 94: {
                    this.wrongAttribute();
                    break;
                }
                case 12: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(12);
            state.coords = d;
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void infoNode(State state) throws RecognitionException, TokenStreamException {
        if (VRMLHelper.verbose) {
            System.err.println("Info:{ ");
        }
        String s = null;
        try {
            this.match(40);
            this.match(11);
            block6: while (true) {
                switch (this.LA(1)) {
                    case 15: {
                        this.match(15);
                        s = this.sfstringValue();
                        if (!VRMLHelper.verbose) continue block6;
                        System.err.println(state.history + "    " + s);
                        continue block6;
                    }
                    case 94: {
                        this.wrongAttribute();
                        continue block6;
                    }
                }
                break;
            }
            this.match(12);
            if (VRMLHelper.verbose) {
                System.err.println(state.history + "}");
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void materialNode(State state) throws RecognitionException, TokenStreamException {
        if (VRMLHelper.verbose) {
            System.err.print("Material( ");
        }
        Color[] c = null;
        double[] d = null;
        Color[] amb = new Color[]{};
        Color[] dif = new Color[]{};
        Color[] spe = new Color[]{};
        Color[] emi = new Color[]{};
        double[] shi = new double[]{};
        double[] tra = new double[]{};
        try {
            this.match(41);
            this.match(11);
            block11: while (true) {
                switch (this.LA(1)) {
                    case 42: {
                        this.match(42);
                        if (VRMLHelper.verbose) {
                            System.err.print("ambientColor ");
                        }
                        c = this.mfcolorValue();
                        amb = c;
                        continue block11;
                    }
                    case 43: {
                        this.match(43);
                        if (VRMLHelper.verbose) {
                            System.err.print("diffuseColor ");
                        }
                        c = this.mfcolorValue();
                        dif = c;
                        continue block11;
                    }
                    case 44: {
                        this.match(44);
                        if (VRMLHelper.verbose) {
                            System.err.print("specularColor ");
                        }
                        c = this.mfcolorValue();
                        spe = c;
                        continue block11;
                    }
                    case 45: {
                        this.match(45);
                        if (VRMLHelper.verbose) {
                            System.err.print("emissiveColor ");
                        }
                        c = this.mfcolorValue();
                        emi = c;
                        continue block11;
                    }
                    case 46: {
                        this.match(46);
                        if (VRMLHelper.verbose) {
                            System.err.print("shininess ");
                        }
                        d = this.mffloatValue();
                        shi = d;
                        continue block11;
                    }
                    case 47: {
                        this.match(47);
                        if (VRMLHelper.verbose) {
                            System.err.print("transparency ");
                        }
                        d = this.mffloatValue();
                        tra = d;
                        continue block11;
                    }
                    case 94: {
                        this.wrongAttribute();
                        continue block11;
                    }
                }
                break;
            }
            this.match(12);
            state.ambient = amb;
            state.diffuse = dif;
            state.specular = spe;
            state.emissive = emi;
            state.shininess = shi;
            state.transparency = tra;
            if (VRMLHelper.verbose) {
                System.err.println(")");
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void baseColorNode(State state) throws RecognitionException, TokenStreamException {
        if (VRMLHelper.verbose) {
            System.err.print("BaseColor( ");
        }
        Color[] c = null;
        Color[] rgb = new Color[]{new Color(0.8f, 0.8f, 0.8f)};
        try {
            this.match(48);
            this.match(11);
            block6: while (true) {
                switch (this.LA(1)) {
                    case 49: {
                        this.match(49);
                        if (VRMLHelper.verbose) {
                            System.err.print("rgb ");
                        }
                        c = this.mfcolorValue();
                        rgb = c;
                        continue block6;
                    }
                    case 94: {
                        this.wrongAttribute();
                        continue block6;
                    }
                }
                break;
            }
            this.match(12);
            state.diffuse = rgb;
            if (VRMLHelper.verbose) {
                System.err.println(")");
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void materialBindingNode(State state) throws RecognitionException, TokenStreamException {
        if (VRMLHelper.verbose) {
            System.err.println("Material Binding");
        }
        String mb = "OVERALL";
        try {
            this.match(50);
            this.match(11);
            switch (this.LA(1)) {
                case 51: {
                    this.match(51);
                    mb = this.sfenumValue();
                    break;
                }
                case 94: {
                    this.wrongAttribute();
                    break;
                }
                case 12: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(12);
            state.materialBinding = State.getBinding(mb);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void normalNode(State state) throws RecognitionException, TokenStreamException {
        if (VRMLHelper.verbose) {
            System.err.println("Normals");
        }
        Object normals = new double[][]{};
        try {
            this.match(52);
            this.match(11);
            switch (this.LA(1)) {
                case 53: {
                    this.match(53);
                    normals = this.mfvec3fValue();
                    break;
                }
                case 94: {
                    this.wrongAttribute();
                    break;
                }
                case 12: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(12);
            state.normals = normals;
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void normalBindingNode(State state) throws RecognitionException, TokenStreamException {
        if (VRMLHelper.verbose) {
            System.err.print("normalBinding( ");
        }
        String nb = "DEFAULT";
        try {
            this.match(54);
            this.match(11);
            switch (this.LA(1)) {
                case 51: {
                    this.match(51);
                    if (VRMLHelper.verbose) {
                        System.err.print("value ");
                    }
                    nb = this.sfenumValue();
                    break;
                }
                case 94: {
                    this.wrongAttribute();
                    break;
                }
                case 12: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(12);
            state.normalBinding = State.getBinding(nb);
            if (VRMLHelper.verbose) {
                System.err.println(")");
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void texture2Node(State state) throws RecognitionException, TokenStreamException {
        if (VRMLHelper.verbose) {
            System.err.print("texture2( ");
        }
        String file = "";
        Object image = new int[][][]{new int[][]{new int[0]}};
        String[] code = new String[]{"REPEAT", "CLAMP"};
        String wrapS = "REPEAT";
        String wrapT = "REPEAT";
        try {
            this.match(55);
            this.match(11);
            block9: while (true) {
                switch (this.LA(1)) {
                    case 56: {
                        this.match(56);
                        if (VRMLHelper.verbose) {
                            System.err.print("filename ");
                        }
                        file = this.sfstringValue();
                        continue block9;
                    }
                    case 57: {
                        this.match(57);
                        if (VRMLHelper.verbose) {
                            System.err.print("image ");
                        }
                        image = this.sfimageValue();
                        continue block9;
                    }
                    case 58: {
                        this.match(58);
                        if (VRMLHelper.verbose) {
                            System.err.print("wrapS ");
                        }
                        wrapS = this.sfenumValue();
                        continue block9;
                    }
                    case 59: {
                        this.match(59);
                        if (VRMLHelper.verbose) {
                            System.err.print("wrapT ");
                        }
                        wrapT = this.sfenumValue();
                        continue block9;
                    }
                    case 94: {
                        this.wrongAttribute();
                        continue block9;
                    }
                }
                break;
            }
            this.match(12);
            state.textureFile = file;
            state.textureData = image;
            state.wrapS = VRMLHelper.getEnum(code, wrapS);
            state.wrapT = VRMLHelper.getEnum(code, wrapT);
            if (VRMLHelper.verbose) {
                System.err.println(")");
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void texture2TransformNode(State state) throws RecognitionException, TokenStreamException {
        if (VRMLHelper.verbose) {
            System.err.print("texture2Transform( ");
        }
        double[] trans = new double[]{0.0, 0.0};
        double rot = 0.0;
        double[] scale = new double[]{1.0, 1.0};
        double[] center = new double[]{0.0, 0.0};
        try {
            this.match(60);
            this.match(11);
            block9: while (true) {
                switch (this.LA(1)) {
                    case 61: {
                        this.match(61);
                        if (VRMLHelper.verbose) {
                            System.err.print("translation ");
                        }
                        trans = this.sfvec2fValue();
                        continue block9;
                    }
                    case 62: {
                        this.match(62);
                        if (VRMLHelper.verbose) {
                            System.err.print("rotation ");
                        }
                        rot = this.sffloatValue();
                        continue block9;
                    }
                    case 63: {
                        this.match(63);
                        if (VRMLHelper.verbose) {
                            System.err.print("scaleFactor ");
                        }
                        scale = this.sfvec2fValue();
                        continue block9;
                    }
                    case 64: {
                        this.match(64);
                        if (VRMLHelper.verbose) {
                            System.err.print("center ");
                        }
                        center = this.sfvec2fValue();
                        continue block9;
                    }
                    case 94: {
                        this.wrongAttribute();
                        continue block9;
                    }
                }
                break;
            }
            this.match(12);
            MatrixBuilder.euclidean().translate(trans[0], trans[1], 0.0).translate(center[0], center[1], 0.0).rotate(rot, 0.0, 0.0, 1.0).scale(scale[0], scale[1], 1.0).translate(-center[0], -center[1], 0.0).assignTo(state.textureTrafo);
            if (VRMLHelper.verbose) {
                System.err.println(")");
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void textureCoordinate2Node(State state) throws RecognitionException, TokenStreamException {
        if (VRMLHelper.verbose) {
            System.err.print("TextureCoordinate2( ");
        }
        Object point = new double[][]{{0.0, 0.0}};
        try {
            this.match(65);
            this.match(11);
            switch (this.LA(1)) {
                case 39: {
                    this.match(39);
                    if (VRMLHelper.verbose) {
                        System.err.print("point ");
                    }
                    point = this.mfvec2fValue();
                    break;
                }
                case 94: {
                    this.wrongAttribute();
                    break;
                }
                case 12: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(12);
            state.textureCoords = point;
            if (VRMLHelper.verbose) {
                System.err.println(")");
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void shapeHintsNode(State state) throws RecognitionException, TokenStreamException {
        if (VRMLHelper.verbose) {
            System.err.println("ShapeHints");
        }
        boolean vertOrd = false;
        boolean shape = false;
        boolean face = false;
        double crease = 0.5;
        try {
            this.match(66);
            this.match(11);
            block9: while (true) {
                switch (this.LA(1)) {
                    case 67: {
                        this.match(67);
                        String s = this.sfenumValue();
                        state.vertOrder = VRMLHelper.getEnum(State.VERTORDER, s);
                        continue block9;
                    }
                    case 68: {
                        this.match(68);
                        String s = this.sfenumValue();
                        state.shapeType = VRMLHelper.getEnum(State.SHAPETYPE, s);
                        continue block9;
                    }
                    case 69: {
                        this.match(69);
                        String s = this.sfenumValue();
                        state.faceType = VRMLHelper.getEnum(State.FACETYPE, s);
                        continue block9;
                    }
                    case 70: {
                        this.match(70);
                        state.creaseAngle = crease = this.sffloatValue();
                        continue block9;
                    }
                    case 94: {
                        this.wrongAttribute();
                        continue block9;
                    }
                }
                break;
            }
            this.match(12);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final double[][] mfvec3fValue() throws RecognitionException, TokenStreamException {
        Object vecl = null;
        this.vecs = new double[10000][];
        int i = 0;
        try {
            block1 : switch (this.LA(1)) {
                case 100: {
                    this.match(100);
                    switch (this.LA(1)) {
                        case 101: {
                            this.match(101);
                            vecl = new double[0][];
                            break block1;
                        }
                        case 104: 
                        case 106: 
                        case 107: {
                            double[] vec = this.sfvec3fValue();
                            this.vecs[0] = vec;
                            ++i;
                            while (this.LA(1) == 102 && (this.LA(2) == 104 || this.LA(2) == 106 || this.LA(2) == 107)) {
                                this.match(102);
                                vec = this.sfvec3fValue();
                                if (i == this.vecs.length) {
                                    this.vecs = VRMLHelper.reallocate(this.vecs);
                                }
                                this.vecs[i] = vec;
                                ++i;
                            }
                            switch (this.LA(1)) {
                                case 102: {
                                    this.match(102);
                                    break;
                                }
                                case 101: {
                                    break;
                                }
                                default: {
                                    throw new NoViableAltException(this.LT(1), this.getFilename());
                                }
                            }
                            this.match(101);
                            vecl = new double[i][];
                            System.arraycopy(this.vecs, 0, vecl, 0, i);
                            break block1;
                        }
                    }
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                case 104: 
                case 106: 
                case 107: {
                    double[] vec = this.sfvec3fValue();
                    vecl = new double[][]{vec};
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_14);
        }
        return vecl;
    }

    private final Color[] mfcolorValue() throws RecognitionException, TokenStreamException {
        Color[] cl = null;
        Color c = null;
        this.cs = new Color[10000];
        int i = 0;
        try {
            block1 : switch (this.LA(1)) {
                case 100: {
                    this.match(100);
                    switch (this.LA(1)) {
                        case 101: {
                            this.match(101);
                            cl = new Color[]{};
                            break block1;
                        }
                        case 104: 
                        case 106: 
                        case 107: {
                            this.cs[0] = c = this.sfcolorValue();
                            ++i;
                            while (this.LA(1) == 102 && (this.LA(2) == 104 || this.LA(2) == 106 || this.LA(2) == 107)) {
                                this.match(102);
                                c = this.sfcolorValue();
                                if (i == this.cs.length) {
                                    this.cs = VRMLHelper.reallocate(this.cs);
                                }
                                this.cs[i] = c;
                                ++i;
                            }
                            switch (this.LA(1)) {
                                case 102: {
                                    this.match(102);
                                    break;
                                }
                                case 101: {
                                    break;
                                }
                                default: {
                                    throw new NoViableAltException(this.LT(1), this.getFilename());
                                }
                            }
                            this.match(101);
                            cl = new Color[i];
                            System.arraycopy(this.cs, 0, cl, 0, i);
                            break block1;
                        }
                    }
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                case 104: 
                case 106: 
                case 107: {
                    c = this.sfcolorValue();
                    cl = new Color[]{c};
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_15);
        }
        return cl;
    }

    private final int[][][] sfimageValue() throws RecognitionException, TokenStreamException {
        Object colors = new int[][][]{new int[][]{new int[0]}};
        int width = 0;
        int height = 0;
        int colorDim = 0;
        int[][] colL = null;
        int size = 0;
        try {
            width = this.intThing();
            height = this.intThing();
            colorDim = this.intThing();
            size = width * height;
            colL = this.hexList(size, colorDim);
            colors = new int[width][height][colorDim];
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    for (int k = 0; k < colorDim; ++k) {
                        colors[i][j][k] = colL[i * height + j][k];
                    }
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_16);
        }
        return colors;
    }

    private final double[] sfvec2fValue() throws RecognitionException, TokenStreamException {
        double[] vec = null;
        try {
            double fx = this.doubleThing();
            double fy = this.doubleThing();
            vec = new double[]{fx, fy};
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_17);
        }
        return vec;
    }

    private final double[][] mfvec2fValue() throws RecognitionException, TokenStreamException {
        Object vecl = null;
        this.vecs = new double[10000][];
        int i = 0;
        try {
            block1 : switch (this.LA(1)) {
                case 100: {
                    this.match(100);
                    switch (this.LA(1)) {
                        case 101: {
                            this.match(101);
                            vecl = new double[0][];
                            break block1;
                        }
                        case 104: 
                        case 106: 
                        case 107: {
                            double[] vec = this.sfvec2fValue();
                            this.vecs[0] = vec;
                            ++i;
                            while (this.LA(1) == 102 && (this.LA(2) == 104 || this.LA(2) == 106 || this.LA(2) == 107)) {
                                this.match(102);
                                vec = this.sfvec2fValue();
                                if (i == this.vecs.length) {
                                    this.vecs = VRMLHelper.reallocate(this.vecs);
                                }
                                this.vecs[i] = vec;
                                ++i;
                            }
                            switch (this.LA(1)) {
                                case 102: {
                                    this.match(102);
                                    break;
                                }
                                case 101: {
                                    break;
                                }
                                default: {
                                    throw new NoViableAltException(this.LT(1), this.getFilename());
                                }
                            }
                            this.match(101);
                            vecl = new double[i][];
                            System.arraycopy(this.vecs, 0, vecl, 0, i);
                            break block1;
                        }
                    }
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                case 104: 
                case 106: 
                case 107: {
                    double[] vec = this.sfvec2fValue();
                    vecl = new double[][]{vec};
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_14);
        }
        return vecl;
    }

    private final Transformation matrixTransformNode() throws RecognitionException, TokenStreamException {
        Transformation t = new Transformation();
        if (VRMLHelper.verbose) {
            System.err.println("Matrix Transform");
        }
        double[] mat = null;
        try {
            this.match(71);
            this.match(11);
            switch (this.LA(1)) {
                case 72: {
                    this.match(72);
                    mat = this.sfmatrixValue();
                    break;
                }
                case 94: {
                    this.wrongAttribute();
                    break;
                }
                case 12: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(12);
            t = new Transformation(Rn.transpose(null, mat));
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
        return t;
    }

    private final Transformation rotationNode() throws RecognitionException, TokenStreamException {
        Transformation m = new Transformation();
        if (VRMLHelper.verbose) {
            System.err.println("Rotation");
        }
        double[] d = new double[]{0.0, 0.0, 1.0, 0.0};
        try {
            this.match(73);
            this.match(11);
            switch (this.LA(1)) {
                case 62: {
                    this.match(62);
                    d = this.sfrotationValue();
                    break;
                }
                case 94: {
                    this.wrongAttribute();
                    break;
                }
                case 12: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(12);
            double[] axis = new double[3];
            System.arraycopy(d, 0, axis, 0, 3);
            MatrixBuilder.euclidean().rotate(d[3], axis).assignTo(m);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
        return m;
    }

    private final Transformation scaleNode() throws RecognitionException, TokenStreamException {
        Transformation m = new Transformation();
        if (VRMLHelper.verbose) {
            System.err.println("Scale");
        }
        double[] d = new double[]{1.0, 1.0, 1.0};
        try {
            this.match(74);
            this.match(11);
            switch (this.LA(1)) {
                case 63: {
                    this.match(63);
                    d = this.sfvec3fValue();
                    break;
                }
                case 94: {
                    this.wrongAttribute();
                    break;
                }
                case 12: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(12);
            MatrixBuilder.euclidean().scale(d).assignTo(m);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
        return m;
    }

    private final Transformation transformNode() throws RecognitionException, TokenStreamException {
        Transformation m = new Transformation();
        if (VRMLHelper.verbose) {
            System.err.println("transform Node");
        }
        double[] trans = new double[]{0.0, 0.0, 0.0};
        double[] rot = new double[]{0.0, 0.0, 1.0, 0.0};
        double[] scaleF = new double[]{1.0, 1.0, 1.0};
        double[] scaleO = new double[]{0.0, 0.0, 1.0, 0.0};
        double[] center = new double[]{0.0, 0.0, 0.0};
        try {
            this.match(75);
            this.match(11);
            block10: while (true) {
                switch (this.LA(1)) {
                    case 61: {
                        this.match(61);
                        trans = this.sfvec3fValue();
                        continue block10;
                    }
                    case 62: {
                        this.match(62);
                        rot = this.sfrotationValue();
                        continue block10;
                    }
                    case 63: {
                        this.match(63);
                        scaleF = this.sfvec3fValue();
                        continue block10;
                    }
                    case 76: {
                        this.match(76);
                        scaleO = this.sfrotationValue();
                        continue block10;
                    }
                    case 64: {
                        this.match(64);
                        center = this.sfvec3fValue();
                        continue block10;
                    }
                    case 94: {
                        this.wrongAttribute();
                        continue block10;
                    }
                }
                break;
            }
            this.match(12);
            MatrixBuilder.euclidean().translate(trans).translate(center).rotate(rot[3], rot[0], rot[1], rot[2]).rotate(scaleO[3], scaleO[0], scaleO[1], scaleO[2]).scale(scaleF).rotate(-scaleO[3], scaleO[0], scaleO[1], scaleO[2]).translate(-center[0], -center[1], -center[2]).assignTo(m);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
        return m;
    }

    private final Transformation translationNode() throws RecognitionException, TokenStreamException {
        Transformation m = new Transformation();
        if (VRMLHelper.verbose) {
            System.err.println("Translation");
        }
        double[] d = new double[]{0.0, 0.0, 0.0};
        try {
            this.match(77);
            this.match(11);
            switch (this.LA(1)) {
                case 61: {
                    this.match(61);
                    d = this.sfvec3fValue();
                    break;
                }
                case 94: {
                    this.wrongAttribute();
                    break;
                }
                case 12: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(12);
            MatrixBuilder.euclidean().translate(d).assignTo(m);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
        return m;
    }

    private final double[] sfmatrixValue() throws RecognitionException, TokenStreamException {
        double[] m = new double[16];
        int i = 0;
        try {
            double d;
            m[i] = d = this.doubleThing();
            m[++i] = d = this.doubleThing();
            m[++i] = d = this.doubleThing();
            m[++i] = d = this.doubleThing();
            m[++i] = d = this.doubleThing();
            m[++i] = d = this.doubleThing();
            m[++i] = d = this.doubleThing();
            m[++i] = d = this.doubleThing();
            m[++i] = d = this.doubleThing();
            m[++i] = d = this.doubleThing();
            m[++i] = d = this.doubleThing();
            m[++i] = d = this.doubleThing();
            m[++i] = d = this.doubleThing();
            m[++i] = d = this.doubleThing();
            m[++i] = d = this.doubleThing();
            m[++i] = d = this.doubleThing();
            ++i;
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_14);
        }
        return m;
    }

    private final double[] sfrotationValue() throws RecognitionException, TokenStreamException {
        double[] rv = null;
        try {
            double x = this.doubleThing();
            double y = this.doubleThing();
            double z = this.doubleThing();
            double ang = this.doubleThing();
            rv = new double[]{x, y, z, ang};
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_18);
        }
        return rv;
    }

    private final double[] sfvec3fValue() throws RecognitionException, TokenStreamException {
        double[] vec = null;
        try {
            double fx = this.doubleThing();
            double fy = this.doubleThing();
            double fz = this.doubleThing();
            vec = new double[]{fx, fy, fz};
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_19);
        }
        return vec;
    }

    private final Camera orthographicCameraNode(State state) throws RecognitionException, TokenStreamException {
        Camera cam = null;
        if (VRMLHelper.verbose) {
            System.err.print("orthographic Cam( ");
        }
        double[] pos = new double[]{0.0, 0.0, 1.0};
        double[] orient = new double[]{0.0, 0.0, 1.0, 0.0};
        double fDist = 5.0;
        double height = 2.0;
        try {
            this.match(83);
            this.match(11);
            block9: while (true) {
                switch (this.LA(1)) {
                    case 79: {
                        this.match(79);
                        if (VRMLHelper.verbose) {
                            System.err.print("position ");
                        }
                        pos = this.sfvec3fValue();
                        continue block9;
                    }
                    case 80: {
                        this.match(80);
                        if (VRMLHelper.verbose) {
                            System.err.print("Orientation ");
                        }
                        orient = this.sfrotationValue();
                        continue block9;
                    }
                    case 81: {
                        this.match(81);
                        if (VRMLHelper.verbose) {
                            System.err.print("focalDistance ");
                        }
                        fDist = this.sffloatValue();
                        continue block9;
                    }
                    case 22: {
                        this.match(22);
                        if (VRMLHelper.verbose) {
                            System.err.print("height ");
                        }
                        height = this.sffloatValue();
                        continue block9;
                    }
                    case 94: {
                        this.wrongAttribute();
                        continue block9;
                    }
                }
                break;
            }
            this.match(12);
            cam = new Camera();
            cam.setPerspective(false);
            cam.setFieldOfView(45.0);
            cam.setFocus(height * 6.0 / 5.0);
            cam.setName("orthographic Cam");
            cam.setFocalLength(fDist);
            state.extraGeoTrans = new Transformation();
            MatrixBuilder.euclidean().rotate(orient[3], orient[0], orient[1], orient[2]).translate(pos).assignTo(state.extraGeoTrans);
            if (VRMLHelper.verbose) {
                System.err.println(")");
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
        return cam;
    }

    private final Camera perspectiveCameraNode(State state) throws RecognitionException, TokenStreamException {
        Camera cam = null;
        if (VRMLHelper.verbose) {
            System.err.print("perspective Cam( ");
        }
        double[] pos = new double[]{0.0, 0.0, 1.0};
        double[] orient = new double[]{0.0, 0.0, 1.0, 0.0};
        double fDist = 5.0;
        double heightA = 0.785398;
        try {
            this.match(78);
            this.match(11);
            block9: while (true) {
                switch (this.LA(1)) {
                    case 79: {
                        this.match(79);
                        if (VRMLHelper.verbose) {
                            System.err.print("position ");
                        }
                        pos = this.sfvec3fValue();
                        continue block9;
                    }
                    case 80: {
                        this.match(80);
                        if (VRMLHelper.verbose) {
                            System.err.print("Orientation ");
                        }
                        orient = this.sfrotationValue();
                        continue block9;
                    }
                    case 81: {
                        this.match(81);
                        if (VRMLHelper.verbose) {
                            System.err.print("focalDistance ");
                        }
                        fDist = this.sffloatValue();
                        continue block9;
                    }
                    case 82: {
                        this.match(82);
                        if (VRMLHelper.verbose) {
                            System.err.print("heightAngle ");
                        }
                        heightA = this.sffloatValue();
                        continue block9;
                    }
                    case 94: {
                        this.wrongAttribute();
                        continue block9;
                    }
                }
                break;
            }
            this.match(12);
            double[] rotAx = new double[3];
            System.arraycopy(orient, 0, rotAx, 0, 3);
            cam = new Camera();
            cam.setPerspective(true);
            double hAngle = heightA * 180.0 / Math.PI;
            cam.setFieldOfView(hAngle);
            cam.setFocus(3.0);
            cam.setName("perspective Cam");
            cam.setFocalLength(fDist);
            state.extraGeoTrans = new Transformation();
            MatrixBuilder.euclidean().rotate(orient[3], rotAx).translate(pos).assignTo(state.extraGeoTrans);
            if (VRMLHelper.verbose) {
                System.err.println(")");
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
        return cam;
    }

    private final DirectionalLight directionalLightNode(State state) throws RecognitionException, TokenStreamException {
        DirectionalLight l = null;
        if (VRMLHelper.verbose) {
            System.err.print("Dir Light( ");
        }
        boolean on = true;
        double intens = 1.0;
        Color c = new Color(1.0f, 1.0f, 1.0f);
        double[] dir = new double[]{0.0, 0.0, -1.0};
        try {
            this.match(93);
            this.match(11);
            block9: while (true) {
                switch (this.LA(1)) {
                    case 85: {
                        this.match(85);
                        if (VRMLHelper.verbose) {
                            System.err.print("on ");
                        }
                        on = this.sfboolValue();
                        continue block9;
                    }
                    case 86: {
                        this.match(86);
                        if (VRMLHelper.verbose) {
                            System.err.print("intensity ");
                        }
                        intens = this.sffloatValue();
                        continue block9;
                    }
                    case 87: {
                        this.match(87);
                        if (VRMLHelper.verbose) {
                            System.err.print("color ");
                        }
                        c = this.sfcolorValue();
                        continue block9;
                    }
                    case 90: {
                        this.match(90);
                        if (VRMLHelper.verbose) {
                            System.err.print("direction ");
                        }
                        dir = this.sfvec3fValue();
                        continue block9;
                    }
                    case 94: {
                        this.wrongAttribute();
                        continue block9;
                    }
                }
                break;
            }
            this.match(12);
            l = new DirectionalLight();
            if (on) {
                l.setIntensity(intens);
            } else {
                l.setIntensity(0.0);
            }
            l.setColor(c);
            l.setGlobal(false);
            l.setName("Directional Light");
            state.extraGeoTrans = new Transformation();
            MatrixBuilder.euclidean().rotateFromTo(new double[]{0.0, 0.0, -1.0}, dir).assignTo(state.extraGeoTrans);
            if (VRMLHelper.verbose) {
                System.err.println(")");
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
        return l;
    }

    private final PointLight pointLightNode(State state) throws RecognitionException, TokenStreamException {
        PointLight l = null;
        if (VRMLHelper.verbose) {
            System.err.print("Point Light( ");
        }
        boolean on = true;
        double intens = 1.0;
        Color c = new Color(1.0f, 1.0f, 1.0f);
        double[] loc = new double[]{0.0, 0.0, 1.0};
        try {
            this.match(84);
            this.match(11);
            block9: while (true) {
                switch (this.LA(1)) {
                    case 85: {
                        this.match(85);
                        if (VRMLHelper.verbose) {
                            System.err.print("on ");
                        }
                        on = this.sfboolValue();
                        continue block9;
                    }
                    case 86: {
                        this.match(86);
                        if (VRMLHelper.verbose) {
                            System.err.print("intensity ");
                        }
                        intens = this.sffloatValue();
                        continue block9;
                    }
                    case 87: {
                        this.match(87);
                        if (VRMLHelper.verbose) {
                            System.err.print("color ");
                        }
                        c = this.sfcolorValue();
                        continue block9;
                    }
                    case 88: {
                        this.match(88);
                        if (VRMLHelper.verbose) {
                            System.err.print("location ");
                        }
                        loc = this.sfvec3fValue();
                        continue block9;
                    }
                    case 94: {
                        this.wrongAttribute();
                        continue block9;
                    }
                }
                break;
            }
            this.match(12);
            l = new PointLight();
            if (on) {
                l.setIntensity(intens);
            } else {
                l.setIntensity(0.0);
            }
            l.setColor(c);
            l.setGlobal(false);
            l.setName("Point Light");
            state.extraGeoTrans = new Transformation();
            MatrixBuilder.euclidean().translate(loc).assignTo(state.extraGeoTrans);
            if (VRMLHelper.verbose) {
                System.err.println(")");
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
        return l;
    }

    private final SpotLight spotLightNode(State state) throws RecognitionException, TokenStreamException {
        SpotLight l = null;
        if (VRMLHelper.verbose) {
            System.err.print("Spot Light( ");
        }
        boolean on = true;
        double intens = 1.0;
        Color c = new Color(1.0f, 1.0f, 1.0f);
        double[] loc = new double[]{0.0, 0.0, 1.0};
        double[] dir = new double[]{0.0, 0.0, -1.0};
        double dropR = 0.0;
        double cutA = 0.785398;
        try {
            this.match(89);
            this.match(11);
            block12: while (true) {
                switch (this.LA(1)) {
                    case 85: {
                        this.match(85);
                        if (VRMLHelper.verbose) {
                            System.err.print("on ");
                        }
                        on = this.sfboolValue();
                        continue block12;
                    }
                    case 86: {
                        this.match(86);
                        if (VRMLHelper.verbose) {
                            System.err.print("intensity ");
                        }
                        intens = this.sffloatValue();
                        continue block12;
                    }
                    case 87: {
                        this.match(87);
                        if (VRMLHelper.verbose) {
                            System.err.print("color ");
                        }
                        c = this.sfcolorValue();
                        continue block12;
                    }
                    case 88: {
                        this.match(88);
                        if (VRMLHelper.verbose) {
                            System.err.print("location ");
                        }
                        loc = this.sfvec3fValue();
                        continue block12;
                    }
                    case 90: {
                        this.match(90);
                        if (VRMLHelper.verbose) {
                            System.err.print("direction ");
                        }
                        dir = this.sfvec3fValue();
                        continue block12;
                    }
                    case 91: {
                        this.match(91);
                        if (VRMLHelper.verbose) {
                            System.err.print("dropOffRate ");
                        }
                        dropR = this.sffloatValue();
                        continue block12;
                    }
                    case 92: {
                        this.match(92);
                        if (VRMLHelper.verbose) {
                            System.err.print("cutOffAngle ");
                        }
                        cutA = this.sffloatValue();
                        continue block12;
                    }
                    case 94: {
                        this.wrongAttribute();
                        continue block12;
                    }
                }
                break;
            }
            this.match(12);
            l = new SpotLight();
            if (on) {
                l.setIntensity(intens);
            } else {
                l.setIntensity(0.0);
            }
            l.setColor(c);
            l.setGlobal(false);
            l.setName("Spot Light");
            state.extraGeoTrans = new Transformation();
            MatrixBuilder.euclidean().translate(loc).rotateFromTo(new double[]{0.0, 0.0, 1.0}, dir).assignTo(state.extraGeoTrans);
            l.setConeAngle(cutA);
            l.setDistribution(dropR);
            l.setFalloffA0(1.0);
            l.setFalloffA1(0.0);
            l.setFalloffA2(0.0);
            if (VRMLHelper.verbose) {
                System.err.println(")");
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
        return l;
    }

    private final boolean sfboolValue() throws RecognitionException, TokenStreamException {
        boolean b = false;
        int n = 0;
        try {
            switch (this.LA(1)) {
                case 104: 
                case 106: 
                case 107: {
                    n = this.intThing();
                    if (n == 0) {
                        b = false;
                        break;
                    }
                    b = true;
                    break;
                }
                case 98: {
                    this.match(98);
                    b = true;
                    break;
                }
                case 99: {
                    this.match(99);
                    b = false;
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_20);
        }
        return b;
    }

    private final Color sfcolorValue() throws RecognitionException, TokenStreamException {
        Color c = null;
        try {
            double r = this.doubleThing();
            double g = this.doubleThing();
            double b = this.doubleThing();
            int ro = (int)Math.round(r * 255.0);
            int ge = (int)Math.round(g * 255.0);
            int bl = (int)Math.round(b * 255.0);
            c = new Color(ro, ge, bl);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_21);
        }
        return c;
    }

    private final int intThing() throws RecognitionException, TokenStreamException {
        Token s = null;
        int i = 0;
        String sig = "";
        try {
            switch (this.LA(1)) {
                case 106: {
                    this.match(106);
                    break;
                }
                case 107: {
                    this.match(107);
                    sig = "-";
                    break;
                }
                case 104: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            s = this.LT(1);
            this.match(104);
            double d = Double.parseDouble(sig + s.getText());
            i = (int)Math.round(d);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_22);
        }
        return i;
    }

    private final double doubleThing() throws RecognitionException, TokenStreamException {
        double d = 0.0;
        Token s = null;
        double e = 0.0;
        String sig = "";
        try {
            switch (this.LA(1)) {
                case 106: {
                    this.match(106);
                    break;
                }
                case 107: {
                    this.match(107);
                    sig = "-";
                    break;
                }
                case 104: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            s = this.LT(1);
            this.match(104);
            d = Double.parseDouble(sig + s.getText());
            switch (this.LA(1)) {
                case 108: 
                case 109: {
                    e = this.expThing();
                    d *= Math.pow(10.0, e);
                    break;
                }
                case 12: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 20: 
                case 21: 
                case 22: 
                case 24: 
                case 26: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 49: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 76: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 90: 
                case 91: 
                case 92: 
                case 94: 
                case 101: 
                case 102: 
                case 104: 
                case 106: 
                case 107: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_23);
        }
        return d;
    }

    private final int[][] hexList(int size, int dim) throws RecognitionException, TokenStreamException {
        int[][] cL = new int[size][dim];
        Token g = null;
        Token k = null;
        int i = 0;
        String s = "";
        try {
            while (this.LA(1) == 103 || this.LA(1) == 104) {
                switch (this.LA(1)) {
                    case 103: {
                        g = this.LT(1);
                        this.match(103);
                        s = g.getText();
                        break;
                    }
                    case 104: {
                        k = this.LT(1);
                        this.match(104);
                        s = k.getText();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                if (i < size) {
                    cL[i] = VRMLHelper.decodeColorFromString(dim, s);
                }
                ++i;
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_16);
        }
        return cL;
    }

    private final int hexValue() throws RecognitionException, TokenStreamException {
        Token g = null;
        int hexVal = 0;
        try {
            g = this.LT(1);
            this.match(103);
            hexVal = Integer.parseInt(g.getText());
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_1);
        }
        return hexVal;
    }

    private final double expThing() throws RecognitionException, TokenStreamException {
        Token s = null;
        double e = 0.0;
        String sig = "";
        try {
            switch (this.LA(1)) {
                case 108: {
                    this.match(108);
                    break;
                }
                case 109: {
                    this.match(109);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            switch (this.LA(1)) {
                case 106: {
                    this.match(106);
                    break;
                }
                case 107: {
                    this.match(107);
                    sig = "-";
                    break;
                }
                case 104: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            s = this.LT(1);
            this.match(104);
            e = Double.parseDouble(sig + s.getText());
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_23);
        }
        return e;
    }

    private final void dumb() throws RecognitionException, TokenStreamException {
        try {
            block1 : switch (this.LA(1)) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 96: 
                case 98: 
                case 99: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: {
                    int _cnt214 = 0;
                    while (true) {
                        if (!_tokenSet_24.member(this.LA(1)) || this.LA(2) < 4 || this.LA(2) > 117) {
                            if (_cnt214 >= 1) break;
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                        this.match(_tokenSet_24);
                        ++_cnt214;
                    }
                    if (this.LA(1) == 11 && _tokenSet_25.member(this.LA(2))) {
                        this.match(11);
                        while (_tokenSet_4.member(this.LA(1))) {
                            this.dumb();
                        }
                        this.match(12);
                        break;
                    }
                    if (this.LA(1) == 95 && _tokenSet_26.member(this.LA(2))) {
                        this.match(95);
                        while (_tokenSet_4.member(this.LA(1))) {
                            this.dumb();
                        }
                        this.match(97);
                        break;
                    }
                    if (this.LA(1) == 100 && _tokenSet_27.member(this.LA(2))) {
                        this.match(100);
                        while (_tokenSet_4.member(this.LA(1))) {
                            this.dumb();
                        }
                        this.match(101);
                        break;
                    }
                    if (this.LA(1) >= 4 && this.LA(1) <= 117 && _tokenSet_28.member(this.LA(2))) break;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                case 11: 
                case 95: 
                case 100: {
                    switch (this.LA(1)) {
                        case 11: {
                            this.match(11);
                            while (_tokenSet_4.member(this.LA(1))) {
                                this.dumb();
                            }
                            this.match(12);
                            break block1;
                        }
                        case 100: {
                            this.match(100);
                            while (_tokenSet_4.member(this.LA(1))) {
                                this.dumb();
                            }
                            this.match(101);
                            break block1;
                        }
                        case 95: {
                            this.match(95);
                            while (_tokenSet_4.member(this.LA(1))) {
                                this.dumb();
                            }
                            this.match(97);
                            break block1;
                        }
                    }
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_29);
        }
    }

    private static final long[] mk_tokenSet_0() {
        long[] data = new long[]{1212879467279050720L, 1645768326L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_1() {
        long[] data = new long[]{2L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_2() {
        long[] data = new long[]{1212879467279054818L, 1645768326L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_3() {
        long[] data = new long[]{2293743377848465378L, 413962628742L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_4() {
        long[] data = new long[8];
        data[0] = -4112L;
        data[1] = 0x3FFFDDFFFFFFFFL;
        return data;
    }

    private static final long[] mk_tokenSet_5() {
        long[] data = new long[]{1080863910643865600L, 84825604216L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_6() {
        long[] data = new long[]{495616L, 0x40000000L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_7() {
        long[] data = new long[]{-2305565932191772672L, 413892313209L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_8() {
        long[] data = new long[]{1080863910569414656L, 1073741944L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_9() {
        long[] data = new long[]{277076930695168L, 0x40000000L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_10() {
        long[] data = new long[]{-1224139016103292928L, 1575456889L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_11() {
        long[] data = new long[]{74452992L, 0x40000000L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_12() {
        long[] data = new long[]{0xF0001000L, 0x40000000L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_13() {
        long[] data = new long[]{55566143488L, 0x6040000000L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_14() {
        long[] data = new long[]{4096L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_15() {
        long[] data = new long[]{840026883624960L, 0x40000000L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_16() {
        long[] data = new long[]{0xF00000000001000L, 0x40000000L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_17() {
        long[] data = new long[]{-2305843009213689856L, 413390602241L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_18() {
        long[] data = new long[]{-2305843009209495552L, 1074237441L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_19() {
        long[] data = new long[]{-2305843009209495552L, 413892317185L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_20() {
        long[] data = new long[]{4096L, 1574961152L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_21() {
        long[] data = new long[]{840026883624960L, 413891821568L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_22() {
        long[] data = new long[]{1080863966135062528L, 15257298796544L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_23() {
        long[] data = new long[]{-2305002982238351360L, 14707543478393L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_24() {
        long[] data = new long[8];
        data[0] = -6160L;
        data[1] = 18014181613633535L;
        return data;
    }

    private static final long[] mk_tokenSet_25() {
        long[] data = new long[8];
        data[0] = -16L;
        data[1] = 0x3FFFDDFFFFFFFFL;
        return data;
    }

    private static final long[] mk_tokenSet_26() {
        long[] data = new long[8];
        data[0] = -4112L;
        data[1] = 0x3FFFDFFFFFFFFFL;
        return data;
    }

    private static final long[] mk_tokenSet_27() {
        long[] data = new long[8];
        data[0] = -4112L;
        data[1] = 0x3FFFFDFFFFFFFFL;
        return data;
    }

    private static final long[] mk_tokenSet_28() {
        long[] data = new long[8];
        data[0] = -14L;
        data[1] = 0x3FFFFFFFFFFFFFL;
        return data;
    }

    private static final long[] mk_tokenSet_29() {
        long[] data = new long[8];
        data[0] = -16L;
        data[1] = 0x3FFFFFFFFFFFFFL;
        return data;
    }
}

