/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader.vrml;

import de.jreality.reader.vrml.State;
import de.jreality.scene.Appearance;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Transformation;
import java.util.LinkedList;

public class DefUseData {
    public static final int NO_TYP = -1;
    public static final int KNOT = 0;
    public static final int MATERIAL = 1;
    public static final int BIND_M = 2;
    public static final int BIND_N = 3;
    public static final int COORDS = 4;
    public static final int NORMALS = 5;
    public static final int TRAFO = 6;
    public static final int TEXTURE = 7;
    public static final int TEXTURE_TRAFO = 8;
    public static final int TEXTURE_COORDS = 9;
    public static final int SHAPE_HINTS = 10;
    private static LinkedList types = new LinkedList();
    private LinkedList names = new LinkedList();
    private LinkedList states = new LinkedList();

    public void addDef(State s, String n) {
        for (int i = 0; i < this.names.size(); ++i) {
            if (!n.equalsIgnoreCase((String)this.names.get(i))) continue;
            this.states.set(i, s);
            return;
        }
        this.names.add(n);
        this.states.add(s);
    }

    public static State defState(State givenState) {
        State s = new State(givenState);
        s.trafo = null;
        if (s.materialBinding == State.Binding.OVERALL || s.materialBinding == State.Binding.DEFAULT) {
            s.materialBinding = State.Binding.NONE;
        }
        s.currNode = new SceneGraphComponent();
        s.history = "DEF:";
        return s;
    }

    public void use(State givenState, String name, boolean definition) {
        int n = -1;
        for (int i = 0; i < this.names.size(); ++i) {
            if (!name.equalsIgnoreCase((String)this.names.get(i))) continue;
            n = i;
        }
        if (n == -1) {
            return;
        }
        State defState = (State)this.states.get(n);
        givenState.defTyp = defState.defTyp;
        switch (defState.defTyp) {
            case 0: {
                DefUseData.useKnot(givenState, defState, name, definition);
                break;
            }
            case 1: {
                DefUseData.useMaterial(givenState, defState);
                break;
            }
            case 2: {
                givenState.materialBinding = defState.materialBinding;
                break;
            }
            case 3: {
                givenState.normalBinding = defState.normalBinding;
                break;
            }
            case 4: {
                givenState.coords = new State((State)defState).coords;
                break;
            }
            case 5: {
                givenState.normals = new State((State)defState).normals;
                break;
            }
            case 6: {
                DefUseData.useTrafo(givenState, defState);
                break;
            }
            case 7: {
                DefUseData.useTexture(givenState, defState);
                break;
            }
            case 9: {
                givenState.textureCoords = new State((State)defState).textureCoords;
                break;
            }
            case 8: {
                givenState.textureTrafo = new State((State)defState).textureTrafo;
                break;
            }
            case 10: {
                DefUseData.useShapeHints(givenState, defState);
                break;
            }
        }
    }

    private static void useKnot(State givenState, State defState, String name, boolean definition) {
        SceneGraphComponent c = defState.currNode.getChildComponent(0);
        SceneGraphComponent defUseNode = new SceneGraphComponent();
        if (definition) {
            defUseNode.setName("defined:" + name);
        } else {
            defUseNode.setName("used:" + name);
        }
        defUseNode.addChild(c);
        givenState.currNode.addChild(defUseNode);
        if (givenState.trafo != null) {
            defUseNode.setTransformation(new Transformation(givenState.trafo.getMatrix()));
        }
        if (givenState.materialBinding == State.Binding.OVERALL || givenState.materialBinding == State.Binding.DEFAULT) {
            Appearance app = new Appearance();
            givenState.setColorApp(app, false);
            defUseNode.setAppearance(app);
        }
    }

    private static void useMaterial(State givenState, State defState) {
        State s = new State(defState);
        givenState.diffuse = s.diffuse;
        givenState.emissive = s.emissive;
        givenState.specular = s.specular;
        givenState.ambient = s.ambient;
        givenState.shininess = s.shininess;
        givenState.transparency = s.transparency;
        if (givenState.materialBinding == State.Binding.NONE) {
            givenState.materialBinding = State.Binding.OVERALL;
        }
    }

    private static void useTexture(State givenState, State defState) {
        State s = new State(defState);
        givenState.textureFile = s.textureFile;
        givenState.textureData = s.textureData;
        givenState.wrapS = s.wrapS;
        givenState.wrapT = s.wrapT;
    }

    private static void useTrafo(State givenState, State defState) {
        State s = new State(defState);
        if (defState.trafo == null) {
            return;
        }
        if (givenState.trafo == null) {
            givenState.trafo = new Transformation(defState.trafo.getMatrix());
        } else {
            givenState.trafo.multiplyOnRight(new State((State)defState).trafo.getMatrix());
        }
    }

    private static void useShapeHints(State givenState, State s) {
        givenState.vertOrder = s.vertOrder;
        givenState.shapeType = s.shapeType;
        givenState.faceType = s.faceType;
        givenState.creaseAngle = s.creaseAngle;
    }
}

