/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader.mathematica;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.impl.BitSet;
import de.jreality.geometry.IndexedFaceSetFactory;
import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.geometry.IndexedLineSetFactory;
import de.jreality.geometry.PointSetFactory;
import de.jreality.geometry.Primitives;
import de.jreality.geometry.RemoveDuplicateInfo;
import de.jreality.math.MatrixBuilder;
import de.jreality.reader.mathematica.MathematicaHelper;
import de.jreality.reader.mathematica.MathematicaParserTokenTypes;
import de.jreality.scene.Appearance;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.util.LoggingSystem;
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathematicaParser
extends LLkParser
implements MathematicaParserTokenTypes {
    private SceneGraphComponent root;
    private SceneGraphComponent current;
    private Logger log;
    private Appearance startApp;
    private Color plCDefault;
    private Color fCDefault;
    private boolean optGeo;
    private Object defaultEdgeForm;
    private double[][] borderValue;
    private boolean gotFirstPoint;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "OPEN_BRACE", "CLOSE_BRACE", "COLON", "\"Graphics3D\"", "OPEN_BRACKET", "CLOSE_BRACKET", "\"Cuboid\"", "\"Sphere\"", "\"Cylinder\"", "\"Text\"", "STRING", "\"Point\"", "\"Line\"", "\"Polygon\"", "\"EdgeForm\"", "\"SurfaceColor\"", "\"RGBColor\"", "\"Hue\"", "\"GrayLevel\"", "\"CMYKColor\"", "\"AbsolutePointSize\"", "\"AbsoluteThickness\"", "\"Dashing\"", "\"FaceForm\"", "\"PointSize\"", "\"Thickness\"", "\"AbsoluteDashing\"", "\"Boxed\"", "DDOT", "LARGER", "MINUS", "\"Axes\"", "\"AxesLabel\"", "\"Prolog\"", "\"Epilog\"", "\"ViewPoint\"", "\"ViewCenter\"", "\"FaceGrids\"", "\"Ticks\"", "\"TextStyle\"", "\"BoxRatios\"", "\"Lighting\"", "\"LightSources\"", "\"AmbientLight\"", "\"AxesEdge\"", "\"PlotRange\"", "\"DefaultColor\"", "\"Background\"", "\"ColorOutput\"", "\"AxesStyle\"", "\"BoxStyle\"", "\"PlotLabel\"", "\"AspectRatio\"", "\"DefaultFont\"", "\"PlotRegion\"", "\"ViewVertical\"", "\"SphericalRegion\"", "\"Shading\"", "\"RenderAll\"", "\"PolygonIntersections\"", "\"DisplayFunction\"", "\"Plot3Matrix\"", "\"ImageSize\"", "\"FormatType\"", "LPAREN", "RPAREN", "PLUS", "INTEGER_THING", "STAR", "\"I\"", "DOT", "HAT", "BACKS", "SLASH", "DOLLAR", "SMALER", "T1", "T2", "T3", "T4", "T5", "T6", "T7", "T8", "T9", "an identifier", "ID_LETTER", "DIGIT", "ESC", "WS_"};
    public static final BitSet _tokenSet_0 = new BitSet(MathematicaParser.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(MathematicaParser.mk_tokenSet_1());
    public static final BitSet _tokenSet_2 = new BitSet(MathematicaParser.mk_tokenSet_2());
    public static final BitSet _tokenSet_3 = new BitSet(MathematicaParser.mk_tokenSet_3());
    public static final BitSet _tokenSet_4 = new BitSet(MathematicaParser.mk_tokenSet_4());
    public static final BitSet _tokenSet_5 = new BitSet(MathematicaParser.mk_tokenSet_5());
    public static final BitSet _tokenSet_6 = new BitSet(MathematicaParser.mk_tokenSet_6());
    public static final BitSet _tokenSet_7 = new BitSet(MathematicaParser.mk_tokenSet_7());
    public static final BitSet _tokenSet_8 = new BitSet(MathematicaParser.mk_tokenSet_8());
    public static final BitSet _tokenSet_9 = new BitSet(MathematicaParser.mk_tokenSet_9());
    public static final BitSet _tokenSet_10 = new BitSet(MathematicaParser.mk_tokenSet_10());
    public static final BitSet _tokenSet_11 = new BitSet(MathematicaParser.mk_tokenSet_11());
    public static final BitSet _tokenSet_12 = new BitSet(MathematicaParser.mk_tokenSet_12());
    public static final BitSet _tokenSet_13 = new BitSet(MathematicaParser.mk_tokenSet_13());
    public static final BitSet _tokenSet_14 = new BitSet(MathematicaParser.mk_tokenSet_14());
    public static final BitSet _tokenSet_15 = new BitSet(MathematicaParser.mk_tokenSet_15());
    public static final BitSet _tokenSet_16 = new BitSet(MathematicaParser.mk_tokenSet_16());
    public static final BitSet _tokenSet_17 = new BitSet(MathematicaParser.mk_tokenSet_17());
    public static final BitSet _tokenSet_18 = new BitSet(MathematicaParser.mk_tokenSet_18());
    public static final BitSet _tokenSet_19 = new BitSet(MathematicaParser.mk_tokenSet_19());

    public void setOptimizeGeometry(boolean flag) {
        this.optGeo = flag;
    }

    private void resetBorder(double[] v) {
        if (this.gotFirstPoint) {
            for (int i = 0; i < 3; ++i) {
                if (v[i] < this.borderValue[0][i]) {
                    this.borderValue[0][i] = v[i];
                }
                if (!(this.borderValue[1][i] < v[i])) continue;
                this.borderValue[1][i] = v[i];
            }
        } else {
            this.borderValue[0] = v;
            this.borderValue[1] = v;
            this.gotFirstPoint = true;
        }
    }

    public static SceneGraphComponent getDefaultLightNode() {
        return MathematicaHelper.getDefaultLightNode();
    }

    protected MathematicaParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.current = this.root = new SceneGraphComponent();
        this.log = LoggingSystem.getLogger(MathematicaParser.class);
        this.startApp = new Appearance();
        this.plCDefault = new Color(127, 127, 127);
        this.fCDefault = new Color(255, 255, 255);
        this.optGeo = false;
        this.defaultEdgeForm = new Double(1.0);
        this.borderValue = new double[3][];
        this.gotFirstPoint = false;
        this.tokenNames = _tokenNames;
    }

    public MathematicaParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 2);
    }

    protected MathematicaParser(TokenStream lexer, int k) {
        super(lexer, k);
        this.current = this.root = new SceneGraphComponent();
        this.log = LoggingSystem.getLogger(MathematicaParser.class);
        this.startApp = new Appearance();
        this.plCDefault = new Color(127, 127, 127);
        this.fCDefault = new Color(255, 255, 255);
        this.optGeo = false;
        this.defaultEdgeForm = new Double(1.0);
        this.borderValue = new double[3][];
        this.gotFirstPoint = false;
        this.tokenNames = _tokenNames;
    }

    public MathematicaParser(TokenStream lexer) {
        this(lexer, 2);
    }

    public MathematicaParser(ParserSharedInputState state) {
        super(state, 2);
        this.current = this.root = new SceneGraphComponent();
        this.log = LoggingSystem.getLogger(MathematicaParser.class);
        this.startApp = new Appearance();
        this.plCDefault = new Color(127, 127, 127);
        this.fCDefault = new Color(255, 255, 255);
        this.optGeo = false;
        this.defaultEdgeForm = new Double(1.0);
        this.borderValue = new double[3][];
        this.gotFirstPoint = false;
        this.tokenNames = _tokenNames;
    }

    public final SceneGraphComponent start() throws RecognitionException, TokenStreamException {
        SceneGraphComponent r = new SceneGraphComponent();
        this.root.setName("Mathematica");
        this.log.setLevel(Level.FINE);
        try {
            switch (this.LA(1)) {
                case 7: {
                    this.graphics3D();
                    break;
                }
                case 4: {
                    this.match(4);
                    this.listOfGraphics();
                    this.match(5);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            r = this.root;
            if (r == null) {
                r = new SceneGraphComponent();
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_0);
        }
        return r;
    }

    private final void graphics3D() throws RecognitionException, TokenStreamException {
        try {
            this.match(7);
            this.match(8);
            switch (this.LA(1)) {
                case 4: {
                    this.match(4);
                    switch (this.LA(1)) {
                        case 4: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: {
                            this.objectList(this.startApp, this.defaultEdgeForm);
                            break;
                        }
                        case 5: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.match(5);
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 17: 
                case 19: {
                    this.faceThing(this.startApp, this.defaultEdgeForm);
                    break;
                }
                case 13: 
                case 15: 
                case 16: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    this.plThing(this.startApp);
                    break;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: {
                    this.appThing(this.startApp);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            switch (this.LA(1)) {
                case 6: {
                    this.match(6);
                    this.egal();
                    this.log.fine("options are not supported");
                    break;
                }
                case 9: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(9);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_1);
        }
    }

    private final void listOfGraphics() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 4: 
                case 7: {
                    switch (this.LA(1)) {
                        case 7: {
                            this.graphics3D();
                            break;
                        }
                        case 4: {
                            this.match(4);
                            SceneGraphComponent newPart = new SceneGraphComponent();
                            newPart.setName("Graphic");
                            SceneGraphComponent oldPart = this.current;
                            this.current.addChild(newPart);
                            this.current = newPart;
                            this.listOfGraphics();
                            this.match(5);
                            this.current = oldPart;
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    while (this.LA(1) == 6 && this.LA(2) >= 4 && this.LA(2) <= 7) {
                        this.match(6);
                        this.listOfGraphics();
                    }
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void objectList(Appearance app, Object edgeF) throws RecognitionException, TokenStreamException {
        Appearance app2 = MathematicaHelper.copyApp(app);
        try {
            switch (this.LA(1)) {
                case 4: {
                    this.list(app2, edgeF);
                    break;
                }
                case 18: {
                    edgeF = this.edgeFormThing();
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 17: 
                case 19: {
                    app2 = this.faceThing(app2, edgeF);
                    break;
                }
                case 13: 
                case 15: 
                case 16: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    app2 = this.plThing(app2);
                    break;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: {
                    app2 = this.appThing(app2);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            block16: while (this.LA(1) == 6) {
                this.match(6);
                switch (this.LA(1)) {
                    case 4: {
                        this.list(app2, edgeF);
                        continue block16;
                    }
                    case 18: {
                        edgeF = this.edgeFormThing();
                        continue block16;
                    }
                    case 10: 
                    case 11: 
                    case 12: 
                    case 17: 
                    case 19: {
                        app2 = this.faceThing(app2, edgeF);
                        continue block16;
                    }
                    case 13: 
                    case 15: 
                    case 16: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: {
                        app2 = this.plThing(app2);
                        continue block16;
                    }
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: {
                        app2 = this.appThing(app2);
                        continue block16;
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_3);
        }
    }

    private final Appearance faceThing(Appearance app, Object edgeF) throws RecognitionException, TokenStreamException {
        Appearance app2 = MathematicaHelper.copyApp(app);
        try {
            switch (this.LA(1)) {
                case 10: {
                    this.cuboid(app2, edgeF);
                    break;
                }
                case 11: {
                    this.sphere(app2, edgeF);
                    break;
                }
                case 12: {
                    this.cylinder(app2, edgeF);
                    break;
                }
                case 17: {
                    app2 = this.polygonBlock(app2, edgeF);
                    break;
                }
                case 19: {
                    app2 = this.faceColor(app2);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_4);
        }
        return app2;
    }

    private final Appearance plThing(Appearance app) throws RecognitionException, TokenStreamException {
        Appearance app2 = MathematicaHelper.copyApp(app);
        Color c = null;
        try {
            switch (this.LA(1)) {
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    c = this.color();
                    app2 = MathematicaHelper.setPLColor(app2, c);
                    break;
                }
                case 16: {
                    app2 = this.lineBlock(app2);
                    break;
                }
                case 15: {
                    app2 = this.pointBlock(app2);
                    break;
                }
                case 13: {
                    this.text(app2);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_4);
        }
        return app2;
    }

    private final Appearance appThing(Appearance appOld) throws RecognitionException, TokenStreamException {
        Appearance app = MathematicaHelper.copyApp(appOld);
        try {
            app = this.directiveBlock(app);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_4);
        }
        return app;
    }

    private final void egal() throws RecognitionException, TokenStreamException {
        try {
            while (_tokenSet_5.member(this.LA(1)) && this.LA(2) >= 4 && this.LA(2) <= 93) {
                this.match(_tokenSet_5);
            }
            switch (this.LA(1)) {
                case 4: {
                    this.match(4);
                    while (_tokenSet_6.member(this.LA(1))) {
                        this.dumb();
                    }
                    this.match(5);
                    if (this.LA(1) >= 4 && this.LA(1) <= 93 && _tokenSet_7.member(this.LA(2))) {
                        this.egal();
                        break;
                    }
                    if ((this.LA(1) == 5 || this.LA(1) == 6 || this.LA(1) == 9) && _tokenSet_8.member(this.LA(2))) break;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                case 8: {
                    this.match(8);
                    while (_tokenSet_6.member(this.LA(1))) {
                        this.dumb();
                    }
                    this.match(9);
                    if (this.LA(1) >= 4 && this.LA(1) <= 93 && _tokenSet_7.member(this.LA(2))) {
                        this.egal();
                        break;
                    }
                    if ((this.LA(1) == 5 || this.LA(1) == 6 || this.LA(1) == 9) && _tokenSet_8.member(this.LA(2))) break;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                case 68: {
                    this.match(68);
                    while (_tokenSet_6.member(this.LA(1))) {
                        this.dumb();
                    }
                    this.match(69);
                    if (this.LA(1) >= 4 && this.LA(1) <= 93 && _tokenSet_7.member(this.LA(2))) {
                        this.egal();
                        break;
                    }
                    if ((this.LA(1) == 5 || this.LA(1) == 6 || this.LA(1) == 9) && _tokenSet_8.member(this.LA(2))) break;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                case 5: 
                case 6: 
                case 9: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_4);
        }
    }

    private final void list(Appearance app, Object edgeF) throws RecognitionException, TokenStreamException {
        Appearance app2 = MathematicaHelper.copyApp(app);
        try {
            this.match(4);
            SceneGraphComponent newPart = new SceneGraphComponent();
            newPart.setName("Object");
            SceneGraphComponent oldPart = this.current;
            this.current.addChild(newPart);
            this.current = newPart;
            switch (this.LA(1)) {
                case 4: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: {
                    this.objectList(app2, edgeF);
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(5);
            this.current = oldPart;
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final Object edgeFormThing() throws RecognitionException, TokenStreamException {
        Color c = null;
        try {
            this.match(18);
            this.match(8);
            switch (this.LA(1)) {
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    c = this.color();
                    break;
                }
                case 9: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(9);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
        return c;
    }

    private final void cuboid(Appearance app, Object edgeF) throws RecognitionException, TokenStreamException {
        try {
            this.match(10);
            this.match(8);
            double[] v2 = new double[3];
            v2[2] = 1.0;
            v2[1] = 1.0;
            v2[0] = 1.0;
            double[] v = new double[3];
            v = this.vektor();
            switch (this.LA(1)) {
                case 6: {
                    this.match(6);
                    v2 = this.vektordata();
                    break;
                }
                case 9: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(9);
            SceneGraphComponent geo = new SceneGraphComponent();
            this.current.addChild(geo);
            geo.setGeometry(Primitives.cube());
            geo.setName("Cuboid");
            Appearance cubicApp = MathematicaHelper.copyApp(app);
            if (edgeF != null) {
                cubicApp.setAttribute("tubeRadius", 0);
                cubicApp.setAttribute("lineWidth", 1);
                if (edgeF instanceof Color) {
                    cubicApp.setAttribute("lineShader.polygonShader.diffuseColor", (Color)edgeF);
                    cubicApp.setAttribute("lineShader.diffuseColor", (Color)edgeF);
                }
            } else {
                cubicApp.setAttribute("showLines", false);
            }
            geo.setAppearance(cubicApp);
            MatrixBuilder.euclidean().scale(v2[0], v2[1], v2[2]).translate(v[0], v[1], v[2]).assignTo(geo);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_4);
        }
    }

    private final void sphere(Appearance app, Object edgeF) throws RecognitionException, TokenStreamException {
        try {
            this.match(11);
            this.match(8);
            double[] center = new double[3];
            double radius = 1.0;
            center = this.vektor();
            switch (this.LA(1)) {
                case 6: {
                    this.match(6);
                    radius = this.doublething();
                    break;
                }
                case 9: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(9);
            SceneGraphComponent geo = Primitives.sphere(radius, center);
            this.current.addChild(geo);
            geo.setName("Cylinder");
            Appearance App = MathematicaHelper.copyApp(app);
            App.setAttribute("showLines", false);
            geo.setAppearance(App);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_4);
        }
    }

    private final void cylinder(Appearance app, Object edgeF) throws RecognitionException, TokenStreamException {
        try {
            this.match(12);
            this.match(8);
            double[] anfg = new double[3];
            double[] ende = new double[3];
            double radius = 1.0;
            this.match(4);
            anfg = this.vektor();
            this.match(6);
            ende = this.vektor();
            this.match(5);
            switch (this.LA(1)) {
                case 6: {
                    this.match(6);
                    radius = this.doublething();
                    break;
                }
                case 9: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(9);
            SceneGraphComponent geo = new SceneGraphComponent();
            this.current.addChild(geo);
            geo.setGeometry(MathematicaHelper.makeCylinder(anfg, ende, radius));
            geo.setName("Cylinder");
            Appearance cylApp = MathematicaHelper.copyApp(app);
            cylApp.setAttribute("showLines", false);
            cylApp.setAttribute("showPoints", false);
            geo.setAppearance(cylApp);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_4);
        }
    }

    private final Appearance polygonBlock(Appearance app, Object edgeF) throws RecognitionException, TokenStreamException {
        Appearance app2 = MathematicaHelper.copyApp(app);
        Color fC = MathematicaHelper.getFColor(app2, this.fCDefault);
        LinkedList<double[]> coordinates = new LinkedList<double[]>();
        LinkedList<Object> poly = new LinkedList();
        LinkedList<Color> colors = new LinkedList<Color>();
        LinkedList<int[]> polysIndices = new LinkedList<int[]>();
        int count = 0;
        boolean colorFlag = false;
        boolean colorNeeded = false;
        try {
            Object d;
            this.match(17);
            this.match(8);
            poly = this.lineset();
            int[] polyIndices = new int[poly.size()];
            int i = 0;
            for (double[] dArray : poly) {
                coordinates.add(dArray);
                polyIndices[i] = i;
                ++i;
            }
            count = poly.size();
            polysIndices.add(polyIndices);
            colors.add(fC);
            this.match(9);
            block7: while (this.LA(1) == 6 && (this.LA(2) == 17 || this.LA(2) == 19)) {
                this.match(6);
                switch (this.LA(1)) {
                    case 19: {
                        app2 = this.faceColor(app2);
                        colorFlag = true;
                        fC = MathematicaHelper.getFColor(app2, this.fCDefault);
                        continue block7;
                    }
                    case 17: {
                        this.match(17);
                        this.match(8);
                        poly = this.lineset();
                        if (colorFlag) {
                            colorNeeded = true;
                        }
                        polyIndices = new int[poly.size()];
                        i = 0;
                        for (double[] dArray : poly) {
                            coordinates.add(dArray);
                            polyIndices[i] = i + count;
                            ++i;
                        }
                        count += poly.size();
                        polysIndices.add(polyIndices);
                        colors.add(fC);
                        this.match(9);
                        continue block7;
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            double[][] data = new double[count][];
            double[][] dArrayArray = new double[polysIndices.size()][];
            i = 0;
            for (double[] d3 : coordinates) {
                data[i] = (double[])coordinates.get(i);
                ++i;
            }
            int[][] indices = new int[polysIndices.size()][];
            i = 0;
            Iterator i$ = polysIndices.iterator();
            while (i$.hasNext()) {
                indices[i] = d = (int[])i$.next();
                ++i;
            }
            i = 0;
            i$ = colors.iterator();
            while (i$.hasNext()) {
                d = (Color)i$.next();
                dArrayArray[i] = MathematicaHelper.getRGBColor((Color)d);
                ++i;
            }
            IndexedFaceSetFactory faceSet = new IndexedFaceSetFactory();
            faceSet.setVertexCount(count);
            faceSet.setFaceCount(polysIndices.size());
            faceSet.setFaceIndices(indices);
            faceSet.setVertexCoordinates(data);
            Appearance faceApp = MathematicaHelper.copyApp(app2);
            if (colorNeeded) {
                faceSet.setFaceColors(dArrayArray);
            } else {
                faceApp.setAttribute("polygonShader.diffuseColor", fC);
            }
            if (edgeF != null) {
                faceApp.setAttribute("tubeRadius", 0);
                faceApp.setAttribute("lineWidth", 1);
                if (edgeF instanceof Color) {
                    faceApp.setAttribute("lineShader.polygonShader.diffuseColor", edgeF);
                    faceApp.setAttribute("lineShader.diffuseColor", edgeF);
                }
                faceSet.setGenerateEdgesFromFaces(true);
            } else {
                faceSet.setGenerateEdgesFromFaces(false);
            }
            faceSet.setGenerateFaceNormals(true);
            faceSet.update();
            IndexedFaceSet ifs = faceSet.getIndexedFaceSet();
            ifs = (IndexedFaceSet)RemoveDuplicateInfo.removeDuplicateVertices((PointSet)ifs, Attribute.COLORS);
            IndexedFaceSetUtility.assignSmoothVertexNormals(ifs, -1);
            SceneGraphComponent geo = new SceneGraphComponent();
            geo.setAppearance(faceApp);
            this.current.addChild(geo);
            geo.setName("Faces");
            geo.setGeometry(ifs);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_4);
        }
        return app2;
    }

    private final Appearance faceColor(Appearance app) throws RecognitionException, TokenStreamException {
        Appearance app2 = MathematicaHelper.copyApp(app);
        Color fC = new Color(255, 0, 0);
        try {
            this.match(19);
            this.match(8);
            fC = this.color();
            app2.setAttribute("polygonShader.diffuseColor", fC);
            block1 : switch (this.LA(1)) {
                case 6: {
                    this.match(6);
                    Color specular = this.color();
                    app2.setAttribute("polygonShader.specularColor", specular);
                    switch (this.LA(1)) {
                        case 6: {
                            this.match(6);
                            double d = this.doublething();
                            app2.setAttribute("polygonShader.specularExponent", d);
                            break block1;
                        }
                        case 9: {
                            break block1;
                        }
                    }
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                case 9: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(9);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_4);
        }
        return app2;
    }

    private final Color color() throws RecognitionException, TokenStreamException {
        Color c = new Color(0, 255, 0);
        try {
            switch (this.LA(1)) {
                case 20: {
                    this.match(20);
                    this.match(8);
                    double g = 0.0;
                    double b = 0.0;
                    double r = 0.0;
                    r = this.doublething();
                    this.match(6);
                    g = this.doublething();
                    this.match(6);
                    b = this.doublething();
                    this.match(9);
                    float red = (float)r;
                    float green = (float)g;
                    float blue = (float)b;
                    c = new Color(red, green, blue);
                    break;
                }
                case 21: {
                    this.match(21);
                    this.match(8);
                    double b = 0.5;
                    double s = 0.5;
                    double h = 0.5;
                    h = this.doublething();
                    switch (this.LA(1)) {
                        case 6: {
                            this.match(6);
                            s = this.doublething();
                            this.match(6);
                            b = this.doublething();
                            break;
                        }
                        case 9: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.match(9);
                    float hue = (float)h;
                    float sat = (float)s;
                    float bri = (float)b;
                    c = Color.getHSBColor(hue, sat, bri);
                    break;
                }
                case 22: {
                    this.match(22);
                    this.match(8);
                    double gr = 0.0;
                    gr = this.doublething();
                    this.match(9);
                    float grey = (float)gr;
                    c = new Color(grey, grey, grey);
                    break;
                }
                case 23: {
                    this.match(23);
                    this.match(8);
                    double k = 0.0;
                    double ye = 0.0;
                    double ma = 0.0;
                    double cy = 0.0;
                    cy = this.doublething();
                    this.match(6);
                    ma = this.doublething();
                    this.match(6);
                    ye = this.doublething();
                    this.match(6);
                    k = this.doublething();
                    this.match(9);
                    float r = (float)((1.0 - cy) * (1.0 - k));
                    float g = (float)((1.0 - ma) * (1.0 - k));
                    float b = (float)((1.0 - ye) * (1.0 - k));
                    c = new Color(r, g, b);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_4);
        }
        return c;
    }

    private final Appearance lineBlock(Appearance app) throws RecognitionException, TokenStreamException {
        Appearance app2 = MathematicaHelper.copyApp(app);
        Color plC = MathematicaHelper.getPLColor(app2, this.plCDefault);
        LinkedList<double[]> coordinates = new LinkedList<double[]>();
        LinkedList<Object> line = new LinkedList();
        LinkedList<Color> colors = new LinkedList<Color>();
        int count = 0;
        LinkedList<int[]> linesIndices = new LinkedList<int[]>();
        boolean colorFlag = false;
        boolean colorNeeded = false;
        try {
            Object d;
            this.match(16);
            this.match(8);
            line = this.lineset();
            int[] lineIndices = new int[line.size()];
            int i = 0;
            for (double[] dArray : line) {
                coordinates.add(dArray);
                lineIndices[i] = i;
                ++i;
            }
            count = line.size();
            linesIndices.add(lineIndices);
            colors.add(plC);
            this.match(9);
            block7: while (this.LA(1) == 6 && _tokenSet_9.member(this.LA(2))) {
                this.match(6);
                switch (this.LA(1)) {
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: {
                        plC = this.color();
                        colorFlag = true;
                        app2 = MathematicaHelper.setPLColor(app2, plC);
                        continue block7;
                    }
                    case 16: {
                        this.match(16);
                        this.match(8);
                        line = this.lineset();
                        if (colorFlag) {
                            colorNeeded = true;
                        }
                        lineIndices = new int[line.size()];
                        i = 0;
                        for (double[] dArray : line) {
                            coordinates.add(dArray);
                            lineIndices[i] = i + count;
                            ++i;
                        }
                        count += line.size();
                        linesIndices.add(lineIndices);
                        colors.add(plC);
                        this.match(9);
                        continue block7;
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            double[][] data = new double[coordinates.size()][];
            double[][] dArrayArray = new double[linesIndices.size()][];
            i = 0;
            Iterator i$ = coordinates.iterator();
            while (i$.hasNext()) {
                double[] d3;
                data[i] = d3 = (double[])i$.next();
                ++i;
            }
            int[][] indices = new int[linesIndices.size()][];
            i = 0;
            Iterator i$2 = linesIndices.iterator();
            while (i$2.hasNext()) {
                indices[i] = d = (int[])i$2.next();
                ++i;
            }
            i = 0;
            Iterator i$3 = colors.iterator();
            while (i$3.hasNext()) {
                d = (Color)i$3.next();
                dArrayArray[i] = MathematicaHelper.getRGBColor((Color)d);
                ++i;
            }
            IndexedLineSetFactory lineset = new IndexedLineSetFactory();
            lineset.setLineCount(linesIndices.size());
            lineset.setVertexCount(count);
            lineset.setEdgeIndices(indices);
            lineset.setVertexCoordinates(data);
            lineset.update();
            Appearance lineApp = MathematicaHelper.copyApp(app2);
            if (colorNeeded) {
                lineset.getIndexedLineSet().setEdgeAttributes(Attribute.COLORS, new DoubleArrayArray.Array(dArrayArray));
            } else {
                lineApp = MathematicaHelper.setPLColor(lineApp, plC);
            }
            lineset.update();
            SceneGraphComponent geo = new SceneGraphComponent();
            geo.setAppearance(lineApp);
            IndexedLineSet ils = lineset.getIndexedLineSet();
            ils = (IndexedLineSet)RemoveDuplicateInfo.removeDuplicateVertices((PointSet)ils, Attribute.COLORS);
            geo.setGeometry(ils);
            geo.setName("Lines");
            this.current.addChild(geo);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_4);
        }
        return app2;
    }

    private final Appearance pointBlock(Appearance app) throws RecognitionException, TokenStreamException {
        Appearance app2 = MathematicaHelper.copyApp(app);
        LinkedList<double[]> points = new LinkedList<double[]>();
        LinkedList<Color> colors = new LinkedList<Color>();
        Color plC = MathematicaHelper.getPLColor(app2, this.plCDefault);
        boolean colorFlag = false;
        boolean colorNeeded = false;
        try {
            Object d;
            this.match(15);
            this.match(8);
            double[] v = new double[3];
            v = this.vektor();
            points.add(v);
            colors.add(plC);
            this.match(9);
            block6: while (this.LA(1) == 6 && _tokenSet_10.member(this.LA(2))) {
                this.match(6);
                switch (this.LA(1)) {
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: {
                        plC = this.color();
                        colorFlag = true;
                        app2 = MathematicaHelper.setPLColor(app2, plC);
                        continue block6;
                    }
                    case 15: {
                        this.match(15);
                        if (colorFlag) {
                            colorNeeded = true;
                        }
                        this.match(8);
                        v = new double[3];
                        v = this.vektor();
                        points.add(v);
                        colors.add(plC);
                        this.match(9);
                        continue block6;
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            PointSetFactory psf = new PointSetFactory();
            double[][] data = new double[points.size()][];
            double[][] colorData = new double[points.size()][];
            int i = 0;
            Iterator i$ = points.iterator();
            while (i$.hasNext()) {
                data[i] = d = (double[])i$.next();
                ++i;
            }
            i = 0;
            i$ = colors.iterator();
            while (i$.hasNext()) {
                d = (Color)i$.next();
                colorData[i] = MathematicaHelper.getRGBColor((Color)d);
                ++i;
            }
            psf.setVertexCount(points.size());
            psf.setVertexCoordinates(data);
            Appearance pointApp = MathematicaHelper.copyApp(app2);
            if (colorNeeded) {
                psf.setVertexColors(colorData);
            } else {
                pointApp = MathematicaHelper.setPLColor(pointApp, plC);
            }
            psf.update();
            SceneGraphComponent geo = new SceneGraphComponent();
            geo.setAppearance(pointApp);
            geo.setGeometry(psf.getPointSet());
            geo.setName("Points");
            this.current.addChild(geo);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_4);
        }
        return app2;
    }

    private final void text(Appearance app) throws RecognitionException, TokenStreamException {
        Token s = null;
        double[] v = new double[3];
        try {
            this.match(13);
            this.match(8);
            s = this.LT(1);
            this.match(14);
            this.match(6);
            v = this.vektordata();
            this.match(9);
            String t = s.getText();
            PointSetFactory psf = new PointSetFactory();
            double[][] data = new double[][]{v};
            psf.setVertexCount(1);
            psf.setVertexCoordinates(data);
            String[] labs = new String[]{s.getText()};
            psf.setVertexLabels(labs);
            psf.update();
            SceneGraphComponent geo = new SceneGraphComponent();
            Appearance pointApp = MathematicaHelper.copyApp(app);
            pointApp.setAttribute("spheresDraw", true);
            pointApp.setAttribute("pointRadius", 1.0E-4);
            geo.setAppearance(pointApp);
            geo.setGeometry(psf.getPointSet());
            geo.setName("Label");
            this.current.addChild(geo);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_4);
        }
    }

    private final Appearance directiveBlock(Appearance appOld) throws RecognitionException, TokenStreamException {
        Appearance app = MathematicaHelper.copyApp(appOld);
        try {
            app = this.directive(app);
            while (this.LA(1) == 6 && this.LA(2) >= 24 && this.LA(2) <= 30) {
                this.match(6);
                app = this.directive(app);
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_4);
        }
        return app;
    }

    private final double[] vektor() throws RecognitionException, TokenStreamException {
        double[] res = new double[3];
        try {
            this.match(4);
            double res1 = this.doublething();
            this.match(6);
            double res2 = this.doublething();
            this.match(6);
            double res3 = this.doublething();
            this.match(5);
            res[0] = res1;
            res[1] = res2;
            res[2] = res3;
            this.resetBorder(res);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_4);
        }
        return res;
    }

    private final double[] vektordata() throws RecognitionException, TokenStreamException {
        double[] res = new double[3];
        try {
            this.match(4);
            double res1 = this.doublething();
            this.match(6);
            double res2 = this.doublething();
            this.match(6);
            double res3 = this.doublething();
            this.match(5);
            res[0] = res1;
            res[1] = res2;
            res[2] = res3;
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_11);
        }
        return res;
    }

    private final double doublething() throws RecognitionException, TokenStreamException {
        double d = 0.0;
        try {
            d = this.doubleHelp();
            switch (this.LA(1)) {
                case 34: 
                case 70: 
                case 71: 
                case 74: {
                    this.doubleHelp();
                    this.match(72);
                    this.match(73);
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_4);
        }
        return d;
    }

    private final LinkedList<double[]> lineset() throws RecognitionException, TokenStreamException {
        double[] point = new double[3];
        double[] point2 = new double[3];
        double[] point3 = new double[3];
        LinkedList<double[]> v = new LinkedList<double[]>();
        try {
            this.match(4);
            point = this.vektor();
            v.add(point);
            point3[0] = point[0];
            point3[1] = point[1];
            point3[2] = point[2];
            while (this.LA(1) == 6) {
                this.match(6);
                point2 = new double[3];
                point2 = this.vektor();
                v.add(point2);
            }
            this.match(5);
            v.set(0, point3);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_11);
        }
        return v;
    }

    private final Appearance directive(Appearance appGiven) throws RecognitionException, TokenStreamException {
        Appearance app = MathematicaHelper.copyApp(appGiven);
        try {
            switch (this.LA(1)) {
                case 24: {
                    this.match(24);
                    this.match(8);
                    double d = 0.0;
                    d = this.doublething();
                    app.setAttribute("pointRadius", d / 40.0);
                    app.setAttribute("pointSize", d);
                    this.match(9);
                    break;
                }
                case 25: {
                    this.match(25);
                    this.match(8);
                    double d = 0.0;
                    d = this.doublething();
                    this.match(9);
                    app.setAttribute("tubeRadius", d / 40.0);
                    app.setAttribute("lineWidth", d);
                    break;
                }
                case 26: {
                    this.match(26);
                    this.match(8);
                    switch (this.LA(1)) {
                        case 4: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: {
                            this.dumb();
                            break;
                        }
                        case 9: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.match(9);
                    this.log.fine("Dashing not implemented");
                    break;
                }
                case 27: {
                    this.match(27);
                    this.match(8);
                    switch (this.LA(1)) {
                        case 4: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: {
                            this.dumb();
                            break;
                        }
                        case 9: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.match(9);
                    this.log.fine("FaceForm not implemented");
                    break;
                }
                case 28: {
                    this.match(28);
                    this.match(8);
                    switch (this.LA(1)) {
                        case 4: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: {
                            this.dumb();
                            break;
                        }
                        case 9: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.match(9);
                    this.log.fine("PointSize not implemented");
                    break;
                }
                case 29: {
                    this.match(29);
                    this.match(8);
                    switch (this.LA(1)) {
                        case 4: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: {
                            this.dumb();
                            break;
                        }
                        case 9: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.match(9);
                    this.log.fine("Thicknes not implemented");
                    break;
                }
                case 30: {
                    this.match(30);
                    this.match(8);
                    switch (this.LA(1)) {
                        case 4: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: {
                            this.dumb();
                            break;
                        }
                        case 9: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.match(9);
                    this.log.fine("AbsoluteDashing not implemented");
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_4);
        }
        return app;
    }

    private final void dumb() throws RecognitionException, TokenStreamException {
        try {
            block1 : switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: {
                    int _cnt138 = 0;
                    while (true) {
                        if (!_tokenSet_12.member(this.LA(1)) || this.LA(2) < 4 || this.LA(2) > 93) {
                            if (_cnt138 >= 1) break;
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                        this.match(_tokenSet_12);
                        ++_cnt138;
                    }
                    if (this.LA(1) == 4 && _tokenSet_13.member(this.LA(2))) {
                        this.match(4);
                        while (_tokenSet_6.member(this.LA(1))) {
                            this.dumb();
                        }
                        this.match(5);
                        break;
                    }
                    if (this.LA(1) == 8 && _tokenSet_14.member(this.LA(2))) {
                        this.match(8);
                        while (_tokenSet_6.member(this.LA(1))) {
                            this.dumb();
                        }
                        this.match(9);
                        break;
                    }
                    if (this.LA(1) == 68 && _tokenSet_15.member(this.LA(2))) {
                        this.match(68);
                        while (_tokenSet_6.member(this.LA(1))) {
                            this.dumb();
                        }
                        this.match(69);
                        break;
                    }
                    if (this.LA(1) >= 4 && this.LA(1) <= 93 && this.LA(2) >= 4 && this.LA(2) <= 93) break;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                case 4: 
                case 8: 
                case 68: {
                    switch (this.LA(1)) {
                        case 4: {
                            this.match(4);
                            while (_tokenSet_6.member(this.LA(1))) {
                                this.dumb();
                            }
                            this.match(5);
                            break block1;
                        }
                        case 8: {
                            this.match(8);
                            while (_tokenSet_6.member(this.LA(1))) {
                                this.dumb();
                            }
                            this.match(9);
                            break block1;
                        }
                        case 68: {
                            this.match(68);
                            while (_tokenSet_6.member(this.LA(1))) {
                                this.dumb();
                            }
                            this.match(69);
                            break block1;
                        }
                    }
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_16);
        }
    }

    private final void optionen() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 4: {
                    this.match(4);
                    switch (this.LA(1)) {
                        case 4: 
                        case 31: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: {
                            this.optionen();
                            while (this.LA(1) == 6) {
                                this.match(6);
                                this.optionen();
                            }
                            break;
                        }
                        case 5: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.match(5);
                    break;
                }
                case 31: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: {
                    this.optionPrimitive();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final void optionPrimitive() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 31: {
                    this.match(31);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" Boxed not implemented");
                    break;
                }
                case 35: {
                    this.match(35);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" Axes not implemented");
                    break;
                }
                case 36: {
                    this.match(36);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" AxesLabel not implemented");
                    break;
                }
                case 37: {
                    this.match(37);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" Prolog not implemented");
                    break;
                }
                case 38: {
                    this.match(38);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" Epilog not implemented");
                    break;
                }
                case 39: {
                    this.match(39);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" ViewPoint not implemented");
                    break;
                }
                case 40: {
                    this.match(40);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" ViewCenter not implemented");
                    break;
                }
                case 41: {
                    this.match(41);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" FaceGrids not implemented");
                    break;
                }
                case 42: {
                    this.match(42);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" Ticks not implemented");
                    break;
                }
                case 43: {
                    this.match(43);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" TextStyle not implemented");
                    break;
                }
                case 44: {
                    this.match(44);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" BoxRatios not implemented");
                    break;
                }
                case 45: {
                    this.match(45);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" Lighting not implemented");
                    break;
                }
                case 46: {
                    this.match(46);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" LightSources not implemented");
                    break;
                }
                case 47: {
                    this.match(47);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" AmbientLight not implemented");
                    break;
                }
                case 48: {
                    this.match(48);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" AxesEdge not implemented");
                    break;
                }
                case 49: {
                    this.match(49);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" PlotRange not implemented");
                    break;
                }
                case 50: {
                    this.match(50);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" DefaultColor not implemented");
                    break;
                }
                case 51: {
                    this.match(51);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" Background not implemented");
                    break;
                }
                case 52: {
                    this.match(52);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" ColorOutput not implemented");
                    break;
                }
                case 53: {
                    this.match(53);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" AxesStyle not implemented");
                    break;
                }
                case 54: {
                    this.match(54);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" BoxStyle not implemented");
                    break;
                }
                case 55: {
                    this.match(55);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" PlotLabel not implemented");
                    break;
                }
                case 56: {
                    this.match(56);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" AspectRatio not implemented");
                    break;
                }
                case 57: {
                    this.match(57);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" DefaultFont not implemented");
                    break;
                }
                case 58: {
                    this.match(58);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" PlotRegion not implemented");
                    break;
                }
                case 59: {
                    this.match(59);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" ViewVertical not implemented");
                    break;
                }
                case 60: {
                    this.match(60);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" SphericalRegion not implemented");
                    break;
                }
                case 61: {
                    this.match(61);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" Shading not implemented");
                    break;
                }
                case 62: {
                    this.match(62);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" RenderAll not implemented");
                    break;
                }
                case 63: {
                    this.match(63);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" PolygonIntersections not implemented");
                    break;
                }
                case 64: {
                    this.match(64);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" DisplayFunction not implemented");
                    break;
                }
                case 65: {
                    this.match(65);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" Plot3Matrix not implemented");
                    break;
                }
                case 66: {
                    this.match(66);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" ImageSize not implemented");
                    break;
                }
                case 67: {
                    this.match(67);
                    switch (this.LA(1)) {
                        case 32: {
                            this.match(32);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        case 34: {
                            this.match(34);
                            this.match(33);
                            this.egal();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.log.fine(" FormatType not implemented");
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_2);
        }
    }

    private final int integerthing() throws RecognitionException, TokenStreamException {
        Token s = null;
        int i = 0;
        String sig = "";
        try {
            switch (this.LA(1)) {
                case 70: {
                    this.match(70);
                    break;
                }
                case 34: {
                    this.match(34);
                    sig = "-";
                    break;
                }
                case 71: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            s = this.LT(1);
            this.match(71);
            i = Integer.parseInt(sig + s.getText());
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_0);
        }
        return i;
    }

    private final double doubleHelp() throws RecognitionException, TokenStreamException {
        double d = 0.0;
        Token s = null;
        Token s2 = null;
        Token s3 = null;
        double e = 0.0;
        String sig = "";
        try {
            switch (this.LA(1)) {
                case 70: {
                    this.match(70);
                    break;
                }
                case 34: {
                    this.match(34);
                    sig = "-";
                    break;
                }
                case 71: 
                case 74: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            switch (this.LA(1)) {
                case 71: {
                    s = this.LT(1);
                    this.match(71);
                    d = Double.parseDouble(sig + s.getText());
                    if (this.LA(1) == 74 && _tokenSet_17.member(this.LA(2))) {
                        this.match(74);
                        if (this.LA(1) == 71 && _tokenSet_17.member(this.LA(2))) {
                            s2 = this.LT(1);
                            this.match(71);
                            d = Double.parseDouble(sig + s.getText() + "." + s2.getText());
                            break;
                        }
                        if (_tokenSet_17.member(this.LA(1)) && _tokenSet_18.member(this.LA(2))) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    if (_tokenSet_17.member(this.LA(1)) && _tokenSet_18.member(this.LA(2))) break;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                case 74: {
                    this.match(74);
                    s3 = this.LT(1);
                    this.match(71);
                    d = Double.parseDouble(sig + "0." + s3.getText());
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            if (this.LA(1) == 72 && this.LA(2) == 75) {
                e = this.exponent_thing();
                d *= Math.pow(10.0, e);
            } else if (!_tokenSet_17.member(this.LA(1)) || !_tokenSet_19.member(this.LA(2))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_17);
        }
        return d;
    }

    private final int exponent_thing() throws RecognitionException, TokenStreamException {
        Token s = null;
        int e = 0;
        String sig = "";
        try {
            this.match(72);
            this.match(75);
            switch (this.LA(1)) {
                case 70: {
                    this.match(70);
                    break;
                }
                case 34: {
                    this.match(34);
                    sig = "-";
                    break;
                }
                case 71: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            s = this.LT(1);
            this.match(71);
            e = Integer.parseInt(sig + s.getText());
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_17);
        }
        return e;
    }

    private static final long[] mk_tokenSet_0() {
        long[] data = new long[]{2L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_1() {
        long[] data = new long[]{98L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_2() {
        long[] data = new long[]{96L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_3() {
        long[] data = new long[]{32L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_4() {
        long[] data = new long[]{608L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_5() {
        long[] data = new long[8];
        data[0] = -384L;
        data[1] = 0x3FFFFFEFL;
        return data;
    }

    private static final long[] mk_tokenSet_6() {
        long[] data = new long[8];
        data[0] = -560L;
        data[1] = 0x3FFFFFDFL;
        return data;
    }

    private static final long[] mk_tokenSet_7() {
        long[] data = new long[8];
        data[0] = -14L;
        data[1] = 0x3FFFFFFFL;
        return data;
    }

    private static final long[] mk_tokenSet_8() {
        long[] data = new long[]{-32212254606L, 15L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_9() {
        long[] data = new long[]{0xF10000L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_10() {
        long[] data = new long[]{0xF08000L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_11() {
        long[] data = new long[]{512L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_12() {
        long[] data = new long[8];
        data[0] = -832L;
        data[1] = 0x3FFFFFCFL;
        return data;
    }

    private static final long[] mk_tokenSet_13() {
        long[] data = new long[8];
        data[0] = -528L;
        data[1] = 0x3FFFFFDFL;
        return data;
    }

    private static final long[] mk_tokenSet_14() {
        long[] data = new long[8];
        data[0] = -48L;
        data[1] = 0x3FFFFFDFL;
        return data;
    }

    private static final long[] mk_tokenSet_15() {
        long[] data = new long[8];
        data[0] = -560L;
        data[1] = 0x3FFFFFFFL;
        return data;
    }

    private static final long[] mk_tokenSet_16() {
        long[] data = new long[8];
        data[0] = -16L;
        data[1] = 0x3FFFFFFFL;
        return data;
    }

    private static final long[] mk_tokenSet_17() {
        long[] data = new long[]{17179869792L, 1472L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_18() {
        long[] data = new long[]{17179869792L, 4032L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_19() {
        long[] data = new long[]{17179869792L, 1984L, 0L, 0L};
        return data;
    }
}

