/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader.mathematica;

import de.jreality.geometry.GeometryMergeFactory;
import de.jreality.geometry.Primitives;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.PointLight;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.data.Attribute;
import java.awt.Color;
import java.util.Set;

public class MathematicaHelper {
    static Appearance copyApp(Appearance appOld) {
        Appearance appNew = new Appearance();
        Set s = appOld.getStoredAttributes();
        for (String key : s) {
            appNew.setAttribute(key, appOld.getAttribute(key));
        }
        return appNew;
    }

    static Appearance setPLColor(Appearance app, Object c) {
        Appearance app2 = MathematicaHelper.copyApp(app);
        app2.setAttribute("pointShader.polygonShader.diffuseColor", c);
        app2.setAttribute("pointShader.diffuseColor", c);
        app2.setAttribute("lineShader.polygonShader.diffuseColor", c);
        app2.setAttribute("lineShader.diffuseColor", c);
        return app2;
    }

    static Color getPLColor(Appearance app, Color plCDefault) {
        Color c = null;
        try {
            c = (Color)app.getAttribute("pointShader.diffuseColor");
        }
        catch (Exception e) {
            c = plCDefault;
        }
        return c;
    }

    static Color getFColor(Appearance app, Color fCDefault) {
        Color c = null;
        try {
            c = (Color)app.getAttribute("polygonShader.diffuseColor");
        }
        catch (Exception e) {
            c = fCDefault;
        }
        return c;
    }

    static Color copyColor(Color c) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue());
    }

    static double[] getRGBColor(Color c) {
        double[] fl = new double[]{(double)c.getRed() / 255.0, (double)c.getGreen() / 255.0, (double)c.getBlue() / 255.0};
        return fl;
    }

    public static SceneGraphComponent getDefaultLightNode() {
        SceneGraphComponent lightNode = new SceneGraphComponent();
        SceneGraphComponent light1Node = new SceneGraphComponent();
        SceneGraphComponent light2Node = new SceneGraphComponent();
        SceneGraphComponent light3Node = new SceneGraphComponent();
        SceneGraphComponent light4Node = new SceneGraphComponent();
        SceneGraphComponent light5Node = new SceneGraphComponent();
        SceneGraphComponent light6Node = new SceneGraphComponent();
        PointLight light1 = new PointLight();
        PointLight light2 = new PointLight();
        PointLight light3 = new PointLight();
        PointLight light4 = new PointLight();
        PointLight light5 = new PointLight();
        PointLight light6 = new PointLight();
        lightNode.addChild(light1Node);
        lightNode.addChild(light2Node);
        lightNode.addChild(light3Node);
        lightNode.addChild(light4Node);
        lightNode.addChild(light5Node);
        lightNode.addChild(light6Node);
        light1.setColor(new Color(255, 0, 0));
        light2.setColor(new Color(0, 255, 0));
        light3.setColor(new Color(0, 0, 255));
        light4.setColor(new Color(255, 0, 0));
        light5.setColor(new Color(0, 255, 0));
        light6.setColor(new Color(0, 0, 255));
        light1.setIntensity(1.0);
        light2.setIntensity(1.0);
        light3.setIntensity(1.0);
        light4.setIntensity(1.0);
        light5.setIntensity(1.0);
        light6.setIntensity(1.0);
        light1Node.setLight(light1);
        light2Node.setLight(light2);
        light3Node.setLight(light3);
        light4Node.setLight(light4);
        light5Node.setLight(light5);
        light6Node.setLight(light6);
        MatrixBuilder.euclidean().translate(1.0, 0.0, 1.0).assignTo(light1Node);
        MatrixBuilder.euclidean().translate(1.0, 1.0, 1.0).assignTo(light2Node);
        MatrixBuilder.euclidean().translate(0.0, 1.0, 1.0).assignTo(light3Node);
        MatrixBuilder.euclidean().translate(-1.0, 0.0, -1.0).assignTo(light4Node);
        MatrixBuilder.euclidean().translate(-1.0, -1.0, -1.0).assignTo(light5Node);
        MatrixBuilder.euclidean().translate(0.0, -1.0, -1.0).assignTo(light6Node);
        return lightNode;
    }

    static IndexedFaceSet makeCylinder(double[] start, double[] end, double radius) {
        GeometryMergeFactory gem = new GeometryMergeFactory();
        SceneGraphComponent sgc = new SceneGraphComponent();
        double len = Rn.euclideanDistance(start, end);
        sgc.addChild(Primitives.closedCylinder(20, radius, 0.0, len, Math.PI * 2));
        double[] diff = Rn.subtract(null, end, start);
        MatrixBuilder.euclidean().rotateFromTo(new double[]{0.0, 0.0, 1.0}, diff).assignTo(sgc);
        IndexedFaceSet ifs = gem.mergeGeometrySets(sgc);
        ifs.setVertexAttributes(Attribute.COLORS, null);
        ifs.setFaceAttributes(Attribute.COLORS, null);
        return ifs;
    }
}

