/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader.mathematica;

import de.jreality.geometry.PointSetFactory;
import de.jreality.geometry.Primitives;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.Rn;
import de.jreality.reader.mathematica.MHelper;
import de.jreality.scene.Appearance;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DoubleArrayArray;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MState {
    static Color plCDefault = new Color(127, 127, 127);
    static Color fCDefault = new Color(255, 255, 255);
    LinkedList<IndexedFaceSet> faces = new LinkedList();
    double[][] coords = null;
    Color color = null;
    Color faceColor = null;
    Color edgeColor = null;
    boolean edgeDraw = true;
    boolean faceDraw = true;

    public double[] getCoords(int index) {
        if (this.coords == null) {
            return new double[]{0.0, 0.0, 0.0};
        }
        int i = index;
        if (i >= this.coords.length) {
            return new double[]{0.0, 0.0, 0.0};
        }
        return this.coords[i];
    }

    public double[][] getIndexCoords(int[] indis) {
        double[][] res = new double[indis.length][];
        for (int i = 0; i < indis.length; ++i) {
            res[i] = this.getCoords(indis[i]);
        }
        return res;
    }

    public MState copy() {
        MState snew = new MState();
        snew.faces = this.faces;
        snew.color = this.color;
        snew.edgeColor = this.edgeColor;
        snew.faceColor = this.faceColor;
        snew.coords = this.coords;
        snew.edgeDraw = this.edgeDraw;
        snew.faceDraw = this.faceDraw;
        return snew;
    }

    public Appearance getPointSetApp() {
        Appearance app = new Appearance();
        if (this.color != null) {
            app.setAttribute("pointShader.polygonShader.diffuseColor", this.color);
            app.setAttribute("pointShader.diffuseColor", this.color);
            app.setAttribute("pointShader.transparency", 1.0 - (double)this.color.getAlpha() / 256.0);
        }
        return app;
    }

    public Appearance getLineSetApp() {
        Appearance app = new Appearance();
        app.setAttribute("showPoints", false);
        if (this.color != null) {
            app.setAttribute("lineShader.polygonShader.diffuseColor", this.color);
            app.setAttribute("lineShader.diffuseColor", this.color);
            app.setAttribute("lineShader.transparency", 1.0 - (double)this.color.getAlpha() / 256.0);
            app.setAttribute("pointShader.polygonShader.diffuseColor", this.color);
            app.setAttribute("pointShader.diffuseColor", this.color);
            app.setAttribute("pointShader.transparency", 1.0 - (double)this.color.getAlpha() / 256.0);
        }
        return app;
    }

    public Appearance getFaceApp() {
        Appearance app = new Appearance();
        if (!this.edgeDraw) {
            app.setAttribute("showLines", false);
        }
        if (!this.faceDraw) {
            app.setAttribute("showFaces", false);
        }
        if (this.faceColor != null) {
            app.setAttribute("polygonShader.diffuseColor", this.faceColor);
            app.setAttribute("polygonShader.transparency", 1.0 - (double)this.faceColor.getAlpha() / 256.0);
        } else if (this.color != null) {
            app.setAttribute("polygonShader.diffuseColor", this.color);
            app.setAttribute("polygonShader.transparency", 1.0 - (double)this.color.getAlpha() / 256.0);
        }
        if (this.edgeColor != null) {
            app.setAttribute("lineShader.polygonShader.diffuseColor", this.edgeColor);
            app.setAttribute("lineShader.diffuseColor", this.edgeColor);
            app.setAttribute("lineShader.transparency", 1.0 - (double)this.edgeColor.getAlpha() / 256.0);
        } else if (this.color != null) {
            app.setAttribute("lineShader.polygonShader.diffuseColor", this.color);
            app.setAttribute("lineShader.diffuseColor", this.color);
            app.setAttribute("lineShader.transparency", 1.0 - (double)this.color.getAlpha() / 256.0);
        }
        if (this.color != null) {
            app.setAttribute("pointShader.polygonShader.diffuseColor", this.color);
            app.setAttribute("pointShader.diffuseColor", this.color);
            app.setAttribute("pointShader.transparency", 1.0 - (double)this.color.getAlpha() / 256.0);
        }
        return app;
    }

    public Appearance getPrimitiveApp() {
        Appearance app = new Appearance();
        app.setAttribute("showLines", false);
        app.setAttribute("showPoints", false);
        if (this.color != null) {
            app.setAttribute("polygonShader.diffuseColor", this.color);
            app.setAttribute("polygonShader.transparency", 1.0 - (double)this.color.getAlpha() / 256.0);
        }
        return app;
    }

    public SceneGraphComponent makeCuboid(double[] vMin, double[] vMax) {
        double[] vCenter = Rn.linearCombination(null, 0.5, vMin, 0.5, vMax);
        double[] vScale = Rn.subtract(null, vMax, vCenter);
        SceneGraphComponent geo = new SceneGraphComponent();
        geo.setGeometry(Primitives.cube());
        geo.setName("Cuboid");
        geo.setAppearance(this.getPrimitiveApp());
        MatrixBuilder.euclidean().translate(vCenter).scale(vScale).assignTo(geo);
        return geo;
    }

    public SceneGraphComponent makeSphere(double[] center, double radius) {
        SceneGraphComponent geo = Primitives.sphere(radius, center);
        geo.setName("Sphere");
        geo.setAppearance(this.getPrimitiveApp());
        return geo;
    }

    public SceneGraphComponent makeCylinder(double[] anfg, double[] ende, double radius) {
        double[] pos = Rn.linearCombination(null, 0.5, anfg, 0.5, ende);
        double scale = Rn.euclideanDistance(ende, anfg) / 2.0;
        double[] dir = Rn.normalize(null, Rn.subtract(null, ende, anfg));
        SceneGraphComponent geo = new SceneGraphComponent();
        geo = Primitives.closedCylinder(20, radius, -scale, scale, Math.PI * 2);
        geo.setName("closed Cylinder");
        if (geo.getTransformation() == null) {
            geo.setTransformation(new Transformation());
        }
        double[] m = MatrixBuilder.euclidean().translate(pos).rotateFromTo(new double[]{0.0, 0.0, 1.0}, dir).getArray();
        geo.getTransformation().multiplyOnLeft(m);
        geo.setAppearance(this.getPrimitiveApp());
        return geo;
    }

    public SceneGraphComponent makeLabel(String expr, double[] coords, double[] offset, double[] dir) {
        PointSetFactory psf = new PointSetFactory();
        psf.setVertexCount(1);
        psf.setVertexCoordinates(new double[][]{coords});
        psf.setVertexLabels(new String[]{expr});
        psf.update();
        SceneGraphComponent geo = new SceneGraphComponent();
        geo.setAppearance(this.getLabelApp());
        geo.setGeometry(psf.getPointSet());
        geo.setName("Label");
        return geo;
    }

    public Appearance getLabelApp() {
        Appearance app = new Appearance();
        app.setAttribute("pointRadius", 1.0E-4);
        if (this.color != null) {
            app.setAttribute("pointShader.polygonShader.diffuseColor", this.color);
            app.setAttribute("pointShader.transparency", 1.0 - (double)this.color.getAlpha() / 256.0);
            app.setAttribute("pointShader.diffuseColor", this.color);
        }
        return app;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getLineColor() {
        return this.color;
    }

    public Color getEdgeColor() {
        if (this.edgeColor == null) {
            return this.color;
        }
        return this.edgeColor;
    }

    public Color getFaceColor() {
        if (this.faceColor == null) {
            return this.color;
        }
        return this.faceColor;
    }

    public Color getPointColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.color = c;
        this.edgeColor = c;
        this.faceColor = c;
    }

    public void assignColorList(ArrayList<Color> cols) {
        for (IndexedFaceSet f : this.faces) {
            int n = f.getNumPoints();
            if (n > cols.size() || f.getVertexAttributes(Attribute.COLORS) != null) continue;
            double[][] cData = new double[n][];
            for (int i = 0; i < n; ++i) {
                cData[i] = MHelper.getRgbaColor(cols.get(i));
            }
            f.setVertexAttributes(Attribute.COLORS, new DoubleArrayArray.Array(cData));
        }
    }

    public void assignNormalList(ArrayList<double[]> norms) {
        for (IndexedFaceSet f : this.faces) {
            int n = f.getNumPoints();
            if (n > norms.size() || f.getVertexAttributes(Attribute.NORMALS) != null) continue;
            double[][] nData = new double[n][];
            for (int i = 0; i < n; ++i) {
                nData[i] = new double[norms.get(i).length];
                for (int j = 0; j < nData[i].length; ++j) {
                    nData[i][j] = norms.get(i)[j];
                }
            }
            f.setVertexAttributes(Attribute.NORMALS, new DoubleArrayArray.Array(nData));
        }
    }

    public void assignColorList(PointSet p, ArrayList<Color> cols) {
        int n = p.getNumPoints();
        if (n > cols.size()) {
            return;
        }
        double[][] cData = new double[n][];
        for (int i = 0; i < n; ++i) {
            cData[i] = MHelper.getRgbaColor(cols.get(i));
        }
        p.setVertexAttributes(Attribute.COLORS, new DoubleArrayArray.Array(cData));
    }

    public void assignNormalList(PointSet p, ArrayList<double[]> norms) {
        int n = p.getNumPoints();
        if (n > norms.size()) {
            return;
        }
        double[][] nData = new double[n][];
        for (int i = 0; i < n; ++i) {
            nData[i] = new double[norms.get(i).length];
            for (int j = 0; j < nData[i].length; ++j) {
                nData[i][j] = norms.get(i)[j];
            }
        }
        p.setVertexAttributes(Attribute.NORMALS, new DoubleArrayArray.Array(nData));
    }
}

