/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader;

import de.jreality.reader.SceneReader;
import de.jreality.scene.Appearance;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.util.Input;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public final class Readers {
    private Readers() {
    }

    public static SceneReader findReader(String format) {
        ReflectiveOperationException ex;
        try {
            return (SceneReader)Class.forName("de.jreality.reader.Reader" + format).newInstance();
        }
        catch (InstantiationException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        IllegalStateException rtex = new IllegalStateException("invalid reader");
        rtex.initCause(ex);
        throw rtex;
    }

    public static SceneGraphComponent read(SceneReader reader, Input input) throws IOException {
        reader.setInput(input);
        return reader.getComponent();
    }

    public static SceneGraphComponent read(String format, Input input) throws IOException {
        return Readers.read(Readers.findReader(format), input);
    }

    public static SceneGraphComponent read(File file) throws IOException {
        return Readers.read(Input.getInput(file));
    }

    public static SceneGraphComponent read(URL url) throws IOException {
        return Readers.read(Input.getInput(url));
    }

    public static SceneGraphComponent read(Input input) throws IOException {
        String lc = input.getDescription();
        String format = Readers.findFormat(lc);
        if (format == null) {
            throw new IllegalArgumentException("unknown file format");
        }
        SceneGraphComponent sgc = Readers.read(format, input);
        if (sgc.getAppearance() == null) {
            sgc.setAppearance(new Appearance());
        }
        return sgc;
    }

    public static String findFormat(String resourceName) {
        String format = null;
        String lcName = resourceName.toLowerCase();
        if (lcName.endsWith(".fe")) {
            format = "FE";
        } else if (lcName.endsWith(".mesh")) {
            format = "MESH";
        } else if (lcName.endsWith(".top")) {
            format = "POLY";
        } else if (lcName.endsWith(".pov")) {
            format = "POV";
        } else if (lcName.endsWith(".bsh")) {
            format = "BSH";
        } else if (lcName.endsWith(".las")) {
            format = "LAS";
        } else if (lcName.endsWith(".obj")) {
            format = "OBJ";
        } else if (lcName.endsWith(".3ds")) {
            format = "3DS";
        } else if (lcName.endsWith(".jvx")) {
            format = "JVX";
        } else if (lcName.endsWith(".jrs")) {
            format = "JRS";
        } else if (lcName.endsWith(".pts")) {
            format = "PTS";
        } else if (lcName.endsWith(".stl")) {
            format = "STL";
        } else if (lcName.endsWith(".wrl") || lcName.endsWith(".vrml") || lcName.endsWith(".iv")) {
            format = "VRML";
        } else if (lcName.endsWith(".m")) {
            format = "MATHEMATICA";
        } else if (lcName.endsWith(".msms")) {
            format = "MSMS";
        } else if (lcName.endsWith(".off") || lcName.endsWith(".quad") || lcName.endsWith(".mesh") || lcName.endsWith(".vect") || lcName.endsWith(".bez") || lcName.endsWith(".grp") || lcName.endsWith(".oogl") || lcName.endsWith(".list") || lcName.endsWith(".inst")) {
            format = "OOGL";
        }
        return format;
    }
}

