/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader;

import de.jreality.geometry.IndexedFaceSetFactory;
import de.jreality.reader.AbstractReader;
import de.jreality.reader.PointOctree;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.util.Input;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.LinkedList;

public class ReaderSTL
extends AbstractReader {
    public ReaderSTL() {
        this.root = new SceneGraphComponent();
    }

    public void setInput(Input input) throws IOException {
        super.setInput(input);
        try {
            this.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void load() throws Exception {
        LineNumberReader r = new LineNumberReader(this.input.getReader());
        PointOctree po = new PointOctree();
        LinkedList<double[]> pts = new LinkedList<double[]>();
        LinkedList<int[]> face_indices = new LinkedList<int[]>();
        while (!r.readLine().trim().startsWith("solid")) {
        }
        int faceCount = 0;
        while (true) {
            String line;
            if ((line = r.readLine().trim()).startsWith("end solid") || line.startsWith("endsolid")) break;
            assert (line.startsWith("facet normal"));
            ++faceCount;
            String[] split = line.trim().split("\\s+");
            double[] normal = new double[]{Double.parseDouble(split[2]), Double.parseDouble(split[3]), Double.parseDouble(split[4])};
            line = r.readLine().trim();
            assert (line.startsWith("outer loop"));
            LinkedList<Integer> face_idx = new LinkedList<Integer>();
            while ((line = r.readLine().trim()).startsWith("vertex")) {
                PointOctree.Node n;
                String[] numbers = line.trim().split("\\s+");
                double[] coord = new double[]{Double.parseDouble(numbers[1]), Double.parseDouble(numbers[2]), Double.parseDouble(numbers[3])};
                if (po.insert(coord[0], coord[1], coord[2]) != null) {
                    pts.add(coord);
                }
                if ((n = po.find(coord[0], coord[1], coord[2])) == null) {
                    throw new RuntimeException();
                }
                face_idx.add(n.index());
            }
            assert (line.equals("endloop"));
            line = r.readLine().trim();
            assert (line.equals("endfacet"));
            int[] face = new int[face_idx.size()];
            for (int i = 0; i < face.length; ++i) {
                face[i] = (Integer)face_idx.get(i);
            }
            face_indices.add(face);
        }
        System.out.println("solid end: " + faceCount + " facets read.");
        double[][] vertices = (double[][])pts.toArray((T[])new double[0][0]);
        int[][] faces = (int[][])face_indices.toArray((T[])new int[0][0]);
        IndexedFaceSetFactory ifsf = new IndexedFaceSetFactory();
        ifsf.setVertexCount(vertices.length);
        ifsf.setFaceCount(faces.length);
        ifsf.setVertexCoordinates(vertices);
        ifsf.setFaceIndices(faces);
        ifsf.setGenerateEdgesFromFaces(true);
        ifsf.setGenerateFaceNormals(true);
        ifsf.update();
        IndexedFaceSet ifs = ifsf.getIndexedFaceSet();
        this.root.setGeometry(ifs);
    }
}

