/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader;

import de.jreality.geometry.BoundingBoxUtility;
import de.jreality.geometry.GeometryUtility;
import de.jreality.geometry.PointSetFactory;
import de.jreality.reader.AbstractReader;
import de.jreality.scene.Appearance;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.util.Input;
import de.jreality.util.Rectangle3D;
import java.awt.Color;
import java.io.IOException;
import java.io.LineNumberReader;

public class ReaderPTS
extends AbstractReader {
    public ReaderPTS() {
        this.root = new SceneGraphComponent();
        Appearance app = new Appearance();
        app.setAttribute("spheresDraw", false);
        app.setAttribute("pickable", false);
        app.setAttribute("pointShader.pickable", false);
        app.setAttribute("pointShader.pointSize", 30.0);
        app.setAttribute("showPoints", true);
        app.setAttribute("pointShader.diffuseColor", Color.white);
        this.root.setAppearance(app);
    }

    public void setInput(Input input) throws IOException {
        super.setInput(input);
        this.load();
    }

    private void load() throws IOException {
        int skip = 2;
        LineNumberReader r = new LineNumberReader(this.input.getReader());
        String l = null;
        while ((l = r.readLine().trim()).startsWith("#")) {
        }
        int pointCount = Integer.parseInt(l) / (skip + 1);
        double[] points = new double[pointCount * 3];
        double[] colors = new double[pointCount * 3];
        int index = 0;
        while ((l = r.readLine()) != null && index != pointCount) {
            for (int i = 0; i < skip; ++i) {
                r.readLine();
            }
            String[] split = l.split(" ");
            if (split.length != 7) continue;
            points[3 * index] = Double.parseDouble(split[0]);
            points[3 * index + 1] = Double.parseDouble(split[1]);
            points[3 * index + 2] = Double.parseDouble(split[2]);
            colors[3 * index] = Double.parseDouble(split[4]) / 255.0;
            colors[3 * index + 1] = Double.parseDouble(split[5]) / 255.0;
            colors[3 * index + 2] = Double.parseDouble(split[6]) / 255.0;
            ++index;
        }
        PointSetFactory psf = new PointSetFactory();
        psf.setVertexCount(pointCount);
        psf.setVertexCoordinates(points);
        psf.setVertexColors(colors);
        psf.update();
        Rectangle3D bb = BoundingBoxUtility.calculateBoundingBox(psf.getPointSet());
        psf.getPointSet().setGeometryAttributes(GeometryUtility.BOUNDING_BOX, bb);
        this.root.setGeometry(psf.getPointSet());
    }
}

