/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader;

import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.reader.AbstractReader;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.StorageModel;
import de.jreality.util.Input;
import de.jreality.util.LoggingSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Vector;

public class ReaderPOLY
extends AbstractReader {
    public void setInput(Input input) throws IOException {
        super.setInput(input);
        this.root = ReaderPOLY.parse(input.getInputStream());
    }

    static SceneGraphComponent parse(InputStream is) {
        InputStreamReader r = new InputStreamReader(is);
        LineNumberReader lr = new LineNumberReader(r);
        SceneGraphComponent root = new SceneGraphComponent();
        Vector<String> v = null;
        HashMap map = new HashMap();
        try {
            String line;
            while ((line = lr.readLine()) != null) {
                if ((line = line.trim()).equals("")) continue;
                if (Character.isUpperCase(line.charAt(0))) {
                    LoggingSystem.getLogger(ReaderPOLY.class).finer(" make entry " + line);
                    v = new Vector<String>();
                    map.put(line, v);
                    continue;
                }
                if (v == null || line.equals("")) continue;
                v.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int o = 0;
        Vector vData = (Vector)map.get("GEOMETRIC_REALIZATION");
        int n = vData.size();
        double[] vertices = new double[3 * n];
        for (int i = 0; i < n; ++i) {
            String str = (String)vData.get(i);
            String[] vals = str.split("[\\s\\{\\}/]");
            LoggingSystem.getLogger(ReaderPOLY.class).finer("vals length " + vals.length);
            vertices[3 * i] = (double)Integer.parseInt(vals[0]) / (double)Integer.parseInt(vals[1]);
            vertices[3 * i + 1] = (double)Integer.parseInt(vals[2]) / (double)Integer.parseInt(vals[3]);
            vertices[3 * i + 2] = (double)Integer.parseInt(vals[4]) / (double)Integer.parseInt(vals[5]);
        }
        vData = (Vector)map.get("FACETS");
        n = vData.size();
        int[][] faces = new int[n][3];
        for (int i = 0; i < n; ++i) {
            String str = (String)vData.get(i);
            String[] vals = str.split("[\\s\\{\\}/]");
            LoggingSystem.getLogger(ReaderPOLY.class).finer("face vals length " + vals.length);
            o = vals.length > 3 ? 1 : 0;
            faces[i][0] = Integer.parseInt(vals[o + 0]);
            faces[i][1] = Integer.parseInt(vals[o + 1]);
            faces[i][2] = Integer.parseInt(vals[o + 2]);
        }
        IndexedFaceSet ifs = new IndexedFaceSet();
        ifs.setVertexCountAndAttributes(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY.inlined(3).createReadOnly(vertices));
        ifs.setFaceCountAndAttributes(Attribute.INDICES, StorageModel.INT_ARRAY_ARRAY.createReadOnly(faces));
        IndexedFaceSetUtility.calculateAndSetFaceNormals(ifs);
        IndexedFaceSetUtility.calculateAndSetVertexNormals(ifs);
        IndexedFaceSetUtility.calculateAndSetEdgesFromFaces(ifs);
        root.setGeometry(ifs);
        return root;
    }
}

