/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader;

import de.jreality.geometry.IndexedFaceSetFactory;
import de.jreality.geometry.Primitives;
import de.jreality.geometry.QuadMeshFactory;
import de.jreality.math.Rn;
import de.jreality.reader.AbstractReader;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.StorageModel;
import de.jreality.util.Input;
import de.jreality.util.LoggingSystem;
import de.jreality.util.SceneGraphUtility;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.logging.Level;

public class ReaderOOGL
extends AbstractReader {
    static String[] OOGLkeys = new String[]{"OFF", "MESH", "VECT", "SKEL", "LIST", "inst", "tlist", "transforms", "unit", "INST", "QUAD", "BEZ", "BBP"};

    public void setInput(Input input) throws IOException {
        super.setInput(input);
        this.root = this.load(input.getInputStream());
    }

    SceneGraphComponent load(InputStream inputStream) {
        BufferedReader r = new BufferedReader(new InputStreamReader(inputStream));
        SceneGraphComponent disk = new SceneGraphComponent();
        StreamTokenizer st = new StreamTokenizer(r);
        st.resetSyntax();
        st.eolIsSignificant(false);
        st.wordChars(48, 57);
        st.wordChars(65, 90);
        st.wordChars(97, 122);
        st.wordChars(46, 46);
        st.wordChars(45, 45);
        st.wordChars(43, 43);
        st.wordChars(160, 255);
        st.ordinaryChar(61);
        st.ordinaryChar(123);
        st.ordinaryChar(125);
        st.whitespaceChars(0, 32);
        st.commentChar(35);
        SceneGraphComponent sgc = this.loadOneLevel(st, 0);
        return sgc;
    }

    private SceneGraphComponent loadOneLevel(StreamTokenizer st, int bracketDepth) {
        SceneGraphComponent current;
        block88: {
            current = null;
            String name = "noName";
            LoggingSystem.getLogger(ReaderOOGL.class).log(Level.FINER, "start.");
            try {
                st.nextToken();
                if (st.ttype == 125) {
                    return null;
                }
                if (st.ttype == 123) {
                    SceneGraphComponent contents = this.loadOneLevel(st, bracketDepth + 1);
                    st.nextToken();
                    if (st.ttype != 125) {
                        LoggingSystem.getLogger(ReaderOOGL.class).log(Level.FINER, "Unmatched left bracket at  " + st.lineno());
                        return contents;
                    }
                    return contents;
                }
                if (bracketDepth > 0) {
                    if (st.ttype == -3 && !ReaderOOGL.isOOGLKeyword(st.sval)) {
                        name = st.sval;
                        st.nextToken();
                    }
                    if (st.ttype == 61) {
                        st.nextToken();
                    } else if (st.ttype == 60) {
                        ReaderOOGL or = new ReaderOOGL();
                        st.nextToken();
                        Input in = this.input.getRelativeInput(st.sval);
                        return or.read(in);
                    }
                }
                if (st.ttype != -3) break block88;
                double[][] verts = null;
                double[][] vc = null;
                double[][] fc = null;
                double[][] vn = null;
                double[][] tc = null;
                if (st.sval.indexOf("OFF") != -1) {
                    int i;
                    boolean hasTC = st.sval.indexOf("ST") >= 0;
                    boolean hasVC = st.sval.indexOf("C") >= 0;
                    boolean hasVN = st.sval.indexOf("N") >= 0;
                    Object indices = null;
                    current = SceneGraphUtility.createFullSceneGraphComponent("OFF-node");
                    int vLength = st.sval.indexOf("4") != -1 ? 4 : 3;
                    st.nextToken();
                    int numV = Integer.parseInt(st.sval);
                    st.nextToken();
                    int numF = Integer.parseInt(st.sval);
                    st.nextToken();
                    int numE = Integer.parseInt(st.sval);
                    verts = new double[numV][vLength];
                    indices = new int[numF][];
                    if (hasTC) {
                        tc = new double[numV][2];
                    }
                    if (hasVC) {
                        vc = new double[numV][4];
                    }
                    if (hasVN) {
                        vn = new double[numV][3];
                    }
                    for (i = 0; i < numV; ++i) {
                        int j;
                        for (j = 0; j < vLength; ++j) {
                            st.nextToken();
                            verts[i][j] = Double.parseDouble(st.sval);
                        }
                        if (hasVN) {
                            for (j = 0; j < 3; ++j) {
                                st.nextToken();
                                vn[i][j] = Double.parseDouble(st.sval);
                            }
                        }
                        if (hasVC) {
                            for (j = 0; j < 4; ++j) {
                                st.nextToken();
                                vc[i][j] = Double.parseDouble(st.sval);
                            }
                        }
                        if (!hasTC) continue;
                        for (j = 0; j < 2; ++j) {
                            st.nextToken();
                            tc[i][j] = Double.parseDouble(st.sval);
                        }
                    }
                    for (i = 0; i < numF; ++i) {
                        int j;
                        st.nextToken();
                        int size = Integer.parseInt(st.sval);
                        indices[i] = new int[size];
                        for (j = 0; j < size; ++j) {
                            st.nextToken();
                            indices[i][j] = Integer.parseInt(st.sval);
                        }
                        st.eolIsSignificant(true);
                        st.nextToken();
                        if (st.ttype != 10 && st.ttype != -1) {
                            if (fc == null) {
                                fc = new double[numF][4];
                            }
                            j = 0;
                            for (j = 0; j < 4 && st.ttype != 10 && st.ttype != -1; ++j) {
                                fc[i][j] = Double.parseDouble(st.sval);
                                st.nextToken();
                            }
                            if (j != 4) {
                                fc[i][3] = 1.0;
                            }
                            while (st.ttype != 10 && st.ttype != -1) {
                                st.nextToken();
                            }
                        }
                        st.eolIsSignificant(false);
                    }
                    LoggingSystem.getLogger(ReaderOOGL.class).log(Level.INFO, "Read " + numV + " vertices and " + numF + " faces");
                    IndexedFaceSetFactory ifsf = new IndexedFaceSetFactory();
                    ifsf.setVertexCount(verts.length);
                    ifsf.setVertexCoordinates(verts);
                    ifsf.setFaceCount(((int[][])indices).length);
                    ifsf.setFaceIndices((int[][])indices);
                    if (vn != null) {
                        ifsf.setVertexNormals(vn);
                    } else {
                        ifsf.setGenerateVertexNormals(true);
                    }
                    if (vc != null) {
                        ifsf.setVertexColors(vc);
                    }
                    if (tc != null) {
                        ifsf.setVertexTextureCoordinates(tc);
                    }
                    if (fc != null) {
                        ifsf.setFaceColors(fc);
                    }
                    ifsf.setGenerateEdgesFromFaces(true);
                    ifsf.setGenerateFaceNormals(true);
                    ifsf.update();
                    IndexedFaceSet ifs = ifsf.getIndexedFaceSet();
                    ifs.setName("OFF Geometry");
                    current.setGeometry(ifs);
                    break block88;
                }
                if (st.sval.indexOf("MESH") != -1) {
                    current = SceneGraphUtility.createFullSceneGraphComponent("MESH-node");
                    boolean closedU = st.sval.indexOf("u") >= 0;
                    boolean closedV = st.sval.indexOf("v") >= 0;
                    boolean hasTC = st.sval.indexOf("ST") >= 0;
                    boolean hasVC = st.sval.indexOf("C") >= 0;
                    boolean hasVN = st.sval.indexOf("N") >= 0;
                    int vLength = st.sval.indexOf("4") != -1 ? 4 : 3;
                    st.nextToken();
                    int u = Integer.parseInt(st.sval);
                    st.nextToken();
                    int v = Integer.parseInt(st.sval);
                    int n = u * v;
                    verts = new double[n][vLength];
                    if (hasTC) {
                        tc = new double[n][2];
                    }
                    if (hasVC) {
                        vc = new double[n][4];
                    }
                    if (hasVN) {
                        vn = new double[n][3];
                    }
                    for (int i = 0; i < n; ++i) {
                        int j;
                        for (j = 0; j < vLength; ++j) {
                            st.nextToken();
                            verts[i][j] = Double.parseDouble(st.sval);
                        }
                        if (hasVN) {
                            for (j = 0; j < 3; ++j) {
                                st.nextToken();
                                vn[i][j] = Double.parseDouble(st.sval);
                            }
                        }
                        if (hasVC) {
                            for (j = 0; j < 4; ++j) {
                                st.nextToken();
                                vc[i][j] = Double.parseDouble(st.sval);
                            }
                        }
                        if (!hasTC) continue;
                        for (j = 0; j < 2; ++j) {
                            st.nextToken();
                            tc[i][j] = Double.parseDouble(st.sval);
                        }
                    }
                    LoggingSystem.getLogger(ReaderOOGL.class).log(Level.FINER, "Read " + n + " vertices");
                    QuadMeshFactory qmf = new QuadMeshFactory();
                    qmf.setULineCount(u);
                    qmf.setVLineCount(v);
                    qmf.setClosedInUDirection(closedU);
                    qmf.setClosedInVDirection(closedV);
                    qmf.setVertexCoordinates(verts);
                    if (hasVN) {
                        qmf.setVertexNormals(vn);
                    } else {
                        qmf.setGenerateVertexNormals(true);
                    }
                    if (hasVC) {
                        qmf.setVertexColors(vc);
                    }
                    if (hasTC) {
                        qmf.setVertexTextureCoordinates(tc);
                    }
                    qmf.setGenerateEdgesFromFaces(true);
                    qmf.setGenerateFaceNormals(true);
                    qmf.update();
                    IndexedFaceSet mesh = qmf.getIndexedFaceSet();
                    mesh.setName("OOGL MESH");
                    current.setGeometry(mesh);
                    break block88;
                }
                if (st.sval.indexOf("VECT") != -1) {
                    int i;
                    int j;
                    current = SceneGraphUtility.createFullSceneGraphComponent("VECT-node");
                    int vLength = st.sval.indexOf("4") != -1 ? 4 : 3;
                    LoggingSystem.getLogger(this).log(Level.FINER, "found object!");
                    st.nextToken();
                    int numCurves = Integer.parseInt(st.sval);
                    st.nextToken();
                    int totalVerts = Integer.parseInt(st.sval);
                    st.nextToken();
                    int totalFolors = Integer.parseInt(st.sval);
                    int[] sizes = new int[numCurves];
                    int[] colors = new int[numCurves];
                    boolean[] closed = new boolean[numCurves];
                    int[][] indices = new int[numCurves][];
                    int vertCount = 0;
                    for (int i2 = 0; i2 < numCurves; ++i2) {
                        st.nextToken();
                        int realCount = 0;
                        LoggingSystem.getLogger(this).log(Level.FINER, "Token is " + st.sval);
                        int val = Integer.parseInt(st.sval);
                        if (val < 0) {
                            val = sizes[i2] = -val;
                            realCount = sizes[i2] + 1;
                            closed[i2] = true;
                        } else {
                            sizes[i2] = val;
                            closed[i2] = false;
                            realCount = sizes[i2];
                        }
                        indices[i2] = new int[realCount];
                        for (j = 0; j < val; ++j) {
                            indices[i2][j] = vertCount + j;
                        }
                        if (closed[i2]) {
                            indices[i2][val] = vertCount;
                        }
                        vertCount += val;
                    }
                    int totalColors = 0;
                    for (i = 0; i < numCurves; ++i) {
                        st.nextToken();
                        LoggingSystem.getLogger(this).log(Level.FINER, "Token is " + st.sval);
                        colors[i] = Integer.parseInt(st.sval);
                        totalColors += colors[i];
                    }
                    verts = new double[totalVerts][vLength];
                    vc = new double[totalVerts][4];
                    for (i = 0; i < totalVerts; ++i) {
                        for (int j2 = 0; j2 < vLength; ++j2) {
                            st.nextToken();
                            LoggingSystem.getLogger(this).log(Level.FINER, "Token is " + st.sval);
                            verts[i][j2] = Double.parseDouble(st.sval);
                        }
                    }
                    int vertC = 0;
                    if (totalColors > 0) {
                        for (int i3 = 0; i3 < numCurves; ++i3) {
                            int k;
                            for (j = 0; j < colors[i3]; ++j) {
                                for (k = 0; k < 4; ++k) {
                                    st.nextToken();
                                    vc[vertC][k] = Double.parseDouble(st.sval);
                                }
                                ++vertC;
                            }
                            while (j < sizes[i3]) {
                                for (k = 0; k < 4; ++k) {
                                    vc[vertC][k] = vc[vertC - 1][k];
                                }
                                ++vertC;
                                ++j;
                            }
                        }
                    }
                    LoggingSystem.getLogger(ReaderOOGL.class).log(Level.INFO, "Read " + numCurves + " curves and " + totalVerts + " vertices");
                    IndexedLineSet ils = new IndexedLineSet(totalVerts);
                    ils.setName("VECT Geometry");
                    ils.setVertexAttributes(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY.array(vLength).createReadOnly(verts));
                    ils.setVertexAttributes(Attribute.COLORS, StorageModel.DOUBLE_ARRAY.array(4).createReadOnly(vc));
                    ils.setEdgeCountAndAttributes(Attribute.INDICES, StorageModel.INT_ARRAY.array().createReadOnly(indices));
                    current.setGeometry(ils);
                    break block88;
                }
                if (st.sval.indexOf("SPHERE") != -1) {
                    double[] x = new double[4];
                    for (int i = 0; i < 4; ++i) {
                        st.nextToken();
                        x[i] = Double.parseDouble(st.sval);
                    }
                    current = Primitives.sphere(x[0], x[1], x[2], x[3]);
                    current.setName("SPHERE-node");
                    break block88;
                }
                if (st.sval.indexOf("TLIST") != -1) {
                    boolean transposed;
                    current = SceneGraphUtility.createFullSceneGraphComponent("TLIST-node");
                    boolean bl = transposed = st.sval.indexOf("FLIP") != -1;
                    if (transposed) {
                        LoggingSystem.getLogger(ReaderOOGL.class).log(Level.FINER, "Matrices are trasnposed");
                    }
                    double[] mat = new double[16];
                    boolean reading = true;
                    int count = 0;
                    while (reading) {
                        for (int j = 0; j < 16; ++j) {
                            st.nextToken();
                            if (st.ttype != -3) {
                                reading = false;
                                break;
                            }
                            mat[j] = Double.parseDouble(st.sval);
                        }
                        if (transposed) {
                            Rn.transpose(mat, mat);
                        }
                        if (reading) {
                            SceneGraphComponent sgc = new SceneGraphComponent();
                            sgc.setName("tlist child" + count++);
                            sgc.setTransformation(new Transformation(mat));
                            current.addChild(sgc);
                            continue;
                        }
                        break block88;
                    }
                    break block88;
                }
                if (st.sval.indexOf("LIST") != -1) {
                    SceneGraphComponent child;
                    current = SceneGraphUtility.createFullSceneGraphComponent("LIST-node");
                    while ((child = this.loadOneLevel(st, bracketDepth)) != null) {
                        current.addChild(child);
                    }
                } else if (st.sval.indexOf("INST") != -1) {
                    current = SceneGraphUtility.createFullSceneGraphComponent("INST-node");
                    SceneGraphComponent geom = SceneGraphUtility.createFullSceneGraphComponent("INST-unit");
                    st.nextToken();
                    if (st.ttype != -3) {
                        LoggingSystem.getLogger(ReaderOOGL.class).log(Level.FINER, "Invalid type in INST: " + st.ttype);
                        return null;
                    }
                    if (st.sval.indexOf("unit") != -1 || st.sval.indexOf("geom") != -1) {
                        geom = this.loadOneLevel(st, bracketDepth);
                    }
                    st.nextToken();
                    if (st.sval.indexOf("tlist") != -1 || st.sval.indexOf("transform") != -1) {
                        current = this.loadOneLevel(st, bracketDepth);
                    }
                    for (int i = 0; i < current.getChildComponentCount(); ++i) {
                        SceneGraphComponent cc = current.getChildComponent(i);
                        cc.addChild(geom);
                    }
                } else if (st.sval.indexOf("XYZR") != -1) {
                    HashMap<Double, Integer> radii = new HashMap<Double, Integer>();
                    current = SceneGraphUtility.createFullSceneGraphComponent("XYZR-node");
                    Color[] testcolors = new Color[]{Color.red, Color.blue, Color.white, Color.green};
                    st.nextToken();
                    double scale = Double.parseDouble(st.sval);
                    st.nextToken();
                    do {
                        double x = Double.parseDouble(st.sval);
                        st.nextToken();
                        double y = Double.parseDouble(st.sval);
                        st.nextToken();
                        double z = Double.parseDouble(st.sval);
                        st.nextToken();
                        double r = Double.parseDouble(st.sval);
                        SceneGraphComponent sphere = Primitives.sphere(scale * r, x, y, z);
                        st.eolIsSignificant(true);
                        st.nextToken();
                        int index = 0;
                        if (st.ttype != 10 && st.ttype != -1) {
                            index = Integer.parseInt(st.sval);
                        } else {
                            Double rr = new Double(r);
                            if (radii.get(rr) != null) {
                                index = (Integer)radii.get(rr);
                            } else {
                                index = radii.size();
                                radii.put(rr, index);
                            }
                        }
                        sphere.getAppearance().setAttribute("polygonShader.diffuseColor", testcolors[index % testcolors.length]);
                        st.eolIsSignificant(false);
                        st.nextToken();
                        current.addChild(sphere);
                    } while (st.ttype != -1);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (current != null) {
            LoggingSystem.getLogger(ReaderOOGL.class).log(Level.FINER, "made " + current.getChildComponentCount() + " components");
            LoggingSystem.getLogger(ReaderOOGL.class).log(Level.FINER, "done.");
        }
        return current;
    }

    private static boolean isOOGLKeyword(String sval) {
        for (int i = 0; i < OOGLkeys.length; ++i) {
            if (sval.indexOf(OOGLkeys[i]) == -1) continue;
            return true;
        }
        return false;
    }
}

