/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader;

import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.reader.AbstractReader;
import de.jreality.reader.ParserMTL;
import de.jreality.reader.ParserUtil;
import de.jreality.scene.Appearance;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.StorageModel;
import de.jreality.util.Input;
import de.jreality.util.LoggingSystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ReaderOBJ
extends AbstractReader {
    private HashMap<String, Appearance> materials = new HashMap();
    private HashMap<String, Group> groups = new HashMap();
    private List<double[]> v;
    private List<double[]> vNorms;
    private List<double[]> vTexs;
    private LinkedList<String> currentGroups;
    private boolean smoothShading = false;
    private Appearance currMat = ParserMTL.createDefault();
    private int[][] temp = new int[3][1000];
    int count;

    public ReaderOBJ() {
        for (int i = 0; i < 1000; ++i) {
            this.temp[0][i] = -1;
            this.temp[1][i] = -1;
            this.temp[2][i] = -1;
        }
        this.count = 0;
        this.v = new ArrayList<double[]>(1000);
        this.vNorms = new ArrayList<double[]>(1000);
        this.vTexs = new ArrayList<double[]>(1000);
        this.currentGroups = new LinkedList();
        this.currentGroups.add("default");
        this.groups.put("default", new Group("default"));
        this.root = new SceneGraphComponent();
        this.root.setAppearance(ParserMTL.createDefault());
    }

    public void setInput(Input input) throws IOException {
        super.setInput(input);
        this.load();
    }

    private StreamTokenizer globalSyntax(StreamTokenizer st) {
        st.resetSyntax();
        st.eolIsSignificant(true);
        st.wordChars(48, 57);
        st.wordChars(65, 90);
        st.wordChars(97, 122);
        st.wordChars(95, 95);
        st.wordChars(46, 46);
        st.wordChars(45, 45);
        st.wordChars(43, 43);
        st.wordChars(160, 255);
        st.whitespaceChars(0, 32);
        st.commentChar(35);
        st.ordinaryChar(47);
        st.parseNumbers();
        return st;
    }

    private StreamTokenizer filenameSyntax(StreamTokenizer st) {
        st.resetSyntax();
        st.eolIsSignificant(true);
        st.wordChars(48, 57);
        st.wordChars(65, 90);
        st.wordChars(97, 122);
        st.wordChars(95, 95);
        st.wordChars(46, 46);
        st.wordChars(45, 45);
        st.wordChars(43, 43);
        st.wordChars(160, 255);
        st.whitespaceChars(0, 32);
        st.commentChar(35);
        st.ordinaryChar(47);
        st.parseNumbers();
        return st;
    }

    private void load() throws IOException {
        StreamTokenizer st = new StreamTokenizer(this.input.getReader());
        this.globalSyntax(st);
        while (st.nextToken() != -1) {
            if (st.ttype != -3) continue;
            String word = st.sval;
            if (word.equalsIgnoreCase("v")) {
                this.addVertex(st);
                continue;
            }
            if (word.equalsIgnoreCase("vp")) {
                this.ignoreTag(st);
                continue;
            }
            if (word.equalsIgnoreCase("vn")) {
                this.addVertexNormal(st);
                continue;
            }
            if (word.equalsIgnoreCase("vt")) {
                this.addVertexTextureCoordinate(st);
                continue;
            }
            if (word.equalsIgnoreCase("g")) {
                this.addGroup(st);
                continue;
            }
            if (word.equalsIgnoreCase("s")) {
                this.setSmootheningGroup(st);
                continue;
            }
            if (word.equalsIgnoreCase("p")) {
                this.ignoreTag(st);
                continue;
            }
            if (word.equalsIgnoreCase("l")) {
                this.ignoreTag(st);
                continue;
            }
            if (word.equalsIgnoreCase("f")) {
                this.addFace(st);
                continue;
            }
            if (word.equalsIgnoreCase("mtllib")) {
                this.addMaterial(st);
                continue;
            }
            if (word.equalsIgnoreCase("usemtl")) {
                this.setCurrentMaterial(st);
                continue;
            }
            LoggingSystem.getLogger(this).fine("unhandled tag: " + word);
            while (st.nextToken() != 10) {
                if (st.ttype == -2) {
                    LoggingSystem.getLogger(this).fine("" + st.nval);
                    continue;
                }
                LoggingSystem.getLogger(this).fine(st.sval);
            }
            LoggingSystem.getLogger(this).fine("unhandled tag: " + word + " end");
        }
        for (Group g : this.groups.values()) {
            if (g.hasGeometry()) {
                this.root.addChild(g.createComponent());
                continue;
            }
            LoggingSystem.getLogger(this).fine("Ignoring group " + g.name + " [has no geometry]");
        }
    }

    private void setSmootheningGroup(StreamTokenizer st) throws IOException {
        st.nextToken();
        if (st.ttype == -2) {
            boolean bl = this.smoothShading = st.nval > 0.0;
        }
        if (st.ttype == -3 && "off".equals(st.sval)) {
            this.smoothShading = false;
        }
        while (st.nextToken() != 10) {
        }
        Iterator i = this.currentGroups.iterator();
        while (i.hasNext()) {
            Group current = this.groups.get(i.next());
            current.setSmoothening(this.smoothShading);
        }
    }

    private void ignoreTag(StreamTokenizer st) throws IOException {
        while (st.nextToken() != 10) {
        }
    }

    private void addVertex(StreamTokenizer st) throws IOException {
        double[] coords = new double[]{ParserUtil.parseNumber(st), ParserUtil.parseNumber(st), ParserUtil.parseNumber(st)};
        this.v.add(coords);
    }

    private void addVertexTextureCoordinate(StreamTokenizer st) throws IOException {
        double[] coords = new double[]{ParserUtil.parseNumber(st), ParserUtil.parseNumber(st)};
        this.vTexs.add(coords);
    }

    private void addVertexNormal(StreamTokenizer st) throws IOException {
        double[] coords = new double[]{ParserUtil.parseNumber(st), ParserUtil.parseNumber(st), ParserUtil.parseNumber(st)};
        this.vNorms.add(coords);
    }

    private void addMaterial(StreamTokenizer st) throws IOException {
        this.filenameSyntax(st);
        while (st.nextToken() != 10) {
            String fileName = st.sval;
            if (fileName == null) continue;
            try {
                List app = ParserMTL.readAppearences(this.input.resolveInput(fileName));
                for (Appearance a : app) {
                    this.materials.put(a.getName(), a);
                }
            }
            catch (FileNotFoundException fnfe) {
                LoggingSystem.getLogger(this).info("couldnt find material file: " + fileName);
            }
        }
        this.globalSyntax(st);
    }

    private void setCurrentMaterial(StreamTokenizer st) throws IOException {
        while (st.nextToken() != 10) {
            String matName = st.sval;
            this.currMat = this.materials.get(matName);
            if (this.currMat == null) {
                System.err.println("Warning: " + matName + " [Material name] is null");
                continue;
            }
            Iterator i = this.currentGroups.iterator();
            while (i.hasNext()) {
                Group current = this.groups.get(i.next());
                current.setMaterial(this.currMat);
            }
        }
    }

    private void addFace(StreamTokenizer st) throws IOException {
        int ix = 0;
        int jx = 0;
        boolean lastWasNumber = false;
        while (st.nextToken() != 10) {
            if (st.ttype == 47) {
                ++jx;
                lastWasNumber = false;
                continue;
            }
            if (st.ttype == -2) {
                if (lastWasNumber) {
                    ++ix;
                    jx = 0;
                }
                if (st.nval > 0.0) {
                    this.temp[jx][ix] = (int)(st.nval - 1.0);
                } else {
                    System.err.println("OBJReader.addFace() negative face");
                    this.temp[jx][ix] = this.v.size() + (int)st.nval;
                }
                lastWasNumber = true;
                continue;
            }
            System.out.println("unknown tag " + st.sval + " " + st.ttype);
        }
        int[] faceV = new int[++ix];
        int[] faceVT = new int[ix];
        int[] faceVN = new int[ix];
        System.arraycopy(this.temp[0], 0, faceV, 0, ix);
        System.arraycopy(this.temp[1], 0, faceVT, 0, ix);
        System.arraycopy(this.temp[2], 0, faceVN, 0, ix);
        for (int i = 0; i < ix; ++i) {
            this.temp[0][i] = -1;
            this.temp[1][i] = -1;
            this.temp[2][i] = -1;
        }
        Iterator i = this.currentGroups.iterator();
        while (i.hasNext()) {
            Group g = this.groups.get(i.next());
            g.addFace(faceV, faceVT, faceVN);
        }
    }

    private void addGroup(StreamTokenizer st) throws IOException {
        this.currentGroups.clear();
        st.nextToken();
        String gName = "default";
        if (st.ttype == 10) {
            LoggingSystem.getLogger(this).fine("Warning: empty group name");
            st.pushBack();
        } else {
            gName = st.sval;
        }
        this.currentGroups.add(gName);
        if (this.groups.get(gName) == null) {
            Group g = new Group(gName);
            this.groups.put(gName, g);
        }
        while (st.nextToken() != 10) {
        }
    }

    private static class FaceData {
        private HashMap<String, Integer> storedData = new HashMap();
        private ArrayList<Triple> list = new ArrayList();
        private int idCounter;

        private FaceData() {
        }

        int getID(int vertexIndex, int texIndex, int normalIndex) {
            String key = vertexIndex + "::" + texIndex + "::" + normalIndex;
            Integer ret = this.storedData.get(key);
            if (ret == null) {
                ret = new Integer(this.idCounter++);
                this.storedData.put(key, ret);
                this.list.add(new Triple(vertexIndex, texIndex, normalIndex));
            }
            return ret;
        }

        void reset() {
            this.storedData.clear();
        }

        int size() {
            return this.storedData.size();
        }

        int vertexId(int id) {
            return this.list.get((int)id).v;
        }

        int texId(int id) {
            return this.list.get((int)id).t;
        }

        int normalId(int id) {
            return this.list.get((int)id).n;
        }

        private class Triple {
            int v;
            int t;
            int n;

            Triple(int vId, int tId, int nId) {
                this.v = vId;
                this.t = tId;
                this.n = nId;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Group {
        final List<int[]> faces;
        final String name;
        final Appearance material;
        boolean smooth;
        boolean hasTex;
        boolean hasNorms;
        FaceData fd;

        Group(String name) {
            this.name = name;
            this.faces = new ArrayList<int[]>(11);
            this.material = ParserMTL.createDefault();
            this.setSmoothening(ReaderOBJ.this.smoothShading);
            this.setMaterial(ReaderOBJ.this.currMat);
            this.fd = new FaceData();
        }

        void addFace(int[] verts, int[] texs, int[] norms) {
            int[] face = new int[verts.length];
            for (int i = 0; i < verts.length; ++i) {
                face[i] = this.fd.getID(verts[i], texs[i], norms[i]);
            }
            this.faces.add(face);
        }

        void setSmoothening(boolean smoothShading) {
        }

        public boolean hasGeometry() {
            return this.faces.size() > 0;
        }

        void setMaterial(Appearance a) {
            if (a == null) {
                System.err.println("Warning: current app==null");
                return;
            }
            Set lst = a.getStoredAttributes();
            for (String aName : lst) {
                this.material.setAttribute(aName, a.getAttribute(aName));
            }
            this.setSmoothening(this.smooth);
        }

        Geometry createGeometry() {
            boolean hasVertexNormals;
            ArrayList<double[]> vertices = this.extractVertices();
            ArrayList<double[]> vertexTex = this.extractTexCoords();
            ArrayList<double[]> vertexNorms = this.extractNormals();
            IndexedFaceSet ifs = new IndexedFaceSet();
            ifs.setVertexCountAndAttributes(Attribute.COORDINATES, StorageModel.DOUBLE3_ARRAY.createReadOnly(vertices.toArray((T[])new double[vertices.size()][])));
            ifs.setFaceCountAndAttributes(Attribute.INDICES, StorageModel.INT_ARRAY_ARRAY.createReadOnly(this.faces.toArray((T[])new int[this.faces.size()][])));
            if (vertexTex != null) {
                ifs.setVertexAttributes(Attribute.TEXTURE_COORDINATES, StorageModel.DOUBLE_ARRAY.array(2).createReadOnly(vertexTex.toArray((T[])new double[vertexTex.size()][])));
            }
            if (vertexNorms != null) {
                ifs.setVertexAttributes(Attribute.NORMALS, StorageModel.DOUBLE3_ARRAY.createReadOnly(vertexNorms.toArray((T[])new double[vertexNorms.size()][])));
            }
            boolean bl = hasVertexNormals = ifs.getVertexAttributes(Attribute.NORMALS) != null;
            if (!hasVertexNormals && this.smooth) {
                IndexedFaceSetUtility.calculateAndSetVertexNormals(ifs);
            }
            if (!this.smooth && !hasVertexNormals) {
                IndexedFaceSetUtility.calculateAndSetFaceNormals(ifs);
            }
            IndexedFaceSetUtility.calculateAndSetEdgesFromFaces(ifs);
            return ifs;
        }

        private ArrayList<double[]> extractNormals() {
            if (this.fd.normalId(0) == -1) {
                return null;
            }
            ArrayList<double[]> list = new ArrayList<double[]>(this.fd.size());
            for (int i = 0; i < this.fd.size(); ++i) {
                list.add(i, (double[])ReaderOBJ.this.vNorms.get(this.fd.normalId(i)));
            }
            return list;
        }

        private ArrayList<double[]> extractTexCoords() {
            if (this.fd.texId(0) == -1) {
                return null;
            }
            ArrayList<double[]> list = new ArrayList<double[]>(this.fd.size());
            for (int i = 0; i < this.fd.size(); ++i) {
                list.add(i, (double[])ReaderOBJ.this.vTexs.get(this.fd.texId(i)));
            }
            return list;
        }

        private ArrayList<double[]> extractVertices() {
            ArrayList<double[]> list = new ArrayList<double[]>(this.fd.size());
            for (int i = 0; i < this.fd.size(); ++i) {
                list.add(i, (double[])ReaderOBJ.this.v.get(this.fd.vertexId(i)));
            }
            return list;
        }

        SceneGraphComponent createComponent() {
            SceneGraphComponent ret = new SceneGraphComponent();
            ret.setName(this.name);
            ret.setAppearance(this.material);
            ret.setGeometry(this.createGeometry());
            return ret;
        }
    }
}

