/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader;

import de.jreality.geometry.IndexedFaceSetFactory;
import de.jreality.reader.AbstractReader;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.util.Input;
import de.jreality.util.LoggingSystem;
import de.jreality.util.SceneGraphUtility;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.logging.Level;

public class ReaderMSMS
extends AbstractReader {
    public void setInput(Input input) throws IOException {
        super.setInput(input);
        this.root = this.load(input.getInputStream());
    }

    SceneGraphComponent load(InputStream inputStream) {
        BufferedReader r = new BufferedReader(new InputStreamReader(inputStream));
        StreamTokenizer st = new StreamTokenizer(r);
        st.resetSyntax();
        st.eolIsSignificant(false);
        st.wordChars(48, 57);
        st.wordChars(65, 90);
        st.wordChars(97, 122);
        st.wordChars(46, 46);
        st.wordChars(45, 45);
        st.wordChars(43, 43);
        st.wordChars(160, 255);
        st.ordinaryChar(61);
        st.ordinaryChar(123);
        st.ordinaryChar(125);
        st.whitespaceChars(0, 32);
        st.commentChar(35);
        SceneGraphComponent current = null;
        LoggingSystem.getLogger(ReaderMSMS.class).log(Level.FINER, "start.");
        try {
            current = SceneGraphUtility.createFullSceneGraphComponent("MSMS-node");
            st.nextToken();
            int numV = Integer.parseInt(st.sval);
            st.nextToken();
            int numS = Integer.parseInt(st.sval);
            st.nextToken();
            double density = Double.parseDouble(st.sval);
            st.nextToken();
            double probeRadius = Double.parseDouble(st.sval);
            double[][] verts = new double[numV][3];
            double[][] normals = new double[numV][3];
            int[] nearestSphere = new int[numV];
            int[] vertexType = new int[numV];
            for (int i = 0; i < numV; ++i) {
                int j;
                for (j = 0; j < 3; ++j) {
                    st.nextToken();
                    verts[i][j] = Double.parseDouble(st.sval);
                }
                for (j = 0; j < 3; ++j) {
                    st.nextToken();
                    normals[i][j] = Double.parseDouble(st.sval);
                }
                st.nextToken();
                st.nextToken();
                nearestSphere[i] = Integer.parseInt(st.sval);
                st.nextToken();
                vertexType[i] = Integer.parseInt(st.sval);
            }
            st.nextToken();
            int numF = Integer.parseInt(st.sval);
            st.nextToken();
            st.nextToken();
            st.nextToken();
            int[][] indices = new int[numF][3];
            int[] faceType = new int[numF];
            Color[] facec = new Color[numF];
            Color[] colors = new Color[]{new Color(255, 55, 0), new Color(100, 255, 0), new Color(50, 50, 255), new Color(255, 200, 0), new Color(255, 0, 255), new Color(0, 255, 255)};
            for (int i = 0; i < numF; ++i) {
                for (int j = 0; j < 3; ++j) {
                    st.nextToken();
                    indices[i][j] = Integer.parseInt(st.sval) - 1;
                }
                st.nextToken();
                faceType[i] = Integer.parseInt(st.sval);
                facec[i] = colors[faceType[i] % colors.length];
                st.nextToken();
            }
            LoggingSystem.getLogger(ReaderMSMS.class).log(Level.INFO, "Read " + numV + " vertices and " + numF + " faces");
            IndexedFaceSetFactory ifsf = new IndexedFaceSetFactory();
            ifsf.setVertexCount(verts.length);
            ifsf.setVertexCoordinates(verts);
            ifsf.setVertexNormals(normals);
            ifsf.setFaceCount(indices.length);
            ifsf.setFaceIndices(indices);
            ifsf.setGenerateEdgesFromFaces(true);
            ifsf.setGenerateFaceNormals(true);
            ifsf.update();
            IndexedFaceSet ifs = ifsf.getIndexedFaceSet();
            ifs.setName("OFF Geometry");
            current.setGeometry(ifs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return current;
    }
}

