/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader;

import de.jreality.geometry.PointSetFactory;
import de.jreality.math.MatrixBuilder;
import de.jreality.reader.AbstractReader;
import de.jreality.scene.Appearance;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.util.Input;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ReaderLAS
extends AbstractReader {
    public final int z = 1;
    public final int x = 4;
    public final int y = 5;
    public final int phi = 2;
    public final int theta = 3;
    private boolean hasHeader = true;

    public ReaderLAS() {
        this.root = new SceneGraphComponent("borehole");
        Appearance app = new Appearance();
        app.setAttribute("spheresDraw", true);
        app.setAttribute("pointRadius", 2.0);
        app.setAttribute("showPoints", true);
        this.root.setAppearance(app);
        MatrixBuilder.euclidean().rotate(Math.PI, 0.0, 1.0, 0.0).assignTo(this.root);
        MatrixBuilder.euclidean(this.root).rotate(1.5707963267948966, 0.0, 0.0, 1.0).assignTo(this.root);
    }

    public void setInput(Input input) throws IOException {
        super.setInput(input);
        this.read();
    }

    private void read() throws IOException {
        LineNumberReader r = new LineNumberReader(this.input.getReader());
        String line = this.hasHeader ? r.readLine() : "";
        ArrayList<Double> lx = new ArrayList<Double>();
        ArrayList<Double> ly = new ArrayList<Double>();
        ArrayList<Double> lz = new ArrayList<Double>();
        ArrayList<Double> lphi = new ArrayList<Double>();
        ArrayList<Double> ltheta = new ArrayList<Double>();
        StringTokenizer st = new StringTokenizer(line);
        while ((line = r.readLine()) != null) {
            if (line.equals("")) continue;
            line = line.replace(',', '.');
            st = new StringTokenizer(line);
            int i = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                switch (i) {
                    case 4: {
                        lx.add(Double.parseDouble(token));
                        break;
                    }
                    case 5: {
                        ly.add(Double.parseDouble(token));
                        break;
                    }
                    case 1: {
                        lz.add(Double.parseDouble(token));
                        break;
                    }
                    case 2: {
                        lphi.add(Double.parseDouble(token));
                        break;
                    }
                    case 3: {
                        ltheta.add(Double.parseDouble(token));
                    }
                }
                ++i;
            }
        }
        double[][] vertices = new double[lx.size()][3];
        for (int i = 1; i < lx.size(); ++i) {
            vertices[i] = new double[]{(Double)lx.get(i), (Double)ly.get(i), (Double)lz.get(i)};
        }
        PointSetFactory f = new PointSetFactory();
        f.setVertexCount(vertices.length);
        f.setVertexCoordinates(vertices);
        f.update();
        this.root.setGeometry(f.getPointSet());
    }

    public void setHasHeader(boolean hasHeader) {
        this.hasHeader = hasHeader;
    }
}

