/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader;

import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.reader.AbstractReader;
import de.jreality.scene.Appearance;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataListSet;
import de.jreality.scene.data.StorageModel;
import de.jreality.util.Input;
import de.jreality.util.LoggingSystem;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ReaderJVX
extends AbstractReader {
    public void setInput(Input input) throws IOException {
        super.setInput(input);
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setValidating(false);
        try {
            SAXParser parser = parserFactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setEntityResolver(new Resolver());
            Handler handler = new Handler();
            reader.setContentHandler(handler);
            InputSource src = new InputSource(input.getInputStream());
            reader.parse(src);
            this.root = handler.getRoot();
        }
        catch (ParserConfigurationException e) {
            IOException ie = new IOException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        catch (SAXException e) {
            IOException ie = new IOException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    static class Handler
    extends DefaultHandler {
        SceneGraphComponent root = new SceneGraphComponent();
        Stack<SceneGraphComponent> componentStack = new Stack();
        SceneGraphComponent currentComponent;
        DataListSet vertexAttributes;
        DataListSet edgeAttributes;
        DataListSet faceAttributes;
        private CharData currentCharData = CharData.NONE;
        LinkedList<double[]> currentPoints;
        LinkedList<double[]> currentNormals;
        LinkedList<double[]> currentColors;
        LinkedList<int[]> currentEdges;
        LinkedList<int[]> currentFaces;
        LinkedList<String> currentLabels;
        LinkedList<char[]> chars = new LinkedList();

        Handler() {
        }

        public SceneGraphComponent getRoot() {
            return this.root;
        }

        public void startDocument() throws SAXException {
            this.currentComponent = this.root;
            super.startDocument();
        }

        public void endDocument() throws SAXException {
            if (this.componentStack.size() != 0) {
                throw new RuntimeException(" nonempty stack at end of jvx file.");
            }
            super.endDocument();
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            LoggingSystem.getLogger(this).fine("start elem: qName " + qName);
            if (qName.equals("geometry")) {
                SceneGraphComponent c = new SceneGraphComponent();
                Appearance ap = new Appearance();
                c.setAppearance(ap);
                if (this.currentComponent != null) {
                    this.currentComponent.addChild(c);
                }
                this.componentStack.push(this.currentComponent);
                this.currentComponent = c;
                return;
            }
            if (qName.equals("pointSet")) {
                String point = attributes.getValue("point");
                if (point != null && point.equals("show")) {
                    this.currentComponent.getAppearance().setAttribute("showPoints", true);
                } else {
                    this.currentComponent.getAppearance().setAttribute("showPoints", false);
                }
                return;
            }
            if (qName.equals("points")) {
                this.currentPoints = new LinkedList();
                this.currentLabels = new LinkedList();
                return;
            }
            if (qName.equals("p")) {
                if (this.currentPoints == null) {
                    return;
                }
                this.currentLabels.add(attributes.getValue("name"));
                this.currentCharData = CharData.POINT;
                return;
            }
            if (qName.equals("lineSet")) {
                String point = attributes.getValue("line");
                if (point != null && point.equals("show")) {
                    this.currentComponent.getAppearance().setAttribute("showLines", true);
                } else {
                    this.currentComponent.getAppearance().setAttribute("showLines", false);
                }
                return;
            }
            if (qName.equals("lines")) {
                this.currentEdges = new LinkedList();
                this.currentLabels = new LinkedList();
                return;
            }
            if (qName.equals("l")) {
                if (this.currentEdges == null) {
                    return;
                }
                this.currentLabels.add(attributes.getValue("name"));
                this.currentCharData = CharData.LINE;
                return;
            }
            if (qName.equals("faceSet")) {
                String point = attributes.getValue("face");
                if (point != null && point.equals("show")) {
                    this.currentComponent.getAppearance().setAttribute("showFaces", true);
                } else {
                    this.currentComponent.getAppearance().setAttribute("showFaces", false);
                }
                return;
            }
            if (qName.equals("faces")) {
                this.currentFaces = new LinkedList();
                this.currentLabels = new LinkedList();
                return;
            }
            if (qName.equals("f")) {
                if (this.currentFaces == null) {
                    return;
                }
                this.currentLabels.add(attributes.getValue("name"));
                this.currentCharData = CharData.FACE;
                return;
            }
            if (qName.equals("colors")) {
                this.currentColors = new LinkedList();
                return;
            }
            if (qName.equals("c")) {
                if (this.currentColors == null) {
                    return;
                }
                this.currentCharData = CharData.COLOR;
                return;
            }
            if (qName.equals("normals")) {
                this.currentNormals = new LinkedList();
                return;
            }
            if (qName.equals("n")) {
                if (this.currentNormals == null) {
                    return;
                }
                this.currentCharData = CharData.NORMAL;
                return;
            }
            this.currentCharData = CharData.NONE;
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.charactersImpl();
            this.currentCharData = CharData.NONE;
            LoggingSystem.getLogger(this).fine("end elem: qName " + qName);
            if (qName.equals("geometry")) {
                IndexedFaceSet geom = this.faceAttributes != null ? new IndexedFaceSet() : (this.edgeAttributes != null ? new IndexedLineSet() : new PointSet());
                this.currentComponent.setGeometry(geom);
                this.currentComponent.childrenWriteAccept(new SceneGraphVisitor(){

                    public void visit(IndexedFaceSet i) {
                        this.visit((IndexedLineSet)i);
                        i.setFaceCountAndAttributes(Handler.this.faceAttributes);
                        if (!(Handler.this.faceAttributes.containsAttribute(Attribute.NORMALS) || Handler.this.edgeAttributes != null && Handler.this.edgeAttributes.containsAttribute(Attribute.NORMALS))) {
                            IndexedFaceSetUtility.calculateAndSetFaceNormals(i);
                        }
                    }

                    public void visit(IndexedLineSet g) {
                        this.visit((PointSet)g);
                        if (Handler.this.edgeAttributes != null) {
                            g.setEdgeCountAndAttributes(Handler.this.edgeAttributes);
                        }
                    }

                    public void visit(PointSet p) {
                        p.setVertexCountAndAttributes(Handler.this.vertexAttributes);
                    }
                }, false, false, false, false, true, false);
                this.faceAttributes = null;
                this.edgeAttributes = null;
                this.vertexAttributes = null;
                this.currentComponent = this.componentStack.pop();
            }
            if (qName.equals("pointSet")) {
                double[][] points = (double[][])this.currentPoints.toArray((T[])new double[0][]);
                this.vertexAttributes = new DataListSet(points.length);
                this.vertexAttributes.addReadOnly(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY_ARRAY, points);
                if (this.currentNormals != null && !this.currentNormals.isEmpty()) {
                    double[][] normals = (double[][])this.currentNormals.toArray((T[])new double[0][]);
                    this.vertexAttributes.addReadOnly(Attribute.NORMALS, StorageModel.DOUBLE_ARRAY_ARRAY, normals);
                }
                if (this.currentColors != null && !this.currentColors.isEmpty()) {
                    double[][] colors = (double[][])this.currentColors.toArray((T[])new double[0][]);
                    this.vertexAttributes.addReadOnly(Attribute.COLORS, StorageModel.DOUBLE_ARRAY_ARRAY, colors);
                }
                if (!this.currentLabels.isEmpty()) {
                    String[] labels = this.currentLabels.toArray(new String[0]);
                    boolean empty = true;
                    for (String l : labels) {
                        if (l == null || "".equals(l.trim())) continue;
                        empty = false;
                    }
                    if (!empty) {
                        this.vertexAttributes.addReadOnly(Attribute.LABELS, StorageModel.STRING_ARRAY, labels);
                    }
                }
                this.currentNormals = null;
                this.currentColors = null;
                this.currentPoints = null;
                this.currentLabels = null;
                return;
            }
            if (qName.equals("points")) {
                return;
            }
            if (qName.equals("p")) {
                return;
            }
            if (qName.equals("lineSet")) {
                if (this.currentEdges == null || this.currentEdges.size() == 0) {
                    return;
                }
                int[][] edges = (int[][])this.currentEdges.toArray((T[])new int[0][]);
                this.edgeAttributes = new DataListSet(edges.length);
                this.edgeAttributes.addReadOnly(Attribute.INDICES, StorageModel.INT_ARRAY_ARRAY, edges);
                if (this.currentColors != null && !this.currentColors.isEmpty()) {
                    double[][] colors = (double[][])this.currentColors.toArray((T[])new double[0][]);
                    this.edgeAttributes.addReadOnly(Attribute.COLORS, StorageModel.DOUBLE_ARRAY_ARRAY, colors);
                }
                if (!this.currentLabels.isEmpty()) {
                    String[] labels = this.currentLabels.toArray(new String[0]);
                    boolean empty = true;
                    for (String l : labels) {
                        if (l == null || "".equals(l.trim())) continue;
                        empty = false;
                    }
                    if (!empty) {
                        this.edgeAttributes.addReadOnly(Attribute.LABELS, StorageModel.STRING_ARRAY, labels);
                    }
                }
                this.currentEdges = null;
                this.currentNormals = null;
                this.currentColors = null;
                this.currentLabels = null;
                return;
            }
            if (qName.equals("lines")) {
                return;
            }
            if (qName.equals("l")) {
                return;
            }
            if (qName.equals("faceSet")) {
                if (this.currentFaces.size() == 0) {
                    return;
                }
                int[][] faces = (int[][])this.currentFaces.toArray((T[])new int[0][]);
                this.faceAttributes = new DataListSet(faces.length);
                this.faceAttributes.addReadOnly(Attribute.INDICES, StorageModel.INT_ARRAY_ARRAY, faces);
                if (this.currentNormals != null && !this.currentNormals.isEmpty()) {
                    double[][] normals = (double[][])this.currentNormals.toArray((T[])new double[0][]);
                    this.faceAttributes.addReadOnly(Attribute.NORMALS, StorageModel.DOUBLE_ARRAY_ARRAY, normals);
                }
                if (this.currentColors != null && !this.currentColors.isEmpty()) {
                    double[][] colors = (double[][])this.currentColors.toArray((T[])new double[0][]);
                    this.faceAttributes.addReadOnly(Attribute.COLORS, StorageModel.DOUBLE_ARRAY_ARRAY, colors);
                }
                if (!this.currentLabels.isEmpty()) {
                    String[] labels = this.currentLabels.toArray(new String[0]);
                    boolean empty = true;
                    for (String l : labels) {
                        if (l == null || "".equals(l.trim())) continue;
                        empty = false;
                    }
                    if (!empty) {
                        this.faceAttributes.addReadOnly(Attribute.LABELS, StorageModel.STRING_ARRAY, labels);
                    }
                }
                this.currentFaces = null;
                this.currentNormals = null;
                this.currentColors = null;
                this.currentLabels = null;
                return;
            }
            if (qName.equals("faces")) {
                return;
            }
            if (qName.equals("f")) {
                return;
            }
            if (qName.equals("colors")) {
                return;
            }
            if (qName.equals("c")) {
                return;
            }
            if (qName.equals("normals")) {
                return;
            }
            if (qName.equals("n")) {
                return;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.currentCharData == CharData.NONE) {
                return;
            }
            char[] read = new char[length];
            System.arraycopy(ch, start, read, 0, length);
            this.chars.add(read);
        }

        public void charactersImpl() {
            char[] ch;
            if (this.chars.isEmpty()) {
                return;
            }
            if (this.chars.size() > 1) {
                int i;
                int len = 0;
                for (i = 0; i < this.chars.size(); ++i) {
                    len += this.chars.get(i).length;
                }
                ch = new char[len];
                int s = 0;
                for (i = 0; i < this.chars.size(); ++i) {
                    char[] cs = this.chars.get(i);
                    System.arraycopy(cs, 0, ch, s, cs.length);
                    s += cs.length;
                }
            } else {
                ch = this.chars.get(0);
            }
            this.chars.clear();
            String s = new String(ch);
            s = s.trim();
            switch (this.currentCharData) {
                case NONE: {
                    return;
                }
                case FACE: 
                case LINE: {
                    String[] nums = s.split("\\s+");
                    int[] data = new int[nums.length];
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = Integer.parseInt(nums[i]);
                    }
                    if (this.currentCharData == CharData.FACE) {
                        this.currentFaces.add(data);
                    } else {
                        this.currentEdges.add(data);
                    }
                    return;
                }
                case COLOR: {
                    int i;
                    String[] nums = s.split("\\s+");
                    double[] doubles = new double[nums.length];
                    for (i = 0; i < doubles.length; ++i) {
                        doubles[i] = Double.parseDouble(nums[i]);
                    }
                    i = 0;
                    while (i < doubles.length) {
                        int n = i++;
                        doubles[n] = doubles[n] / 255.0;
                    }
                    this.currentColors.add(doubles);
                    return;
                }
                case NORMAL: {
                    String[] nums = s.split("\\s+");
                    double[] doubles = new double[nums.length];
                    for (int i = 0; i < doubles.length; ++i) {
                        doubles[i] = Double.parseDouble(nums[i]);
                    }
                    this.currentNormals.add(doubles);
                    return;
                }
                case POINT: {
                    if (this.currentPoints == null) {
                        return;
                    }
                    String[] nums = s.split("\\s+");
                    double[] doubles = new double[nums.length];
                    for (int i = 0; i < doubles.length; ++i) {
                        doubles[i] = Double.parseDouble(nums[i]);
                    }
                    this.currentPoints.add(doubles);
                    return;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum CharData {
            NONE,
            POINT,
            LINE,
            FACE,
            COLOR,
            NORMAL;

        }
    }

    static class Resolver
    implements EntityResolver {
        Resolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            Input dtd = null;
            try {
                dtd = Input.getInput("jvx.dtd");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (dtd == null) {
                try {
                    dtd = Input.getInput(new URL(systemId));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (dtd != null) {
                try {
                    return new InputSource(dtd.getInputStream());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            throw new RuntimeException("could not find jvx.dtd - download http://www.javaview.de/rsrc/jvx.dtd into the execution dir");
        }
    }
}

