/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader;

import com.thoughtworks.xstream.XStream;
import de.jreality.io.JrScene;
import de.jreality.io.jrs.XStreamFactory;
import de.jreality.reader.AbstractReader;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.util.Input;
import de.jreality.util.SceneGraphUtility;
import java.io.IOException;

public class ReaderJRS
extends AbstractReader {
    JrScene read;

    public void setInput(Input input) throws IOException {
        Object stuff;
        super.setInput(input);
        XStream xstr = XStreamFactory.forVersion(0.2);
        try {
            stuff = xstr.fromXML(input.getReader());
        }
        catch (Exception e) {
            xstr = XStreamFactory.forVersion(0.1);
            try {
                System.out.println("trying to read JRS v0.1");
                stuff = xstr.fromXML(input.copy().getReader());
                System.out.println("JRS v0.1 success.");
            }
            catch (Exception e2) {
                throw new IOException("illegal JRS file");
            }
        }
        if (stuff instanceof JrScene) {
            this.read = (JrScene)stuff;
            this.root = this.read.getSceneRoot();
        } else if (stuff instanceof SceneGraphComponent) {
            this.root = (SceneGraphComponent)stuff;
        } else {
            this.root = new SceneGraphComponent();
            this.root.setName("jrs");
            SceneGraphUtility.addChildNode(this.root, (SceneGraphNode)stuff);
        }
    }

    public JrScene getScene() {
        return this.read;
    }
}

