/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader;

import de.jreality.geometry.IndexedFaceSetFactory;
import de.jreality.reader.AbstractReader;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.util.Input;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class ReaderFE
extends AbstractReader {
    private List<double[]> v = new ArrayList<double[]>(1000);
    private HashMap<Integer, Integer> vertexIndices = new HashMap();
    private List<int[]> edges = new ArrayList<int[]>(1000);
    private HashMap<Integer, Integer> edgeIndices = new HashMap();
    private List<int[]> faces = new ArrayList<int[]>(1000);
    IndexedFaceSetFactory ifsf = new IndexedFaceSetFactory();

    public ReaderFE() {
        this.root = new SceneGraphComponent();
        this.root.setGeometry(this.ifsf.getGeometry());
        this.ifsf.setGenerateFaceNormals(true);
        this.ifsf.setGenerateVertexNormals(true);
    }

    public void setInput(Input input) throws IOException {
        super.setInput(input);
        this.load();
    }

    private void load() throws IOException {
        int index;
        StringTokenizer tok;
        LineNumberReader lnr = new LineNumberReader(this.input.getReader());
        String line = null;
        while ((line = lnr.readLine()) != null && !line.startsWith("vertices")) {
        }
        while ((line = lnr.readLine()) != null && !line.trim().equals("")) {
            tok = new StringTokenizer(line);
            index = Integer.parseInt(tok.nextToken());
            double x = Double.parseDouble(tok.nextToken());
            double y = Double.parseDouble(tok.nextToken());
            double z = Double.parseDouble(tok.nextToken());
            this.vertexIndices.put(index, this.v.size());
            double[] vertex = new double[]{x, y, z};
            this.v.add(vertex);
        }
        while ((line = lnr.readLine()) != null && !line.startsWith("edges")) {
        }
        while ((line = lnr.readLine()) != null && !line.trim().equals("")) {
            tok = new StringTokenizer(line);
            index = Integer.parseInt(tok.nextToken());
            int sv = Integer.parseInt(tok.nextToken());
            int ev = Integer.parseInt(tok.nextToken());
            this.edgeIndices.put(index, this.edges.size());
            this.edges.add(new int[]{this.vertexIndices.get(sv), this.vertexIndices.get(ev)});
        }
        while ((line = lnr.readLine()) != null && !line.startsWith("faces") && !line.startsWith("facets")) {
        }
        while ((line = lnr.readLine()) != null && !line.trim().equals("")) {
            tok = new StringTokenizer(line);
            index = Integer.parseInt(tok.nextToken());
            ArrayList<Integer> edgs = new ArrayList<Integer>();
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                try {
                    int ei = Integer.parseInt(token);
                    edgs.add(ei);
                }
                catch (NumberFormatException nfe) {
                    break;
                }
            }
            int[] face = new int[edgs.size()];
            int cnt = 0;
            Iterator i$ = edgs.iterator();
            while (i$.hasNext()) {
                int ei = (Integer)i$.next();
                boolean orientation = ei > 0;
                int evolverEdgeIndex = orientation ? ei : -ei;
                int edgeIndex = this.edgeIndices.get(evolverEdgeIndex);
                int[] edge = this.edges.get(edgeIndex);
                face[cnt++] = edge[orientation ? 1 : 0];
            }
            this.faces.add(face);
        }
        this.ifsf.setVertexCount(this.v.size());
        this.ifsf.setEdgeCount(this.edges.size());
        this.ifsf.setFaceCount(this.faces.size());
        this.ifsf.setVertexCoordinates((double[][])this.v.toArray((T[])new double[0][]));
        this.ifsf.setEdgeIndices((int[][])this.edges.toArray((T[])new int[0][]));
        this.ifsf.setFaceIndices((int[][])this.faces.toArray((T[])new int[0][]));
        this.ifsf.update();
    }
}

