/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.math;

import de.jreality.math.Pn;
import de.jreality.util.LoggingSystem;
import java.util.Arrays;
import java.util.logging.Level;

public final class Rn {
    static final double[][] identityMatrices = new double[5][];
    public static final double TOLERANCE = 1.0E-7;

    private Rn() {
    }

    public static double[] abs(double[] dst, double[] src) {
        int n = src.length;
        if (dst == null) {
            dst = new double[n];
        }
        for (int i = 0; i < n; ++i) {
            dst[i] = Math.abs(src[i]);
        }
        return dst;
    }

    public static double[] add(double[] dst, double[] src1, double[] src2) {
        if (dst == null) {
            dst = new double[src1.length];
        }
        int n = src1.length;
        if (src1.length != src2.length) {
            n = Math.min(Math.min(dst.length, src1.length), src2.length);
        }
        for (int i = 0; i < n; ++i) {
            dst[i] = src1[i] + src2[i];
        }
        return dst;
    }

    public static double[] adjoint(double[] dst, double[] src) {
        double[] out;
        int n = Rn.mysqrt(src.length);
        int sgn = 1;
        if (dst == null) {
            dst = (double[])src.clone();
        }
        boolean rewrite = false;
        if (dst == src) {
            out = new double[dst.length];
            rewrite = true;
        } else {
            out = dst;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                out[i * n + j] = Rn.cofactor(src, i, j) * (double)((i + j) % 2 == 1 ? -1 : 1);
                sgn *= -1;
            }
        }
        if (rewrite) {
            System.arraycopy(out, 0, dst, 0, dst.length);
        }
        return dst;
    }

    public static double[] average(double[] dst, double[][] vlist) {
        if (dst == null) {
            dst = new double[vlist[0].length];
        }
        if (vlist.length == 0) {
            return null;
        }
        double[] tmp = new double[dst.length];
        for (int i = 0; i < vlist.length; ++i) {
            Rn.add(tmp, tmp, vlist[i]);
        }
        Rn.times(dst, 1.0 / (double)vlist.length, tmp);
        return dst;
    }

    public static double[] barycentricTriangleInterp(double[] dst, double[][] corners, double[] weights) {
        double[] ddst = dst == null ? new double[corners[0].length] : dst;
        int n = Math.min(corners[0].length, ddst.length);
        double[] tmp = new double[n];
        Arrays.fill(dst, 0.0);
        for (int i = 0; i < 3; ++i) {
            Rn.add(ddst, ddst, Rn.times(tmp, weights[i], corners[i]));
        }
        return ddst;
    }

    public static double[][] calculateBounds(double[][] bounds, double[][] vlist) {
        int i;
        int vl = vlist[0].length;
        int bl = bounds[0].length;
        if (vl > bl) {
            throw new IllegalArgumentException("invalid dimension");
        }
        for (i = 0; i < vl; ++i) {
            bounds[0][i] = Double.MAX_VALUE;
            bounds[1][i] = -1.7976931348623157E308;
        }
        for (i = vl; i < bl; ++i) {
            bounds[1][i] = 0.0;
            bounds[0][i] = 0.0;
        }
        for (i = 0; i < vlist.length; ++i) {
            Rn.max(bounds[1], bounds[1], vlist[i]);
            Rn.min(bounds[0], bounds[0], vlist[i]);
        }
        return bounds;
    }

    public static double cofactor(double[] m, int row, int column) {
        int n = Rn.mysqrt(m.length);
        return Rn.determinant(Rn.submatrix(null, m, row, column));
    }

    public static double[] conjugateByMatrix(double[] dst, double[] m, double[] c) {
        int n = Rn.mysqrt(c.length);
        if (dst == null) {
            dst = new double[c.length];
        }
        Rn.times(dst, c, Rn.times(null, m, Rn.inverse(null, c)));
        return dst;
    }

    public static double[] convertArray2DToArray1D(double[] target, double[][] src) {
        int slotLength = src[0].length;
        if (target == null) {
            target = new double[src.length * slotLength];
        }
        for (int i = 0; i < src.length; ++i) {
            for (int j = 0; j < slotLength; ++j) {
                target[i * slotLength + j] = src[i][j];
            }
        }
        return target;
    }

    public static double[] convertArray3DToArray1D(double[][][] V) {
        return Rn.convertArray3DToArray1D(V, 1, 1);
    }

    public static double[] convertArray3DToArray1D(double[][][] V, int usample, int vsample) {
        int n = V.length;
        int m = V[0].length;
        int p = V[0][0].length;
        double[] newV = new double[(n + vsample - 1) / vsample * ((m + usample - 1) / usample) * p];
        int ind = 0;
        for (int i = 0; i < n; i += vsample) {
            for (int j = 0; j < m; j += usample) {
                int k = 0;
                while (k < p) {
                    newV[ind] = V[i][j][k];
                    ++k;
                    ++ind;
                }
            }
        }
        return newV;
    }

    public static double[][] convertArray3DToArray2D(double[][][] V) {
        int n = V.length;
        int m = V[0].length;
        int p = V[0][0].length;
        double[][] newV = new double[n * m][p];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                System.arraycopy(V[i][j], 0, newV[i * m + j], 0, p);
            }
        }
        return newV;
    }

    public static float[] convertDoubleToFloatArray(double[] ds) {
        int n = ds.length;
        float[] fs = new float[n];
        for (int i = 0; i < n; ++i) {
            fs[i] = (float)ds[i];
        }
        return fs;
    }

    public static double[] copy(double[] dst, double[] src) {
        if (dst == null) {
            dst = new double[src.length];
        }
        System.arraycopy(src, 0, dst, 0, Math.min(dst.length, src.length));
        return dst;
    }

    public static double[] crossProduct(double[] dst, double[] u, double[] v) {
        if (u.length < 3 || v.length < 3) {
            throw new IllegalArgumentException("Vectors too short");
        }
        if (dst == null) {
            dst = new double[3];
        }
        double[] tmp = dst;
        if (dst == u || dst == v) {
            tmp = new double[]{u[1] * v[2] - u[2] * v[1], u[2] * v[0] - u[0] * v[2], u[0] * v[1] - u[1] * v[0]};
        }
        if (tmp != dst) {
            System.arraycopy(tmp, 0, dst, 0, 3);
        }
        return dst;
    }

    public static double determinant(double[] m) {
        double det = 0.0;
        int n = Rn.mysqrt(m.length);
        if (n > 4) {
            double[] subm = new double[(n - 1) * (n - 1)];
            for (int i = 0; i < n; ++i) {
                double tmp = m[i] * Rn.determinant(Rn.submatrix(subm, m, 0, i));
                det += i % 2 == 0 ? tmp : -tmp;
            }
        } else {
            return Rn.determinantOld(m);
        }
        return det;
    }

    public static double determinant(double[][] m) {
        int n = m.length;
        if (n != m[0].length) {
            throw new IllegalArgumentException("Must be square matrix");
        }
        double[] lm = new double[n * n];
        for (int i = 0; i < m.length; ++i) {
            System.arraycopy(m[i], 0, lm, n * i, n);
        }
        return Rn.determinant(lm);
    }

    private static double determinantOld(double[] m) {
        double det = 0.0;
        int n = Rn.mysqrt(m.length);
        switch (n) {
            case 4: {
                det = m[3] * m[6] * m[9] * m[12] - m[2] * m[7] * m[9] * m[12] - m[3] * m[5] * m[10] * m[12] + m[1] * m[7] * m[10] * m[12] + m[2] * m[5] * m[11] * m[12] - m[1] * m[6] * m[11] * m[12] - m[3] * m[6] * m[8] * m[13] + m[2] * m[7] * m[8] * m[13] + m[3] * m[4] * m[10] * m[13] - m[0] * m[7] * m[10] * m[13] - m[2] * m[4] * m[11] * m[13] + m[0] * m[6] * m[11] * m[13] + m[3] * m[5] * m[8] * m[14] - m[1] * m[7] * m[8] * m[14] - m[3] * m[4] * m[9] * m[14] + m[0] * m[7] * m[9] * m[14] + m[1] * m[4] * m[11] * m[14] - m[0] * m[5] * m[11] * m[14] - m[2] * m[5] * m[8] * m[15] + m[1] * m[6] * m[8] * m[15] + m[2] * m[4] * m[9] * m[15] - m[0] * m[6] * m[9] * m[15] - m[1] * m[4] * m[10] * m[15] + m[0] * m[5] * m[10] * m[15];
                break;
            }
            case 3: {
                det = -(m[2] * m[4] * m[6]) + m[1] * m[5] * m[6] + m[2] * m[3] * m[7] - m[0] * m[5] * m[7] - m[1] * m[3] * m[8] + m[0] * m[4] * m[8];
                break;
            }
            case 2: {
                det = m[0] * m[3] - m[2] * m[1];
                break;
            }
            case 1: {
                det = m[0];
                break;
            }
            default: {
                det = Rn.determinant(m);
            }
        }
        return det;
    }

    public static boolean equals(double[] u, double[] v) {
        return Rn.equals(u, v, 0.0);
    }

    public static boolean equals(double[] u, double[] v, double tol) {
        int n = u.length;
        if (v.length < u.length) {
            n = v.length;
        }
        for (int i = 0; i < n; ++i) {
            if (Double.isNaN(u[i]) && !Double.isNaN(v[i]) || Double.isNaN(v[i]) && !Double.isNaN(u[i])) {
                return false;
            }
            double d = u[i] - v[i];
            if (!(d > tol) && !(d < -tol)) continue;
            return false;
        }
        return true;
    }

    public static double euclideanAngle(double[] u, double[] v) {
        if (u.length != v.length) {
            throw new IllegalArgumentException("Vectors must have same length");
        }
        double uu = Rn.innerProduct(u, u);
        double vv = Rn.innerProduct(v, v);
        double uv = Rn.innerProduct(u, v);
        if (uu == 0.0 || vv == 0.0) {
            return Double.MAX_VALUE;
        }
        double f = uv / Math.sqrt(Math.abs(uu * vv));
        if (f > 1.0) {
            f = 1.0;
        }
        if (f < -1.0) {
            f = -1.0;
        }
        double d = Math.acos(f);
        return d;
    }

    public static double euclideanDistance(double[] u, double[] v) {
        return Math.sqrt(Rn.euclideanDistanceSquared(u, v));
    }

    public static double euclideanDistanceSquared(double[] u, double[] v) {
        double[] tmp = new double[u.length];
        Rn.subtract(tmp, u, v);
        return Rn.euclideanNormSquared(tmp);
    }

    public static double euclideanNorm(double[] vec) {
        return Math.sqrt(Rn.innerProduct(vec, vec));
    }

    public static double euclideanNormSquared(double[] vec) {
        return Rn.innerProduct(vec, vec);
    }

    public static double[] extractSubmatrix(double[] subm, double[] src, int l, int r, int t, int b) {
        if (r - l != b - t) {
            throw new IllegalArgumentException("(b-t) must equal (r-l)");
        }
        int n = Rn.mysqrt(src.length);
        int submsize = (b - t + 1) * (r - l + 1);
        int count = 0;
        if (subm.length != submsize) {
            subm = new double[submsize];
        }
        for (int i = t; i <= b; ++i) {
            for (int j = l; j <= r; ++j) {
                subm[count++] = src[i * n + j];
            }
        }
        return subm;
    }

    public static double[] identityMatrix(int dim) {
        double[] m = new double[dim * dim];
        int i = 0;
        int k = 0;
        int doffs = dim + 1;
        while (i < dim) {
            m[k] = 1.0;
            ++i;
            k += doffs;
        }
        return m;
    }

    public static double[] diagonalMatrix(double[] dst, double[] entries) {
        int n = entries.length;
        if (dst == null) {
            dst = Rn.identityMatrix(n);
        }
        for (int i = 0; i < n; ++i) {
            dst[n * i + i] = entries[i];
        }
        return dst;
    }

    public static double innerProduct(double[] u, double[] v) {
        if (u.length != v.length && Math.abs(u.length - v.length) != 1) {
            throw new IllegalArgumentException("Vectors must have same length");
        }
        double norm = 0.0;
        int n = u.length < v.length ? u.length : v.length;
        for (int i = 0; i < n; ++i) {
            norm += u[i] * v[i];
        }
        return norm;
    }

    public static double innerProduct(double[] u, double[] v, int n) {
        if (u.length < n || v.length < n) {
            throw new IllegalArgumentException("Vectors not long enough");
        }
        double norm = 0.0;
        int m = u.length < n ? u.length : n;
        for (int i = 0; i < m; ++i) {
            norm += u[i] * v[i];
        }
        return norm;
    }

    public static double[] inverse(double[] minvIn, double[] m) {
        double f;
        int k;
        int j;
        int i;
        int n = Rn.mysqrt(m.length);
        double[] t = new double[m.length];
        System.arraycopy(m, 0, t, 0, m.length);
        double[] minv = minvIn == null ? new double[m.length] : minvIn;
        Rn.setIdentityMatrix(minv);
        for (i = 0; i < n; ++i) {
            double x;
            int largest = i;
            double largesq = t[n * i + i] * t[n * i + i];
            for (j = i + 1; j < n; ++j) {
                double d;
                x = t[j * n + i] * t[j * n + i];
                if (!(d > largesq)) continue;
                largest = j;
                largesq = x;
            }
            for (k = 0; k < n; ++k) {
                x = t[i * n + k];
                t[i * n + k] = t[largest * n + k];
                t[largest * n + k] = x;
            }
            for (k = 0; k < n; ++k) {
                x = minv[i * n + k];
                minv[i * n + k] = minv[largest * n + k];
                minv[largest * n + k] = x;
            }
            for (j = i + 1; j < n; ++j) {
                f = t[j * n + i] / t[i * n + i];
                for (k = 0; k < n; ++k) {
                    int n2 = j * n + k;
                    t[n2] = t[n2] - f * t[i * n + k];
                }
                for (k = 0; k < n; ++k) {
                    int n3 = j * n + k;
                    minv[n3] = minv[n3] - f * minv[i * n + k];
                }
            }
        }
        for (i = 0; i < n; ++i) {
            f = t[i * n + i];
            if (f == 0.0) {
                f = 1.0E-15;
                LoggingSystem.getLogger(Rn.class).log(Level.WARNING, "Divide by zero, returning identity matrix");
                Rn.setIdentityMatrix(minv);
                return minv;
            }
            f = 1.0 / f;
            for (j = 0; j < n; ++j) {
                int n4 = i * n + j;
                t[n4] = t[n4] * f;
                int n5 = i * n + j;
                minv[n5] = minv[n5] * f;
            }
        }
        for (i = n - 1; i >= 0; --i) {
            for (j = i - 1; j >= 0; --j) {
                f = t[j * n + i];
                for (k = 0; k < n; ++k) {
                    int n6 = j * n + k;
                    t[n6] = t[n6] - f * t[i * n + k];
                }
                for (k = 0; k < n; ++k) {
                    int n7 = j * n + k;
                    minv[n7] = minv[n7] - f * minv[i * n + k];
                }
            }
        }
        return minv;
    }

    private static double[] inverseSlow(double[] dst, double[] src) {
        if (dst == null) {
            dst = new double[src.length];
        }
        double[] tmp = new double[dst.length];
        double det = Rn.determinant(src);
        if (det == 0.0) {
            throw new IllegalArgumentException("Input matrix has determinant zero");
        }
        Rn.times(dst, 1.0 / det, Rn.transpose(tmp, Rn.adjoint(dst, src)));
        return dst;
    }

    public static boolean isIdentityMatrix(double[] mat, double tol) {
        int n = Rn.mysqrt(mat.length);
        double[] tmp = new double[mat.length];
        double[] idd = identityMatrices[n];
        for (int i = 0; i < tmp.length; ++i) {
            if (!(Math.abs(mat[i] - idd[i]) > tol)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSpecialMatrix(double[] mat, double tol) {
        double d = Rn.determinant(mat);
        return Math.abs(Math.abs(d) - 1.0) < tol;
    }

    public static double[] linearCombination(double[] dst, double a, double[] aVec, double b, double[] bVec) {
        if (aVec.length != bVec.length) {
            throw new IllegalArgumentException("Vectors must be same length");
        }
        if (dst == null) {
            dst = new double[aVec.length];
        }
        double[] tmp = new double[dst.length];
        return Rn.add(dst, Rn.times(tmp, a, aVec), Rn.times(dst, b, bVec));
    }

    public static double manhattanNorm(double[] vec) {
        double sum = 0.0;
        for (int i = 0; i < vec.length; ++i) {
            sum += Math.abs(vec[i]);
        }
        return sum;
    }

    public static double manhattanNormDistance(double[] u, double[] v) {
        double[] tmp = new double[u.length];
        Rn.subtract(tmp, u, v);
        return Rn.manhattanNorm(tmp);
    }

    public static double[] matrixTimesVector(double[] dst, double[] m, double[] src) {
        double[] out;
        boolean rewrite = false;
        if (dst == m || dst == src) {
            out = new double[dst.length];
            rewrite = true;
        } else {
            out = dst == null ? new double[src.length] : dst;
        }
        Rn._matrixTimesVectorSafe(out, m, src);
        if (rewrite) {
            System.arraycopy(out, 0, dst, 0, dst.length);
            return dst;
        }
        return out;
    }

    private static void _matrixTimesVectorSafe(double[] dst, double[] m, double[] src) {
        int sl = src.length;
        int ml = Rn.mysqrt(m.length);
        boolean dehomog = false;
        if (ml == sl + 1) {
            dehomog = true;
        }
        if (sl + 1 < ml || sl > ml) {
            throw new IllegalArgumentException("Invalid dimension in _matrixTimesVectorSafe");
        }
        double[] out = dehomog ? new double[ml] : dst;
        for (int i = 0; i < ml; ++i) {
            out[i] = 0.0;
            for (int j = 0; j < ml; ++j) {
                if (dehomog && j == ml - 1) {
                    int n = i;
                    out[n] = out[n] + m[i * ml + j];
                    continue;
                }
                int n = i;
                out[n] = out[n] + m[i * ml + j] * src[j];
            }
        }
        if (dehomog) {
            Pn.dehomogenize(dst, out);
        }
    }

    public static double[][] matrixTimesVector(double[][] dst, double[] m, double[][] src) {
        double[][] out;
        int n = Rn.mysqrt(m.length);
        boolean rewrite = false;
        if (dst == null || dst == src) {
            out = new double[src.length][src[0].length];
            if (dst == src) {
                rewrite = true;
            }
        } else {
            out = dst;
        }
        int nv = src.length;
        for (int k = 0; k < nv; ++k) {
            Rn._matrixTimesVectorSafe(out[k], m, src[k]);
        }
        if (rewrite) {
            System.arraycopy(out, 0, dst, 0, dst.length);
            return dst;
        }
        return out;
    }

    public static String matrixToJavaString(double[] v) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                sb.append(String.format("%g", v[4 * i + j]));
                if (i != 3 || j != 3) {
                    sb.append(",");
                }
                sb.append(j == 3 ? "\n" : "\t");
            }
        }
        sb.append("};");
        return sb.toString();
    }

    public static String matrixToString(double[] m) {
        return Rn.matrixToString(m, "%g");
    }

    public static String matrixToString(double[] m, String formatString) {
        StringBuffer sb = new StringBuffer();
        int n = Rn.mysqrt(m.length);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                sb.append(String.format(formatString, m[n * i + j]));
                sb.append(j == n - 1 ? "\n" : "\t");
            }
        }
        return sb.toString();
    }

    public static double[] max(double[] dst, double[] src1, double[] src2) {
        int n = Math.min(src1.length, src2.length);
        if (dst == null) {
            dst = new double[n];
        }
        if (dst.length != n) {
            throw new IllegalArgumentException("Invalid target vector length");
        }
        int lim = Math.min(dst.length, n);
        for (int i = 0; i < lim; ++i) {
            dst[i] = Math.max(src1[i], src2[i]);
        }
        return dst;
    }

    public static double maxNorm(double[] vec) {
        double max = 0.0;
        for (int i = 0; i < vec.length; ++i) {
            max = Math.max(max, Math.abs(vec[i]));
        }
        return max;
    }

    public static double maxNormDistance(double[] u, double[] v) {
        double[] tmp = new double[u.length];
        Rn.subtract(tmp, u, v);
        return Rn.maxNorm(tmp);
    }

    public static double[] min(double[] dst, double[] src1, double[] src2) {
        int n = Math.min(src1.length, src2.length);
        if (dst == null) {
            dst = new double[n];
        }
        if (dst.length != n) {
            throw new IllegalArgumentException("Invalid target vector length");
        }
        for (int i = 0; i < n; ++i) {
            dst[i] = Math.min(src1[i], src2[i]);
        }
        return dst;
    }

    public static double[] negate(double[] dst, double[] src) {
        if (dst == null) {
            dst = new double[src.length];
        }
        if (dst.length != src.length) {
            throw new IllegalArgumentException("Vectors must have same length");
        }
        int n = Math.min(dst.length, src.length);
        for (int i = 0; i < n; ++i) {
            dst[i] = -src[i];
        }
        return dst;
    }

    public static double[] normalize(double[] dst, double[] src) {
        return Rn.setEuclideanNorm(dst, 1.0, src);
    }

    public static double[][] normalize(double[][] dst, double[][] src) {
        if (dst == null) {
            dst = new double[src.length][src[0].length];
        }
        if (dst.length != src.length || dst[0].length != src[0].length) {
            throw new IllegalArgumentException("Vectors must have same length");
        }
        int n = Math.min(dst.length, src.length);
        for (int i = 0; i < n; ++i) {
            Rn.normalize(dst[i], src[i]);
        }
        return dst;
    }

    public static double[] planeParallelToPassingThrough(double[] plane, double[] ds, double[] ds2) {
        if (plane == null) {
            plane = new double[4];
        }
        System.arraycopy(ds, 0, plane, 0, 3);
        plane[3] = -Rn.innerProduct(plane, ds2, 3);
        return plane;
    }

    public static double[] polarDecompose(double[] q, double[] s, double[] m) {
        int old = 0;
        int nw = 1;
        double[][] qq = new double[2][];
        double[] qit = (double[])m.clone();
        qq[old] = (double[])m.clone();
        qq[nw] = (double[])m.clone();
        double tol = 1.0E-11;
        int count = 0;
        do {
            Rn.transpose(qit, Rn.inverse(qit, qq[old]));
            Rn.add(qq[nw], qq[old], qit);
            Rn.times(qq[nw], 0.5, qq[nw]);
            nw = 1 - nw;
            old = 1 - old;
        } while (++count < 20 && !Rn.equals(qq[nw], qq[old], tol));
        System.arraycopy(qq[nw], 0, q, 0, m.length);
        Rn.transpose(qit, qq[nw]);
        Rn.times(s, qit, m);
        return m;
    }

    public static double[] projectOnto(double[] dst, double[] src, double[] fixed) {
        if (dst == null) {
            dst = new double[src.length];
        }
        double d = Rn.innerProduct(fixed, fixed);
        double f = Rn.innerProduct(fixed, src);
        Rn.times(dst, f / d, fixed);
        return dst;
    }

    public static double[] projectOntoComplement(double[] dst, double[] src, double[] fixed) {
        return Rn.subtract(dst, src, Rn.projectOnto(null, src, fixed));
    }

    public static double[] setDiagonalMatrix(double[] dst, double[] diag) {
        int n1;
        int n2 = diag.length;
        if (dst == null) {
            dst = new double[n2 * n2];
        }
        if ((n1 = Rn.mysqrt(dst.length)) < n2) {
            throw new IllegalArgumentException("Incompatible lengths");
        }
        Rn.setIdentityMatrix(dst);
        int n = Math.min(n1, n2);
        for (int i = 0; i < n; ++i) {
            dst[n1 * i + i] = diag[i];
        }
        return dst;
    }

    public static double[] setEuclideanNorm(double[] dst, double length, double[] src) {
        if (dst == null) {
            dst = new double[src.length];
        }
        if (dst.length != src.length) {
            throw new IllegalArgumentException("Incompatible lengths");
        }
        double norm = Rn.euclideanNorm(src);
        if (norm == 0.0) {
            System.arraycopy(src, 0, dst, 0, Math.min(src.length, dst.length));
            return dst;
        }
        return Rn.times(dst, length / norm, src);
    }

    public static double[] setIdentityMatrix(double[] mat) {
        int n = Rn.mysqrt(mat.length);
        int noffs = n + 1;
        Arrays.fill(mat, 0.0);
        int i = 0;
        int k = 0;
        while (i < n) {
            mat[k] = 1.0;
            ++i;
            k += noffs;
        }
        return mat;
    }

    public static double[] setToValue(double[] dst, double val) {
        Arrays.fill(dst, val);
        return dst;
    }

    public static double[] setToValue(double[] dst, double x, double y) {
        if (dst == null) {
            dst = new double[2];
        }
        if (dst.length != 2) {
            throw new IllegalArgumentException("Incompatible length");
        }
        dst[0] = x;
        dst[1] = y;
        return dst;
    }

    public static double[] setToValue(double[] dst, double x, double y, double z) {
        if (dst == null) {
            dst = new double[3];
        }
        if (dst.length != 3) {
            throw new IllegalArgumentException("Incompatible length");
        }
        dst[0] = x;
        dst[1] = y;
        dst[2] = z;
        return dst;
    }

    public static double[] setToValue(double[] dst, double x, double y, double z, double w) {
        if (dst == null) {
            dst = new double[4];
        }
        if (dst.length != 4) {
            throw new IllegalArgumentException("Incompatible length");
        }
        dst[0] = x;
        dst[1] = y;
        dst[2] = z;
        dst[3] = w;
        return dst;
    }

    public static int mysqrt(int sq) {
        switch (sq) {
            case 16: {
                return 4;
            }
            case 9: {
                return 3;
            }
            case 4: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 25: {
                return 5;
            }
            case 36: {
                return 6;
            }
            case 49: {
                return 7;
            }
            case 64: {
                return 8;
            }
            case 81: {
                return 9;
            }
            case 100: {
                return 10;
            }
            case 0: {
                return 0;
            }
        }
        if (sq < 0) {
            throw new IllegalArgumentException(String.valueOf(sq));
        }
        return (int)Math.sqrt(sq);
    }

    public static double[] submatrix(double[] subm, double[] m, int row, int column) {
        int n = Rn.mysqrt(m.length);
        if (subm == null) {
            subm = new double[(n - 1) * (n - 1)];
        }
        if (subm.length != (n - 1) * (n - 1)) {
            throw new IllegalArgumentException("Invalid dimension for submatrix");
        }
        int cnt = 0;
        for (int i = 0; i < n; ++i) {
            if (i == row) continue;
            for (int j = 0; j < n; ++j) {
                if (j == column) continue;
                subm[cnt++] = m[i * n + j];
            }
        }
        return subm;
    }

    public static double[] subtract(double[] dst, double[] src1, double[] src2) {
        int n = Math.min(src1.length, src2.length);
        if (dst == null) {
            dst = new double[n];
        }
        if (dst.length > n) {
            throw new IllegalArgumentException("Invalid dimension for target");
        }
        boolean x = false;
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = src1[i] - src2[i];
        }
        return dst;
    }

    public static void swap(double[] u, double[] v) {
        if (v.length != v.length) {
            throw new IllegalArgumentException("Inputs must be same length");
        }
        int n = u.length;
        for (int i = 0; i < n; ++i) {
            double tmp = u[i];
            u[i] = v[i];
            v[i] = tmp;
        }
    }

    public static double[] times(double[] dst, double factor, double[] src) {
        if (dst == null) {
            dst = new double[src.length];
        }
        if (dst.length != src.length) {
            throw new IllegalArgumentException("Vectors must be same length");
        }
        int n = dst.length;
        for (int i = 0; i < n; ++i) {
            dst[i] = factor * src[i];
        }
        return dst;
    }

    public static double[] times(double[] dst, double[] src1, double[] src2) {
        double[] out;
        if (src1.length != src2.length) {
            throw new IllegalArgumentException("Matrices must be same size");
        }
        int n = Rn.mysqrt(src1.length);
        boolean rewrite = false;
        if (dst == src1 || dst == src2 || dst == null) {
            out = new double[src1.length];
            if (dst != null) {
                rewrite = true;
            }
        } else {
            out = dst;
        }
        if (out.length != src1.length) {
            throw new IllegalArgumentException("Matrices must be same size");
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                out[i * n + j] = 0.0;
                for (int k = 0; k < n; ++k) {
                    int n2 = i * n + j;
                    out[n2] = out[n2] + src1[i * n + k] * src2[k * n + j];
                }
            }
        }
        if (dst == null) {
            return out;
        }
        if (rewrite) {
            System.arraycopy(out, 0, dst, 0, dst.length);
        }
        return out;
    }

    public static double[][] times(double[][] dst, double factor, double[][] src) {
        if (dst == null) {
            dst = new double[src.length][src[0].length];
        }
        if (dst.length != src.length) {
            throw new IllegalArgumentException("Vectors must be same length");
        }
        int n = src.length;
        for (int i = 0; i < n; ++i) {
            Rn.times(dst[i], factor, src[i]);
        }
        return dst;
    }

    public static String toString(double[] v) {
        return Rn.toString(v, "%g");
    }

    public static String toString(double[] v, String formatString) {
        int n = v.length;
        StringBuffer strb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            strb.append(String.format(formatString, v[i]));
            strb.append("\t");
        }
        return strb.toString();
    }

    public static String toString(double[][] v) {
        int n = v.length;
        StringBuffer strb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            strb.append(Rn.toString(v[i]) + "\t");
            strb.append("\n");
        }
        return new String(strb);
    }

    public static String toString(double[][][] v) {
        int n = v.length;
        int m = v[0].length;
        StringBuffer strb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                strb.append(Rn.toString(v[i][j]) + "\t");
                strb.append("\n");
            }
            strb.append("\n");
        }
        return new String(strb);
    }

    public static String toString(float[] v) {
        double[] cp = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            cp[i] = v[i];
        }
        return Rn.toString(cp);
    }

    public static double trace(double[] m) {
        int n = Rn.mysqrt(m.length);
        double t = 0.0;
        for (int i = 0; i < n; ++i) {
            t += m[i * n + i];
        }
        return t;
    }

    public static double[] transpose(double[] dst, double[] src) {
        double[] out;
        int n = Rn.mysqrt(src.length);
        boolean rewrite = false;
        if (dst == null) {
            dst = new double[src.length];
        }
        if (dst.length != src.length) {
            throw new IllegalArgumentException("Matrices must be same size");
        }
        if (dst == src) {
            out = new double[dst.length];
            rewrite = true;
        } else {
            out = dst;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                out[i * n + j] = src[j * n + i];
            }
        }
        if (rewrite) {
            System.arraycopy(out, 0, dst, 0, dst.length);
        }
        return dst;
    }

    public static float[] transposeD2F(float[] dst, double[] src) {
        if (dst == null) {
            dst = new float[16];
        }
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                dst[i * 4 + j] = (float)src[j * 4 + i];
            }
        }
        return dst;
    }

    public static double[] transposeF2D(double[] dst, float[] src) {
        if (dst == null) {
            dst = new double[16];
        }
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                dst[i * 4 + j] = src[j * 4 + i];
            }
        }
        return dst;
    }

    public static double[] bilinearInterpolation(double[] ds, double u, double v, double[] vb, double[] vt, double[] cb, double[] ct) {
        if (ds == null) {
            ds = new double[vb.length];
        }
        double[] vv = Rn.linearCombination(null, 1.0 - u, vb, u, vt);
        double[] cc = Rn.linearCombination(null, 1.0 - u, cb, u, ct);
        Rn.linearCombination(ds, 1.0 - v, vv, v, cc);
        return ds;
    }

    public static double[] bezierCombination(double[] dst, double t, double[] v0, double[] t0, double[] t1, double[] v1) {
        double tmp1 = 1.0 - t;
        double tmp2 = tmp1 * tmp1;
        double c0 = tmp2 * tmp1;
        double c1 = 3.0 * tmp2 * t;
        double c2 = 3.0 * tmp1 * t * t;
        double c3 = t * t * t;
        dst = Rn.add(dst, Rn.add(null, Rn.times(null, c0, v0), Rn.times(null, c1, t0)), Rn.add(null, Rn.times(null, c2, t1), Rn.times(null, c3, v1)));
        return dst;
    }

    public static boolean isNan(double[] ds) {
        int n = ds.length;
        for (int i = 0; i < n; ++i) {
            if (!Double.isNaN(ds[i])) continue;
            return true;
        }
        return false;
    }

    public static double[] setToLength(double[] p1, double[] p12, double rad) {
        return Rn.times(p1, rad / Rn.euclideanNorm(p12), p12);
    }

    public static double[][] completeBasis(double[][] dst, double[][] partial) {
        int i;
        int dim = partial[0].length;
        int size = partial.length;
        if (dst == null || dst.length != dim) {
            dst = new double[dim][dim];
        }
        double[] inline = new double[dim * dim];
        for (i = 0; i < size; ++i) {
            System.arraycopy(partial[i], 0, inline, i * dim, dim);
        }
        for (i = size; i < dim; ++i) {
            for (int j = 0; j < dim; ++j) {
                inline[i * dim + j] = Math.random();
            }
        }
        for (i = size; i < dim; ++i) {
            double[] newrow = dst[i];
            for (int j = 0; j < dim; ++j) {
                newrow[j] = (double)((i + j) % 2 == 0 ? 1 : -1) * Rn.determinant(Rn.submatrix(null, inline, i, j));
            }
            System.arraycopy(newrow, 0, inline, i * dim, dim);
        }
        for (i = 0; i < dim; ++i) {
            System.arraycopy(inline, i * dim, dst[i], 0, dim);
        }
        return dst;
    }

    public static double[] permutationMatrix(double[] dst, int[] perm) {
        int n = perm.length;
        if (dst == null) {
            dst = new double[n * n];
        }
        for (int i = 0; i < n; ++i) {
            dst[i * n + perm[i]] = 1.0;
        }
        Rn.transpose(dst, dst);
        return dst;
    }

    public static boolean isZero(double[] iline) {
        return Rn.isZero(iline, 1.0E-7);
    }

    public static boolean isZero(double[] iline, double tol) {
        for (double d : iline) {
            if (!(Math.abs(d) > tol)) continue;
            return false;
        }
        return true;
    }

    static {
        for (int i = 1; i < 5; ++i) {
            Rn.identityMatrices[i] = Rn.identityMatrix(i);
        }
    }
}

