/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.math;

import de.jreality.math.P3;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import java.io.Serializable;

public final class Quaternion
implements Cloneable,
Serializable {
    static Quaternion INFINITE_QUATERNION = new Quaternion(Double.POSITIVE_INFINITY, 0.0, 0.0, 0.0);
    public double re;
    public double x;
    public double y;
    public double z;
    static Quaternion[] eq = new Quaternion[]{new Quaternion(0.0, 1.0, 0.0, 0.0), new Quaternion(0.0, 0.0, 1.0, 0.0), new Quaternion(0.0, 0.0, 0.0, 1.0)};
    static int[] chan = new int[]{0, 1, 2, 3};

    public Quaternion() {
        this(1.0, 0.0, 0.0, 0.0);
    }

    public Quaternion(Quaternion nq) {
        this(nq.re, nq.x, nq.y, nq.z);
    }

    public Quaternion(double r, double dx, double dy, double dz) {
        this.re = r;
        this.x = dx;
        this.y = dy;
        this.z = dz;
    }

    public String toString() {
        return "re: " + String.format("%8.6f\t", this.re) + "i: " + String.format("%8.6f\t", this.x) + "j: " + String.format("%8.6f\t", this.y) + "k: " + String.format("%8.6f", this.z);
    }

    public static double[] asDouble(double[] dst, Quaternion q) {
        if (dst == null) {
            dst = new double[]{q.re, q.x, q.y, q.z};
        }
        return dst;
    }

    public void setValue(double r, double dx, double dy, double dz) {
        this.re = r;
        this.x = dx;
        this.y = dy;
        this.z = dz;
    }

    public static Quaternion copy(Quaternion dst, Quaternion src) {
        if (dst == null) {
            return new Quaternion(src);
        }
        dst.re = src.re;
        dst.x = src.x;
        dst.y = src.y;
        dst.z = src.z;
        return dst;
    }

    public static double[] IJK(double[] dst, Quaternion q) {
        if (dst == null) {
            dst = new double[]{q.x, q.y, q.z};
        }
        return dst;
    }

    public static boolean equals(Quaternion a, Quaternion b, double tol) {
        Quaternion tmp = new Quaternion();
        Quaternion.subtract(tmp, a, b);
        double ll = Quaternion.length(tmp);
        return ll < tol;
    }

    public static boolean equalsRotation(Quaternion a, Quaternion b, double tol) {
        Quaternion tmp = new Quaternion();
        return Quaternion.equals(a, b, tol) || Quaternion.equals(Quaternion.times(tmp, -1.0, a), b, tol);
    }

    public static Quaternion exp(Quaternion dst, double t, Quaternion src) {
        if (dst == null) {
            dst = new Quaternion();
        }
        dst.re = Math.cos(t);
        double s = Math.sin(t);
        dst.x = s * src.x;
        dst.y = s * src.y;
        dst.z = s * src.z;
        return dst;
    }

    public static Quaternion add(Quaternion dst, Quaternion a, Quaternion b) {
        if (dst == null) {
            dst = new Quaternion();
        }
        if (a == null || b == null) {
            return dst;
        }
        dst.re = a.re + b.re;
        dst.x = a.x + b.x;
        dst.y = a.y + b.y;
        dst.z = a.z + b.z;
        return dst;
    }

    public static Quaternion negate(Quaternion dst, Quaternion src) {
        if (dst == null) {
            dst = new Quaternion();
        }
        if (src == null) {
            return dst;
        }
        dst.re = -src.re;
        dst.x = -src.x;
        dst.y = -src.y;
        dst.z = -src.z;
        return dst;
    }

    public static Quaternion conjugate(Quaternion dst, Quaternion src) {
        if (dst == null) {
            dst = new Quaternion();
        }
        if (src == null) {
            return dst;
        }
        dst.re = src.re;
        dst.x = -src.x;
        dst.y = -src.y;
        dst.z = -src.z;
        return dst;
    }

    public static Quaternion subtract(Quaternion dst, Quaternion a, Quaternion b) {
        if (dst == null) {
            dst = new Quaternion();
        }
        if (a == null || b == null) {
            return dst;
        }
        dst.re = a.re - b.re;
        dst.x = a.x - b.x;
        dst.y = a.y - b.y;
        dst.z = a.z - b.z;
        return dst;
    }

    public static Quaternion times(Quaternion dst, double s, Quaternion src) {
        if (dst == null) {
            dst = new Quaternion();
        }
        dst.re = s * src.re;
        dst.x = s * src.x;
        dst.y = s * src.y;
        dst.z = s * src.z;
        return dst;
    }

    public static Quaternion times(Quaternion dst, Quaternion a, Quaternion b) {
        if (dst == null) {
            dst = new Quaternion();
        }
        if (a == null || b == null) {
            return dst;
        }
        dst.re = a.re * b.re - a.x * b.x - a.y * b.y - a.z * b.z;
        dst.x = a.re * b.x + b.re * a.x + a.y * b.z - a.z * b.y;
        dst.y = a.re * b.y - a.x * b.z + b.re * a.y + a.z * b.x;
        dst.z = a.re * b.z + a.x * b.y - a.y * b.x + b.re * a.z;
        return dst;
    }

    public static double innerProduct(Quaternion a, Quaternion b) {
        return a.re * b.re + a.x * b.x + a.y * b.y + a.z * b.z;
    }

    public static double lengthSquared(Quaternion q) {
        return Quaternion.innerProduct(q, q);
    }

    public static double length(Quaternion q) {
        return Math.sqrt(Quaternion.lengthSquared(q));
    }

    public static Quaternion invert(Quaternion dst, Quaternion src) {
        Quaternion tmp = new Quaternion();
        double ll = Quaternion.lengthSquared(src);
        if (ll == 0.0) {
            dst = new Quaternion(INFINITE_QUATERNION);
        } else {
            ll = 1.0 / ll;
            Quaternion.conjugate(tmp, src);
            Quaternion.times(dst, ll, tmp);
        }
        return dst;
    }

    public static Quaternion divide(Quaternion dst, Quaternion a, Quaternion b) {
        Quaternion tmp = new Quaternion();
        Quaternion.invert(tmp, b);
        return Quaternion.times(dst, a, tmp);
    }

    public static Quaternion star(Quaternion dst, Quaternion src) {
        Quaternion tmp = new Quaternion();
        return Quaternion.conjugate(dst, Quaternion.invert(tmp, src));
    }

    public static Quaternion normalize(Quaternion dst, Quaternion src) {
        double ll = Quaternion.length(src);
        if (ll == 0.0) {
            dst = new Quaternion(src);
        } else {
            ll = 1.0 / ll;
            Quaternion.times(dst, ll, src);
        }
        return dst;
    }

    public static Quaternion makeRotationQuaternionAngle(Quaternion q, double angle, double[] axis) {
        double[] tmp = (double[])axis.clone();
        double cos = Math.cos(angle / 2.0);
        double sin = Math.sin(angle / 2.0);
        Rn.normalize(tmp, axis);
        Rn.times(tmp, sin, tmp);
        q.setValue(cos, tmp[0], tmp[1], tmp[2]);
        Quaternion.normalize(q, q);
        return q;
    }

    public static Quaternion makeRotationQuaternionCos(Quaternion q, double cos, double[] axis) {
        return Quaternion.makeRotationQuaternionAngle(q, 2.0 * Math.acos(cos), axis);
    }

    private static double[] convert44To33(double[] d) {
        double[] d33 = new double[]{d[0], d[1], d[2], d[4], d[5], d[6], d[8], d[9], d[10]};
        return d33;
    }

    public static Quaternion rotationMatrixToQuaternion(Quaternion q, double[] mat) {
        int n = Rn.mysqrt(mat.length);
        double d = Rn.determinant(mat);
        double[] m = null;
        if (d < 0.0) {
            double[] mtmp = new double[9];
            Rn.times(mtmp, -1.0, mat);
            m = mtmp;
        } else {
            m = mat;
        }
        if (q == null) {
            q = new Quaternion();
        }
        q.x = Math.sqrt(1.0 - m[2 * n + 2] - m[n + 1] + m[0]) / 2.0;
        if (q.x > 0.001) {
            q.y = (m[1] + m[n]) / (4.0 * q.x);
            q.z = (m[2] + m[2 * n]) / (4.0 * q.x);
            q.re = (m[2 * n + 1] - m[n + 2]) / (4.0 * q.x);
        } else {
            q.y = Math.sqrt(1.0 - m[2 * n + 2] + m[n + 1] - m[0]) / 2.0;
            if (q.y > 0.001) {
                q.x = (m[1] + m[n]) / (4.0 * q.y);
                q.z = (m[n + 2] + m[2 * n + 1]) / (4.0 * q.y);
                q.re = (m[2] - m[2 * n]) / (4.0 * q.y);
            } else {
                q.z = Math.sqrt(1.0 + m[2 * n + 2] - m[n + 1] - m[0]) / 2.0;
                if (q.z > 0.001) {
                    q.x = (m[2] + m[2 * n]) / (4.0 * q.z);
                    q.y = (m[n + 2] + m[2 * n + 1]) / (4.0 * q.z);
                    q.re = (m[n] - m[1]) / (4.0 * q.z);
                } else {
                    q.setValue(1.0, 0.0, 0.0, 0.0);
                }
            }
        }
        Quaternion.normalize(q, q);
        return q;
    }

    public static double[] quaternionToRotationMatrixOld(double[] rot, Quaternion qt) {
        if (rot == null) {
            rot = new double[16];
        }
        double[] axis = new double[3];
        Quaternion q = new Quaternion();
        Quaternion.normalize(q, qt);
        if (1.0 - Math.abs(q.re) < 1.0E-15) {
            Rn.setIdentityMatrix(rot);
            return rot;
        }
        Quaternion.IJK(axis, q);
        Rn.normalize(axis, axis);
        double angle = 2.0 * Math.acos(q.re);
        return P3.makeRotationMatrix(rot, axis, angle);
    }

    public static double[] quaternionToRotationMatrix(double[] rot, Quaternion qt) {
        if (rot == null) {
            rot = new double[16];
        }
        Rn.setToValue(rot, 0.0);
        Quaternion.normalize(qt, qt);
        rot[4] = 2.0 * (qt.re * qt.z + qt.y * qt.x);
        rot[1] = 2.0 * (-qt.re * qt.z + qt.x * qt.y);
        rot[8] = 2.0 * (-qt.re * qt.y + qt.x * qt.z);
        rot[2] = 2.0 * (qt.re * qt.y + qt.x * qt.z);
        rot[9] = 2.0 * (qt.re * qt.x + qt.y * qt.z);
        rot[6] = 2.0 * (-qt.re * qt.x + qt.y * qt.z);
        rot[0] = qt.re * qt.re + qt.x * qt.x - qt.y * qt.y - qt.z * qt.z;
        rot[5] = qt.re * qt.re - qt.x * qt.x + qt.y * qt.y - qt.z * qt.z;
        rot[10] = qt.re * qt.re - qt.x * qt.x - qt.y * qt.y + qt.z * qt.z;
        rot[15] = 1.0;
        return rot;
    }

    public static Quaternion linearInterpolation(Quaternion dst, Quaternion rot1, Quaternion rot2, double s) {
        double[] r2;
        double[] r1;
        if (dst == null) {
            dst = new Quaternion();
        }
        if (Rn.innerProduct(r1 = rot1.asDouble(), r2 = rot2.asDouble()) < 0.0) {
            Rn.times(r2, -1.0, r2);
        }
        double[] val = Pn.linearInterpolation(null, r1, r2, s, 1);
        dst.setValue(val[0], val[1], val[2], val[3]);
        return dst;
    }

    public double[] asDouble() {
        return this.asDouble(null);
    }

    public double[] asDouble(double[] val) {
        return this.asDouble(val, chan);
    }

    public double[] asDouble(double[] val, int[] channels) {
        if (val == null) {
            val = new double[4];
        }
        val[channels[0]] = this.re;
        val[channels[1]] = this.x;
        val[channels[2]] = this.y;
        val[channels[3]] = this.z;
        return val;
    }
}

