/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.math;

import de.jreality.math.Matrix;
import de.jreality.math.P3;
import de.jreality.math.Quaternion;
import de.jreality.math.Rn;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.DoubleArray;

public class FactoredMatrix
extends Matrix {
    protected double[] translationVector;
    protected double[] centerVector;
    protected double[] stretchVector;
    protected double[] rotationAxis;
    protected double[] centerMatrix;
    protected double[] invCenterMatrix;
    protected Quaternion rotationQ;
    protected Quaternion stretchRotationQ;
    protected boolean factorHasChanged;
    protected boolean matrixHasChanged;
    protected boolean isFactored;
    protected boolean isIdentity;
    protected boolean isSpecial;
    protected boolean isReflection;
    protected boolean useCenter;
    private int metric;

    public FactoredMatrix(int metric, double[] m) {
        super(m);
        this.metric = metric;
        this.translationVector = new double[4];
        this.stretchVector = new double[4];
        this.rotationAxis = new double[3];
        this.rotationQ = new Quaternion(1.0, 0.0, 0.0, 0.0);
        this.stretchRotationQ = new Quaternion(1.0, 0.0, 0.0, 0.0);
        this.matrixHasChanged = true;
        this.useCenter = false;
        this.update();
    }

    public FactoredMatrix(Matrix m, int metric) {
        this(metric, (double[])m.getArray().clone());
    }

    public FactoredMatrix(FactoredMatrix fm) {
        this(fm, fm.getMetric());
    }

    public FactoredMatrix(int metric) {
        this(metric, null);
    }

    public FactoredMatrix(double[] m) {
        this(0, m);
    }

    public FactoredMatrix() {
        this(0, null);
    }

    public FactoredMatrix(DoubleArray da) {
        this(0, da.toDoubleArray(null));
    }

    public FactoredMatrix(Transformation trafo) {
        this(0, trafo.getMatrix());
    }

    public double[] getArray() {
        if (this.factorHasChanged) {
            this.update();
        }
        return super.getArray();
    }

    public void assignFrom(FactoredMatrix fm) {
        super.assignFrom(fm);
        this.metric = fm.getMetric();
        this.matrixHasChanged = true;
        this.update();
    }

    public boolean getIsReflection() {
        return this.isReflection;
    }

    public void setIsReflection(boolean aVal) {
        if (aVal == this.isReflection) {
            return;
        }
        this.isReflection = aVal;
        this.factorHasChanged = true;
        this.update();
    }

    public boolean getUseCenter() {
        return this.useCenter;
    }

    public boolean getIsSpecial() {
        if (this.isMatrixHasChanged() || this.factorHasChanged) {
            this.update();
        }
        return this.isSpecial;
    }

    public void setCenter(double[] aVec) {
        this.setCenter(aVec, false);
    }

    public void setCenter(double[] aVec, boolean keepMatrix) {
        if (aVec == null) {
            this.useCenter = false;
            return;
        }
        this.useCenter = true;
        if (this.centerVector == null) {
            this.centerVector = new double[4];
        }
        if (this.centerMatrix == null) {
            this.centerMatrix = new double[16];
        }
        if (this.invCenterMatrix == null) {
            this.invCenterMatrix = new double[16];
        }
        this.centerVector[3] = 1.0;
        System.arraycopy(aVec, 0, this.centerVector, 0, aVec.length);
        P3.makeTranslationMatrix(this.centerMatrix, this.centerVector, this.metric);
        Rn.inverse(this.invCenterMatrix, this.centerMatrix);
        if (keepMatrix) {
            this.matrixHasChanged = true;
            this.factorHasChanged = false;
        } else {
            this.matrixHasChanged = false;
            this.factorHasChanged = true;
        }
        this.update();
    }

    public double[] getCenter() {
        return this.centerVector;
    }

    public void setTranslation(double tx, double ty, double tz) {
        this.translationVector[0] = tx;
        this.translationVector[1] = ty;
        this.translationVector[2] = tz;
        this.translationVector[3] = 1.0;
        this.factorHasChanged = true;
        this.update();
    }

    public void setTranslation(double[] aTransV) {
        if (aTransV.length == 4 && this.metric == 0 && aTransV[3] == 0.0) {
            throw new IllegalArgumentException("Invalid euclidean translation");
        }
        int n = Math.min(aTransV.length, 4);
        System.arraycopy(aTransV, 0, this.translationVector, 0, n);
        System.arraycopy(P3.originP3, n, this.translationVector, n, 4 - n);
        this.factorHasChanged = true;
        this.update();
    }

    public double[] getTranslation() {
        if (this.isMatrixHasChanged()) {
            this.update();
        }
        return this.translationVector;
    }

    public void setRotationAxis(double ax, double ay, double az) {
        double[] axis = new double[]{ax, ay, az};
        this.setRotation(this.getRotationAngle(), axis);
    }

    public void setRotationAxis(double[] axis) {
        this.setRotation(this.getRotationAngle(), axis);
    }

    public void setRotationAngle(double angle) {
        this.setRotation(angle, this.getRotationAxis());
    }

    public void setRotation(double angle, double[] axis) {
        Quaternion.makeRotationQuaternionAngle(this.rotationQ, angle, axis);
        this.factorHasChanged = true;
        this.update();
    }

    public void setRotation(double angle, double ax, double ay, double az) {
        double[] axis = new double[]{ax, ay, az};
        this.setRotation(angle, axis);
    }

    public void setRotation(Quaternion aQ) {
        Quaternion.copy(this.rotationQ, aQ);
        Quaternion.normalize(this.rotationQ, this.rotationQ);
        this.getRotationAxis();
        this.factorHasChanged = true;
        this.update();
    }

    public double[] getRotationAxis() {
        return Rn.normalize(this.rotationAxis, Quaternion.IJK(this.rotationAxis, this.rotationQ));
    }

    public double getRotationAngle() {
        double angle = 2.0 * Math.acos(this.rotationQ.re);
        return angle;
    }

    public Quaternion getRotationQuaternion() {
        if (this.isMatrixHasChanged()) {
            this.update();
        }
        return this.rotationQ;
    }

    public void setStretch(double stretch) {
        this.stretchVector[0] = stretch;
        this.stretchVector[1] = stretch;
        this.stretchVector[2] = stretch;
        this.stretchVector[3] = 1.0;
        this.factorHasChanged = true;
        this.update();
    }

    public void setStretch(double sx, double sy, double sz) {
        this.stretchVector[0] = sx;
        this.stretchVector[1] = sy;
        this.stretchVector[2] = sz;
        this.stretchVector[3] = 1.0;
        this.factorHasChanged = true;
        this.update();
    }

    public void setStretch(double[] stretchV) {
        System.arraycopy(stretchV, 0, this.stretchVector, 0, Math.min(stretchV.length, stretchV.length));
        if (stretchV.length == 3) {
            this.stretchVector[3] = 1.0;
        }
        this.factorHasChanged = true;
        this.update();
    }

    public double[] getStretch() {
        if (this.isMatrixHasChanged()) {
            this.update();
        }
        return this.stretchVector;
    }

    public void update() {
        boolean[] isFlipped = new boolean[1];
        double[] MC = new double[16];
        if (this.factorHasChanged) {
            isFlipped[0] = this.isReflection;
            P3.composeMatrixFromFactors(this.matrix, this.translationVector, this.rotationQ, this.stretchRotationQ, this.stretchVector, this.isReflection, this.metric);
            if (this.useCenter) {
                Rn.times(this.matrix, this.matrix, this.invCenterMatrix);
                Rn.times(this.matrix, this.centerMatrix, this.matrix);
            }
        } else if (this.isMatrixHasChanged()) {
            double[] TTmp;
            if (this.useCenter) {
                Rn.times(MC, this.matrix, this.centerMatrix);
                Rn.times(MC, this.invCenterMatrix, MC);
                TTmp = MC;
            } else {
                TTmp = this.matrix;
            }
            P3.factorMatrix(TTmp, this.translationVector, this.rotationQ, this.stretchRotationQ, this.stretchVector, isFlipped, this.metric);
            this.isReflection = isFlipped[0];
        }
        this.isSpecial = Rn.isSpecialMatrix(this.matrix, 1.0E-7);
        this.matrixChanged = false;
        this.factorHasChanged = false;
        this.matrixHasChanged = false;
    }

    public FactoredMatrix getInverseFactored() {
        return new FactoredMatrix(this.getMetric(), Rn.inverse(null, this.matrix));
    }

    public int getMetric() {
        return this.metric;
    }

    public boolean isMatrixHasChanged() {
        return this.matrixHasChanged || this.matrixChanged;
    }

    public Matrix getRotation() {
        Matrix m = new Matrix();
        Quaternion.quaternionToRotationMatrix(m.getArray(), this.getRotationQuaternion());
        return m;
    }

    public String toString() {
        String rot = "rotation + " + Rn.toString(this.getRotationAxis()) + " " + this.getRotationAngle() / Math.PI;
        String trans = "translation + " + Rn.toString(this.getTranslation());
        String stretch = "scale + " + Rn.toString(this.getStretch());
        return "metric=" + this.metric + "\n" + rot + "\n" + trans + "\n" + stretch + "\n";
    }
}

