/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl.shader;

import de.jreality.jogl.JOGLRenderer;
import de.jreality.jogl.JOGLRenderingState;
import de.jreality.jogl.shader.AbstractPrimitiveShader;
import de.jreality.jogl.shader.DefaultGeometryShader;
import de.jreality.jogl.shader.DefaultPolygonShader;
import de.jreality.jogl.shader.PolygonShader;
import de.jreality.scene.Geometry;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.util.LoggingSystem;
import java.util.logging.Level;

public class TwoSidePolygonShader
extends AbstractPrimitiveShader
implements PolygonShader {
    private PolygonShader front;
    private PolygonShader back;

    public TwoSidePolygonShader() {
        this.front = new DefaultPolygonShader();
        this.back = new DefaultPolygonShader();
    }

    public TwoSidePolygonShader(de.jreality.shader.TwoSidePolygonShader tsps) {
        this.front = DefaultGeometryShader.createFrom(tsps.getFront());
        this.back = DefaultGeometryShader.createFrom(tsps.getFront());
    }

    public void render(JOGLRenderingState jrs) {
        Geometry g = jrs.currentGeometry;
        jrs.currentGeometry = null;
        if (this.back != null) {
            jrs.frontBack = 1029;
            this.back.render(jrs);
        }
        jrs.currentGeometry = g;
        if (this.front != null) {
            jrs.frontBack = 1028;
            this.front.render(jrs);
        }
        jrs.frontBack = 1032;
    }

    public void postRender(JOGLRenderingState jrs) {
        if (this.front != null) {
            this.front.postRender(jrs);
        }
        if (this.back != null) {
            this.back.postRender(jrs);
        }
        this.displayListsDirty = this.front.displayListsDirty() || this.back.displayListsDirty();
    }

    public void setFromEffectiveAppearance(EffectiveAppearance eap, String shaderName) {
        this.front.setFromEffectiveAppearance(eap, shaderName + ".front");
        this.back.setFromEffectiveAppearance(eap, shaderName + ".back");
    }

    public boolean providesProxyGeometry() {
        LoggingSystem.getLogger(this).log(Level.FINER, "Front has proxy: " + this.front.providesProxyGeometry());
        if (this.front != null) {
            return this.front.providesProxyGeometry();
        }
        return false;
    }

    public int proxyGeometryFor(JOGLRenderingState jrs) {
        int dp = 0;
        if (this.front != null) {
            dp = this.front.proxyGeometryFor(jrs);
            LoggingSystem.getLogger(this).log(Level.FINER, "Providing dl " + dp);
            return dp;
        }
        return -1;
    }

    public void flushCachedState(JOGLRenderer jr) {
        if (this.front != null) {
            this.front.flushCachedState(jr);
        }
        if (this.back != null) {
            this.back.flushCachedState(jr);
        }
    }
}

