/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl.shader;

import de.jreality.jogl.JOGLRenderer;
import de.jreality.math.Rn;
import de.jreality.shader.CubeMap;
import de.jreality.shader.ImageData;
import de.jreality.shader.Texture2D;
import de.jreality.util.LoggingSystem;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Texture2DLoaderJOGL {
    private static HashMap<GL, WeakHashMap<ImageData, Integer>> lookupTextures = new HashMap();
    private static WeakHashMap<GL, WeakHashMap<ImageData, Integer>> lookupCubemaps = new WeakHashMap();
    private static WeakHashMap<GL, List<ImageData>> animatedTextures = new WeakHashMap();
    private static WeakHashMap<GL, ReferenceQueue<ImageData>> refQueues = new WeakHashMap();
    private static IdentityHashMap<WeakReference<ImageData>, Integer> refToID = new IdentityHashMap();
    private static IdentityHashMap<WeakReference<ImageData>, GL> refToGL = new IdentityHashMap();
    private static IdentityHashMap<WeakReference<ImageData>, Dimension> refToDim = new IdentityHashMap();
    private static final boolean REPLACE_TEXTURES = true;
    static Texture2D lastRendered = null;
    static boolean haveAutoMipmapGeneration;
    static boolean haveCheckedAutoMipmapGeneration;
    static GLU glu;
    private static FloatBuffer maxAnisotropy;
    private static boolean canFilterAnisotropic;
    private static boolean haveCheckedForAnisotropy;

    private Texture2DLoaderJOGL() {
    }

    private static int createTextureID(GL gl) {
        int[] tmp = new int[1];
        gl.glGenTextures(1, tmp, 0);
        return tmp[0];
    }

    private static WeakHashMap<ImageData, Integer> getTextureTableForGL(GL gl) {
        WeakHashMap<ImageData, Integer> ht = lookupTextures.get(gl);
        if (ht == null) {
            ht = new WeakHashMap();
            lookupTextures.put(gl, ht);
        }
        return ht;
    }

    private static WeakHashMap<ImageData, Integer> getCubeMapTableForGL(GL gl) {
        WeakHashMap<ImageData, Integer> ht = lookupCubemaps.get(gl);
        if (ht == null) {
            ht = new WeakHashMap();
            lookupCubemaps.put(gl, ht);
        }
        return ht;
    }

    public static void postRender(GL gl) {
        if (animatedTextures.get(gl) == null) {
            animatedTextures.put(gl, new Vector());
            return;
        }
        animatedTextures.get(gl).clear();
        lastRendered = null;
    }

    public static void render(GL gl, Texture2D tex) {
        Texture2DLoaderJOGL.render(gl, tex, true);
    }

    private static void generateTexture(GL gl, ImageData image) {
        switch (image.getImageType()) {
            case 0: {
                byte[] data = image.getByteArray();
                if (data != null) {
                    gl.glTexImage2D(3553, 0, 6408, image.getWidth(), image.getHeight(), 0, 6408, 5121, (Buffer)ByteBuffer.wrap(data));
                    break;
                }
                int[] dataInt = image.getIntArray();
                gl.glTexImage2D(3553, 0, 6408, image.getWidth(), image.getHeight(), 0, 6408, 32821, (Buffer)IntBuffer.wrap(dataInt));
                break;
            }
            case 1: {
                byte[] data = image.getByteArray();
                gl.glTexImage2D(3553, 0, 6409, image.getWidth(), image.getHeight(), 0, 6409, 5121, (Buffer)ByteBuffer.wrap(data));
                break;
            }
            case 2: {
                float[] data = image.getFloatArray();
                gl.glTexImage2D(3553, 0, 34840, image.getWidth(), image.getHeight(), 0, 6409, 5126, (Buffer)FloatBuffer.wrap(data));
            }
        }
    }

    public static synchronized void render(GL gl, Texture2D tex, boolean oneTexturePerImage) {
        WeakHashMap<ImageData, Integer> ht;
        Integer texid;
        ImageData image = tex.getImage();
        if (image == null) {
            return;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        Texture2DLoaderJOGL.checkForTextureExtensions(gl);
        boolean first = true;
        boolean replace = false;
        ReferenceQueue<ImageData> refQueue = refQueues.get(gl);
        if (refQueue == null) {
            refQueue = new ReferenceQueue();
            refQueues.put(gl, refQueue);
        }
        if ((texid = (ht = Texture2DLoaderJOGL.getTextureTableForGL(gl)).get(image)) != null && gl.glIsTexture(texid.intValue())) {
            first = false;
        } else {
            Reference<ImageData> ref;
            Dimension dim = new Dimension(width, height);
            if (texid == null) {
                ref = refQueue.poll();
                while (ref != null) {
                    Integer id = refToID.remove(ref);
                    if (id == null) {
                        throw new Error();
                    }
                    GL g = refToGL.remove(ref);
                    Dimension d = refToDim.remove(ref);
                    if (g == gl && dim.equals(d) && !replace) {
                        LoggingSystem.getLogger(Texture2DLoaderJOGL.class).fine("replacing texture...");
                        texid = id;
                        replace = true;
                        first = false;
                    } else if (g == gl) {
                        LoggingSystem.getLogger(Texture2DLoaderJOGL.class).fine("deleted texture...");
                        g.glDeleteTextures(1, new int[]{id}, 0);
                    } else {
                        System.err.println("Warning: tried to delete something which doesn't belong to this context");
                    }
                    ref = refQueue.poll();
                }
                LoggingSystem.getLogger(Texture2DLoaderJOGL.class).fine("creating texture... ");
            }
            if (texid == null || !gl.glIsTexture(texid.intValue())) {
                texid = Texture2DLoaderJOGL.createTextureID(gl);
                ht.put(image, texid);
            }
            ref = new WeakReference<ImageData>(image, refQueue);
            refToID.put((WeakReference<ImageData>)ref, texid);
            refToGL.put((WeakReference<ImageData>)ref, gl);
            refToDim.put((WeakReference<ImageData>)ref, new Dimension(image.getWidth(), image.getHeight()));
        }
        gl.glBindTexture(3553, texid.intValue());
        gl.glMatrixMode(5890);
        gl.glLoadTransposeMatrixd(tex.getTextureMatrix().getArray(), 0);
        gl.glMatrixMode(5888);
        int srcPixelFormat = tex.getPixelFormat();
        boolean animated = tex.getAnimated();
        if (animated) {
            boolean done;
            List<ImageData> list = animatedTextures.get(gl);
            if (list == null) {
                list = new Vector<ImageData>();
                animatedTextures.put(gl, list);
            }
            if (!(done = animatedTextures.get(gl).contains(image))) {
                Buffer buffer;
                Runnable r = tex.getRunnable();
                if (r != null) {
                    r.run();
                }
                gl.glPixelStorei(3314, image.getWidth());
                gl.glPixelStorei(3315, 0);
                gl.glPixelStorei(3316, 0);
                DataBuffer dataBuffer = ((BufferedImage)image.getImage()).getRaster().getDataBuffer();
                if (dataBuffer instanceof DataBufferByte) {
                    buffer = ByteBuffer.wrap(((DataBufferByte)dataBuffer).getData());
                } else {
                    if (dataBuffer instanceof DataBufferDouble) {
                        throw new RuntimeException("DataBufferDouble rasters not supported by OpenGL");
                    }
                    if (dataBuffer instanceof DataBufferFloat) {
                        buffer = FloatBuffer.wrap(((DataBufferFloat)dataBuffer).getData());
                    } else if (dataBuffer instanceof DataBufferInt) {
                        buffer = IntBuffer.wrap(((DataBufferInt)dataBuffer).getData());
                    } else if (dataBuffer instanceof DataBufferShort) {
                        buffer = ShortBuffer.wrap(((DataBufferShort)dataBuffer).getData());
                    } else if (dataBuffer instanceof DataBufferUShort) {
                        buffer = ShortBuffer.wrap(((DataBufferUShort)dataBuffer).getData());
                    } else {
                        throw new RuntimeException("Unexpected DataBuffer type?");
                    }
                }
                gl.glTexSubImage2D(3553, 0, 0, 0, width, height, srcPixelFormat, 5121, buffer);
                animatedTextures.get(gl).add(image);
            }
        }
        if (first || !oneTexturePerImage || lastRendered == null || image != lastRendered.getImage() || image.isDirty(gl.hashCode())) {
            lastRendered = tex;
            if (canFilterAnisotropic) {
                gl.glTexParameterf(3553, 34046, maxAnisotropy.get(0));
            }
            gl.glTexParameteri(3553, 10242, tex.getRepeatS().intValue());
            gl.glTexParameteri(3553, 10243, tex.getRepeatT().intValue());
            gl.glTexParameteri(3553, 10241, tex.getMinFilter().intValue());
            gl.glTexParameteri(3553, 10240, tex.getMagFilter().intValue());
            float[] texcolor = tex.getBlendColor().getRGBComponents(null);
            gl.glTexEnvfv(8960, 8705, texcolor, 0);
            gl.glTexEnvf(8960, 8704, (float)tex.getApplyMode().intValue());
            if (tex.getApplyMode() == 34160) {
                gl.glTexEnvf(8960, 34161, (float)tex.getCombineMode().intValue());
                gl.glTexEnvf(8960, 34176, (float)tex.getSource0Color().intValue());
                gl.glTexEnvf(8960, 34192, (float)tex.getOperand0Color().intValue());
                gl.glTexEnvf(8960, 34177, (float)tex.getSource1Color().intValue());
                gl.glTexEnvf(8960, 34193, (float)tex.getOperand1Color().intValue());
                gl.glTexEnvf(8960, 34178, (float)tex.getSource2Color().intValue());
                gl.glTexEnvf(8960, 34194, (float)tex.getOperand2Color().intValue());
                gl.glTexEnvf(8960, 34162, (float)tex.getCombineModeAlpha().intValue());
                gl.glTexEnvf(8960, 34184, (float)tex.getSource0Alpha().intValue());
                gl.glTexEnvf(8960, 34200, (float)tex.getOperand0Alpha().intValue());
                gl.glTexEnvf(8960, 34185, (float)tex.getSource1Alpha().intValue());
                gl.glTexEnvf(8960, 34201, (float)tex.getOperand1Alpha().intValue());
                gl.glTexEnvf(8960, 34186, (float)tex.getSource2Alpha().intValue());
                gl.glTexEnvf(8960, 34202, (float)tex.getOperand2Alpha().intValue());
            }
            if (first || replace || image.isDirty(gl.hashCode())) {
                boolean mipmapped;
                image.setClean(gl.hashCode());
                boolean bl = mipmapped = tex.getMipmapMode() != false && image.getImageType() != 2;
                if (mipmapped) {
                    if (haveAutoMipmapGeneration) {
                        gl.glPixelStorei(3314, image.getWidth());
                        gl.glPixelStorei(3315, 0);
                        gl.glPixelStorei(3316, 0);
                        gl.glTexParameteri(3553, 33169, 1);
                        Texture2DLoaderJOGL.generateTexture(gl, image);
                    } else {
                        GLU glu = new GLU();
                        try {
                            switch (image.getImageType()) {
                                case 0: {
                                    Object[] data = image.getByteArray();
                                    glu.gluBuild2DMipmaps(3553, 34030, width, height, srcPixelFormat, 5121, (Buffer)ByteBuffer.wrap(data));
                                    break;
                                }
                                case 2: {
                                    Object[] data = image.getFloatArray();
                                    glu.gluBuild2DMipmaps(3553, 34840, width, height, 6409, 5126, (Buffer)FloatBuffer.wrap(data));
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    gl.glPixelStorei(3314, image.getWidth());
                    gl.glPixelStorei(3315, 0);
                    gl.glPixelStorei(3316, 0);
                    Texture2DLoaderJOGL.generateTexture(gl, image);
                }
            }
        }
    }

    public static void render(JOGLRenderer jr, CubeMap ref) {
        int textureID;
        boolean first = true;
        boolean mipmapped = true;
        lastRendered = null;
        GL gl = jr.globalGL;
        WeakHashMap<ImageData, Integer> ht = Texture2DLoaderJOGL.getCubeMapTableForGL(gl);
        Texture2DLoaderJOGL.checkForTextureExtensions(gl);
        Integer texid = ht.get(ref.getLeft());
        if (texid != null) {
            first = false;
            textureID = texid;
        } else {
            textureID = Texture2DLoaderJOGL.createTextureID(gl);
            ht.put(ref.getLeft(), new Integer(textureID));
        }
        gl.glBindTexture(34067, textureID);
        double[] c2w = Rn.copy(null, jr.renderingState.cameraToWorld);
        c2w[11] = 0.0;
        c2w[7] = 0.0;
        c2w[3] = 0.0;
        int srcPixelFormat = 6408;
        gl.glTexParameteri(3553, 10242, 33071);
        gl.glTexParameteri(3553, 10243, 33071);
        gl.glTexParameteri(3553, 10241, 9987);
        gl.glTexParameteri(3553, 10240, 9729);
        float[] texcolor = ref.getBlendColor().getRGBComponents(null);
        gl.glTexEnvfv(8960, 8705, texcolor, 0);
        gl.glTexEnvf(8960, 8704, 34160.0f);
        gl.glTexEnvf(8960, 8704, 34160.0f);
        gl.glTexEnvf(8960, 34161, 34165.0f);
        gl.glTexEnvf(8960, 34176, 5890.0f);
        gl.glTexEnvf(8960, 34192, 768.0f);
        gl.glTexEnvf(8960, 34177, 34168.0f);
        gl.glTexEnvf(8960, 34193, 768.0f);
        gl.glTexEnvf(8960, 34178, 34166.0f);
        gl.glTexEnvf(8960, 34194, 770.0f);
        gl.glMatrixMode(5890);
        gl.glLoadTransposeMatrixd(c2w, 0);
        gl.glMatrixMode(5888);
        gl.glTexParameteri(34067, 32882, 33071);
        gl.glTexParameteri(34067, 10242, 33071);
        gl.glTexParameteri(34067, 10243, 33071);
        gl.glTexGeni(8192, 9472, 34066);
        gl.glTexGeni(8193, 9472, 34066);
        gl.glTexGeni(8194, 9472, 34066);
        gl.glEnable(3168);
        gl.glEnable(3169);
        gl.glEnable(3170);
        gl.glEnable(34067);
        if (first) {
            ImageData[] faces = new ImageData[]{ref.getBack(), ref.getFront(), ref.getBottom(), ref.getTop(), ref.getLeft(), ref.getRight()};
            for (int i = 0; i < 6; ++i) {
                byte[] data = faces[i].getByteArray();
                int width = faces[i].getWidth();
                int height = faces[i].getHeight();
                gl.glPixelStorei(3314, width);
                gl.glPixelStorei(3315, 0);
                gl.glPixelStorei(3316, 0);
                if (glu == null) {
                    glu = new GLU();
                }
                if (mipmapped) {
                    glu.gluBuild2DMipmaps(34069 + i, 6408, width, height, srcPixelFormat, 5121, (Buffer)ByteBuffer.wrap(data));
                    continue;
                }
                gl.glTexImage2D(34069 + i, 0, 34030, width, height, 0, srcPixelFormat, 5121, (Buffer)ByteBuffer.wrap(data));
            }
        }
    }

    private static void checkForTextureExtensions(GL gl) {
        if (!haveCheckedForAnisotropy) {
            if (gl.glGetString(7939).contains("GL_EXT_texture_filter_anisotropic")) {
                gl.glGetFloatv(34047, maxAnisotropy);
                canFilterAnisotropic = true;
            } else {
                canFilterAnisotropic = false;
            }
            haveCheckedForAnisotropy = true;
        }
        if (!haveCheckedAutoMipmapGeneration) {
            String vendor = gl.glGetString(7936);
            System.err.println("Vendor = " + vendor);
            haveAutoMipmapGeneration = gl.isExtensionAvailable("GL_VERSION_1_4") || gl.isExtensionAvailable("GL_SGIS_generate_mipmap");
            haveCheckedAutoMipmapGeneration = true;
            System.err.println("Have automipmap generation = " + haveAutoMipmapGeneration);
        }
    }

    public static void deleteAllTextures(GL gl) {
        WeakHashMap<ImageData, Integer> ht = lookupTextures.get(gl);
        ReferenceQueue<ImageData> currentRefQueue = refQueues.get(gl);
        if (ht == null) {
            return;
        }
        Iterator<Serializable> i$ = ht.values().iterator();
        while (i$.hasNext()) {
            int idx = i$.next();
            int[] list = new int[]{idx};
            gl.glDeleteTextures(1, IntBuffer.wrap(list));
        }
        for (ImageData img : ht.keySet()) {
            refToID.remove(img);
            refToGL.remove(img);
            refToDim.remove(img);
        }
        ht.clear();
    }

    static {
        glu = null;
        maxAnisotropy = FloatBuffer.allocate(1);
        canFilterAnisotropic = false;
        haveCheckedForAnisotropy = false;
    }
}

