/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl.shader;

import de.jreality.jogl.shader.DefaultPolygonShader;
import de.jreality.jogl.shader.Shader;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ShaderUtility;
import de.jreality.util.LoggingSystem;
import java.util.HashMap;
import java.util.logging.Level;

public class ShaderLookup {
    private ShaderLookup() {
    }

    private static Object lookup2(String shaderName, String type) {
        DefaultPolygonShader ps;
        HashMap<String, String> unknowns = new HashMap<String, String>();
        try {
            String clName = "de.jreality.jogl.shader." + Character.toUpperCase(shaderName.charAt(0)) + shaderName.substring(1) + Character.toUpperCase(type.charAt(0)) + type.substring(1);
            LoggingSystem.getLogger(ShaderLookup.class).log(Level.FINEST, "attempt to load {0}", clName);
            Class<?> cl = Class.forName(clName);
            LoggingSystem.getLogger(ShaderLookup.class).log(Level.FINEST, "loaded {0}", cl);
            ps = cl.newInstance();
            LoggingSystem.getLogger(ShaderLookup.class).log(Level.FINEST, "instantiated {0}", cl);
        }
        catch (ClassNotFoundException ex) {
            type = Character.toUpperCase(type.charAt(0)) + type.substring(1);
            if (unknowns.get(shaderName) != null) {
                unknowns.put(shaderName, shaderName);
                LoggingSystem.getLogger(ShaderLookup.class).warning("unsupported shader " + shaderName);
            }
            ps = new DefaultPolygonShader();
        }
        catch (Exception ex) {
            type = Character.toUpperCase(type.charAt(0)) + type.substring(1);
            LoggingSystem.getLogger(ShaderLookup.class).warning("shader " + shaderName + " failed");
            ps = new DefaultPolygonShader();
        }
        return ps;
    }

    public static Shader getShaderAttr(EffectiveAppearance eAppearance, String base, String type) {
        return ShaderLookup.getShaderAttr(eAppearance, base, type, type);
    }

    public static Shader getShaderAttr(EffectiveAppearance eAppearance, String base, String type, String attr) {
        String vShader = (String)eAppearance.getAttribute(ShaderUtility.nameSpace(base, attr), "default");
        if (vShader.equals("default")) {
            vShader = (String)eAppearance.getAttribute(ShaderUtility.nameSpace(base, attr) + "name", "default");
        }
        if (vShader.equals("default")) {
            vShader = (String)eAppearance.getAttribute(ShaderUtility.nameSpace(base, attr) + ".name", "default");
        }
        Shader vShaderImpl = (Shader)ShaderLookup.lookup2(vShader, type);
        String foo = ShaderUtility.nameSpace(base, attr);
        vShaderImpl.setFromEffectiveAppearance(eAppearance, foo);
        return vShaderImpl;
    }
}

