/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl.shader;

import de.jreality.jogl.JOGLConfiguration;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.jogl.JOGLRenderingState;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ShaderUtility;
import javax.media.opengl.GL;

public class RenderingHintsShader {
    double levelOfDetail = 0.0;
    static final int SINGLE_COLOR = 33273;
    static final int SEPARATE_SPECULAR_COLOR = 33274;
    boolean transparencyEnabled = false;
    boolean zBufferEnabled = false;
    boolean lightingEnabled = true;
    boolean antiAliasingEnabled = false;
    boolean backFaceCullingEnabled = false;
    boolean flipNormalsEnabled = false;
    boolean useDisplayLists = true;
    boolean clearColorBuffer = true;
    boolean localLightModel = false;
    boolean separateSpecularColor = false;
    boolean ignoreAlpha0 = true;
    boolean componentDisplayLists = false;
    private boolean oldFlipped = this.flipNormalsEnabled;

    public static RenderingHintsShader createFromEffectiveAppearance(EffectiveAppearance eap, String name) {
        RenderingHintsShader drh = new RenderingHintsShader();
        drh.setFromEffectiveAppearance(eap, name);
        return drh;
    }

    public void setFromEffectiveAppearance(EffectiveAppearance eap, String name) {
        this.lightingEnabled = eap.getAttribute(ShaderUtility.nameSpace(name, "lightingEnabled"), true);
        this.transparencyEnabled = eap.getAttribute(ShaderUtility.nameSpace(name, "transparencyEnabled"), false);
        this.zBufferEnabled = eap.getAttribute(ShaderUtility.nameSpace(name, "zBufferEnabled"), false);
        this.ignoreAlpha0 = eap.getAttribute(ShaderUtility.nameSpace(name, "ignoreAlpha0"), true);
        this.antiAliasingEnabled = eap.getAttribute(ShaderUtility.nameSpace(name, "antiAliasing"), false);
        this.backFaceCullingEnabled = eap.getAttribute(ShaderUtility.nameSpace(name, "backFaceCulling"), false);
        this.flipNormalsEnabled = eap.getAttribute(ShaderUtility.nameSpace(name, "flipNormals"), false);
        this.useDisplayLists = eap.getAttribute(ShaderUtility.nameSpace(name, "anyDisplayLists"), true);
        this.levelOfDetail = eap.getAttribute(ShaderUtility.nameSpace(name, "levelOfDetail"), 1.0);
        this.clearColorBuffer = eap.getAttribute(ShaderUtility.nameSpace(name, "clearColorBuffer"), true);
        this.localLightModel = eap.getAttribute(ShaderUtility.nameSpace(name, "localLightModel"), false);
        this.separateSpecularColor = eap.getAttribute(ShaderUtility.nameSpace(name, "separateSpecularColor"), false);
    }

    public boolean isLightingEnabled() {
        return this.lightingEnabled;
    }

    public boolean isTransparencyEnabled() {
        return this.transparencyEnabled;
    }

    public void render(JOGLRenderingState jrs) {
        JOGLRenderer jr = jrs.renderer;
        GL gl = jr.globalGL;
        if (this.transparencyEnabled) {
            gl.glEnable(3042);
            gl.glDepthMask(this.zBufferEnabled);
            JOGLConfiguration.glBlendFunc(gl, false);
        } else {
            gl.glDepthMask(true);
            gl.glDisable(3042);
        }
        jr.renderingState.transparencyEnabled = this.transparencyEnabled;
        if (this.lightingEnabled) {
            gl.glEnable(2896);
        } else {
            gl.glDisable(2896);
        }
        if (this.backFaceCullingEnabled) {
            gl.glEnable(2884);
            gl.glCullFace(1029);
        } else {
            gl.glDisable(2884);
        }
        this.oldFlipped = jr.renderingState.flipped;
        boolean newf = this.flipNormalsEnabled ^ this.oldFlipped;
        if (this.oldFlipped != newf) {
            jr.renderingState.flipped = newf;
            jr.globalGL.glFrontFace(jr.renderingState.flipped ? 2304 : 2305);
            System.err.println("Flipping normals");
        }
        jr.renderingState.levelOfDetail = this.levelOfDetail;
        gl.glAlphaFunc(this.ignoreAlpha0 ? 516 : 519, 0.0f);
        jr.renderingState.ignoreAlpha0 = this.ignoreAlpha0;
        if (this.localLightModel != jr.renderingState.localLightModel) {
            gl.glLightModeli(2897, this.localLightModel ? 1 : 0);
            jr.renderingState.localLightModel = this.localLightModel;
        }
        if (this.separateSpecularColor != jr.renderingState.separateSpecularColor) {
            gl.glLightModeli(33272, this.separateSpecularColor ? 33274 : 33273);
            jr.renderingState.separateSpecularColor = this.separateSpecularColor;
        }
        jr.renderingState.useDisplayLists = this.useDisplayLists;
    }

    public void postRender(JOGLRenderingState jrs) {
        JOGLRenderer jr = jrs.renderer;
        GL gl = jr.globalGL;
        if (this.oldFlipped != jr.renderingState.flipped) {
            jr.globalGL.glFrontFace(this.oldFlipped ? 2304 : 2305);
            jr.renderingState.flipped = this.oldFlipped;
        }
    }
}

