/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl.shader;

import de.jreality.jogl.JOGLRenderer;
import de.jreality.jogl.JOGLRenderingState;
import de.jreality.jogl.shader.GlslLoader;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.SceneGraphPath;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.GlslProgram;
import de.jreality.shader.ShaderUtility;
import de.jreality.util.Input;
import java.io.IOException;
import javax.media.opengl.GL;

public class NoneuclideanGLSLShader {
    boolean poincareModel = false;
    boolean needsRendered = true;
    SceneGraphPath poincarePath;
    static GlslProgram glslProgram = null;
    static String shaderLocation = "de/jreality/jogl/shader/resources/noneuclidean.vert";

    public void setFromEffectiveAppearance(EffectiveAppearance eap, String name) {
        if (glslProgram == null) {
            try {
                Appearance ap = new Appearance();
                glslProgram = new GlslProgram(ap, "polygonShader", Input.getInput(shaderLocation), null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.poincareModel = eap.getAttribute(ShaderUtility.nameSpace(name, "poincareModel"), false);
        if (this.poincareModel) {
            this.poincarePath = (SceneGraphPath)eap.getAttribute(ShaderUtility.nameSpace(name, "poincarePath"), new SceneGraphPath());
            if (this.poincarePath.getLength() == 0) {
                this.poincarePath = null;
            }
        }
        this.needsRendered = true;
    }

    public boolean isPoincareModel() {
        return this.poincareModel;
    }

    public SceneGraphPath getPoincarePath() {
        return this.poincarePath;
    }

    public GlslProgram getNoneuclideanShader() {
        return glslProgram;
    }

    protected void render(JOGLRenderer jr) {
        JOGLRenderingState jrs = jr.renderingState;
        glslProgram.setUniform("lightingEnabled", jrs.lighting);
        glslProgram.setUniform("transparencyEnabled", jrs.transparencyEnabled);
        glslProgram.setUniform("transparency", 1.0f - jrs.diffuseColor[3]);
        glslProgram.setUniform("numLights", jrs.numLights);
        glslProgram.setUniform("fogEnabled", jrs.fogEnabled);
        glslProgram.setUniform("hyperbolic", jrs.currentMetric == -1);
        glslProgram.setUniform("useNormals4", jrs.normals4d);
        glslProgram.setUniform("poincareModel", this.poincareModel);
        if (this.poincarePath != null) {
            double[] H2Cam = Rn.times(null, jrs.worldToCamera, this.poincarePath.getMatrix(null));
            double[] cam2H = Rn.inverse(null, H2Cam);
            double[] H2NDC = Rn.times(null, jrs.cameraToNDC, H2Cam);
            glslProgram.setUniform("cam2H", Rn.convertDoubleToFloatArray(Rn.transpose(null, cam2H)));
            glslProgram.setUniform("H2NDC", Rn.convertDoubleToFloatArray(Rn.transpose(null, H2NDC)));
        }
        this.needsRendered = false;
        GlslLoader.render(glslProgram, jr);
    }

    public void postRender(GL gl) {
        GlslLoader.postRender(glslProgram, gl);
    }
}

