/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl.shader;

import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.jogl.JOGLConfiguration;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.jogl.JOGLRendererHelper;
import de.jreality.jogl.JOGLRenderingState;
import de.jreality.jogl.shader.DefaultPolygonShader;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ShaderUtility;
import de.jreality.util.LoggingSystem;
import java.util.logging.Level;
import javax.media.opengl.GL;

public class ImplodePolygonShader
extends DefaultPolygonShader {
    double implodeFactor;

    public ImplodePolygonShader(de.jreality.shader.DefaultPolygonShader ps) {
        super(ps);
    }

    public void setFromEffectiveAppearance(EffectiveAppearance eap, String name) {
        super.setFromEffectiveAppearance(eap, name);
        this.implodeFactor = eap.getAttribute(ShaderUtility.nameSpace(name, "implodeFactor"), this.implodeFactor);
        System.err.println("implode factor = " + this.implodeFactor);
    }

    public double getImplodeFactor() {
        return this.implodeFactor;
    }

    public boolean providesProxyGeometry() {
        return true;
    }

    public int proxyGeometryFor(JOGLRenderingState jrs) {
        double alpha;
        Geometry original = jrs.currentGeometry;
        JOGLRenderer jr = jrs.renderer;
        int sig = jrs.currentMetric;
        boolean useDisplayLists = jrs.useDisplayLists;
        if (!(original instanceof IndexedFaceSet)) {
            return -1;
        }
        if (this.dListProxy != -1) {
            return this.dListProxy;
        }
        GL gl = jr.globalGL;
        JOGLConfiguration.theLog.log(Level.FINE, this + "Providing proxy geometry " + this.implodeFactor);
        IndexedFaceSet ifs = IndexedFaceSetUtility.implode((IndexedFaceSet)original, this.implodeFactor);
        double d = alpha = this.vertexShader == null ? 1.0 : (double)jrs.diffuseColor[3];
        if (useDisplayLists) {
            this.dListProxy = gl.glGenLists(1);
            gl.glNewList(this.dListProxy, 4864);
        }
        JOGLRendererHelper.drawFaces(jr, ifs, jrs.smoothShading, alpha);
        if (useDisplayLists) {
            gl.glEndList();
        }
        return this.dListProxy;
    }

    public void flushCachedState(JOGLRenderer jr) {
        super.flushCachedState(jr);
        LoggingSystem.getLogger(this).fine("ImplodePolygonShader: Flushing display lists " + this.dListProxy + " : " + this.dListProxy);
        if (this.dListProxy != -1) {
            jr.globalGL.glDeleteLists(this.dListProxy, 1);
            this.dListProxy = -1;
        }
        this.displayListsDirty = true;
    }
}

