/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl.shader;

import de.jreality.jogl.JOGLRenderer;
import de.jreality.jogl.JOGLRendererHelper;
import de.jreality.jogl.JOGLRenderingState;
import de.jreality.jogl.shader.AbstractPrimitiveShader;
import de.jreality.jogl.shader.DefaultVertexShader;
import de.jreality.jogl.shader.GlslLoader;
import de.jreality.jogl.shader.JOGLCubeMap;
import de.jreality.jogl.shader.JOGLTexture2D;
import de.jreality.jogl.shader.NoneuclideanGLSLShader;
import de.jreality.jogl.shader.PolygonShader;
import de.jreality.jogl.shader.Texture2DLoaderJOGL;
import de.jreality.scene.Appearance;
import de.jreality.scene.Cylinder;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.Scene;
import de.jreality.scene.Sphere;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.shader.CubeMap;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.GlslProgram;
import de.jreality.shader.ShaderUtility;
import de.jreality.shader.Texture2D;
import de.jreality.shader.TextureUtility;
import de.jreality.util.LoggingSystem;
import java.awt.Color;
import javax.media.opengl.GL;

public class DefaultPolygonShader
extends AbstractPrimitiveShader
implements PolygonShader {
    public static final int FRONT_AND_BACK = 1032;
    public static final int FRONT = 1028;
    public static final int BACK = 1029;
    boolean smoothShading = true;
    Texture2D[] texture2D = new Texture2D[8];
    JOGLTexture2D[] joglTexture2D = new JOGLTexture2D[8];
    CubeMap reflectionMap;
    JOGLCubeMap joglCubeMap;
    public DefaultVertexShader vertexShader = new DefaultVertexShader();
    boolean useGLSL = false;
    int texUnit = 0;
    int refMapUnit = 0;
    GlslProgram glslProgram;
    transient boolean geometryHasTextureCoordinates = false;
    transient boolean hasTextures = false;
    transient boolean firstTime = true;
    transient boolean noneuclideanInitialized = false;
    transient de.jreality.shader.DefaultPolygonShader templateShader;
    NoneuclideanGLSLShader noneuc = new NoneuclideanGLSLShader();
    boolean hasNoneuc = false;
    static int count = 0;
    static Color[] cdbg = new Color[]{Color.BLUE, Color.GREEN, Color.YELLOW, Color.RED, Color.GRAY, Color.WHITE};

    public DefaultPolygonShader() {
    }

    public DefaultPolygonShader(de.jreality.shader.DefaultPolygonShader ps) {
        this.templateShader = ps;
    }

    public void setFromEffectiveAppearance(EffectiveAppearance eap, String name) {
        super.setFromEffectiveAppearance(eap, name);
        this.smoothShading = eap.getAttribute(ShaderUtility.nameSpace(name, "smoothShading"), true);
        this.useGLSL = eap.getAttribute(ShaderUtility.nameSpace(name, "useGLSL"), false);
        for (int i = 0; i < 8; ++i) {
            this.joglTexture2D[i] = null;
        }
        this.joglCubeMap = null;
        this.hasTextures = false;
        if (AttributeEntityUtility.hasAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d"), eap)) {
            this.texture2D[0] = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d"), eap);
            this.joglTexture2D[0] = new JOGLTexture2D(this.texture2D[0]);
            this.hasTextures = true;
        }
        if (AttributeEntityUtility.hasAttributeEntity(CubeMap.class, ShaderUtility.nameSpace(name, "reflectionMap"), eap)) {
            this.reflectionMap = TextureUtility.readReflectionMap(eap, ShaderUtility.nameSpace(name, "reflectionMap"));
            this.joglCubeMap = new JOGLCubeMap(this.reflectionMap);
            this.hasTextures = true;
        }
        if (AttributeEntityUtility.hasAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d[1]"), eap)) {
            this.texture2D[1] = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d[1]"), eap);
            this.joglTexture2D[1] = new JOGLTexture2D(this.texture2D[1]);
            this.hasTextures = true;
        }
        if (AttributeEntityUtility.hasAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d[2]"), eap)) {
            this.texture2D[2] = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d[2]"), eap);
            this.joglTexture2D[2] = new JOGLTexture2D(this.texture2D[2]);
            this.hasTextures = true;
        }
        if (AttributeEntityUtility.hasAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d[3]"), eap)) {
            this.texture2D[3] = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d[3]"), eap);
            this.joglTexture2D[3] = new JOGLTexture2D(this.texture2D[3]);
            this.hasTextures = true;
        }
        if (AttributeEntityUtility.hasAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d[4]"), eap)) {
            this.texture2D[4] = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d[4]"), eap);
            this.joglTexture2D[4] = new JOGLTexture2D(this.texture2D[4]);
            this.hasTextures = true;
        }
        if (AttributeEntityUtility.hasAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d[5]"), eap)) {
            this.texture2D[5] = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d[5]"), eap);
            this.joglTexture2D[5] = new JOGLTexture2D(this.texture2D[5]);
            this.hasTextures = true;
        }
        if (AttributeEntityUtility.hasAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d[6]"), eap)) {
            this.texture2D[6] = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d[6]"), eap);
            this.joglTexture2D[6] = new JOGLTexture2D(this.texture2D[6]);
            this.hasTextures = true;
        }
        if (AttributeEntityUtility.hasAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d[7]"), eap)) {
            this.texture2D[7] = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d[7]"), eap);
            this.joglTexture2D[7] = new JOGLTexture2D(this.texture2D[7]);
            this.hasTextures = true;
        }
        if (this.useGLSL) {
            if (GlslProgram.hasGlslProgram(eap, name)) {
                Appearance app = new Appearance();
                this.glslProgram = new GlslProgram(app, eap, name);
                this.hasNoneuc = false;
            } else {
                this.noneuc.setFromEffectiveAppearance(eap, name);
                this.hasNoneuc = true;
                this.glslProgram = this.noneuc.getNoneuclideanShader();
            }
        } else {
            this.hasNoneuc = false;
        }
        this.vertexShader.setFromEffectiveAppearance(eap, name);
        this.geometryHasTextureCoordinates = false;
        this.firstTime = true;
    }

    public void preRender(JOGLRenderingState jrs) {
        JOGLRenderer jr = jrs.renderer;
        GL gl = jr.globalGL;
        if (this.smoothShading) {
            gl.glShadeModel(7425);
        } else {
            gl.glShadeModel(7424);
        }
        jrs.smoothShading = this.smoothShading;
        int texunitcoords = 0;
        if (this.hasTextures) {
            gl.glPushAttrib(262144);
            this.texUnit = 33984;
            Geometry curgeom = jr.renderingState.currentGeometry;
            if (this.firstTime && curgeom != null && curgeom instanceof IndexedFaceSet && ((IndexedFaceSet)curgeom).getVertexAttributes(Attribute.TEXTURE_COORDINATES) != null) {
                this.geometryHasTextureCoordinates = true;
            }
            if (this.geometryHasTextureCoordinates) {
                for (int i = 0; i < 8; ++i) {
                    if (this.joglTexture2D[i] == null) continue;
                    gl.glActiveTexture(33984 + i);
                    gl.glEnable(3553);
                    Texture2DLoaderJOGL.render(gl, this.joglTexture2D[i], jrs.oneTexture2DPerImage);
                    ++this.texUnit;
                    ++texunitcoords;
                }
            }
        }
        if (this.joglCubeMap != null) {
            gl.glActiveTexture(this.texUnit);
            gl.glEnable(34067);
            this.refMapUnit = this.texUnit++;
            Texture2DLoaderJOGL.render(jr, this.joglCubeMap);
        }
        jr.renderingState.texUnitCount = texunitcoords;
        this.vertexShader.render(jrs);
        if (this.useGLSL) {
            if (this.hasNoneuc) {
                this.noneuc.render(jr);
            } else {
                GlslLoader.render(this.glslProgram, jr);
            }
        }
        this.firstTime = false;
    }

    public void postRender(JOGLRenderingState jrs) {
        if (!jrs.shadeGeometry) {
            return;
        }
        JOGLRenderer jr = jrs.renderer;
        GL gl = jrs.renderer.globalGL;
        if (this.useGLSL) {
            GlslLoader.postRender(this.glslProgram, gl);
        }
        if (this.hasTextures) {
            for (int i = 0; i < 8; ++i) {
                if (this.joglTexture2D[i] == null) continue;
                gl.glActiveTexture(33984 + i);
                gl.glDisable(3553);
            }
        }
        if (this.joglCubeMap != null) {
            gl.glActiveTexture(this.refMapUnit);
            gl.glDisable(34067);
            gl.glDisable(3168);
            gl.glDisable(3169);
            gl.glDisable(3170);
        }
        jr.renderingState.texUnitCount = 0;
        if (this.hasTextures) {
            gl.glPopAttrib();
        }
    }

    public boolean providesProxyGeometry() {
        return false;
    }

    public void render(final JOGLRenderingState jrs) {
        final Geometry g = jrs.currentGeometry;
        final JOGLRenderer jr = jrs.renderer;
        final boolean useDisplayLists = jrs.useDisplayLists;
        if (jrs.shadeGeometry) {
            this.preRender(jrs);
        }
        if (g != null) {
            Scene.executeReader(g, new Runnable(){

                public void run() {
                    if (g instanceof Sphere || g instanceof Cylinder) {
                        int dlist;
                        int i = 3;
                        if (g instanceof Sphere) {
                            jr.renderingState.polygonCount += 24 * (i * (i + 1) + 3);
                            dlist = jr.renderingState.getSphereDisplayLists(i);
                        } else {
                            jr.renderingState.polygonCount = (int)((double)jr.renderingState.polygonCount + 4.0 * Math.pow(2.0, i));
                            dlist = jr.renderingState.getCylinderDisplayLists(i);
                        }
                        jr.globalGL.glCallList(dlist);
                        DefaultPolygonShader.this.displayListsDirty = false;
                    } else if (g instanceof IndexedFaceSet) {
                        jr.renderingState.polygonCount += ((IndexedFaceSet)g).getNumFaces();
                        if (DefaultPolygonShader.this.providesProxyGeometry()) {
                            if (!useDisplayLists || DefaultPolygonShader.this.dListProxy == -1) {
                                DefaultPolygonShader.this.dListProxy = DefaultPolygonShader.this.proxyGeometryFor(jrs);
                                DefaultPolygonShader.this.displayListsDirty = false;
                            }
                            jr.globalGL.glCallList(DefaultPolygonShader.this.dListProxy);
                        } else if (useDisplayLists) {
                            if (DefaultPolygonShader.this.dList == -1) {
                                DefaultPolygonShader.this.dList = jr.globalGL.glGenLists(1);
                                jr.globalGL.glNewList(DefaultPolygonShader.this.dList, 4864);
                                JOGLRendererHelper.drawFaces(jr, (IndexedFaceSet)g);
                                jr.globalGL.glEndList();
                                DefaultPolygonShader.this.displayListsDirty = false;
                            }
                            jr.globalGL.glCallList(DefaultPolygonShader.this.dList);
                        } else {
                            JOGLRendererHelper.drawFaces(jr, (IndexedFaceSet)g);
                        }
                    }
                }
            });
        }
    }

    public static void defaultPolygonRender(JOGLRenderingState jrs) {
        Geometry g = jrs.currentGeometry;
        JOGLRenderer jr = jrs.renderer;
        if (g instanceof Sphere || g instanceof Cylinder) {
            int i = 3;
            int dlist = g instanceof Sphere ? jr.renderingState.getSphereDisplayLists(i) : jr.renderingState.getCylinderDisplayLists(i);
            jr.globalGL.glCallList(dlist);
        } else if (g instanceof IndexedFaceSet) {
            JOGLRendererHelper.drawFaces(jr, (IndexedFaceSet)g);
        }
    }

    public void flushCachedState(JOGLRenderer jr) {
        LoggingSystem.getLogger(this).fine("PolygonShader: Flushing display lists " + this.dList + " : " + this.dListProxy);
        if (this.dList != -1) {
            jr.globalGL.glDeleteLists(this.dList, 1);
        }
        if (this.dListProxy != -1) {
            jr.globalGL.glDeleteLists(this.dListProxy, 1);
        }
        this.dListProxy = -1;
        this.dList = -1;
        this.displayListsDirty = true;
    }
}

