/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl.shader;

import de.jreality.jogl.JOGLRenderingState;
import de.jreality.jogl.shader.AbstractPrimitiveShader;
import de.jreality.jogl.shader.DefaultLineShader;
import de.jreality.jogl.shader.DefaultPointShader;
import de.jreality.jogl.shader.DefaultPolygonShader;
import de.jreality.jogl.shader.GlslPolygonShader;
import de.jreality.jogl.shader.ImplodePolygonShader;
import de.jreality.jogl.shader.LineShader;
import de.jreality.jogl.shader.PointShader;
import de.jreality.jogl.shader.PolygonShader;
import de.jreality.jogl.shader.Shader;
import de.jreality.jogl.shader.TwoSidePolygonShader;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ShaderUtility;
import de.jreality.util.LoggingSystem;

public class DefaultGeometryShader
implements Shader {
    boolean faceDraw = true;
    boolean vertexDraw = false;
    boolean edgeDraw = true;
    public PolygonShader polygonShader;
    public LineShader lineShader;
    public PointShader pointShader;

    public static DefaultGeometryShader createFromEffectiveAppearance(EffectiveAppearance eap, String name) {
        DefaultGeometryShader dgs = new DefaultGeometryShader();
        dgs.setFromEffectiveAppearance(eap, name);
        return dgs;
    }

    public void setFromEffectiveAppearance(EffectiveAppearance eap, String name) {
        String geomShaderName = "";
        this.vertexDraw = eap.getAttribute(ShaderUtility.nameSpace(geomShaderName, "showPoints"), true);
        this.edgeDraw = eap.getAttribute(ShaderUtility.nameSpace(geomShaderName, "showLines"), true);
        this.faceDraw = eap.getAttribute(ShaderUtility.nameSpace(geomShaderName, "showFaces"), true);
        de.jreality.shader.DefaultGeometryShader dgs = ShaderUtility.createDefaultGeometryShader(eap);
        if (this.faceDraw) {
            if (this.polygonShader == null) {
                LoggingSystem.getLogger(this).finer("null polygonshader");
                this.polygonShader = DefaultGeometryShader.createFrom(dgs.getPolygonShader());
            }
            this.polygonShader.setFromEffectiveAppearance(eap, ShaderUtility.nameSpace(name, "polygonShader"));
        } else {
            this.polygonShader = null;
        }
        if (this.edgeDraw) {
            if (this.lineShader == null) {
                LoggingSystem.getLogger(this).finer("null lineshader");
                this.lineShader = DefaultGeometryShader.createFrom(dgs.getLineShader());
            }
            this.lineShader.setFromEffectiveAppearance(eap, ShaderUtility.nameSpace(name, "lineShader"));
        } else {
            this.lineShader = null;
        }
        if (this.vertexDraw) {
            if (this.pointShader == null) {
                Class psClass = (Class)eap.getAttribute("pointShaderClass", Object.class);
                if (psClass != Object.class) {
                    try {
                        this.pointShader = (PointShader)psClass.newInstance();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                if (this.pointShader == null) {
                    this.pointShader = DefaultGeometryShader.createFrom(dgs.getPointShader());
                }
            }
            this.pointShader.setFromEffectiveAppearance(eap, ShaderUtility.nameSpace(name, "pointShader"));
        } else {
            this.pointShader = null;
        }
    }

    public boolean isEdgeDraw() {
        return this.edgeDraw;
    }

    public boolean isFaceDraw() {
        return this.faceDraw;
    }

    public boolean isVertexDraw() {
        return this.vertexDraw;
    }

    public Shader getLineShader() {
        return this.lineShader;
    }

    public Shader getPointShader() {
        return this.pointShader;
    }

    public Shader getPolygonShader() {
        return this.polygonShader;
    }

    public void postRender(JOGLRenderingState jrs) {
    }

    public void render(JOGLRenderingState jrs) {
    }

    public static PolygonShader createFrom(de.jreality.shader.PolygonShader ps) {
        AbstractPrimitiveShader ret = null;
        ret = ps instanceof de.jreality.shader.TwoSidePolygonShader ? new TwoSidePolygonShader((de.jreality.shader.TwoSidePolygonShader)ps) : (ps instanceof de.jreality.shader.ImplodePolygonShader ? new ImplodePolygonShader((de.jreality.shader.ImplodePolygonShader)ps) : (ps instanceof de.jreality.shader.GlslPolygonShader ? new GlslPolygonShader() : (ps instanceof de.jreality.shader.DefaultPolygonShader ? new DefaultPolygonShader((de.jreality.shader.DefaultPolygonShader)ps) : new DefaultPolygonShader())));
        return ret;
    }

    public static LineShader createFrom(de.jreality.shader.LineShader ps) {
        DefaultLineShader ret = null;
        ret = ps instanceof de.jreality.shader.DefaultLineShader ? new DefaultLineShader((de.jreality.shader.DefaultLineShader)ps) : new DefaultLineShader();
        return ret;
    }

    public static PointShader createFrom(de.jreality.shader.PointShader ps) {
        DefaultPointShader ret = null;
        ret = ps instanceof de.jreality.shader.DefaultPointShader ? new DefaultPointShader((de.jreality.shader.DefaultPointShader)ps) : new DefaultPointShader();
        return ret;
    }
}

