/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl.shader;

import de.jreality.jogl.ClothCalculation;
import de.jreality.jogl.GpgpuViewer;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.jogl.JOGLRenderingState;
import de.jreality.jogl.shader.AbstractPrimitiveShader;
import de.jreality.jogl.shader.LineShader;
import de.jreality.jogl.shader.Texture2DLoaderJOGL;
import de.jreality.math.Matrix;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.shader.CommonAttributes;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ShaderUtility;
import de.jreality.shader.Texture2D;
import de.jreality.util.Rectangle3D;
import java.awt.Color;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.WeakHashMap;
import javax.media.opengl.GL;

public class ClothLineShader
extends AbstractPrimitiveShader
implements LineShader {
    Texture2D spriteTex;
    Texture2D tex;
    private double pointRadius;
    private Color diffuseColor;
    static float[] difCol = new float[4];
    private static FloatBuffer data;
    private static IntBuffer index;
    private static FloatBuffer texCoords;
    static float[] mat;
    protected static double pointSize;
    boolean debug;
    private boolean newFrame;
    private boolean write;
    private static boolean array;
    protected static boolean sprites;
    protected static float[] pointAttenuation;
    static float[] particles;
    static boolean setParticles;
    private static Rectangle3D bb;
    private static float[][] bounds;
    private static Matrix rootToObject;
    private static int framecnt;
    private String folder = ".";
    private String fileName = "particles";
    static boolean setGravity;
    private static double[] gravity;
    static boolean setInitialPositions;
    private static double[] initialPositions;
    static boolean setDamping;
    private static double damping;
    static boolean setFactor;
    private static double factor;
    private static double[] DEFAULT_GRAVITY;
    private int rows;
    private int columns;
    ClothCalculation calc;
    private static boolean inited;
    static WeakHashMap displayLists;

    public boolean providesProxyGeometry() {
        return true;
    }

    public int proxyGeometryFor(JOGLRenderingState jrs) {
        return -1;
    }

    public void setFromEffectiveAppearance(EffectiveAppearance eap, String name) {
        double[] currInitialPositions;
        double[] currGravity;
        double currDamping;
        this.pointRadius = eap.getAttribute(ShaderUtility.nameSpace(name, "pointRadius"), 0.025);
        pointSize = eap.getAttribute(ShaderUtility.nameSpace(name, "size"), 2.0);
        this.debug = eap.getAttribute(ShaderUtility.nameSpace(name, "debug"), false);
        this.write = eap.getAttribute(ShaderUtility.nameSpace(name, "write"), false);
        if (this.write) {
            this.folder = (String)eap.getAttribute(ShaderUtility.nameSpace(name, "folder"), this.folder);
            this.fileName = (String)eap.getAttribute(ShaderUtility.nameSpace(name, "fileName"), this.fileName);
        }
        if (sprites = eap.getAttribute(ShaderUtility.nameSpace(name, "sprites"), sprites)) {
            this.spriteTex = AttributeEntityUtility.hasAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "pointSprite"), eap) ? (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "pointSprite"), eap) : null;
        }
        this.tex = AttributeEntityUtility.hasAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d"), eap) ? (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d"), eap) : null;
        this.diffuseColor = (Color)eap.getAttribute(ShaderUtility.nameSpace(name, "diffuseColor"), CommonAttributes.DIFFUSE_COLOR_DEFAULT);
        this.diffuseColor.getComponents(difCol);
        float[] parts = (float[])eap.getAttribute(ShaderUtility.nameSpace(name, "particles"), particles);
        if (parts != particles) {
            particles = parts;
            setParticles = true;
        }
        eap.getAttribute("objectToRoot", rootToObject.getArray());
        int fcnt = eap.getAttribute("frameCnt", framecnt);
        if (fcnt > framecnt) {
            framecnt = fcnt;
            this.newFrame = true;
        }
        this.rows = eap.getAttribute(ShaderUtility.nameSpace(name, "rows"), 64);
        this.columns = eap.getAttribute(ShaderUtility.nameSpace(name, "columns"), 64);
        double currFactor = eap.getAttribute(ShaderUtility.nameSpace(name, "factor"), 1);
        if (factor != currFactor) {
            factor = currFactor;
            setFactor = true;
        }
        if (damping != (currDamping = eap.getAttribute(ShaderUtility.nameSpace(name, "damping"), 0.9))) {
            damping = currDamping;
            setDamping = true;
        }
        if (gravity != (currGravity = (double[])eap.getAttribute(ShaderUtility.nameSpace(name, "gravity"), DEFAULT_GRAVITY))) {
            gravity = currGravity;
            setGravity = true;
        }
        if (initialPositions != (currInitialPositions = (double[])eap.getAttribute(ShaderUtility.nameSpace(name, "initialPositions"), DEFAULT_GRAVITY))) {
            initialPositions = currInitialPositions;
            setInitialPositions = true;
        }
    }

    public void updateData(JOGLRenderer jr) {
        this.calc = (ClothCalculation)((GpgpuViewer)jr.getViewer()).getCalculation();
        if (this.calc == null) {
            int i;
            int j;
            this.calc = new ClothCalculation(this.rows, this.columns);
            this.calc.setDisplayTexture(false);
            this.calc.setMeasureCPS(false);
            this.calc.setReadData(true);
            ((GpgpuViewer)jr.getViewer()).setCalculation(this.calc);
            System.out.println("setting calculation.");
            inited = true;
            int cols = this.columns * this.columns;
            index = ByteBuffer.allocateDirect(16 * (this.rows - 1) * (cols - 1)).order(ByteOrder.nativeOrder()).asIntBuffer();
            texCoords = ByteBuffer.allocateDirect(8 * this.rows * cols).order(ByteOrder.nativeOrder()).asFloatBuffer();
            for (j = 0; j < this.rows - 1; ++j) {
                for (i = 0; i < cols - 1; ++i) {
                    int pos = j * cols + i;
                    index.put(pos);
                    index.put(pos + 1);
                    index.put(pos + 1 + cols);
                    index.put(pos + cols);
                }
            }
            for (j = 0; j < this.rows; ++j) {
                for (i = 0; i < cols; ++i) {
                    texCoords.put((float)i / (float)(cols - 1));
                    texCoords.put((float)j / (float)(this.rows - 1));
                }
            }
            return;
        }
        if (setParticles) {
            this.calc.setValues(particles);
            setParticles = false;
        }
        if (setDamping) {
            this.calc.setDamping(damping);
            setDamping = false;
        }
        if (setFactor) {
            this.calc.setFactor(factor);
            setFactor = false;
        }
        if (setGravity) {
            this.calc.setGravity(gravity);
            this.calc.triggerCalculation();
            setGravity = false;
        }
        if (setInitialPositions) {
            this.calc.setPositions(initialPositions);
            this.calc.triggerCalculation();
        }
        data = this.calc.getCurrentValues();
    }

    public void render(JOGLRenderingState jrs) {
        JOGLRenderer jr = jrs.renderer;
        this.updateData(jr);
        if (data == null || inited) {
            inited = false;
            return;
        }
        GL gl = jr.globalGL;
        gl.glPushAttrib(64);
        gl.glDisable(2896);
        gl.glColor3fv(difCol, 0);
        gl.glPointSize((float)pointSize);
        if (sprites && this.spriteTex != null) {
            gl.glPointParameterfv(33065, pointAttenuation, 0);
            gl.glEnable(34913);
            gl.glActiveTexture(33984);
            gl.glTexEnvi(34913, 34914, 1);
            gl.glEnable(3553);
            Texture2DLoaderJOGL.render(jr.globalGL, this.spriteTex);
        }
        data.clear();
        index.clear();
        int cnt = index.remaining();
        if (this.tex != null) {
            gl.glEnable(3553);
            gl.glActiveTexture(33984);
            Texture2DLoaderJOGL.render(jr.globalGL, this.tex);
        }
        gl.glEnableClientState(32884);
        gl.glEnableClientState(32888);
        gl.glVertexPointer(4, 5126, 0, (Buffer)data);
        gl.glTexCoordPointer(2, 5126, 0, (Buffer)texCoords);
        gl.glLockArraysEXT(0, data.remaining() / 4);
        gl.glDrawElements(7, cnt, 5125, (Buffer)index);
        gl.glUnlockArraysEXT();
        gl.glDisableClientState(32888);
        gl.glDisableClientState(32884);
        gl.glPopAttrib();
    }

    public void postRender(JOGLRenderingState jrs) {
        JOGLRenderer jr = jrs.renderer;
        GL gl = jr.globalGL;
        if (sprites) {
            gl.glDisable(34913);
            gl.glActiveTexture(33984);
            gl.glTexEnvf(34913, 34914, 0.0f);
            gl.glDisable(3553);
        }
        if (this.tex != null) {
            gl.glDisable(3553);
        }
    }

    public static void main(String[] args) {
        new ClothLineShader();
    }

    static {
        mat = new float[16];
        ClothLineShader.mat[15] = 1.0f;
        array = true;
        sprites = true;
        pointAttenuation = new float[]{1.0f, 0.0f, 0.0f};
        particles = new float[0];
        bb = new Rectangle3D();
        bounds = new float[2][3];
        rootToObject = new Matrix();
        setGravity = true;
        setInitialPositions = true;
        setDamping = true;
        setFactor = true;
        DEFAULT_GRAVITY = new double[]{-0.001, 0.0};
        displayLists = new WeakHashMap();
    }
}

