/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl.plugin;

import com.sun.opengl.util.GLUT;
import de.jreality.jogl.AbstractViewer;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.swing.KeyStroke;

public class HelpOverlay
implements GLEventListener {
    AbstractViewer viewer;
    private List keyboardEntries = new ArrayList();
    private List mouseEntries = new ArrayList();
    private boolean visible = false;
    private GLUT glut = new GLUT();
    private static final int CHAR_HEIGHT = 12;
    private static final int OFFSET = 15;
    private static final int INDENT = 3;
    private static final String KEYBOARD_CONTROLS = "Keyboard controls";
    private static final String MOUSE_CONTROLS = "Mouse controls";

    public HelpOverlay(AbstractViewer v) {
        this.viewer = v;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (visible) {
            this.mouseEntries.clear();
        }
    }

    public void display(GLAutoDrawable glDrawable) {
        int i;
        if (!this.visible) {
            return;
        }
        GL gl = glDrawable.getGL();
        GLU glu = new GLU();
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        Dimension size = new Dimension(glDrawable.getWidth(), glDrawable.getHeight());
        gl.glViewport(0, 0, size.width, size.height);
        gl.glPushAttrib(8192);
        gl.glDisable(3042);
        gl.glDisable(2896);
        gl.glDisable(3553);
        gl.glDisable(2929);
        for (int i2 = 0; i2 < 6; ++i2) {
            gl.glDisable(i2 + 12288);
        }
        int[] viewPort = new int[4];
        gl.glGetIntegerv(2978, viewPort, 0);
        glu.gluOrtho2D(0.0, (double)viewPort[2], (double)viewPort[3], 0.0);
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        int x = 15;
        int maxx = 0;
        int y = 27;
        if (this.keyboardEntries.size() > 0) {
            gl.glRasterPos2i(x, y);
            this.glut.glutBitmapString(7, KEYBOARD_CONTROLS);
            maxx = Math.max(maxx, 15 + this.glut.glutBitmapLength(7, KEYBOARD_CONTROLS));
            y += 15;
            x += 3;
            for (i = 0; i < this.keyboardEntries.size(); ++i) {
                gl.glRasterPos2f((float)x, (float)y);
                String text = (String)this.keyboardEntries.get(i);
                this.glut.glutBitmapString(7, text);
                maxx = Math.max(maxx, 15 + this.glut.glutBitmapLength(7, text));
                y += 15;
            }
        }
        if (this.mouseEntries.size() > 0) {
            x = maxx + 15;
            y = 27;
            gl.glRasterPos2i(x, y);
            this.glut.glutBitmapString(7, MOUSE_CONTROLS);
            y += 15;
            x += 3;
            for (i = 0; i < this.mouseEntries.size(); ++i) {
                gl.glRasterPos2f((float)x, (float)y);
                this.glut.glutBitmapString(7, (String)this.mouseEntries.get(i));
                y += 15;
            }
        }
        gl.glPopAttrib();
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPopMatrix();
    }

    public void displayChanged(GLAutoDrawable glDrawable, boolean b, boolean b1) {
    }

    public void init(GLAutoDrawable glDrawable) {
    }

    public void reshape(GLAutoDrawable glDrawable, int i, int i1, int i2, int i3) {
    }

    public void registerKeyStroke(KeyStroke keyStroke, String description) {
        String modifiersText = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
        String keyText = KeyEvent.getKeyText(keyStroke.getKeyCode());
        this.keyboardEntries.add((modifiersText.length() != 0 ? modifiersText + " " : "") + keyText + ": " + description);
    }

    public void registerInfoString(String eventDesc, String description) {
        this.mouseEntries.add(eventDesc + ": " + description);
    }

    public void printOut() {
        for (int i = 0; i < this.keyboardEntries.size(); ++i) {
            String text = (String)this.keyboardEntries.get(i);
            System.out.println(text);
        }
    }
}

