/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl.pick;

import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Viewer;
import de.jreality.scene.pick.Graphics3D;
import de.jreality.scene.pick.PickResult;

public class PickPoint
implements PickResult {
    public static final int HIT_NOTHING = 0;
    public static final int HIT_FACE = 1;
    public static final int HIT_EDGE = 2;
    public static final int HIT_VERTEX = 4;
    public int pickType;
    public int pickCoordinateSystem;
    public double[] pointNDC;
    public double[] pointWorld;
    public double[] textureCoordinates;
    public int faceNum;
    public int edgeNum;
    public int vertexNum;
    public int[] edgeID = new int[]{0, 0};
    public int[] indices = new int[3];
    double[] barycentricCoords;
    SceneGraphPath pickPath = null;
    SceneGraphPath cameraPath = null;

    public int[] getIndices() {
        return this.indices;
    }

    public void setIndices(int[] indices) {
        this.indices = indices;
    }

    private PickPoint() {
    }

    private PickPoint(Viewer v, SceneGraphPath sgp, double[] pNDC) {
        this(v.getSceneRoot(), v.getCameraPath(), sgp);
        this.setPointNDC(pNDC);
    }

    private PickPoint(SceneGraphComponent sgc, SceneGraphPath cp, SceneGraphPath pp) {
        this.setPickPath(pp);
        this.setCameraPath(cp);
        this.pickType = 0;
    }

    public static PickPoint PickPointFactory(SceneGraphPath pp, SceneGraphPath camPath, double[] pointNDC) {
        if (camPath == null) {
            throw new IllegalArgumentException("Camera path can't be null");
        }
        PickPoint value = new PickPoint();
        value.setPickPath(pp);
        value.setCameraPath(camPath);
        value.setPointNDC(pointNDC);
        value.pickCoordinateSystem = 1;
        return value;
    }

    public static PickPoint PickPointFactory(SceneGraphPath pp, double[] pointWorld) {
        PickPoint value = new PickPoint();
        value.setPickPath(pp);
        value.setPointWorld(pointWorld);
        value.pickCoordinateSystem = 2;
        return value;
    }

    protected void setPointNDC(double[] ds) {
        this.pointNDC = new double[4];
        this.pointNDC[3] = 1.0;
        System.arraycopy(ds, 0, this.pointNDC, 0, ds.length);
        Pn.dehomogenize(this.pointNDC, this.pointNDC);
    }

    protected void setPointWorld(double[] ds) {
        this.pointWorld = new double[4];
        this.pointWorld[3] = 1.0;
        System.arraycopy(ds, 0, this.pointWorld, 0, ds.length);
    }

    public SceneGraphPath getCameraPath() {
        return this.cameraPath;
    }

    protected void setCameraPath(SceneGraphPath cameraPath) {
        this.cameraPath = cameraPath;
    }

    public SceneGraphPath getPickPath() {
        return this.pickPath;
    }

    protected void setPickPath(SceneGraphPath pickPath) {
        this.pickPath = (SceneGraphPath)pickPath.clone();
    }

    public String toString() {
        return "pickPoint:\n\tPath:\t" + this.getPickPath().toString() + "\n\tFace number: " + this.faceNum + "\n\tworld:\t" + Rn.toString(this.getPointWorld()) + "\n\tobject:\t" + Rn.toString(this.getPointObject());
    }

    public int getPickType() {
        return this.pickType;
    }

    public double[] getPointNDC() {
        return this.pointNDC;
    }

    public double[] getPointObject() {
        double[] pointObject = null;
        Graphics3D context = new Graphics3D(this.cameraPath, this.pickPath, 1.0);
        pointObject = this.pickCoordinateSystem == 1 ? Rn.matrixTimesVector(null, context.getNDCToObject(), this.pointNDC) : Rn.matrixTimesVector(null, context.getWorldToObject(), this.pointWorld);
        if (pointObject.length == 4) {
            Pn.dehomogenize(pointObject, pointObject);
        }
        return (double[])pointObject.clone();
    }

    public double[] getPointWorld() {
        if (this.pickCoordinateSystem == 2) {
            return this.pointWorld;
        }
        if (this.pointNDC == null) {
            throw new IllegalStateException("PickPoint should have non-null NDC point");
        }
        Graphics3D context = new Graphics3D(this.cameraPath, this.pickPath, 1.0);
        double[] pointWorld = Rn.matrixTimesVector(null, context.getNDCToWorld(), this.pointNDC);
        if (pointWorld.length == 4) {
            Pn.dehomogenize(pointWorld, pointWorld);
        }
        return (double[])pointWorld.clone();
    }

    public double[] getTextureCoordinates() {
        return this.textureCoordinates;
    }

    public int getVertexNum() {
        return this.vertexNum;
    }

    public int getEdgeNum() {
        return this.edgeNum;
    }

    public int getFaceNum() {
        return this.faceNum;
    }

    public int getIndex() {
        switch (this.pickType) {
            case 2: {
                return this.edgeNum;
            }
            case 4: {
                return this.vertexNum;
            }
            case 1: {
                return this.faceNum;
            }
        }
        return -1;
    }

    public void setVertexNum(int i) {
        this.vertexNum = i;
    }

    public void setEdgeNum(int i) {
        this.edgeNum = i;
    }

    public void setFaceNum(int i) {
        this.faceNum = i;
    }

    public void setPickType(int i) {
        this.pickType = i;
    }

    public void setTextureCoordinates(double[] ds) {
        this.textureCoordinates = ds;
    }

    public double[] getBarycentricCoords() {
        return this.barycentricCoords;
    }

    public void setBarycentricCoords(double[] barycentricCoords) {
        this.barycentricCoords = barycentricCoords;
    }

    public void setEdgeNum(int[] ia) {
        this.edgeID[0] = ia[0];
        this.edgeID[1] = ia[1];
    }

    public double[] getWorldCoordinates() {
        return this.getPointWorld();
    }

    public double[] getObjectCoordinates() {
        return this.getPointObject();
    }

    public double getAffineCoordinate() {
        return 0.0;
    }
}

