/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl.pick;

import de.jreality.geometry.BoundingBoxUtility;
import de.jreality.jogl.pick.PickPoint;
import de.jreality.math.P2;
import de.jreality.math.P3;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.Camera;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.Sphere;
import de.jreality.scene.Transformation;
import de.jreality.scene.Viewer;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.pick.Graphics3D;
import de.jreality.util.CameraUtility;
import de.jreality.util.LoggingSystem;
import de.jreality.util.Rectangle3D;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import java.util.logging.Level;

public class PickAction
extends SceneGraphVisitor {
    public static final int PICK_VERTICES = 1;
    public static final int PICK_EDGES = 2;
    public static final int PICK_FACES = 4;
    public static final int PICK_ALL = 7;
    public static final int PICK_CLOSEST = 8;
    public static final int PICK_NDC = 1;
    public static final int PICK_WORLD = 2;
    public static final double MIN_PICKZ = -1.0;
    public static final double MAX_PICKZ = 1.0;
    static int debug = 0;
    protected SceneGraphComponent theRoot;
    protected SceneGraphPath cameraPath;
    protected int metric = 0;
    protected Graphics3D context3D;
    protected int pickType;
    protected int pickCoordinateSystem;
    protected double[] pickPointNDC = new double[3];
    protected SceneGraphPath thePath;
    protected Vector pickHits;
    protected double minZ;
    protected double maxZ;
    protected boolean possibleHit = true;
    protected double[][] pointsInNDC;
    protected PickAction worldToNDC = null;
    protected double[][] tstack = new double[32][16];
    protected int tstackPtr = 0;
    SceneGraphComponent camNode = null;
    Camera cam = null;
    protected Viewer theViewer = null;

    public PickAction(Viewer v) {
        this(v.getSceneRoot());
        this.setCameraPath(v.getCameraPath());
        this.theViewer = v;
    }

    public PickAction(SceneGraphComponent root) {
        this.theRoot = root;
        this.thePath = new SceneGraphPath();
        this.pickType = 15;
        this.pickCoordinateSystem = 1;
        this.setPickPoint(0.0, 0.0);
        this.pickHits = new Vector();
        Rn.setIdentityMatrix(this.tstack[0]);
    }

    public void setPickPoint(double xNDC, double yNDC) {
        this.setPickPoint(Rn.setToValue(null, xNDC, yNDC, 1.0));
    }

    public void setPickPoint(double[] ndc) {
        if (ndc == null) {
            return;
        }
        this.pickPointNDC[0] = ndc[0];
        this.pickPointNDC[1] = ndc[1];
        this.pickPointNDC[2] = 1.0;
        this.pickCoordinateSystem = 1;
        this.minZ = -1.0;
        this.maxZ = 1.0;
    }

    protected void setCameraPath(SceneGraphPath cp) {
        this.cameraPath = cp;
    }

    public void dispose() {
        if (this.worldToNDC != null && this.theRoot.isDirectAncestor(this.camNode)) {
            this.theRoot.removeChild(this.camNode);
        }
    }

    public void setPickSegment(double[] p0, double[] p1) {
        double[] p14;
        double[] p04;
        this.pickCoordinateSystem = 2;
        if (this.worldToNDC == null) {
            SceneGraphPath camPath = new SceneGraphPath();
            camPath.push(this.theRoot);
            this.camNode = new SceneGraphComponent();
            this.camNode.setTransformation(new Transformation());
            camPath.push(this.camNode);
            this.cam = new Camera();
            camPath.push(this.cam);
            this.theRoot.addChild(this.camNode);
            this.camNode.setCamera(this.cam);
            this.worldToNDC = new PickAction(this.theRoot);
            this.worldToNDC.setMetric(this.getMetric());
            this.worldToNDC.setCameraPath(camPath);
        }
        if (p0.length == 3) {
            p04 = Pn.homogenize(null, p0);
        } else if (p0.length == 4) {
            p04 = p0;
        } else {
            throw new IllegalArgumentException("p0 has invalid length");
        }
        if (p1.length == 3) {
            p14 = Pn.homogenize(null, p1);
        } else if (p1.length == 4) {
            p14 = p1;
        } else {
            throw new IllegalArgumentException("p1 has invalid length");
        }
        double[] origin = Rn.linearCombination(null, 1.0, p04, -0.1, p14);
        Pn.dehomogenize(origin, origin);
        this.camNode.getTransformation().setMatrix(Rn.inverse(null, P3.makeLookatMatrix(null, origin, p04, 0.0, this.metric)));
        Graphics3D cg = new Graphics3D(this.worldToNDC.cameraPath, null, CameraUtility.getAspectRatio(this.theViewer));
        double[] worldToNDCMatrix = cg.getWorldToNDC();
        double[] p04NDC = Rn.matrixTimesVector(null, worldToNDCMatrix, p04);
        Pn.dehomogenize(p04NDC, p04NDC);
        double[] p14NDC = Rn.matrixTimesVector(null, worldToNDCMatrix, p14);
        Pn.dehomogenize(p14NDC, p14NDC);
        this.minZ = p04NDC[2];
        this.maxZ = p14NDC[2];
    }

    public int getMetric() {
        return this.metric;
    }

    public void setMetric(int metric) {
        this.metric = metric;
    }

    public PickPoint getFirstHit() {
        if (this.pickHits != null && this.pickHits.size() != 0) {
            return (PickPoint)this.pickHits.get(0);
        }
        return null;
    }

    protected void pushMatrix(double[] m) {
        ++this.tstackPtr;
        if (this.tstackPtr >= this.tstack.length) {
            return;
        }
        Rn.times(this.tstack[this.tstackPtr], this.tstack[this.tstackPtr - 1], m);
        this.context3D.setObjectToWorld(this.tstack[this.tstackPtr]);
    }

    protected void popMatrix() {
        --this.tstackPtr;
    }

    public Object visit() {
        if (this.pickCoordinateSystem == 2) {
            return this.worldToNDC.visit();
        }
        this.context3D = new Graphics3D(this.cameraPath, null, CameraUtility.getAspectRatio(this.theViewer));
        this.pickHits.clear();
        this.tstackPtr = 0;
        Rn.setIdentityMatrix(this.tstack[0]);
        if (debug >= 1) {
            System.out.println(Rn.toString(this.pickPointNDC));
        }
        this.thePath.clear();
        this.theRoot.accept(this);
        if (debug != 0) {
            System.out.println("Returning " + this.pickHits.size() + " hits");
        }
        if (this.pickHits.size() == 0) {
            return this.pickHits;
        }
        Comparator sorter = new Comparator(){

            public int compare(Object o1, Object o2) {
                double z2;
                PickPoint p1 = (PickPoint)o1;
                PickPoint p2 = (PickPoint)o2;
                double z1 = p1.getPointNDC()[2];
                if (z1 - (z2 = p2.getPointNDC()[2]) < 0.0) {
                    return -1;
                }
                if (z1 - z2 == 0.0) {
                    return 0;
                }
                return 1;
            }
        };
        if (debug != 0) {
            for (int i = 0; i < this.pickHits.size(); ++i) {
                PickPoint pp = (PickPoint)this.pickHits.get(i);
                LoggingSystem.getLogger(this).log(Level.INFO, pp.getPointNDC()[2] + pp.getPickPath().toString());
            }
        }
        Collections.sort(this.pickHits, sorter);
        return this.pickHits;
    }

    public void visit(PointSet sg) {
        double[][] verts;
        if ((debug & 4) != 0) {
            LoggingSystem.getLogger(this).log(Level.FINER, "Visiting PointSet");
        }
        if (sg.getClass() == PointSet.class) {
            this.thePath.push(sg);
        }
        if ((verts = sg.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null)).length > 0) {
            this.pointsInNDC = Rn.matrixTimesVector((double[][])null, this.context3D.getObjectToNDC(), verts);
            if (verts[0].length == 4) {
                Pn.dehomogenize(this.pointsInNDC, this.pointsInNDC);
            }
            Rectangle3D box = BoundingBoxUtility.calculateBoundingBox(this.pointsInNDC);
            double[][] bnds = box.getBounds();
            if ((debug & 2) != 0) {
                System.out.println("NDC bound: " + Rn.toString(bnds));
            }
            if (bnds[0][0] < this.pickPointNDC[0] && bnds[1][0] > this.pickPointNDC[0] && bnds[0][1] < this.pickPointNDC[1] && bnds[1][1] > this.pickPointNDC[1] && bnds[0][2] <= this.maxZ && bnds[1][2] >= this.minZ) {
                if ((debug & 1) != 0) {
                    LoggingSystem.getLogger(this).log(Level.FINER, "Possible hit");
                }
                this.possibleHit = true;
            } else {
                this.possibleHit = false;
            }
        } else {
            this.possibleHit = false;
        }
        if (sg.getClass() == PointSet.class) {
            this.thePath.pop();
        }
    }

    public void visit(IndexedLineSet sg) {
        if ((debug & 4) != 0) {
            LoggingSystem.getLogger(this).log(Level.FINER, "Visiting ILS");
        }
        if (sg.getClass() == IndexedLineSet.class) {
            this.thePath.push(sg);
        }
        this.visit((PointSet)sg);
        if (sg.getClass() == IndexedLineSet.class) {
            this.thePath.pop();
        }
    }

    public void visit(IndexedFaceSet sg) {
        if ((debug & 4) != 0) {
            LoggingSystem.getLogger(this).log(Level.FINER, "Visiting IFS");
        }
        this.possibleHit = true;
        this.visit((IndexedLineSet)sg);
        if (!this.possibleHit) {
            return;
        }
        if ((this.pickType & 4) == 0) {
            return;
        }
        this.thePath.push(sg);
        int[][] indices = sg.getFaceAttributes(Attribute.INDICES).toIntArrayArray(null);
        for (int i = 0; i < indices.length; ++i) {
            double[][] onePolygon = new double[indices[i].length][];
            for (int j = 0; j < indices[i].length; ++j) {
                onePolygon[j] = this.pointsInNDC[indices[i][j]];
            }
            double[][] bds = new double[2][3];
            if (this.pointsInNDC[0].length == 3) {
                bds = Rn.calculateBounds(bds, onePolygon);
            } else if (this.pointsInNDC[0].length == 4) {
                bds = Pn.calculateBounds(bds, onePolygon);
            }
            if (!P2.isConvex(onePolygon) || !P2.polygonContainsPoint(onePolygon, this.pickPointNDC)) continue;
            if ((debug & 2) != 0) {
                System.out.println("Hit Polygon " + i + Rn.toString(onePolygon));
            }
            double[] planeNDC = P3.planeFromPoints(null, onePolygon[0], onePolygon[1], onePolygon[2]);
            double[] pickPoint2 = (double[])this.pickPointNDC.clone();
            pickPoint2[2] = 0.0;
            double[] intersectNDC = P3.lineIntersectPlane(null, this.pickPointNDC, pickPoint2, planeNDC);
            if (intersectNDC[2] < this.minZ || intersectNDC[2] > this.maxZ) continue;
            double[] NDCToObject = Rn.inverse(null, this.context3D.getObjectToNDC());
            double[] objectPt = Rn.matrixTimesVector(null, NDCToObject, intersectNDC);
            Pn.dehomogenize(objectPt, objectPt);
            PickPoint pp = PickPoint.PickPointFactory(this.thePath, this.cameraPath, intersectNDC);
            if ((debug & 2) != 0) {
                System.out.println("Path is " + pp.getPickPath().toString());
            }
            pp.setFaceNum(i);
            pp.setPickType(1);
            this.pickHits.add(pp);
        }
        this.thePath.pop();
    }

    public void visit(Sphere sph) {
        double[] pndc1 = new double[4];
        double[] pndc2 = new double[4];
        pndc1[0] = pndc2[0] = this.pickPointNDC[0];
        pndc1[1] = pndc2[1] = this.pickPointNDC[1];
        pndc1[2] = 0.5;
        pndc2[2] = -0.5;
        pndc2[3] = 1.0;
        pndc1[3] = 1.0;
        double[] ndc2o = this.context3D.getNDCToObject();
        double[] pt0 = Rn.matrixTimesVector(null, ndc2o, pndc1);
        double[] pt1 = Rn.matrixTimesVector(null, ndc2o, pndc2);
        double[] hp0 = new double[3];
        double[] hp1 = new double[3];
        Pn.dehomogenize(hp0, pt0);
        Pn.dehomogenize(hp1, pt1);
        double q = Rn.innerProduct(hp0, hp0);
        double r = Rn.innerProduct(hp0, hp1);
        double s = Rn.innerProduct(hp1, hp1);
        double a = s - 2.0 * r + q;
        double b = 2.0 * (r - q);
        double c = q - 1.0;
        double d = b * b - 4.0 * a * c;
        if (d < 0.0) {
            LoggingSystem.getLogger(this).log(Level.FINEST, "Missed sphere");
            return;
        }
        d = Math.sqrt(d);
        double[] x = new double[]{(-b + d) / (2.0 * a), (-b - d) / (2.0 * a)};
        double[][] opt = new double[2][];
        double[][] ndcpt = new double[2][];
        double[] o2ndc = Rn.inverse(null, ndc2o);
        this.thePath.push(sph);
        for (int k = 0; k < 2; ++k) {
            opt[k] = Rn.linearCombination(null, 1.0 - x[k], hp0, x[k], hp1);
            ndcpt[k] = Rn.matrixTimesVector(null, o2ndc, opt[k]);
            PickPoint oneHit = PickPoint.PickPointFactory(this.thePath, this.cameraPath, Pn.homogenize(null, ndcpt[k]));
            oneHit.setPickType(1);
            this.pickHits.add(oneHit);
        }
        this.thePath.pop();
    }

    public void visit(SceneGraphComponent sg) {
        Transformation t;
        if (!sg.isVisible()) {
            return;
        }
        if ((debug & 4) != 0) {
            LoggingSystem.getLogger(this).log(Level.FINER, "Visiting Component");
        }
        if ((t = sg.getTransformation()) != null) {
            this.pushMatrix(t.getMatrix());
        }
        this.thePath.push(sg);
        sg.childrenAccept(this);
        this.thePath.pop();
        if (t != null) {
            this.popMatrix();
        }
    }

    public void visit(SceneGraphNode sg) {
        if ((debug & 4) != 0) {
            LoggingSystem.getLogger(this).log(Level.FINER, "Visiting Node");
        }
    }

    public Vector getPickHits() {
        return this.pickHits;
    }

    public int getPickType() {
        return this.pickType;
    }

    public void setPickType(int i) {
        this.pickType = i;
    }
}

