/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl.pick;

import de.jreality.jogl.AbstractViewer;
import de.jreality.jogl.pick.PickPoint;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.Viewer;
import de.jreality.scene.pick.Graphics3D;
import de.jreality.util.CameraUtility;

public class JOGLPickUtility {
    private JOGLPickUtility() {
    }

    public static double[] getPointObject(PickPoint pp, Viewer v) {
        double[] pointObject = null;
        Graphics3D context = new Graphics3D(pp.getCameraPath(), pp.getPickPath(), CameraUtility.getAspectRatio(v));
        pointObject = pp.pickCoordinateSystem == 1 ? Rn.matrixTimesVector(null, context.getNDCToObject(), pp.getPointNDC()) : Rn.matrixTimesVector(null, context.getWorldToObject(), pp.getPointWorld());
        if (pointObject.length == 4) {
            Pn.dehomogenize(pointObject, pointObject);
        }
        return pointObject;
    }

    public double[] getPointWorld(PickPoint pp, Viewer v) {
        if (pp.pickCoordinateSystem == 2) {
            return pp.getPointWorld();
        }
        if (pp.getPointNDC() == null) {
            throw new IllegalStateException("PickPoint should have non-null NDC point");
        }
        Graphics3D context = new Graphics3D(pp.getCameraPath(), pp.getPickPath(), CameraUtility.getAspectRatio(v));
        double[] pointWorld = Rn.matrixTimesVector(null, context.getNDCToWorld(), pp.getPointNDC());
        if (pointWorld.length == 4) {
            Pn.dehomogenize(pointWorld, pointWorld);
        }
        return (double[])pointWorld.clone();
    }

    public static Graphics3D getContext(PickPoint pp, AbstractViewer v) {
        return new Graphics3D(pp.getCameraPath(), pp.getPickPath(), CameraUtility.getAspectRatio(v));
    }
}

