/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl.pick;

import de.jreality.jogl.AbstractViewer;
import de.jreality.jogl.JOGLConfiguration;
import de.jreality.jogl.pick.PickAction;
import de.jreality.jogl.pick.PickPoint;
import de.jreality.jogl.pick.PickPointComparator;
import de.jreality.math.P2;
import de.jreality.math.P3;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Sphere;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.pick.Graphics3D;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Level;

public class JOGLPickAction
extends PickAction {
    public static int SGCOMP_BASE = 20010;
    public static int GEOMETRY_BASE;
    public static int GEOMETRY_POINT;
    public static int GEOMETRY_LINE;
    public static int GEOMETRY_FACE;
    public static int PROXY_GEOMETRY_POINT;
    public static int PROXY_GEOMETRY_LINE;
    public static int PROXY_GEOMETRY_FACE;
    static boolean useOpenGL;
    static boolean debug;

    public JOGLPickAction(AbstractViewer v) {
        super(v);
    }

    public Object visit() {
        if (useOpenGL && this.theViewer instanceof AbstractViewer) {
            PickPoint[] hits = ((AbstractViewer)this.theViewer).getRenderer().performPick(this.pickPointNDC);
            int n = 0;
            if (hits != null) {
                n = hits.length;
            }
            this.pickHits = new Vector();
            for (int i = 0; i < n; ++i) {
                this.pickHits.add(hits[i]);
            }
            return this.pickHits;
        }
        return super.visit();
    }

    public static PickPoint[] processOpenGLSelectionBuffer(int numberHits, IntBuffer selectBuffer, double[] pickPoint, AbstractViewer v) {
        double factor = 4.656612875245797E-10;
        ArrayList<PickPoint> al = new ArrayList<PickPoint>();
        PickPoint oneHit = null;
        int realHits = 0;
        Graphics3D context3D = new Graphics3D(v);
        SceneGraphComponent theRoot = v.getSceneRoot();
        if (debug) {
            JOGLConfiguration.theLog.log(Level.FINE, "Processing gl selection buffer");
        }
        int count = 0;
        for (int i = 0; i < numberHits; ++i) {
            PointSet sg;
            int names = selectBuffer.get(count++);
            int[] path = new int[names];
            double[] pndc = new double[3];
            pndc[0] = pickPoint[0];
            pndc[1] = pickPoint[1];
            SceneGraphPath sgp = new SceneGraphPath();
            SceneGraphComponent sgc = theRoot;
            sgp.push(theRoot);
            double z1 = (double)selectBuffer.get(count++) * factor;
            double z2 = (double)selectBuffer.get(count++) * factor;
            pndc[2] = z1 + 1.0;
            if (debug) {
                JOGLConfiguration.theLog.log(Level.FINE, "Hit " + i + ": " + z1 + " - " + z2 + " ");
            }
            int geometryFound = -1;
            int[] geomID = new int[]{-1, -1};
            for (int j = 0; j < names; ++j) {
                path[j] = selectBuffer.get(count);
                if (debug) {
                    JOGLConfiguration.theLog.log(Level.FINE, ": " + path[j]);
                }
                if (j > 0) {
                    if (path[j] >= SGCOMP_BASE) {
                        int which = path[j] - SGCOMP_BASE;
                        if (debug) {
                            JOGLConfiguration.theLog.log(Level.FINE, "?");
                        }
                        if (sgc.getChildComponentCount() > which && sgc.getChildComponent(which) != null) {
                            SceneGraphComponent tmpc = sgc.getChildComponent(which);
                            sgp.push(tmpc);
                            sgc = tmpc;
                            if (debug) {
                                JOGLConfiguration.theLog.log(Level.FINE, "(" + sgc.getName() + ")");
                            }
                        }
                    } else if (path[j] >= GEOMETRY_BASE) {
                        if (geometryFound == -1) {
                            geometryFound = path[j];
                            sgp.push(sgc.getGeometry());
                        } else {
                            JOGLConfiguration.theLog.log(Level.WARNING, "Whoa: too many geometries in the path");
                        }
                    } else if (geomID[0] == -1) {
                        geomID[0] = path[j];
                    } else if (geomID[1] == -1) {
                        geomID[1] = path[j];
                    }
                }
                ++count;
            }
            if (debug) {
                JOGLConfiguration.theLog.log(Level.FINE, "\n");
            }
            SceneGraphNode sgn = sgp.getLastElement();
            if (geometryFound == -1 || !(sgn instanceof Geometry)) continue;
            Geometry geom = (Geometry)sgn;
            context3D.setObjectToWorld(sgp.getMatrix(null));
            if (geometryFound == GEOMETRY_FACE && geom instanceof IndexedFaceSet) {
                if (debug) {
                    JOGLConfiguration.theLog.log(Level.FINE, "Picked face " + geomID[0]);
                }
                if ((oneHit = JOGLPickAction.calculatePickPointForFace(oneHit, pndc, context3D, sgp, sg = (IndexedFaceSet)sgn, geomID)) == null) continue;
                al.add(oneHit);
                ++realHits;
                continue;
            }
            if (geometryFound == GEOMETRY_LINE && geom instanceof IndexedLineSet) {
                if (debug) {
                    JOGLConfiguration.theLog.log(Level.FINE, "Picked edge " + geomID[0] + " " + geomID[1]);
                }
                if ((oneHit = JOGLPickAction.calculatePickPointForEdge(oneHit, pndc, context3D, sgp, sg = (IndexedLineSet)geom, geomID)) == null) continue;
                al.add(oneHit);
                ++realHits;
                continue;
            }
            if (geometryFound == GEOMETRY_POINT && geom instanceof PointSet) {
                sg = (PointSet)geom;
                if (debug) {
                    JOGLConfiguration.theLog.log(Level.FINE, "Picked vertex " + geomID[0]);
                }
                if ((oneHit = JOGLPickAction.calculatePickPointForVertex(oneHit, pndc, context3D, sgp, sg, geomID)) == null) continue;
                al.add(oneHit);
                ++realHits;
                continue;
            }
            if (geom instanceof Sphere) {
                double[] pndc1 = new double[4];
                double[] pndc2 = new double[4];
                pndc1[0] = pndc2[0] = pndc[0];
                pndc1[1] = pndc2[1] = pndc[1];
                pndc1[2] = 0.0;
                pndc2[2] = 1.0;
                pndc2[3] = 1.0;
                pndc1[3] = 1.0;
                double[] ndc2o = context3D.getNDCToObject();
                double[] pt0 = Rn.matrixTimesVector(null, ndc2o, pndc1);
                double[] pt1 = Rn.matrixTimesVector(null, ndc2o, pndc2);
                double[] hp0 = new double[3];
                double[] hp1 = new double[3];
                Pn.dehomogenize(hp0, pt0);
                Pn.dehomogenize(hp1, pt1);
                double q = Rn.innerProduct(hp0, hp0);
                double r = Rn.innerProduct(hp0, hp1);
                double s = Rn.innerProduct(hp1, hp1);
                double a = s - 2.0 * r + q;
                double b = 2.0 * (r - q);
                double c = q - 1.0;
                double d = b * b - 4.0 * a * c;
                if (d < 0.0) {
                    JOGLConfiguration.theLog.log(Level.WARNING, "Missed sphere");
                    continue;
                }
                d = Math.sqrt(d);
                double[] x = new double[]{(-b + d) / (2.0 * a), (-b - d) / (2.0 * a)};
                double[][] opt = new double[2][];
                double[][] ndcpt = new double[2][];
                double[] o2ndc = Rn.inverse(null, ndc2o);
                for (int k = 0; k < 2; ++k) {
                    opt[k] = Rn.linearCombination(null, 1.0 - x[k], hp0, x[k], hp1);
                    ndcpt[k] = Rn.matrixTimesVector(null, o2ndc, opt[k]);
                    oneHit = PickPoint.PickPointFactory(sgp, v.getCameraPath(), ndcpt[k]);
                    oneHit.setPickType(1);
                    al.add(oneHit);
                    ++realHits;
                }
                continue;
            }
            JOGLConfiguration.theLog.log(Level.WARNING, "Invalid geometry type");
        }
        PickPoint[] hits = new PickPoint[realHits];
        hits = al.toArray(hits);
        PickPointComparator cc = PickPointComparator.sharedInstance;
        Arrays.sort(hits, cc);
        return hits;
    }

    protected static PickPoint calculatePickPointForVertex(PickPoint dst, double[] pndc, Graphics3D gc, SceneGraphPath sgp, PointSet sg, int[] geomID) {
        DataList verts = sg.getVertexAttributes(Attribute.COORDINATES);
        if (geomID[0] >= verts.size()) {
            JOGLConfiguration.theLog.log(Level.WARNING, "Invalid vertex number in calculatePickPointFor()");
            return null;
        }
        double[] realNDC = Rn.matrixTimesVector(null, gc.getObjectToNDC(), verts.item(geomID[0]).toDoubleArray(null));
        if (realNDC.length == 4) {
            Pn.dehomogenize(realNDC, realNDC);
        }
        realNDC[2] = pndc[2];
        if (debug) {
            JOGLConfiguration.theLog.log(Level.FINE, "Real and theoretical z-value: " + pndc[2] + "  " + realNDC[2]);
        }
        PickPoint pp = PickPoint.PickPointFactory(sgp, gc.getCameraPath(), realNDC);
        pp.setVertexNum(geomID[0]);
        pp.setPickType(4);
        return pp;
    }

    protected static PickPoint calculatePickPointForEdge(PickPoint dst, double[] pndc, Graphics3D gc, SceneGraphPath sgp, IndexedLineSet sg, int[] geomID) {
        int[][] indices = sg.getEdgeAttributes(Attribute.INDICES).toIntArrayArray(null);
        DataList verts = sg.getVertexAttributes(Attribute.COORDINATES);
        if (geomID[0] >= indices.length) {
            JOGLConfiguration.theLog.log(Level.WARNING, "Invalid edge number in calculatePickPointFor()");
            return null;
        }
        int n = indices[geomID[0]].length;
        double[] realNDC = new double[]{pndc[0], pndc[1], pndc[2], 1.0};
        dst = PickPoint.PickPointFactory(sgp, gc.getCameraPath(), realNDC);
        dst.setEdgeNum(geomID);
        dst.setPickType(2);
        return dst;
    }

    protected static PickPoint calculatePickPointForFace(PickPoint dst, double[] pndc, Graphics3D gc, SceneGraphPath sgp, IndexedFaceSet sg, int[] geomID) {
        double[] intersect;
        int[][] indices = sg.getFaceAttributes(Attribute.INDICES).toIntArrayArray(null);
        DataList verts = sg.getVertexAttributes(Attribute.COORDINATES);
        int faceNum = geomID[0];
        if (faceNum >= indices.length || faceNum < 0) {
            JOGLConfiguration.theLog.log(Level.WARNING, "Invalid face number in calculatePickPointFor()");
            return null;
        }
        pndc[2] = 1.0;
        double[][] onePolygon = new double[indices[faceNum].length][];
        for (int j = 0; j < indices[faceNum].length; ++j) {
            onePolygon[j] = verts.item(indices[faceNum][j]).toDoubleArray(null);
        }
        Rn.matrixTimesVector(onePolygon, gc.getObjectToNDC(), onePolygon);
        if (onePolygon[0].length == 4) {
            Pn.dehomogenize(onePolygon, onePolygon);
        }
        if (P2.polygonContainsPoint(onePolygon, pndc)) {
            double[] plane = P3.planeFromPoints(null, onePolygon[0], onePolygon[1], onePolygon[2]);
            double[] p1 = (double[])pndc.clone();
            p1[2] = 0.0;
            intersect = P3.lineIntersectPlane(null, pndc, p1, plane);
            if (intersect[2] < -1.0 || intersect[2] > 1.0) {
                JOGLConfiguration.theLog.log(Level.WARNING, "calculatePickPointFor: bad z-coordinate");
                return null;
            }
        } else {
            return null;
        }
        double[] NDCToObject = Rn.inverse(null, gc.getObjectToNDC());
        double[] objectPt = Rn.matrixTimesVector(null, NDCToObject, intersect);
        Pn.dehomogenize(objectPt, objectPt);
        dst = PickPoint.PickPointFactory(sgp, gc.getCameraPath(), intersect);
        dst.setFaceNum(faceNum);
        dst.setPickType(1);
        return dst;
    }

    public static boolean isUseOpenGL() {
        return useOpenGL;
    }

    public static void setUseOpenGL(boolean useOpenGL) {
        JOGLPickAction.useOpenGL = useOpenGL;
    }

    static {
        GEOMETRY_POINT = GEOMETRY_BASE = 20000;
        GEOMETRY_LINE = GEOMETRY_BASE + 1;
        GEOMETRY_FACE = GEOMETRY_BASE + 2;
        PROXY_GEOMETRY_POINT = GEOMETRY_BASE + 3;
        PROXY_GEOMETRY_LINE = GEOMETRY_BASE + 4;
        PROXY_GEOMETRY_FACE = GEOMETRY_BASE + 5;
        useOpenGL = true;
        debug = true;
    }
}

