/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.jogl.AbstractViewer;
import de.jreality.jogl.JOGLConfiguration;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.util.SceneGraphUtility;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ViewerSwt
extends AbstractViewer
implements PaintListener {
    protected GLCanvas canvas;
    private Composite parent;
    private boolean autoSwapBuffers = true;
    private boolean pendingUpdate = false;
    private final Object renderLock = new Object();
    private GLContext context;
    private Dimension myDimension = new Dimension();
    final Runnable bufferSwapper = new Runnable(){

        public void run() {
            ViewerSwt.this.canvas.swapBuffers();
        }
    };

    public ViewerSwt() {
        this(null, null);
    }

    public ViewerSwt(SceneGraphPath camPath, SceneGraphComponent root) {
        this(camPath, root, null);
    }

    public ViewerSwt(SceneGraphPath camPath, SceneGraphComponent root, Composite parent) {
        this.parent = parent;
        this.setAuxiliaryRoot(SceneGraphUtility.createFullSceneGraphComponent("AuxiliaryRoot"));
        this.initializeFrom(root, camPath);
    }

    protected void initializeFrom(SceneGraphComponent r, SceneGraphPath p) {
        this.setSceneRoot(r);
        this.setCameraPath(p);
        GLData data = new GLData();
        data.doubleBuffer = true;
        data.depthSize = 24;
        data.greenSize = 8;
        data.blueSize = 8;
        data.redSize = 8;
        data.alphaSize = 8;
        data.stereo = JOGLConfiguration.quadBufferedStereo;
        data.shareContext = null;
        try {
            this.canvas = new GLCanvas(this.parent, 262144, data);
        }
        catch (SWTException ex) {
            data.redSize = 8;
            data.greenSize = 8;
            data.blueSize = 8;
            data.alphaSize = 8;
            data.depthSize = 16;
            this.canvas = new GLCanvas(this.parent, 262144, data);
        }
        if (JOGLConfiguration.quadBufferedStereo) {
            this.setStereoType(4);
        }
        this.init();
    }

    public void render() {
        if (this.canvas.isDisposed()) {
            return;
        }
        if (Thread.currentThread() == this.canvas.getDisplay().getThread()) {
            this.run();
        } else {
            this.canvas.getDisplay().asyncExec((Runnable)this);
        }
    }

    public boolean canRenderAsync() {
        return true;
    }

    public void swapBuffers() {
        if (Thread.currentThread() == this.canvas.getDisplay().getThread()) {
            this.canvas.swapBuffers();
        } else {
            this.canvas.getDisplay().asyncExec(this.bufferSwapper);
        }
    }

    public void setAutoSwapMode(boolean autoSwap) {
        this.autoSwapBuffers = autoSwap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.canvas.isDisposed()) {
            return;
        }
        if (Thread.currentThread() != this.canvas.getDisplay().getThread()) {
            throw new IllegalStateException();
        }
        Object object = this.renderLock;
        synchronized (object) {
            this.pendingUpdate = false;
            this.canvas.setCurrent();
            this.context.makeCurrent();
            GL gl = this.context.getGL();
            this.renderer.display(gl);
            this.canvas.swapBuffers();
            this.context.release();
            this.renderLock.notifyAll();
        }
    }

    public BufferedImage renderOffscreen(int w, int h) {
        if (this.renderer != null) {
            return this.renderer.offscreenRenderer.renderOffscreen(w, h, this.context);
        }
        JOGLConfiguration.getLogger().log(Level.WARNING, "Renderer not initialized");
        return null;
    }

    public void renderOffscreen(int w, int h, File file) {
        if (this.renderer != null) {
            this.renderer.offscreenRenderer.renderOffscreen(w, h, file, this.context);
        } else {
            JOGLConfiguration.getLogger().log(Level.WARNING, "Renderer not initialized");
        }
    }

    public GLAutoDrawable getDrawable() {
        return null;
    }

    public boolean hasViewingComponent() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderAsync() {
        Object object = this.renderLock;
        synchronized (object) {
            if (!this.pendingUpdate) {
                if (this.canvas.isDisposed()) {
                    return;
                }
                if (Thread.currentThread() == this.canvas.getDisplay().getThread()) {
                    this.run();
                } else {
                    this.canvas.getDisplay().asyncExec((Runnable)this);
                    this.pendingUpdate = true;
                }
            }
        }
    }

    public Dimension getViewingComponentSize() {
        return this.myDimension;
    }

    public Object getViewingComponent() {
        return this.canvas;
    }

    public void displayChanged(GLAutoDrawable arg0, boolean arg1, boolean arg2) {
    }

    public void reshape(GLAutoDrawable arg0, int arg1, int arg2, int arg3, int arg4) {
    }

    public void display(GLAutoDrawable arg0) {
    }

    public void init(GLAutoDrawable arg0) {
    }

    private void init() {
        this.renderer = new JOGLRenderer(this);
        this.canvas.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle bounds = ViewerSwt.this.canvas.getBounds();
                ((ViewerSwt)ViewerSwt.this).myDimension.width = bounds.width;
                ((ViewerSwt)ViewerSwt.this).myDimension.height = bounds.height;
                ViewerSwt.this.renderer.setSize(((ViewerSwt)ViewerSwt.this).myDimension.width, ((ViewerSwt)ViewerSwt.this).myDimension.height);
            }
        });
        this.canvas.addPaintListener((PaintListener)this);
        this.canvas.setCurrent();
        this.context = GLDrawableFactory.getFactory().createExternalGLContext();
        firstOne = new WeakReference<GLContext>(this.context);
        Rectangle bounds = this.canvas.getBounds();
        this.myDimension.width = bounds.width;
        this.myDimension.height = bounds.height;
        this.renderer.setSize(this.myDimension.width, this.myDimension.height);
        this.context.makeCurrent();
        GL gl = this.context.getGL();
        this.renderer.init(gl);
        this.renderer.setStereoType(this.stereoType);
        this.context.release();
    }

    public void paintControl(PaintEvent e) {
        this.render();
    }

    public GLCanvas getGLCanvas() {
        return this.canvas;
    }

    public boolean supportsShaders() {
        if (this.renderer != null) {
            return this.renderer.supportGLSL();
        }
        return false;
    }
}

