/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import java.util.LinkedList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SwtQueue
implements Runnable {
    private static SwtQueue instance = new SwtQueue();
    private Display display;
    private boolean inited = false;
    private final Object initLock = new Object();
    private final Thread swtThread;
    int shellCnt = 0;
    private LinkedList tasks = new LinkedList();

    public static SwtQueue getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SwtQueue() {
        this.swtThread = new Thread(this);
        this.swtThread.start();
        Object object = this.initLock;
        synchronized (object) {
            try {
                while (!this.inited) {
                    this.initLock.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public Display getDisplay() {
        return this.display;
    }

    public Shell createShell() {
        final Shell[] shell = new Shell[1];
        Runnable r = new Runnable(){

            public void run() {
                shell[0] = new Shell(SwtQueue.this.display);
                ++SwtQueue.this.shellCnt;
                shell[0].addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent arg0) {
                        --SwtQueue.this.shellCnt;
                        if (SwtQueue.this.shellCnt == 0) {
                            SwtQueue.this.display.dispose();
                        }
                    }
                });
            }
        };
        this.waitFor(r);
        return shell[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.initLock;
        synchronized (object) {
            this.display = new Display();
            this.inited = true;
            this.initLock.notify();
        }
        Runnable task = null;
        while (!this.display.isDisposed()) {
            while (true) {
                LinkedList linkedList = this.tasks;
                synchronized (linkedList) {
                    if (this.tasks.size() > 0) {
                        task = (Runnable)this.tasks.removeFirst();
                    }
                }
                if (task == null) break;
                task.run();
                task = null;
            }
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.dispose();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable r) {
        LinkedList linkedList = this.tasks;
        synchronized (linkedList) {
            this.tasks.addLast(r);
            this.display.wake();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(Runnable r) {
        if (Thread.currentThread() == this.swtThread) {
            System.out.println("Running in the same thread???");
            r.run();
        } else {
            System.out.println("Not running in the same thread???");
            TrackedRunnable rr = new TrackedRunnable(r);
            LinkedList linkedList = this.tasks;
            synchronized (linkedList) {
                this.tasks.addLast(rr);
                this.display.wake();
            }
            rr.waitFor();
        }
    }

    private static final class TrackedRunnable
    implements Runnable {
        private final Runnable task;
        private boolean done = false;

        TrackedRunnable(Runnable task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.task.run();
            Runnable runnable = this.task;
            synchronized (runnable) {
                this.done = true;
                this.task.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitFor() {
            Runnable runnable = this.task;
            synchronized (runnable) {
                while (!this.done) {
                    try {
                        this.task.wait();
                    }
                    catch (InterruptedException e) {
                        throw new Error();
                    }
                }
            }
        }
    }
}

