/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.jogl.GoBetween;
import de.jreality.jogl.JOGLPeerComponent;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.jogl.MatrixListData;
import de.jreality.math.Rn;
import de.jreality.scene.Geometry;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.event.SceneGraphComponentEvent;
import de.jreality.util.CameraUtility;
import de.jreality.util.LoggingSystem;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;

public class MatrixListJOGLPeerComponent
extends JOGLPeerComponent {
    boolean displayListDirty = true;
    boolean isCopyCat = false;
    boolean isTopCat = false;
    boolean isCameraRepn = false;
    boolean visibilityChanged = false;
    boolean insideDL = false;
    double[][] matrices = null;
    boolean[] accepted;
    SceneGraphPath w2camrepn = null;
    double[] world2CameraRepn = new double[16];
    double[] camera2CameraRepn = new double[16];
    int framecount = -1;
    protected boolean[] matrixIsReflection = null;
    GL oldGL;
    public static int instanceCount;
    MatrixListData theDropBox;
    int metric;
    double[] o2c;
    double[] o2ndc;
    private boolean[] localVisibleList;

    public MatrixListJOGLPeerComponent() {
        ++instanceCount;
    }

    public MatrixListJOGLPeerComponent(SceneGraphPath sgp, JOGLPeerComponent p, JOGLRenderer jr) {
        super(sgp, p, jr);
        ++instanceCount;
    }

    public void init(SceneGraphPath sgp, JOGLPeerComponent p, JOGLRenderer jr) {
        this.init(null, sgp, p, jr);
    }

    public void init(GoBetween gb, SceneGraphPath sgp, JOGLPeerComponent p, JOGLRenderer jr) {
        super.init(gb, sgp, p, jr);
        Geometry trojanHorse = this.goBetween.originalComponent.getGeometry();
        boolean bl = this.isCopyCat = trojanHorse != null && trojanHorse instanceof MatrixListData;
        if (this.isCopyCat) {
            this.goBetween.peerGeometry = null;
            this.theDropBox = (MatrixListData)trojanHorse;
            this.readMatrices();
        }
    }

    private void readMatrices() {
        this.matrices = this.theDropBox.getMatrixList();
        this.matrixIsReflection = new boolean[this.matrices.length];
        this.accepted = new boolean[this.matrices.length];
        for (int i = 0; i < this.matrices.length; ++i) {
            this.matrixIsReflection[i] = Rn.determinant(this.matrices[i]) < 0.0;
        }
    }

    public void render() throws GLException {
        if (!this.isVisible) {
            return;
        }
        if (this.childCount == 0 && this.goBetween.peerGeometry == null) {
            return;
        }
        this.insideDL = false;
        if (this.isCopyCat) {
            if (this.matrices.length != this.theDropBox.getMatrixList().length) {
                this.readMatrices();
                this.displayListDirty = true;
            }
            if (this.theDropBox.isNewVisibleList() || this.localVisibleList == null) {
                this.localVisibleList = (boolean[])this.theDropBox.getVisibleList().clone();
                this.theDropBox.setNewVisibleList(false);
                this.displayListDirty = true;
            } else if (this.jr.perfMeter.beginRenderTime - this.lastDisplayListCreationTime > (long)this.theDropBox.getDelay()) {
                this.displayListDirty = true;
            }
            this.jr.renderingState.componentDisplayLists = this.theDropBox.isComponentDisplayLists();
            if (this.jr.renderingState.componentDisplayLists && this.jr.renderingState.useDisplayLists && !this.jr.offscreenMode) {
                if (this.oldGL != this.jr.globalGL) {
                    this.displayListDirty = true;
                    this.oldGL = this.jr.globalGL;
                }
                if (!this.someSubNodeIsDirty()) {
                    if (!this.displayListDirty) {
                        this.jr.globalGL.glCallList(this.displayList);
                        return;
                    }
                    if (this.jr.renderingState.insideDisplayList) {
                        this.printUpState();
                    }
                    if (this.displayList < 0) {
                        this.displayList = this.jr.globalGL.glGenLists(1);
                    }
                    this.jr.globalGL.glNewList(this.displayList, 4864);
                    this.jr.renderingState.insideDisplayList = true;
                    this.insideDL = true;
                    this.lastDisplayListCreationTime = this.jr.perfMeter.beginRenderTime;
                }
            }
        }
        try {
            super.render();
        }
        catch (GLException e) {
            System.err.println("Got exception " + this.name);
            e.printStackTrace();
            if (this.theDropBox != null) {
                this.setDisplayListDirty();
            }
            throw e;
        }
        if (this.insideDL) {
            this.jr.globalGL.glEndList();
            this.jr.globalGL.glCallList(this.displayList);
        }
        this.displayListDirty = false;
    }

    protected boolean someSubNodeIsDirty() {
        if (!this.isVisible) {
            return false;
        }
        if (!this.isCopyCat) {
            if (this.displayListDirty) {
                return true;
            }
            if (this.goBetween.peerGeometry != null && this.geometryDirtyBits != 0) {
                return true;
            }
            for (JOGLPeerComponent child : this.children) {
                if (!child.someSubNodeIsDirty()) continue;
                return true;
            }
            return false;
        }
        JOGLPeerComponent child = (JOGLPeerComponent)this.children.get(0);
        return child.someSubNodeIsDirty();
    }

    private void printUpState() {
        if (debug) {
            theLog.info("dld\tcld:\t" + this.displayListDirty + "\t" + "\t" + this.name);
        }
        if (this.parent != null) {
            ((MatrixListJOGLPeerComponent)this.parent).printUpState();
        }
    }

    protected void renderChildren() {
        if (this.isCopyCat) {
            this.metric = this.jr.renderingState.currentMetric;
            if (debug) {
                theLog.fine("In renderChildren()" + this.name);
            }
            boolean isReflectionBefore = this.jr.renderingState.flipped;
            int nn = this.matrices.length;
            this.theDropBox.setRendering(true);
            boolean clipToCamera = this.theDropBox.isClipToCamera() && !this.jr.offscreenMode;
            int count = 0;
            MatrixListJOGLPeerComponent child = (MatrixListJOGLPeerComponent)this.children.get(0);
            if (!this.theDropBox.isShadeGeometry()) {
                this.geometryShader.polygonShader.render(this.jr.renderingState);
                this.jr.renderingState.shadeGeometry = false;
            }
            for (int j = 0; j < nn; ++j) {
                if (clipToCamera && !this.localVisibleList[j]) continue;
                ++count;
                this.cumulativeIsReflection = isReflectionBefore ^ this.matrixIsReflection[j];
                if (this.cumulativeIsReflection != this.jr.renderingState.flipped) {
                    this.jr.globalGL.glFrontFace(this.cumulativeIsReflection ? 2304 : 2305);
                    this.jr.renderingState.flipped = this.cumulativeIsReflection;
                }
                this.pushTransformation(this.matrices[j]);
                child.render();
                this.popTransformation();
            }
            if (!this.theDropBox.isShadeGeometry()) {
                this.geometryShader.polygonShader.postRender(this.jr.renderingState);
                this.jr.renderingState.shadeGeometry = true;
            }
            this.theDropBox.setRendering(false);
            this.jr.renderingState.flipped = isReflectionBefore;
            this.jr.globalGL.glFrontFace(this.jr.renderingState.flipped ? 2304 : 2305);
            this.jr.renderingState.componentDisplayLists = false;
        } else {
            super.renderChildren();
        }
    }

    protected void pushTransformation(double[] m) {
        if (this.w2camrepn != null) {
            if (this.framecount != this.jr.perfMeter.frameCount) {
                this.w2camrepn.getInverseMatrix(this.world2CameraRepn);
                this.framecount = this.jr.perfMeter.frameCount;
                Rn.times(this.camera2CameraRepn, this.world2CameraRepn, this.jr.renderingState.cameraToWorld);
                Rn.times(this.camera2CameraRepn, this.camera2CameraRepn, CameraUtility.inverseCameraOrientation.getArray());
                this.isReflection = Rn.determinant(this.camera2CameraRepn) < 0.0;
                this.isIdentity = Rn.isIdentityMatrix(this.camera2CameraRepn, 1.0E-7);
            }
            super.pushTransformation(this.camera2CameraRepn);
        } else {
            super.pushTransformation(m);
        }
    }

    protected void propagateAppearanceChanged() {
        this.displayListDirty = true;
        super.propagateAppearanceChanged();
    }

    protected void updateShaders() {
        super.updateShaders();
        if (this.eAp == null) {
            return;
        }
        if (this.goBetween.originalComponent.getAppearance() != null) {
            Object foo = this.goBetween.originalComponent.getAppearance().getAttribute("discreteGroup.cameraRep", SceneGraphPath.class);
            if (foo != null && foo instanceof SceneGraphPath) {
                this.w2camrepn = (SceneGraphPath)foo;
                LoggingSystem.getLogger(this).finer("Found path in " + this.w2camrepn);
                this.useTformCaching = false;
            } else {
                this.w2camrepn = null;
            }
        }
        if (!this.isCopyCat) {
            return;
        }
        this.isTopCat = this.isCopyCat && !this.existsHigherCat();
    }

    private boolean existsHigherCat() {
        if (this.parent != null) {
            if (((MatrixListJOGLPeerComponent)this.parent).isCopyCat) {
                return true;
            }
            return ((MatrixListJOGLPeerComponent)this.parent).existsHigherCat();
        }
        return false;
    }

    protected void updateTransformationInfo() {
        this.displayListDirty = true;
        super.updateTransformationInfo();
    }

    void setDisplayListDirty() {
        this.displayListDirty = true;
        super.setDisplayListDirty();
    }

    public void visibilityChanged(SceneGraphComponentEvent ev) {
        if (debug) {
            theLog.fine("Visibility changed: " + this.name);
        }
        this.displayListDirty = true;
        super.visibilityChanged(ev);
    }
}

