/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.jogl.JOGLRenderingState;
import de.jreality.scene.Appearance;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.scene.event.AppearanceEvent;
import de.jreality.scene.event.AppearanceListener;
import de.jreality.shader.CubeMap;
import de.jreality.util.LoggingSystem;

public class JOGLTopLevelAppearance {
    Appearance rootAp;
    protected transient AppearanceListener topLevelApListener;
    protected transient boolean renderSpherical = false;
    protected transient boolean frontBanana = true;
    protected transient boolean forceResidentTextures = true;
    protected transient boolean oneTexture2DPerImage = false;
    protected transient CubeMap skyboxCubemap;

    public JOGLTopLevelAppearance(Appearance ap) {
        this.rootAp = ap;
        this.topLevelApListener = new AppearanceListener(){

            public void appearanceChanged(AppearanceEvent ev) {
                JOGLTopLevelAppearance.this.update();
            }
        };
        this.rootAp.addAppearanceListener(this.topLevelApListener);
        this.update();
    }

    public void dispose() {
        this.rootAp.removeAppearanceListener(this.topLevelApListener);
    }

    public void update() {
        Object obj = this.rootAp.getAttribute("renderS3", Boolean.class);
        if (obj instanceof Boolean) {
            this.frontBanana = this.renderSpherical = ((Boolean)obj).booleanValue();
        }
        if ((obj = this.rootAp.getAttribute("forceResidentTextures", Boolean.class)) instanceof Boolean) {
            this.forceResidentTextures = (Boolean)obj;
        }
        if ((obj = this.rootAp.getAttribute("oneTexture2DPerImage", Boolean.class)) instanceof Boolean) {
            this.oneTexture2DPerImage = (Boolean)obj;
        }
        LoggingSystem.getLogger(this).info("one texture per image: " + this.oneTexture2DPerImage);
        obj = this.rootAp.getAttribute("clearColorBuffer", Boolean.class);
        obj = this.rootAp.getAttribute("useOldTransparency", Boolean.class);
        if (obj instanceof Boolean) {
            JOGLRenderingState.useOldTransparency = (Boolean)obj;
        }
        this.skyboxCubemap = AttributeEntityUtility.hasAttributeEntity(CubeMap.class, "skyBox", this.rootAp) ? (CubeMap)AttributeEntityUtility.createAttributeEntity(CubeMap.class, "skyBox", this.rootAp, true) : null;
    }

    public boolean isRenderSpherical() {
        return this.renderSpherical;
    }

    public boolean isFrontBanana() {
        return this.frontBanana;
    }

    public boolean isForceResidentTextures() {
        return this.forceResidentTextures;
    }

    public boolean isOneTexture2DPerImage() {
        return this.oneTexture2DPerImage;
    }

    public CubeMap getSkyboxCubemap() {
        return this.skyboxCubemap;
    }
}

