/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.backends.label.LabelUtility;
import de.jreality.geometry.GeometryUtility;
import de.jreality.geometry.HeightFieldFactory;
import de.jreality.geometry.Primitives;
import de.jreality.jogl.JOGLConfiguration;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.jogl.JOGLRenderingState;
import de.jreality.jogl.shader.Texture2DLoaderJOGL;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.ClippingPlane;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.shader.CommonAttributes;
import de.jreality.shader.DefaultTextShader;
import de.jreality.shader.ImageData;
import de.jreality.shader.Texture2D;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.logging.Level;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOGLRendererHelper {
    public static final int PER_PART = 1;
    public static final int PER_FACE = 2;
    public static final int PER_VERTEX = 4;
    public static final int PER_EDGE = 8;
    static float val = 1.0f;
    static float zval = 1.0f;
    static float[][] unitsquare = new float[][]{{val, val, zval}, {-val, val, zval}, {-val, -val, zval}, {val, -val, zval}};
    static Appearance pseudoAp = new Appearance();
    private static IndexedFaceSet bb = Primitives.texturedQuadrilateral(new double[]{0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0});
    private static final Texture2D tex2d = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, "", new Appearance(), true);
    private static double[] correctionNDC;
    private static double[] clipPlane;
    static final int clipBase = 12288;

    private JOGLRendererHelper() {
    }

    static void handleBackground(JOGLRenderer jr, int width, int height, Appearance topAp) {
        GL gl = jr.globalGL;
        JOGLRenderingState openGLState = jr.renderingState;
        Object bgo = null;
        float[] backgroundColor = new float[4];
        if (topAp == null) {
            topAp = pseudoAp;
        }
        for (int i = 0; i < 6; ++i) {
            gl.glDisable(i + 12288);
        }
        if (topAp != null) {
            bgo = topAp.getAttribute("backgroundColor");
        }
        if (bgo != null && bgo instanceof Color) {
            ((Color)bgo).getRGBComponents(backgroundColor);
        } else {
            backgroundColor = CommonAttributes.BACKGROUND_COLOR_DEFAULT.getRGBComponents(null);
        }
        gl.glClearColor(backgroundColor[0], backgroundColor[1], backgroundColor[2], backgroundColor[3]);
        if ((openGLState.clearBufferBits & 0x4000) != 0) {
            gl.glColorMask(true, true, true, true);
        }
        gl.glClear(openGLState.clearBufferBits);
        int cm = openGLState.colorMask;
        gl.glColorMask((cm & 1) != 0, (cm & 2) != 0, (cm & 4) != 0, (cm & 8) != 0);
        Object obj = topAp.getAttribute("skyBox");
        if (obj == Appearance.INHERITED) {
            boolean hasTexture = false;
            boolean hasColors = false;
            double textureAR = 1.0;
            bgo = topAp.getAttribute("backgroundTexture2D");
            Texture2D tex = null;
            if (bgo != null && bgo instanceof List) {
                tex = (Texture2D)((List)bgo).get(0);
                textureAR = (double)tex.getImage().getWidth() / (double)tex.getImage().getHeight();
                hasTexture = true;
            }
            double ar = (double)width / (double)height / textureAR;
            double xl = 0.0;
            double xr = 1.0;
            double yb = 0.0;
            double yt = 1.0;
            if (ar > 1.0) {
                xl = 0.0;
                xr = 1.0;
                yb = 0.5 * (1.0 - 1.0 / ar);
                yt = 1.0 - yb;
            } else {
                yb = 0.0;
                yt = 1.0;
                xl = 0.5 * (1.0 - ar);
                xr = 1.0 - xl;
            }
            if (jr.offscreenMode) {
                int numTiles = jr.offscreenRenderer.getNumTiles();
                double xmin = (double)jr.whichTile[0] / (double)numTiles;
                double xmax = ((double)jr.whichTile[0] + 1.0) / (double)numTiles;
                double ymin = (double)jr.whichTile[1] / (double)numTiles;
                double ymax = ((double)jr.whichTile[1] + 1.0) / (double)numTiles;
                double nxr = xr + xmin * (xl - xr);
                double nxl = xr + xmax * (xl - xr);
                double nyt = yt + ymin * (yb - yt);
                double nyb = yt + ymax * (yb - yt);
                xl = nxl;
                xr = nxr;
                yb = nyb;
                yt = nyt;
            }
            double[][] texcoords = new double[][]{{xl, yb}, {xr, yb}, {xr, yt}, {xl, yt}};
            float[][] cornersf = new float[4][];
            if (!hasTexture) {
                bgo = topAp.getAttribute("backgroundColors");
                if (bgo != null && bgo instanceof Color[]) {
                    Color[] backgroundCorners = (Color[])bgo;
                    for (int i = 0; i < 4; ++i) {
                        cornersf[i] = backgroundCorners[i].getRGBComponents(null);
                    }
                } else {
                    for (int i = 0; i < 4; ++i) {
                        cornersf[i] = backgroundColor;
                    }
                }
                hasColors = true;
            }
            if (hasTexture || hasColors) {
                if (hasTexture) {
                    gl.glPushAttrib(262144);
                    gl.glActiveTexture(33984);
                    gl.glEnable(3553);
                    Texture2DLoaderJOGL.render(gl, tex);
                }
                gl.glDisable(2896);
                gl.glShadeModel(7425);
                gl.glBegin(9);
                for (int q = 0; q < 4; ++q) {
                    if (hasTexture) {
                        gl.glColor3f(1.0f, 1.0f, 1.0f);
                        gl.glTexCoord2dv(texcoords[q], 0);
                    } else {
                        gl.glColor4fv(cornersf[q], 0);
                    }
                    gl.glVertex3fv(unitsquare[q], 0);
                }
                gl.glEnd();
                gl.glEnable(2929);
                gl.glEnable(2896);
                if (hasTexture) {
                    gl.glDisable(3553);
                    gl.glMatrixMode(5889);
                    gl.glPopAttrib();
                }
            }
        }
        bgo = topAp.getAttribute("fogEnabled");
        boolean doFog = false;
        if (bgo instanceof Boolean) {
            doFog = (Boolean)bgo;
        }
        jr.renderingState.fogEnabled = doFog;
        if (doFog) {
            gl.glEnable(2912);
            bgo = topAp.getAttribute("fogColor");
            float[] fogColor = backgroundColor;
            if (bgo != null && bgo instanceof Color) {
                fogColor = ((Color)bgo).getRGBComponents(null);
            }
            gl.glFogi(2917, 2048);
            gl.glFogfv(2918, fogColor, 0);
            bgo = topAp.getAttribute("fogDensity");
            float density = 0.1f;
            if (bgo != null && bgo instanceof Double) {
                density = (float)((Double)bgo).doubleValue();
            }
            gl.glFogf(2914, density);
        } else {
            gl.glDisable(2912);
        }
    }

    @Deprecated
    public static void drawVertices(JOGLRenderer jr, PointSet sg, double alpha) {
        jr.renderingState.currentAlpha = alpha;
        JOGLRendererHelper.drawVertices(jr, sg);
    }

    public static void drawVertices(JOGLRenderer jr, PointSet sg) {
        double alpha = jr.renderingState.currentAlpha;
        GL gl = jr.globalGL;
        JOGLRenderingState openGLState = jr.renderingState;
        DataList vertices = sg.getVertexAttributes(Attribute.COORDINATES);
        if (vertices == null || vertices.size() == 0) {
            return;
        }
        DataList piDL = sg.getVertexAttributes(Attribute.INDICES);
        IntArray vind = null;
        if (piDL != null) {
            vind = piDL.toIntArray();
        }
        DataList vertexColors = sg.getVertexAttributes(Attribute.COLORS);
        DataList pointSize = sg.getVertexAttributes(Attribute.RELATIVE_RADII);
        int vertexLength = GeometryUtility.getVectorLength(vertices);
        int colorLength = 0;
        if (vertexColors != null) {
            colorLength = GeometryUtility.getVectorLength(vertexColors);
            if (openGLState.frontBack != 1032) {
                gl.glColorMaterial(1032, 4609);
                openGLState.frontBack = 1032;
            }
        }
        DoubleArray ra = null;
        if (pointSize != null) {
            ra = pointSize.toDoubleArray();
        }
        if (pointSize == null) {
            gl.glBegin(0);
        }
        for (int i = 0; i < sg.getNumPoints(); ++i) {
            DoubleArray da;
            if (vind != null && vind.getValueAt(i) == 0) continue;
            if (pointSize != null) {
                float ps = (float)(jr.renderingState.pointSize * ra.getValueAt(i));
                gl.glPointSize(ps);
            }
            if (pointSize != null) {
                gl.glBegin(0);
            }
            if (vertexColors != null) {
                da = vertexColors.item(i).toDoubleArray();
                if (colorLength == 3) {
                    gl.glColor4d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), alpha);
                } else if (colorLength == 4) {
                    gl.glColor4d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), alpha * da.getValueAt(3));
                }
            }
            da = vertices.item(i).toDoubleArray();
            if (vertexLength == 3) {
                gl.glVertex3d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2));
            } else if (vertexLength == 4) {
                gl.glVertex4d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), da.getValueAt(3));
            }
            if (pointSize == null) continue;
            gl.glEnd();
        }
        gl.glEnd();
    }

    @Deprecated
    public static void drawLines(JOGLRenderer jr, IndexedLineSet sg, boolean interpolateVertexColors, double alpha) {
        jr.renderingState.currentAlpha = alpha;
        jr.renderingState.useVertexColors = interpolateVertexColors;
        JOGLRendererHelper.drawLines(jr, sg);
    }

    public static void drawLines(JOGLRenderer jr, IndexedLineSet sg) {
        boolean hasNormals;
        double alpha = jr.renderingState.currentAlpha;
        boolean interpolateVertexColors = jr.renderingState.useVertexColors;
        if (sg.getNumEdges() == 0) {
            return;
        }
        GL gl = jr.globalGL;
        DataList vertices = sg.getVertexAttributes(Attribute.COORDINATES);
        vertices = sg.getVertexAttributes(Attribute.COORDINATES);
        int vertexLength = GeometryUtility.getVectorLength(vertices);
        DataList edgeColors = sg.getEdgeAttributes(Attribute.COLORS);
        DataList vertexColors = sg.getVertexAttributes(Attribute.COLORS);
        DataList vertexNormals = sg.getVertexAttributes(Attribute.NORMALS);
        DataList lineWidth = sg.getVertexAttributes(Attribute.RELATIVE_RADII);
        DoubleArray ra = null;
        if (lineWidth != null) {
            ra = lineWidth.toDoubleArray();
        }
        boolean bl = hasNormals = vertexNormals != null;
        if (sg.getEdgeAttributes(Attribute.INDICES) == null) {
            return;
        }
        int colorBind = 0;
        int colorLength = 0;
        if (interpolateVertexColors && vertexColors != null) {
            colorBind = 4;
            colorLength = GeometryUtility.getVectorLength(vertexColors);
        } else if (edgeColors != null) {
            colorBind = 8;
            colorLength = GeometryUtility.getVectorLength(edgeColors);
        } else {
            colorBind = 1;
        }
        if (colorBind != 1 && jr.renderingState.frontBack != 1032) {
            gl.glColorMaterial(1032, 4609);
            jr.renderingState.frontBack = 1032;
        }
        int numEdges = sg.getNumEdges();
        for (int i = 0; i < numEdges; ++i) {
            DoubleArray da;
            gl.glBegin(3);
            int[] ed = sg.getEdgeAttributes(Attribute.INDICES).item(i).toIntArray(null);
            int m = ed.length;
            if (colorBind == 8) {
                da = edgeColors.item(i).toDoubleArray();
                if (colorLength == 3) {
                    gl.glColor4d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), alpha);
                } else if (colorLength == 4) {
                    gl.glColor4d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), alpha * da.getValueAt(3));
                }
            }
            for (int j = 0; j < m; ++j) {
                int k = ed[j];
                if (colorBind == 4) {
                    da = vertexColors.item(k).toDoubleArray();
                    if (colorLength == 3) {
                        gl.glColor4d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), alpha);
                    } else if (colorLength == 4) {
                        gl.glColor4d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), alpha * da.getValueAt(3));
                    }
                }
                if (hasNormals) {
                    da = vertexNormals.item(k).toDoubleArray();
                    gl.glNormal3d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2));
                }
                da = vertices.item(k).toDoubleArray();
                if (vertexLength == 3) {
                    gl.glVertex3d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2));
                    continue;
                }
                if (vertexLength != 4) continue;
                gl.glVertex4d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), da.getValueAt(3));
            }
            gl.glEnd();
        }
    }

    @Deprecated
    public static void drawFaces(JOGLRenderer jr, IndexedFaceSet sg, boolean smooth, double alpha) {
        jr.renderingState.smoothShading = smooth;
        jr.renderingState.currentAlpha = alpha;
        JOGLRendererHelper.drawFaces(jr, sg);
    }

    public static void drawFaces(JOGLRenderer jr, IndexedFaceSet sg) {
        int normalBind;
        boolean smooth = jr.renderingState.smoothShading;
        double alpha = jr.renderingState.currentAlpha;
        if (sg.getNumFaces() == 0) {
            return;
        }
        GL gl = jr.globalGL;
        int colorBind = -1;
        int colorLength = 3;
        DataList vertices = sg.getVertexAttributes(Attribute.COORDINATES);
        DataList vertexNormals = sg.getVertexAttributes(Attribute.NORMALS);
        DataList faceNormals = sg.getFaceAttributes(Attribute.NORMALS);
        DataList vertexColors = sg.getVertexAttributes(Attribute.COLORS);
        DataList faceColors = sg.getFaceAttributes(Attribute.COLORS);
        DataList texCoords = sg.getVertexAttributes(Attribute.TEXTURE_COORDINATES);
        DataList lightMapCoords = sg.getVertexAttributes(Attribute.attributeForName("lightmap coordinates"));
        int textureCount = jr.renderingState.texUnitCount;
        vertices = sg.getVertexAttributes(Attribute.COORDINATES);
        int vertexLength = GeometryUtility.getVectorLength(vertices);
        if (vertexColors != null && (faceColors == null || smooth)) {
            colorBind = 4;
            colorLength = GeometryUtility.getVectorLength(vertexColors);
        } else if (faceColors != null && colorBind != 4) {
            colorBind = 2;
            colorLength = GeometryUtility.getVectorLength(faceColors);
        } else {
            colorBind = 1;
        }
        if (colorBind != 1 && jr.renderingState.frontBack != 1032) {
            gl.glEnable(2903);
            gl.glColorMaterial(1032, 4609);
            jr.renderingState.frontBack = 1032;
        }
        int nFiber = 3;
        if (vertexNormals != null && smooth) {
            normalBind = 4;
            nFiber = GeometryUtility.getVectorLength(vertexNormals);
        } else if (faceNormals != null) {
            normalBind = 2;
            nFiber = GeometryUtility.getVectorLength(faceNormals);
        } else {
            normalBind = 1;
        }
        jr.renderingState.normals4d = nFiber == 4;
        gl.glFogf(2915, nFiber == 4 ? 0.01f : 0.0f);
        DoubleArray da = null;
        boolean isQuadMesh = false;
        boolean isRegularDomainQuadMesh = false;
        Rectangle2D theDomain = null;
        int maxU = 0;
        int maxV = 0;
        int maxFU = 0;
        int maxFV = 0;
        int numV = 0;
        Object qmatt = sg.getGeometryAttributes(GeometryUtility.QUAD_MESH_SHAPE);
        if (qmatt != null && qmatt instanceof Dimension) {
            Dimension dm = (Dimension)qmatt;
            isQuadMesh = true;
            maxU = dm.width;
            maxV = dm.height;
            numV = maxU * maxV;
            maxFU = maxU - 1;
            maxFV = maxV - 1;
        }
        int numF = sg.getNumFaces();
        if (isQuadMesh) {
            double[] pt = new double[3];
            for (int i = 0; i < maxFV; ++i) {
                gl.glBegin(8);
                for (int j = 0; j <= maxFU; ++j) {
                    int u = j % maxU;
                    for (int incr = 0; incr < 2; ++incr) {
                        int vnn = (i * maxU + j % maxU + incr * maxU) % numV;
                        int fnn = (i * maxFU + j % maxFU + incr * maxFU) % numF;
                        int v = (i + incr) % maxV;
                        if (normalBind == 2) {
                            if (incr == 0) {
                                da = faceNormals.item(fnn).toDoubleArray();
                                if (nFiber == 3) {
                                    gl.glNormal3d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2));
                                } else {
                                    gl.glMultiTexCoord4d(33987, da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), da.getValueAt(3));
                                }
                            }
                        } else if (normalBind == 4) {
                            da = vertexNormals.item(vnn).toDoubleArray();
                            if (nFiber == 3) {
                                gl.glNormal3d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2));
                            } else {
                                gl.glMultiTexCoord4d(33987, da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), da.getValueAt(3));
                            }
                        }
                        if (colorBind == 2) {
                            if (incr == 0) {
                                da = faceColors.item(fnn).toDoubleArray();
                                if (colorLength == 3) {
                                    gl.glColor4d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), alpha);
                                } else if (colorLength == 4) {
                                    gl.glColor4d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), alpha * da.getValueAt(3));
                                }
                            }
                        } else if (colorBind == 4) {
                            da = vertexColors.item(vnn).toDoubleArray();
                            if (colorLength == 3) {
                                gl.glColor4d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), alpha);
                            } else if (colorLength == 4) {
                                gl.glColor4d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), alpha * da.getValueAt(3));
                            }
                        }
                        for (int nn = 0; nn < textureCount; ++nn) {
                            int texunit = 33984 + nn;
                            if (nn == 0 && lightMapCoords != null) {
                                da = lightMapCoords.item(vnn).toDoubleArray();
                            } else if (texCoords != null) {
                                da = texCoords.item(vnn).toDoubleArray();
                            }
                            if (da.size() == 2) {
                                gl.glMultiTexCoord2d(texunit, da.getValueAt(0), da.getValueAt(1));
                                continue;
                            }
                            if (da.size() == 3) {
                                gl.glMultiTexCoord3d(texunit, da.getValueAt(0), da.getValueAt(1), da.getValueAt(2));
                                continue;
                            }
                            if (da.size() <= 3) continue;
                            gl.glMultiTexCoord4d(texunit, da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), da.getValueAt(3));
                        }
                        da = vertices.item(vnn).toDoubleArray();
                        if (vertexLength == 1 && isRegularDomainQuadMesh) {
                            double z = da.getValueAt(0);
                            HeightFieldFactory.getCoordinatesForUV(pt, theDomain, u, v, maxU, maxV);
                            gl.glVertex3d(pt[0], pt[1], z);
                            continue;
                        }
                        if (vertexLength == 3) {
                            gl.glVertex3d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2));
                            continue;
                        }
                        if (vertexLength != 4) continue;
                        gl.glVertex4d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), da.getValueAt(3));
                    }
                }
                gl.glEnd();
            }
        } else {
            for (int i = 0; i < sg.getNumFaces(); ++i) {
                if (colorBind == 2) {
                    da = faceColors.item(i).toDoubleArray();
                    if (colorLength == 3) {
                        gl.glColor4d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), alpha);
                    } else if (colorLength == 4) {
                        gl.glColor4d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), alpha * da.getValueAt(3));
                    }
                }
                if (normalBind == 2) {
                    da = faceNormals.item(i).toDoubleArray();
                    if (nFiber == 3) {
                        gl.glNormal3d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2));
                    } else {
                        gl.glMultiTexCoord4d(33987, da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), da.getValueAt(3));
                    }
                }
                IntArray tf = sg.getFaceAttributes(Attribute.INDICES).item(i).toIntArray();
                int nf = tf.getLength();
                gl.glBegin(9);
                for (int j = 0; j < nf; ++j) {
                    int k = tf.getValueAt(j);
                    if (normalBind == 4) {
                        da = vertexNormals.item(k).toDoubleArray();
                        if (nFiber == 3) {
                            gl.glNormal3d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2));
                        } else {
                            gl.glMultiTexCoord4d(33987, da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), da.getValueAt(3));
                        }
                    }
                    if (colorBind == 4) {
                        da = vertexColors.item(k).toDoubleArray();
                        if (colorLength == 3) {
                            gl.glColor4d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), alpha);
                        } else if (colorLength == 4) {
                            gl.glColor4d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), alpha * da.getValueAt(3));
                        }
                    }
                    for (int nn = 0; nn < textureCount; ++nn) {
                        int texunit = 33984 + nn;
                        if (nn == 0 && lightMapCoords != null) {
                            da = lightMapCoords.item(k).toDoubleArray();
                        } else if (texCoords != null) {
                            da = texCoords.item(k).toDoubleArray();
                        }
                        if (da.size() == 2) {
                            gl.glMultiTexCoord2d(texunit, da.getValueAt(0), da.getValueAt(1));
                            continue;
                        }
                        if (da.size() == 3) {
                            gl.glMultiTexCoord3d(texunit, da.getValueAt(0), da.getValueAt(1), da.getValueAt(2));
                            continue;
                        }
                        if (da.size() <= 3) continue;
                        gl.glMultiTexCoord4d(texunit, da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), da.getValueAt(3));
                    }
                    da = vertices.item(k).toDoubleArray();
                    if (vertexLength == 3) {
                        gl.glVertex3d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2));
                        continue;
                    }
                    if (vertexLength != 4) continue;
                    gl.glVertex4d(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), da.getValueAt(3));
                }
                gl.glEnd();
            }
        }
    }

    public static void drawPointLabels(JOGLRenderer jr, PointSet ps, DefaultTextShader ts) {
        if (!ts.getShowLabels().booleanValue()) {
            return;
        }
        Font font = ts.getFont();
        Color c = ts.getDiffuseColor();
        double scale = ts.getScale();
        double[] offset = ts.getOffset();
        int alignment = ts.getAlignment();
        int textorientation = ts.getTextdirection();
        ImageData[] img = ps.getVertexAttributes(Attribute.COLORS) != null ? LabelUtility.createPointImages(ps, font) : LabelUtility.createPointImages(ps, font, c);
        JOGLRendererHelper.renderLabels(jr, img, ps.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(), null, offset, alignment, scale, textorientation);
    }

    public static void drawEdgeLabels(JOGLRenderer jr, IndexedLineSet ils, DefaultTextShader ts) {
        if (!ts.getShowLabels().booleanValue()) {
            return;
        }
        Font font = ts.getFont();
        Color c = ts.getDiffuseColor();
        double scale = ts.getScale();
        double[] offset = ts.getOffset();
        int alignment = ts.getAlignment();
        int textorientation = ts.getTextdirection();
        ImageData[] img = LabelUtility.createEdgeImages(ils, font, c);
        JOGLRendererHelper.renderLabels(jr, img, ils.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(), ils.getEdgeAttributes(Attribute.INDICES).toIntArrayArray(), offset, alignment, scale, textorientation);
    }

    public static void drawFaceLabels(JOGLRenderer jr, IndexedFaceSet ifs, DefaultTextShader ts) {
        if (!ts.getShowLabels().booleanValue()) {
            return;
        }
        Font font = ts.getFont();
        Color c = ts.getDiffuseColor();
        double scale = ts.getScale();
        double[] offset = ts.getOffset();
        int alignment = ts.getAlignment();
        int textorientation = ts.getTextdirection();
        ImageData[] img = LabelUtility.createFaceImages(ifs, font, c);
        JOGLRendererHelper.renderLabels(jr, img, ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(), ifs.getFaceAttributes(Attribute.INDICES).toIntArrayArray(), offset, alignment, scale, textorientation);
    }

    private static void renderLabels(JOGLRenderer jr, ImageData[] labels, DoubleArrayArray vertices, IntArrayArray indices, double[] offset, int alignment, double scale, int textorientation) {
        if (labels == null) {
            return;
        }
        GL gl = jr.globalGL;
        gl.glPushAttrib(8192);
        gl.glEnable(3042);
        gl.glDisable(2896);
        gl.glDepthMask(true);
        JOGLConfiguration.glBlendFunc(gl, false);
        gl.glColor3d(1.0, 1.0, 1.0);
        double[] c2o = jr.getContext().getCameraToObject();
        gl.glActiveTexture(33984);
        gl.glEnable(3553);
        jr.renderingState.texUnitCount = 1;
        double[] bbm = new double[16];
        jr.renderingState.smoothShading = true;
        jr.renderingState.currentAlpha = 1.0;
        int n = labels.length;
        for (int i = 0; i < n; ++i) {
            ImageData img = labels[i];
            tex2d.setImage(img);
            LabelUtility.calculateBillboardMatrix(bbm, (double)img.getWidth() * scale, (double)img.getHeight() * scale, offset, alignment, c2o, LabelUtility.positionFor(i, vertices, indices), jr.renderingState.currentMetric, textorientation);
            Texture2DLoaderJOGL.render(gl, tex2d);
            gl.glPushMatrix();
            gl.glMultTransposeMatrixd(bbm, 0);
            JOGLRendererHelper.drawFaces(jr, bb);
            gl.glPopMatrix();
        }
        gl.glPopAttrib();
        jr.renderingState.texUnitCount = 0;
    }

    public static void processClippingPlanes(JOGLRenderer jr, List<SceneGraphPath> clipPlanes) {
        int n = clipPlanes.size();
        jr.renderingState.currentClippingPlane = 12288;
        for (int i = 0; i < n; ++i) {
            SceneGraphPath lp = clipPlanes.get(i);
            SceneGraphNode cp = lp.getLastElement();
            if (!(cp instanceof ClippingPlane)) {
                JOGLConfiguration.theLog.log(Level.WARNING, "Invalid clipplane class " + cp.getClass().toString());
                continue;
            }
            if (((ClippingPlane)cp).isLocal()) continue;
            double[] mat = lp.getMatrix(null);
            jr.globalGL.glPushMatrix();
            jr.globalGL.glMultTransposeMatrixd(mat, 0);
            JOGLRendererHelper.pushClippingPlane(jr, clipPlane);
            jr.globalGL.glPopMatrix();
        }
    }

    public static void pushClippingPlane(JOGLRenderer jr, double[] plane) {
        GL gl = jr.globalGL;
        gl.glClipPlane(jr.renderingState.currentClippingPlane, plane == null ? clipPlane : plane, 0);
        gl.glEnable(jr.renderingState.currentClippingPlane);
        ++jr.renderingState.currentClippingPlane;
    }

    public static void popClippingPlane(JOGLRenderer jr) {
        --jr.renderingState.currentClippingPlane;
        jr.globalGL.glDisable(jr.renderingState.currentClippingPlane);
    }

    static {
        tex2d.setRepeatS(10496);
        tex2d.setRepeatT(10496);
        correctionNDC = null;
        correctionNDC = Rn.identityMatrix(4);
        JOGLRendererHelper.correctionNDC[11] = 0.5;
        JOGLRendererHelper.correctionNDC[10] = 0.5;
        clipPlane = new double[]{0.0, 0.0, -1.0, 0.0};
    }
}

