/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.jogl.ConstructPeerGraphVisitor;
import de.jreality.jogl.GeometryGoBetween;
import de.jreality.jogl.GoBetween;
import de.jreality.jogl.JOGLConfiguration;
import de.jreality.jogl.JOGLCylinderUtility;
import de.jreality.jogl.JOGLLightHelper;
import de.jreality.jogl.JOGLOffscreenRenderer;
import de.jreality.jogl.JOGLPeerComponent;
import de.jreality.jogl.JOGLPerformanceMeter;
import de.jreality.jogl.JOGLRendererHelper;
import de.jreality.jogl.JOGLRenderingState;
import de.jreality.jogl.JOGLSkyBox;
import de.jreality.jogl.JOGLSphereHelper;
import de.jreality.jogl.JOGLTopLevelAppearance;
import de.jreality.jogl.pick.PickPoint;
import de.jreality.jogl.shader.RenderingHintsInfo;
import de.jreality.jogl.shader.Texture2DLoaderJOGL;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Viewer;
import de.jreality.scene.pick.Graphics3D;
import de.jreality.util.CameraUtility;
import de.jreality.util.CopyVisitor;
import de.jreality.util.LoggingSystem;
import de.jreality.util.SceneGraphUtility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.opengl.DebugGL;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLPbuffer;

public class JOGLRenderer {
    public GL globalGL;
    protected SceneGraphComponent theRoot;
    protected SceneGraphComponent auxiliaryRoot;
    protected transient JOGLPeerComponent thePeerRoot = null;
    protected transient JOGLPeerComponent thePeerAuxilliaryRoot = null;
    public transient JOGLRenderingState renderingState;
    protected transient JOGLLightHelper lightHelper;
    protected transient JOGLTopLevelAppearance topAp;
    protected transient JOGLOffscreenRenderer offscreenRenderer;
    protected transient JOGLPerformanceMeter perfMeter;
    protected transient GeometryGoBetween geometryGB;
    protected transient int width;
    protected transient int height;
    protected transient int whichEye = 0;
    protected transient int[] currentViewport = new int[4];
    private final transient Logger theLog = LoggingSystem.getLogger(this);
    protected static final transient int MAX_STACK_DEPTH = 28;
    protected transient Matrix[] matrixStack = new Matrix[128];
    protected transient int stackCounter;
    protected transient int stackDepth;
    protected transient Stack<RenderingHintsInfo> rhStack = new Stack();
    protected transient int numberTries = 0;
    protected transient int clearColorBits;
    protected transient boolean offscreenMode = false;
    public static transient double[] frontZBuffer = new double[16];
    public static transient double[] backZBuffer = new double[16];
    protected transient boolean lightListDirty = true;
    protected transient boolean lightsChanged = true;
    protected transient boolean clippingPlanesDirty = true;
    protected transient boolean disposed = false;
    protected transient boolean frontBanana = false;
    protected transient boolean texResident = true;
    protected Viewer theViewer;
    protected boolean supportGLSL = false;
    Camera theCamera;
    List clipPlanes = null;
    List<SceneGraphPath> lights = null;
    protected int[] whichTile = new int[2];

    public JOGLRenderer(Viewer viewer) {
        this.theViewer = viewer;
        this.offscreenRenderer = new JOGLOffscreenRenderer(this);
        this.perfMeter = new JOGLPerformanceMeter(this);
        this.geometryGB = new GeometryGoBetween(this);
        this.setAuxiliaryRoot(viewer.getAuxiliaryRoot());
    }

    public void dispose() {
        this.disposed = true;
        this.lightHelper.disposeLights();
        this.setSceneRoot(null);
        this.setAuxiliaryRoot(null);
        Texture2DLoaderJOGL.deleteAllTextures(this.globalGL);
        if (this.topAp != null) {
            this.topAp.dispose();
        }
        LoggingSystem.getLogger(this).info("gobetween table has " + GoBetween.rendererTable.get(this).size());
        LoggingSystem.getLogger(this).info("geom table has " + this.geometryGB.geometries.size());
        this.geometryGB.dispose();
    }

    public int getStereoType() {
        return this.renderingState.stereoType;
    }

    public void setStereoType(int stereoType) {
        this.renderingState.stereoType = stereoType;
    }

    public Viewer getViewer() {
        return this.theViewer;
    }

    private void setSceneRoot(SceneGraphComponent sgc) {
        if (this.topAp != null) {
            this.topAp.dispose();
        }
        this.theRoot = sgc;
        this.topAp = this.theRoot != null && this.theRoot.getAppearance() != null ? new JOGLTopLevelAppearance(this.theRoot.getAppearance()) : new JOGLTopLevelAppearance(new Appearance("dummy root appearance"));
        if (this.thePeerRoot == null) {
            return;
        }
        this.thePeerRoot.dispose();
        this.thePeerRoot = null;
        this.theLog.fine("setSceneRoot");
    }

    public SceneGraphComponent getAuxiliaryRoot() {
        return this.auxiliaryRoot;
    }

    public void setAuxiliaryRoot(SceneGraphComponent auxiliaryRoot) {
        this.auxiliaryRoot = auxiliaryRoot;
        if (this.thePeerAuxilliaryRoot != null) {
            this.thePeerAuxilliaryRoot.dispose();
        }
        if (auxiliaryRoot != null) {
            this.thePeerAuxilliaryRoot = ConstructPeerGraphVisitor.constructPeerForSceneGraphComponent(auxiliaryRoot, null, this);
        }
    }

    public void render() {
        if (this.disposed) {
            return;
        }
        Texture2DLoaderJOGL.postRender(this.globalGL);
        if (this.thePeerRoot == null || this.theViewer.getSceneRoot() != this.thePeerRoot.getOriginalComponent()) {
            this.setSceneRoot(this.theViewer.getSceneRoot());
            this.thePeerRoot = ConstructPeerGraphVisitor.constructPeerForSceneGraphComponent(this.theRoot, null, this);
        }
        if (this.auxiliaryRoot != null && this.thePeerAuxilliaryRoot == null) {
            this.thePeerAuxilliaryRoot = ConstructPeerGraphVisitor.constructPeerForSceneGraphComponent(this.auxiliaryRoot, null, this);
        }
        this.renderingState.context = new Graphics3D(this.theViewer.getCameraPath(), this.renderingState.currentPath, CameraUtility.getAspectRatio(this.theViewer));
        this.globalGL.glMatrixMode(5889);
        this.globalGL.glLoadIdentity();
        JOGLRendererHelper.handleBackground(this, this.width, this.height, this.theRoot.getAppearance());
        this.frontBanana = true;
        this.renderOnePass();
        if (this.topAp.isRenderSpherical()) {
            this.frontBanana = false;
            this.renderOnePass();
        }
        if (this.topAp.isForceResidentTextures()) {
            this.forceResidentTextures();
        }
        this.lightListDirty = false;
    }

    private void renderOnePass() {
        if (this.theCamera == null) {
            return;
        }
        double aspectRatio = this.getAspectRatio();
        this.globalGL.glMatrixMode(5889);
        this.globalGL.glLoadIdentity();
        if (this.topAp.isRenderSpherical()) {
            this.globalGL.glMultTransposeMatrixd(this.frontBanana ? frontZBuffer : backZBuffer, 0);
        }
        double[] c2ndc = CameraUtility.getCameraToNDC(this.theCamera, aspectRatio, this.whichEye);
        this.globalGL.glMultTransposeMatrixd(c2ndc, 0);
        this.globalGL.glMatrixMode(5888);
        this.globalGL.glLoadIdentity();
        this.renderingState.cameraToWorld = this.renderingState.context.getCameraToWorld();
        this.renderingState.worldToCamera = Rn.inverse(null, this.renderingState.cameraToWorld);
        this.globalGL.glMultTransposeMatrixd(this.renderingState.worldToCamera, 0);
        if (this.topAp.getSkyboxCubemap() != null) {
            JOGLSkyBox.render(this.globalGL, this.renderingState.worldToCamera, this.topAp.getSkyboxCubemap(), CameraUtility.getCamera(this.theViewer));
        }
        this.processLights();
        this.processClippingPlanes();
        this.rhStack.clear();
        this.rhStack.push(RenderingHintsInfo.defaultRHInfo);
        RenderingHintsInfo.defaultRHInfo.render(this.renderingState, null);
        this.renderingState.flipped = Rn.determinant(this.renderingState.worldToCamera) < 0.0;
        this.globalGL.glFrontFace(this.renderingState.flipped ? 2304 : 2305);
        this.texResident = true;
        this.renderingState.currentPath.clear();
        this.thePeerRoot.render();
        if (this.thePeerAuxilliaryRoot != null) {
            this.thePeerAuxilliaryRoot.render();
        }
        if (this.topAp.isRenderSpherical() && !this.frontBanana) {
            this.globalGL.glPopMatrix();
        }
        this.globalGL.glLoadIdentity();
    }

    private void processClippingPlanes() {
        if (this.clipPlanes == null || this.clippingPlanesDirty) {
            this.clipPlanes = SceneGraphUtility.collectClippingPlanes(this.theRoot);
        }
        JOGLRendererHelper.processClippingPlanes(this, this.clipPlanes);
        this.clippingPlanesDirty = false;
    }

    private void processLights() {
        if (this.lights == null || this.lights.size() == 0 || this.lightListDirty) {
            this.lightHelper.disposeLights();
            this.lights = SceneGraphUtility.collectLights(this.theRoot);
            this.lightHelper.resetLights(this.globalGL, this.lights);
            this.lightListDirty = false;
            this.renderingState.numLights = this.lights.size();
            this.lightsChanged = true;
        }
        this.lightHelper.enableLights(this.globalGL, this.lights.size());
        if (this.lightsChanged) {
            this.lightHelper.cacheLightMatrices(this.lights);
            this.lightsChanged = false;
        }
        this.lightHelper.processLights(this.globalGL, this.lights);
    }

    private void forceResidentTextures() {
        if (!this.texResident && this.numberTries < 3) {
            final Viewer theV = this.theViewer;
            TimerTask rerenderTask = new TimerTask(){

                public void run() {
                    theV.render();
                }
            };
            Timer doIt = new Timer();
            this.forceNewDisplayLists();
            doIt.schedule(rerenderTask, 10L);
            ++this.numberTries;
            JOGLConfiguration.theLog.log(Level.WARNING, "Textures not resident");
        } else {
            this.numberTries = 0;
        }
    }

    private void forceNewDisplayLists() {
        if (this.thePeerRoot != null) {
            this.thePeerRoot.setDisplayListDirty();
        }
        if (this.thePeerAuxilliaryRoot != null) {
            this.thePeerAuxilliaryRoot.setDisplayListDirty();
        }
    }

    public double getFramerate() {
        return this.perfMeter.getFramerate();
    }

    public double getClockrate() {
        return this.perfMeter.getClockrate();
    }

    public int getPolygonCount() {
        return this.renderingState.polygonCount;
    }

    protected void myglViewport(int lx, int ly, int rx, int ry) {
        this.globalGL.glViewport(lx, ly, rx, ry);
        this.currentViewport[0] = lx;
        this.currentViewport[1] = ly;
        this.currentViewport[2] = rx;
        this.currentViewport[3] = ry;
    }

    public Graphics3D getContext() {
        return this.renderingState.context;
    }

    public int[] getCurrentViewport() {
        return this.currentViewport;
    }

    public double getAspectRatio() {
        return (double)this.currentViewport[2] / (double)this.currentViewport[3];
    }

    public void init(GLAutoDrawable drawable) {
        GLAutoDrawable theCanvas;
        if (JOGLConfiguration.debugGL) {
            drawable.setGL((GL)new DebugGL(drawable.getGL()));
        }
        if (!((theCanvas = drawable) instanceof GLPbuffer)) {
            this.width = theCanvas.getWidth();
            this.height = theCanvas.getHeight();
        }
        this.init(drawable.getGL());
    }

    public void init(GL gl) {
        this.globalGL = gl;
        this.renderingState = new JOGLRenderingState(this);
        this.lightHelper = new JOGLLightHelper(this);
        String vv = this.globalGL.glGetString(7938);
        if (vv != null) {
            String majorNumber;
            int index = vv.indexOf(".");
            if (index > -1 && Integer.parseInt(majorNumber = vv.substring(0, index)) >= 2) {
                this.supportGLSL = true;
            }
        } else {
            this.supportGLSL = false;
        }
        this.supportGLSL = gl.isExtensionAvailable("GL_ARB_shading_language_100");
        if (this.supportGLSL) {
            this.supportGLSL = !gl.isExtensionAvailable("GLX_MESA_allocate_memory");
            this.supportGLSL = !gl.isExtensionAvailable("GLX_MESA_swap_control");
            this.supportGLSL = !gl.isExtensionAvailable("GLX_MESA_copy_sub_buffer");
        }
        this.theLog.log(Level.FINE, "new GL: " + gl);
        this.theLog.log(Level.FINE, "version: " + vv);
        this.lightsChanged = true;
        Texture2DLoaderJOGL.deleteAllTextures(this.globalGL);
        JOGLCylinderUtility.setupCylinderDLists(this);
        JOGLSphereHelper.setupSphereDLists(this);
        if (this.thePeerRoot != null) {
            this.thePeerRoot.propagateGeometryChanged(7);
        }
        if (this.thePeerAuxilliaryRoot != null) {
            this.thePeerAuxilliaryRoot.propagateGeometryChanged(7);
        }
    }

    public void displayChanged(GLAutoDrawable arg0, boolean arg1, boolean arg2) {
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public void reshape(GLAutoDrawable arg0, int arg1, int arg2, int arg3, int arg4) {
        this.globalGL = arg0.getGL();
        this.width = arg3 - arg1;
        this.height = arg4 - arg2;
        this.myglViewport(0, 0, this.width, this.height);
    }

    public void display(GLAutoDrawable drawable) {
        if (this.theViewer.getSceneRoot() == null || this.theViewer.getCameraPath() == null) {
            this.theLog.info("display called w/o scene root or camera path");
        }
        this.display(drawable.getGL());
    }

    public void display(GL gl) {
        this.globalGL = gl;
        this.perfMeter.beginFrame();
        this.renderingState.initializeGLState();
        this.renderingState.currentEye = 0;
        this.clearColorBits = this.renderingState.clearColorBuffer ? 16384 : 0;
        try {
            this.theCamera = CameraUtility.getCamera(this.theViewer);
        }
        catch (IllegalStateException ise) {
            return;
        }
        if (this.offscreenMode) {
            if (this.theCamera.isStereo() && this.renderingState.stereoType != 0) {
                this.theLog.warning("Invalid stereo mode: Can only save cross-eyed stereo offscreen");
                this.offscreenMode = false;
                return;
            }
            GLContext context = this.offscreenRenderer.getOffscreenPBuffer().getContext();
            if (context.makeCurrent() == 0) {
                JOGLConfiguration.getLogger().log(Level.WARNING, "Error making pbuffer's context current");
                this.offscreenMode = false;
                return;
            }
            this.globalGL = this.offscreenRenderer.getOffscreenPBuffer().getGL();
            this.forceNewDisplayLists();
            this.renderingState.initializeGLState();
            CopyVisitor copier = new CopyVisitor();
            copier.visit(this.theCamera);
            Camera offscreenCamera = this.theCamera = (Camera)copier.getCopy();
            Color[] bg = null;
            Object bgColors = null;
            int tileSizeX = this.offscreenRenderer.getTileSizeX();
            int tileSizeY = this.offscreenRenderer.getTileSizeY();
            int numTiles = this.offscreenRenderer.getNumTiles();
            if (numTiles > 1 && this.theRoot.getAppearance() != null && this.theRoot.getAppearance().getAttribute("backgroundColors", Color[].class) != Appearance.INHERITED) {
                bg = (Color[])this.theRoot.getAppearance().getAttribute("backgroundColors", Color[].class);
                bgColors = new float[4][];
                bgColors[0] = bg[0].getRGBComponents(null);
                bgColors[1] = bg[1].getRGBComponents(null);
                bgColors[2] = bg[2].getRGBComponents(null);
                bgColors[3] = bg[3].getRGBComponents(null);
            }
            double[] c2ndc = CameraUtility.getCameraToNDC(offscreenCamera, CameraUtility.getAspectRatio(this.theViewer), 0);
            int numImages = offscreenCamera.isStereo() ? 2 : 1;
            Rectangle2D vp = CameraUtility.getViewport(this.theCamera, this.getAspectRatio());
            this.myglViewport(0, 0, tileSizeX /= numImages, tileSizeY);
            double dx = vp.getWidth() / (double)numTiles;
            double dy = vp.getHeight() / (double)numTiles;
            boolean isOnAxis = offscreenCamera.isOnAxis();
            offscreenCamera.setOnAxis(false);
            for (int st = 0; st < numImages; ++st) {
                this.whichEye = offscreenCamera.isStereo() ? (st == 0 ? 2 : 1) : 0;
                for (int i = 0; i < numTiles; ++i) {
                    for (int j = 0; j < numTiles; ++j) {
                        this.whichTile[0] = j;
                        this.whichTile[1] = i;
                        this.renderingState.clearBufferBits = this.clearColorBits | 0x100;
                        Rectangle2D.Double lr = new Rectangle2D.Double(vp.getX() + (double)j * dx, vp.getY() + (double)i * dy, dx, dy);
                        offscreenCamera.setViewPort(lr);
                        c2ndc = CameraUtility.getCameraToNDC(offscreenCamera, CameraUtility.getAspectRatio(this.theViewer), 0);
                        if (bgColors != null) {
                            Color[] currentBg = new Color[4];
                            currentBg[1] = this.interpolateBG((float[][])bgColors, i + 1, j, numTiles);
                            currentBg[2] = this.interpolateBG((float[][])bgColors, i, j, numTiles);
                            currentBg[3] = this.interpolateBG((float[][])bgColors, i, j + 1, numTiles);
                            currentBg[0] = this.interpolateBG((float[][])bgColors, i + 1, j + 1, numTiles);
                            this.theRoot.getAppearance().setAttribute("backgroundColors", currentBg);
                        }
                        this.render();
                        this.globalGL.glPixelStorei(3330, numImages * numTiles * tileSizeX);
                        this.globalGL.glPixelStorei(3331, i * tileSizeY);
                        this.globalGL.glPixelStorei(3332, (st * numTiles + j) * tileSizeX);
                        this.globalGL.glPixelStorei(3333, 1);
                        this.globalGL.glReadPixels(0, 0, tileSizeX, tileSizeY, 6408, 5121, this.offscreenRenderer.getOffscreenBuffer());
                    }
                }
            }
            if (bgColors != null) {
                this.theRoot.getAppearance().setAttribute("backgroundColors", bg);
            }
            context.release();
            this.theCamera = CameraUtility.getCamera(this.theViewer);
            Dimension d = this.theViewer.getViewingComponentSize();
            this.myglViewport(0, 0, (int)d.getWidth(), (int)d.getHeight());
            this.offscreenMode = false;
        } else if (this.theCamera.isStereo()) {
            this.setupRightEye(this.width, this.height);
            this.renderingState.currentEye = this.whichEye;
            this.render();
            this.setupLeftEye(this.width, this.height);
            this.renderingState.currentEye = this.whichEye;
            this.render();
            this.renderingState.colorMask = 15;
        } else {
            this.renderingState.clearBufferBits = this.clearColorBits | 0x100;
            this.myglViewport(0, 0, this.width, this.height);
            this.whichEye = 0;
            this.render();
        }
        this.perfMeter.endFrame();
    }

    private Color interpolateBG(float[][] bgColors, int i, int j, int numTiles) {
        float[] col = new float[bgColors[0].length];
        float alpha = (float)j / (float)numTiles;
        float beta = 1.0f - (float)i / (float)numTiles;
        for (int k = 0; k < col.length; ++k) {
            col[k] = alpha * (1.0f - beta) * bgColors[0][k] + (1.0f - alpha) * (1.0f - beta) * bgColors[1][k] + beta * (1.0f - alpha) * bgColors[2][k] + alpha * beta * bgColors[3][k];
        }
        if (col.length == 3) {
            return new Color(col[0], col[1], col[2]);
        }
        return new Color(col[0], col[1], col[2], col[3]);
    }

    protected void setupRightEye(int width, int height) {
        int which = this.renderingState.stereoType;
        switch (which) {
            case 0: {
                this.renderingState.clearBufferBits = this.clearColorBits | 0x100;
                int w = width / 2;
                int h = height;
                this.myglViewport(0, 0, w, h);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.myglViewport(0, 0, width, height);
                this.renderingState.clearBufferBits = this.clearColorBits | 0x100;
                if (which == 2) {
                    this.renderingState.colorMask = 10;
                    break;
                }
                if (which == 1) {
                    this.renderingState.colorMask = 12;
                    break;
                }
                if (which != 3) break;
                this.renderingState.colorMask = 14;
                break;
            }
            case 4: {
                this.myglViewport(0, 0, width, height);
                this.renderingState.clearBufferBits = this.clearColorBits | 0x100;
                this.globalGL.glDrawBuffer(1027);
            }
        }
        this.whichEye = 2;
    }

    protected void setupLeftEye(int width, int height) {
        int which = this.renderingState.stereoType;
        switch (which) {
            case 0: {
                int w = width / 2;
                int h = height;
                this.renderingState.clearBufferBits = 0;
                this.myglViewport(w, 0, w, h);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.renderingState.colorMask = 9;
                this.renderingState.clearBufferBits = 256;
                break;
            }
            case 4: {
                this.globalGL.glDrawBuffer(1026);
                this.renderingState.clearBufferBits = this.clearColorBits | 0x100;
            }
        }
        this.whichEye = 1;
    }

    public PickPoint[] performPick(double[] pickPointNDC) {
        throw new IllegalArgumentException("Picking has been removed from JOGL renderer");
    }

    public boolean supportGLSL() {
        return this.supportGLSL;
    }

    static {
        MatrixBuilder.euclidean().translate(0.0, 0.0, -0.5).scale(1.0, 1.0, 0.5).assignTo(frontZBuffer);
        MatrixBuilder.euclidean().translate(0.0, 0.0, 0.5).scale(1.0, 1.0, 0.5).assignTo(backZBuffer);
        Rn.times(backZBuffer, -1.0, backZBuffer);
    }
}

