/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.jogl.JOGLRenderer;

public class JOGLPerformanceMeter {
    private static transient boolean collectFrameRate = true;
    protected transient double framerate;
    protected transient int nodeCount = 0;
    transient int frameCount = 0;
    transient long[] history = new long[20];
    transient long[] clockTime = new long[20];
    transient long beginRenderTime;
    private JOGLRenderer jr;

    protected JOGLPerformanceMeter(JOGLRenderer jr) {
        this.jr = jr;
    }

    protected void beginFrame() {
        this.jr.renderingState.polygonCount = 0;
        this.nodeCount = 0;
        if (collectFrameRate) {
            this.beginRenderTime = System.currentTimeMillis();
        }
    }

    protected void endFrame() {
        ++this.frameCount;
        int j = this.frameCount % 20;
        this.clockTime[j] = this.beginRenderTime;
        this.history[j] = System.currentTimeMillis() - this.beginRenderTime;
    }

    public double getFramerate() {
        long totalTime = 0L;
        for (int i = 0; i < 20; ++i) {
            totalTime += this.history[i];
        }
        this.framerate = 20000.0 / (double)totalTime;
        return this.framerate;
    }

    public double getClockrate() {
        int j = this.frameCount % 20;
        int k = (this.frameCount + 1) % 20;
        long totalTime = this.clockTime[j] - this.clockTime[k];
        double clockrate = 20000.0 / (double)totalTime;
        return clockrate;
    }
}

