/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.jogl.ConstructPeerGraphVisitor;
import de.jreality.jogl.GoBetween;
import de.jreality.jogl.JOGLPeerNode;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.jogl.JOGLRendererHelper;
import de.jreality.jogl.shader.DefaultGeometryShader;
import de.jreality.jogl.shader.RenderingHintsInfo;
import de.jreality.math.Matrix;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.Lock;
import de.jreality.scene.Scene;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.event.AppearanceEvent;
import de.jreality.scene.event.AppearanceListener;
import de.jreality.scene.event.SceneGraphComponentEvent;
import de.jreality.scene.event.SceneGraphComponentListener;
import de.jreality.scene.event.TransformationEvent;
import de.jreality.scene.event.TransformationListener;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.util.LoggingSystem;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;

public class JOGLPeerComponent
extends JOGLPeerNode
implements TransformationListener,
AppearanceListener,
SceneGraphComponentListener {
    protected EffectiveAppearance eAp;
    protected Vector<JOGLPeerComponent> children;
    protected JOGLPeerComponent parent;
    protected int childIndex;
    protected int metric = 0;
    protected GoBetween goBetween;
    double determinant = 0.0;
    double[] cachedTform = new double[16];
    boolean useTformCaching = true;
    Appearance thisAp;
    RenderingHintsInfo rhInfo;
    DefaultGeometryShader geometryShader;
    Lock childlock = new Lock();
    protected Runnable renderGeometry = null;
    final JOGLPeerComponent self = this;
    transient boolean isReflection = false;
    transient boolean isIdentity = false;
    transient boolean cumulativeIsReflection = false;
    transient boolean effectiveAppearanceDirty = true;
    transient boolean appearanceDirty = true;
    transient boolean originalAppearanceDirty = false;
    transient boolean geometryIsDirty = true;
    transient boolean boundIsDirty = true;
    transient boolean renderRunnableDirty = true;
    transient boolean isVisible = true;
    transient boolean transparencyEnabled = false;
    int geometryDirtyBits = 7;
    int displayList = -1;
    protected int childCount = 0;
    long lastDisplayListCreationTime = 0L;
    protected static final int POINTS_CHANGED = 1;
    protected static final int LINES_CHANGED = 2;
    protected static final int FACES_CHANGED = 4;
    protected static final int ALL_GEOMETRY_CHANGED = 7;
    protected static final int POINT_SHADER_CHANGED = 8;
    protected static final int LINE_SHADER_CHANGED = 16;
    protected static final int POLYGON_SHADER_CHANGED = 32;
    protected static final int ALL_SHADERS_CHANGED = 56;
    protected static final int ALL_CHANGED = 63;
    public static int count = 0;
    static boolean debug = false;
    HashMap<SceneGraphComponent, GoBetween> goBetweenTable = new HashMap();
    boolean mustPop = false;
    boolean oldFlipped;

    public JOGLPeerComponent() {
    }

    public JOGLPeerComponent(SceneGraphPath sgp, JOGLPeerComponent p, JOGLRenderer jr) {
        this.init(sgp, p, jr);
    }

    public void init(SceneGraphPath sgp, JOGLPeerComponent p, JOGLRenderer jr) {
        this.init(null, sgp, p, jr);
    }

    public void init(GoBetween gb, SceneGraphPath sgp, JOGLPeerComponent p, JOGLRenderer jr) {
        this.jr = jr;
        if (sgp == null || !(sgp.getLastElement() instanceof SceneGraphComponent)) {
            throw new IllegalArgumentException("Not a valid SceneGraphComponenet");
        }
        this.goBetween = gb == null ? GoBetween.goBetweenFor(jr, sgp.getLastComponent(), false) : gb;
        this.goBetween.addJOGLPeer(this);
        this.name = "JOGLPeer:" + this.goBetween.originalComponent.getName();
        this.children = new Vector();
        this.parent = p;
        this.updateTransformationInfo();
        this.isVisible = this.goBetween.originalComponent.isVisible();
        ++count;
    }

    protected void updateRenderRunnable() {
        if (debug) {
            theLog.finer("updateRenderRunnable: " + this.name);
        }
        this.setDisplayListDirty();
        this.geometryDirtyBits = 7;
        this.renderGeometry = this.goBetween.peerGeometry == null ? null : new Runnable(){

            public void run() {
                JOGLPeerComponent.this.goBetween.peerGeometry.render(JOGLPeerComponent.this.self);
            }
        };
        this.renderRunnableDirty = false;
    }

    public void dispose() {
        for (JOGLPeerComponent child : this.children) {
            child.dispose();
        }
        this.children.clear();
        this.goBetween.removeJOGLPeer(this);
    }

    public void render() {
        if (!this.isVisible) {
            return;
        }
        this.preRender();
        this.renderChildren();
        this.postRender();
    }

    private void preRender() {
        if (this.renderRunnableDirty) {
            this.updateRenderRunnable();
        }
        this.jr.renderingState.currentPath.push(this.goBetween.originalComponent);
        if (debug) {
            theLog.finest("prerender: " + this.name);
        }
        if (this.useTformCaching) {
            if (this.cachedTform != null && !this.isIdentity) {
                this.pushTransformation(this.cachedTform);
                this.mustPop = true;
            }
        } else if (this.goBetween.originalComponent.getTransformation() != null) {
            this.pushTransformation(this.goBetween.originalComponent.getTransformation().getMatrix());
            this.mustPop = true;
        }
        this.oldFlipped = this.jr.renderingState.flipped;
        this.jr.renderingState.flipped = this.isReflection ^ this.jr.renderingState.flipped;
        if (this.oldFlipped != this.jr.renderingState.flipped) {
            this.jr.globalGL.glFrontFace(this.jr.renderingState.flipped ? 2304 : 2305);
        }
        if (this.appearanceDirty) {
            this.handleAppearanceChanged();
        }
        if (this.geometryDirtyBits != 0) {
            this.handleChangedGeometry();
        }
        this.jr.renderingState.currentMetric = this.metric;
        if (this.rhInfo != null && this.rhInfo.hasSomeActiveField) {
            this.rhInfo.render(this.jr.renderingState, (RenderingHintsInfo)this.jr.rhStack.lastElement());
            this.jr.rhStack.push(this.rhInfo);
        }
        if (this.goBetween.peerGeometry != null && this.goBetween.peerGeometry.localClippingPlane) {
            JOGLRendererHelper.pushClippingPlane(this.jr, null);
        } else if (this.renderGeometry != null && this.goBetween.peerGeometry != null) {
            Scene.executeReader(this.goBetween.peerGeometry.originalGeometry, this.renderGeometry);
        }
    }

    protected void renderChildren() {
        this.childlock.readLock();
        for (JOGLPeerComponent child : this.children) {
            child.render();
        }
        this.childlock.readUnlock();
    }

    private void postRender() {
        if (this.goBetween.peerGeometry != null && this.goBetween.peerGeometry.localClippingPlane) {
            JOGLRendererHelper.popClippingPlane(this.jr);
        }
        if (this.rhInfo != null && this.rhInfo.hasSomeActiveField) {
            this.jr.rhStack.pop();
            this.rhInfo.postRender(this.jr.renderingState, (RenderingHintsInfo)this.jr.rhStack.lastElement());
        }
        if (this.mustPop) {
            this.popTransformation();
            this.mustPop = false;
        }
        if (this.jr.renderingState.flipped != this.oldFlipped) {
            this.jr.renderingState.flipped = this.oldFlipped;
            this.jr.globalGL.glFrontFace(this.jr.renderingState.flipped ? 2304 : 2305);
        }
        this.jr.renderingState.currentPath.pop();
    }

    protected void pushTransformation(double[] m) {
        if (this.jr.stackDepth < 28) {
            this.jr.globalGL.glPushMatrix();
            this.jr.globalGL.glMultTransposeMatrixd(m, 0);
        } else {
            int stackCounter = this.jr.stackDepth - 28;
            if (stackCounter == 0) {
                this.jr.matrixStack[0] = new Matrix(this.jr.renderingState.context.getObjectToCamera());
            } else {
                if (stackCounter >= this.jr.matrixStack.length) {
                    Matrix[] newstack = new Matrix[this.jr.matrixStack.length * 2];
                    System.arraycopy(this.jr.matrixStack, 0, newstack, 0, this.jr.matrixStack.length);
                    this.jr.matrixStack = newstack;
                }
                if (this.jr.matrixStack[stackCounter] == null) {
                    this.jr.matrixStack[stackCounter] = new Matrix();
                }
                Rn.times(this.jr.matrixStack[stackCounter].getArray(), this.jr.matrixStack[stackCounter - 1].getArray(), this.cachedTform);
            }
            this.jr.globalGL.glLoadTransposeMatrixd(this.jr.matrixStack[stackCounter].getArray(), 0);
        }
        ++this.jr.stackDepth;
    }

    protected void popTransformation() {
        if (this.jr.stackDepth <= 28) {
            this.jr.globalGL.glPopMatrix();
        }
        --this.jr.stackDepth;
    }

    protected void setIndexOfChildren() {
        this.childlock.readLock();
        this.childCount = this.children.size();
        int n = this.goBetween.originalComponent.getChildComponentCount();
        for (int i = 0; i < n; ++i) {
            SceneGraphComponent sgc = this.goBetween.originalComponent.getChildComponent(i);
            JOGLPeerComponent jpc = this.getPeerForChildComponent(sgc);
            if (jpc == null) {
                theLog.log(Level.WARNING, "No peer for sgc " + sgc.getName());
                jpc.childIndex = -1;
                continue;
            }
            jpc.childIndex = i;
        }
        this.childlock.readUnlock();
    }

    private JOGLPeerComponent getPeerForChildComponent(SceneGraphComponent sgc) {
        for (JOGLPeerComponent jpc : this.children) {
            if (jpc.goBetween.originalComponent != sgc) continue;
            return jpc;
        }
        return null;
    }

    public void appearanceChanged(AppearanceEvent ev) {
        this.originalAppearanceDirty = true;
        this.appearanceDirty = true;
    }

    private void handleNewAppearance() {
        this.effectiveAppearanceDirty = true;
        this.appearanceDirty = true;
        this.thisAp = this.goBetween.originalComponent.getAppearance();
        this.geometryDirtyBits = 63;
    }

    protected void handleChangedGeometry() {
        if (this.goBetween.peerGeometry != null) {
            if (this.geometryShader == null) {
                this.updateShaders();
            }
            if (this.geometryShader == null) {
                return;
            }
            if (this.geometryShader.pointShader != null && (this.geometryDirtyBits & 1) != 0) {
                this.geometryShader.pointShader.flushCachedState(this.jr);
            }
            if (this.geometryShader.lineShader != null && (this.geometryDirtyBits & 2) != 0) {
                this.geometryShader.lineShader.flushCachedState(this.jr);
            }
            if (this.geometryShader.polygonShader != null && (this.geometryDirtyBits & 4) != 0) {
                this.geometryShader.polygonShader.flushCachedState(this.jr);
            }
            if ((this.geometryDirtyBits & 8) != 0) {
                this.geometryShader.pointShader = null;
            }
            if ((this.geometryDirtyBits & 0x10) != 0) {
                this.geometryShader.lineShader = null;
            }
            if ((this.geometryDirtyBits & 0x20) != 0) {
                this.geometryShader.polygonShader = null;
            }
            if ((this.geometryDirtyBits & 0x38) != 0) {
                this.updateShaders();
            }
            this.geometryDirtyBits = 0;
        }
    }

    protected void propagateAppearanceChanged() {
        if (debug) {
            LoggingSystem.getLogger(this).finer("JOGLPeerComponent: propagate: " + this.name);
        }
        this.appearanceDirty = true;
        for (JOGLPeerComponent child : this.children) {
            child.propagateAppearanceChanged();
        }
        this.originalAppearanceDirty = false;
    }

    protected void propagateEffectiveAppearanceChanged() {
        if (debug) {
            LoggingSystem.getLogger(this).finer("JOGLPeerComponent: propagateeap: " + this.name);
        }
        this.appearanceDirty = true;
        this.effectiveAppearanceDirty = true;
        for (JOGLPeerComponent child : this.children) {
            child.propagateEffectiveAppearanceChanged();
        }
    }

    public void propagateGeometryChanged(int changed) {
        this.geometryDirtyBits |= changed;
        this.childlock.readLock();
        for (JOGLPeerComponent child : this.children) {
            child.propagateGeometryChanged(changed);
        }
        this.childlock.readUnlock();
    }

    private void handleAppearanceChanged() {
        if (this.originalAppearanceDirty) {
            this.propagateAppearanceChanged();
        }
        if (this.effectiveAppearanceDirty) {
            this.propagateEffectiveAppearanceChanged();
        }
        this.thisAp = this.goBetween.originalComponent.getAppearance();
        if (this.parent == null) {
            if (this.eAp == null || this.eAp.getAppearanceHierarchy().indexOf(this.thisAp) == -1) {
                this.eAp = EffectiveAppearance.create();
                if (this.thisAp != null) {
                    this.eAp = this.eAp.create(this.thisAp);
                }
            }
        } else {
            if (this.parent.eAp == null) {
                theLog.warning("Parent must have effective appearance" + this.parent.name);
                this.eAp = this.thisAp != null ? this.eAp.create(this.thisAp) : EffectiveAppearance.create();
            }
            if (this.effectiveAppearanceDirty || this.eAp == null) {
                if (debug) {
                    theLog.finer("updating eap for " + this.name);
                }
                this.eAp = this.thisAp != null ? this.parent.eAp.create(this.thisAp) : this.parent.eAp;
            }
        }
        this.updateShaders();
        this.effectiveAppearanceDirty = false;
        this.appearanceDirty = false;
    }

    protected void updateShaders() {
        if (this.eAp == null) {
            return;
        }
        this.metric = this.eAp.getAttribute("metric", 0);
        this.transparencyEnabled = this.eAp.getAttribute("transparencyEnabled", false);
        this.thisAp = this.goBetween.originalComponent.getAppearance();
        if (this.thisAp == null && this.goBetween.originalComponent.getGeometry() == null && this.parent != null) {
            this.geometryShader = this.parent.geometryShader;
        } else if (this.goBetween.originalComponent.getGeometry() != null) {
            if (debug) {
                theLog.log(Level.FINER, "Updating shaders for " + this.name);
            }
            if (this.geometryShader == null || this.parent == null || this.geometryShader == this.parent.geometryShader) {
                this.geometryShader = DefaultGeometryShader.createFromEffectiveAppearance(this.eAp, "");
            } else {
                this.geometryShader.setFromEffectiveAppearance(this.eAp, "");
            }
        }
        if (this.thisAp != null) {
            if (this.rhInfo == null) {
                this.rhInfo = new RenderingHintsInfo();
            }
            this.rhInfo.setFromAppearance(this.thisAp);
        }
    }

    protected boolean someSubNodeIsDirty() {
        if (this.isVisible && this.goBetween.peerGeometry != null && this.geometryDirtyBits != 0) {
            return true;
        }
        for (JOGLPeerComponent child : this.children) {
            if (!child.someSubNodeIsDirty()) continue;
            return true;
        }
        return false;
    }

    public void childAdded(SceneGraphComponentEvent ev) {
        if (debug) {
            theLog.finer("JOGLPeerComponent: Container Child added to: " + this.name);
        }
        switch (ev.getChildType()) {
            case 4: {
                this.renderRunnableDirty = true;
                break;
            }
            case 3: {
                SceneGraphComponent sgc = (SceneGraphComponent)ev.getNewChildElement();
                JOGLPeerComponent pc = ConstructPeerGraphVisitor.constructPeerForSceneGraphComponent(sgc, this, this.jr);
                this.childlock.writeLock();
                this.children.add(pc);
                this.childlock.writeUnlock();
                this.setIndexOfChildren();
                this.jr.lightListDirty = true;
                break;
            }
            case 1: {
                this.handleNewAppearance();
                if (!debug) break;
                theLog.log(Level.FINE, "Propagating geometry change due to added appearance");
                break;
            }
            case 5: {
                this.jr.lightListDirty = true;
                break;
            }
            case 7: {
                this.updateTransformationInfo();
                break;
            }
            default: {
                theLog.log(Level.INFO, "Taking no action for addition of child type " + ev.getChildType());
            }
        }
        this.jr.clippingPlanesDirty = true;
    }

    public void childRemoved(SceneGraphComponentEvent ev) {
        if (debug) {
            theLog.finer("Container Child removed from: " + this.name);
        }
        switch (ev.getChildType()) {
            case 4: {
                this.renderRunnableDirty = true;
                break;
            }
            case 3: {
                SceneGraphComponent sgc = (SceneGraphComponent)ev.getOldChildElement();
                JOGLPeerComponent jpc = this.getPeerForChildComponent(sgc);
                if (jpc == null) {
                    return;
                }
                this.childlock.writeLock();
                this.children.remove(jpc);
                jpc.dispose();
                this.childlock.writeUnlock();
                this.setIndexOfChildren();
                this.jr.lightListDirty = true;
                break;
            }
            case 1: {
                this.handleNewAppearance();
                if (!debug) break;
                theLog.log(Level.FINE, "Propagating geometry change due to removed appearance");
                break;
            }
            case 5: {
                this.jr.lightListDirty = true;
                break;
            }
            case 7: {
                this.updateTransformationInfo();
                break;
            }
            default: {
                theLog.log(Level.INFO, "Taking no action for removal of child type " + ev.getChildType());
            }
        }
        this.jr.clippingPlanesDirty = true;
    }

    public void childReplaced(SceneGraphComponentEvent ev) {
        if (debug) {
            theLog.finer("Container Child replaced at: " + this.name);
        }
        switch (ev.getChildType()) {
            case 4: {
                this.renderRunnableDirty = true;
                break;
            }
            case 1: {
                this.handleNewAppearance();
                if (!debug) break;
                theLog.log(Level.INFO, "Propagating geometry change due to replaced appearance");
                break;
            }
            case 5: {
                this.jr.lightListDirty = true;
                break;
            }
            case 7: {
                this.updateTransformationInfo();
                break;
            }
            default: {
                theLog.log(Level.INFO, "Taking no action for replacement of child type " + ev.getChildType());
            }
        }
        this.jr.clippingPlanesDirty = true;
    }

    public void transformationMatrixChanged(TransformationEvent ev) {
        this.updateTransformationInfo();
    }

    protected void updateTransformationInfo() {
        if (this.goBetween.originalComponent.getTransformation() != null) {
            this.isReflection = Rn.determinant(this.goBetween.originalComponent.getTransformation().getMatrix()) < 0.0;
            this.isIdentity = Rn.isIdentityMatrix(this.goBetween.originalComponent.getTransformation().getMatrix(), 1.0E-7);
            this.cachedTform = this.goBetween.originalComponent.getTransformation().getMatrix(this.cachedTform);
        } else {
            this.determinant = 0.0;
            this.isReflection = false;
            this.isIdentity = true;
            this.cachedTform = null;
        }
    }

    void setDisplayListDirty() {
        this.geometryDirtyBits = 7;
    }

    public SceneGraphComponent getOriginalComponent() {
        return this.goBetween.originalComponent;
    }

    public void visibilityChanged(SceneGraphComponentEvent ev) {
        this.isVisible = ev.getSceneGraphComponent().isVisible();
        this.jr.lightListDirty = true;
    }
}

