/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import com.sun.opengl.util.ImageUtil;
import de.jreality.jogl.JOGLConfiguration;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.util.ImageUtility;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLPbuffer;
import javax.swing.Timer;

public class JOGLOffscreenRenderer {
    private transient GLPbuffer offscreenPBuffer;
    private transient Buffer offscreenBuffer;
    private transient int tileSizeX = 1024;
    private transient int tileSizeY = 768;
    private transient int numTiles = 4;
    private transient int lastWidth = -1;
    private transient int lastHeight = -1;
    private JOGLRenderer jr;
    BufferedImage offscreenImage;
    boolean preMultiplied = false;
    private Timer followTimer;

    public JOGLOffscreenRenderer(JOGLRenderer jr) {
        this.jr = jr;
    }

    public void renderOffscreen(int imageWidth, int imageHeight, File file, GLAutoDrawable canvas) {
        BufferedImage img = this.renderOffscreen(imageWidth, imageHeight, canvas);
        ImageUtility.writeBufferedImage(file, img);
    }

    public void renderOffscreen(int imageWidth, int imageHeight, File file, GLContext context) {
        BufferedImage img = this.renderOffscreen(imageWidth, imageHeight, context);
        ImageUtility.writeBufferedImage(file, img);
    }

    public BufferedImage renderOffscreen(int imageWidth, int imageHeight, GLAutoDrawable canvas) {
        if (!GLDrawableFactory.getFactory().canCreateGLPbuffer()) {
            JOGLConfiguration.getLogger().log(Level.WARNING, "PBuffers not supported");
            return null;
        }
        this.jr.lightsChanged = true;
        this.numTiles = Math.max(imageWidth / 512, imageHeight / 512);
        if (this.numTiles == 0) {
            this.numTiles = 1;
        }
        this.tileSizeX = imageWidth / this.numTiles;
        this.tileSizeY = imageHeight / this.numTiles;
        this.tileSizeX = 4 * (this.tileSizeX / 4);
        this.tileSizeY = 4 * (this.tileSizeY / 4);
        imageWidth = this.tileSizeX * this.numTiles;
        imageHeight = this.tileSizeY * this.numTiles;
        GLCapabilities caps = new GLCapabilities();
        caps.setDoubleBuffered(false);
        caps.setAlphaBits(8);
        if (this.offscreenPBuffer == null || this.lastWidth != this.tileSizeX || this.lastHeight != this.tileSizeY) {
            System.err.println("Allocating new pbuffer");
            this.lastWidth = this.tileSizeX;
            this.lastHeight = this.tileSizeY;
            if (this.offscreenPBuffer != null) {
                this.offscreenPBuffer.destroy();
            }
            this.offscreenPBuffer = GLDrawableFactory.getFactory().createGLPbuffer(caps, null, this.tileSizeX, this.tileSizeY, canvas.getContext());
        }
        this.offscreenImage = new BufferedImage(imageWidth, imageHeight, 6);
        this.offscreenBuffer = ByteBuffer.wrap(((DataBufferByte)this.offscreenImage.getRaster().getDataBuffer()).getData());
        this.jr.offscreenMode = true;
        this.jr.lightListDirty = true;
        canvas.display();
        BufferedImage bi = ImageUtility.rearrangeChannels(this.offscreenImage);
        ImageUtil.flipImageVertically((BufferedImage)bi);
        bi.coerceData(true);
        return bi;
    }

    public BufferedImage renderOffscreen(int imageWidth, int imageHeight, GLContext context) {
        if (!GLDrawableFactory.getFactory().canCreateGLPbuffer()) {
            JOGLConfiguration.getLogger().log(Level.WARNING, "PBuffers not supported");
            return null;
        }
        this.jr.lightsChanged = true;
        this.numTiles = Math.max(imageWidth / 512, imageHeight / 512);
        if (this.numTiles == 0) {
            this.numTiles = 1;
        }
        this.tileSizeX = imageWidth / this.numTiles;
        this.tileSizeY = imageHeight / this.numTiles;
        imageWidth = this.tileSizeX * this.numTiles;
        imageHeight = this.tileSizeY * this.numTiles;
        GLCapabilities caps = new GLCapabilities();
        caps.setDoubleBuffered(false);
        caps.setAlphaBits(8);
        if (this.offscreenPBuffer == null || this.offscreenPBuffer.getWidth() != this.tileSizeX || this.offscreenPBuffer.getHeight() != this.tileSizeY) {
            this.offscreenPBuffer = GLDrawableFactory.getFactory().createGLPbuffer(caps, null, this.tileSizeX, this.tileSizeY, context);
        }
        this.offscreenImage = new BufferedImage(imageWidth, imageHeight, 6);
        this.offscreenBuffer = ByteBuffer.wrap(((DataBufferByte)this.offscreenImage.getRaster().getDataBuffer()).getData());
        this.jr.offscreenMode = true;
        this.jr.lightListDirty = true;
        this.jr.display(context.getGL());
        BufferedImage bi = ImageUtility.rearrangeChannels(this.offscreenImage);
        ImageUtil.flipImageVertically((BufferedImage)bi);
        bi.coerceData(true);
        return bi;
    }

    public GLPbuffer getOffscreenPBuffer() {
        return this.offscreenPBuffer;
    }

    public Buffer getOffscreenBuffer() {
        return this.offscreenBuffer;
    }

    public int getNumTiles() {
        return this.numTiles;
    }

    public int getTileSizeX() {
        return this.tileSizeX;
    }

    public int getTileSizeY() {
        return this.tileSizeY;
    }
}

