/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.geometry.Primitives;
import de.jreality.jogl.JOGLConfiguration;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.jogl.JOGLRendererHelper;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.util.CameraUtility;
import de.jreality.util.LoggingSystem;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.media.opengl.GL;

public class JOGLCylinderUtility {
    private static int numCyls = 6;
    private static IndexedFaceSet[] cylinderList = new IndexedFaceSet[numCyls];
    static boolean sharedDisplayLists = JOGLConfiguration.sharedContexts;
    static WeakHashMap<GL, int[]> cylinderDListsTable = new WeakHashMap();
    static int[] globalSharedCylinderDisplayLists = null;
    static double[] lodLevels = new double[]{0.02, 0.08, 0.16, 0.32, 0.64};

    private JOGLCylinderUtility() {
    }

    private static IndexedFaceSet getCylinder(int i) {
        if (cylinderList[i] == null) {
            JOGLCylinderUtility.cylinderList[i] = Primitives.cylinder(2 ^ i);
        }
        return cylinderList[i];
    }

    public static void setupCylinderDLists(JOGLRenderer jr) {
        int[] dlists = null;
        GL gl = jr.globalGL;
        int n = 6;
        dlists = null;
        dlists = new int[n];
        JOGLConfiguration.theLog.log(Level.INFO, "Setting up cylinder display lists for context " + gl);
        int nv = 4;
        for (int i = 0; i < n; ++i) {
            dlists[i] = gl.glGenLists(1);
            LoggingSystem.getLogger(JOGLCylinderUtility.class).fine("Allocating new dlist " + dlists[i]);
            gl.glNewList(dlists[i], 4864);
            IndexedFaceSet cyl = Primitives.cylinder(nv);
            nv *= 2;
            JOGLRendererHelper.drawFaces(jr, cyl, true, 1.0);
            gl.glEndList();
        }
        if (!sharedDisplayLists) {
            cylinderDListsTable.put(jr.globalGL, dlists);
        } else {
            globalSharedCylinderDisplayLists = dlists;
        }
    }

    public static int getCylinderDLists(int i, JOGLRenderer jr) {
        int[] dlists = JOGLCylinderUtility.getCylinderDLists(jr);
        if (dlists == null) {
            JOGLConfiguration.getLogger().log(Level.WARNING, "Invalid cylinder display lists");
            return 0;
        }
        return dlists[i];
    }

    public static int[] getCylinderDLists(JOGLRenderer jr) {
        int[] dlists = !sharedDisplayLists ? cylinderDListsTable.get(jr.globalGL) : globalSharedCylinderDisplayLists;
        if (dlists == null) {
            JOGLCylinderUtility.setupCylinderDLists(jr);
            dlists = !sharedDisplayLists ? cylinderDListsTable.get(jr.globalGL) : globalSharedCylinderDisplayLists;
        }
        if (dlists == null) {
            throw new IllegalStateException("Can't make cylinder display lists successfully");
        }
        return dlists;
    }

    public static void disposeCylinderDLists(JOGLRenderer jr) {
        if (!sharedDisplayLists) {
            cylinderDListsTable.remove(jr);
        }
    }

    public static int getResolutionLevel(double[] o2ndc, double lod) {
        double d = lod * CameraUtility.getNDCExtent(o2ndc);
        int i = 0;
        for (i = 0; i < 5 && !(d < lodLevels[i]); ++i) {
        }
        return i;
    }
}

