/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.util.LoggingSystem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class IntegratorFactory {
    private HashSet uniforms = new HashSet();
    private HashSet signatures = new HashSet();
    private HashMap<String, String> methods = new HashMap();
    private HashSet constants = new HashSet();
    private IntegrationScheme scheme;
    String overwrittenMain = null;

    private IntegratorFactory(IntegrationScheme scheme) {
        this.scheme = scheme;
        this.addUniform("h", "float");
        this.addUniform("r3", "bool");
        this.addUniform("values", "samplerRect");
    }

    public static IntegratorFactory euler() {
        return new IntegratorFactory(IntegrationScheme.EULER);
    }

    public static IntegratorFactory midpoint() {
        return new IntegratorFactory(IntegrationScheme.MIDPOINT);
    }

    public static IntegratorFactory rk2() {
        return new IntegratorFactory(IntegrationScheme.RK2);
    }

    public static IntegratorFactory rk4() {
        return new IntegratorFactory(IntegrationScheme.RK4);
    }

    public void addUniform(String name, String type) {
        this.uniforms.add("uniform " + type + " " + name + ";");
    }

    public void addConstant(String definition) {
        this.constants.add(definition);
    }

    public void addMethod(String name, String retType, String params, String implementation) {
        String signature = retType + " " + name + "(" + params + ")";
        String impl = "{\n" + implementation + "}\n";
        this.signatures.add(signature);
        String prevImpl = this.methods.put(signature, impl);
        if (prevImpl != null) {
            LoggingSystem.getLogger(IntegratorFactory.class).info("Overwriting glsl method: " + signature);
        }
    }

    public void srcT0(String impl) {
        if (this.scheme == IntegrationScheme.MIDPOINT) {
            throw new IllegalStateException("no such method for midpoint rule");
        }
        this.addMethod("evaluateT0", "vec4", "const vec4 point", impl);
    }

    public void srcT0_H2(String impl) {
        if (this.scheme == IntegrationScheme.EULER) {
            throw new IllegalStateException("no such method for euler");
        }
        this.addMethod("evaluateT0_H2", "vec4", "const vec4 point", impl);
    }

    public void srcT0_H(String impl) {
        if (this.scheme != IntegrationScheme.RK4) {
            throw new IllegalStateException("no such method for RK4");
        }
        this.addMethod("evaluateT0_H", "vec4", "const vec4 point", impl);
    }

    public void srcAll(String impl) {
        if (this.scheme != IntegrationScheme.MIDPOINT) {
            this.srcT0(impl);
        }
        if (this.scheme != IntegrationScheme.EULER) {
            this.srcT0_H2(impl);
        }
        if (this.scheme == IntegrationScheme.RK4) {
            this.srcT0_H(impl);
        }
    }

    public void overwriteMain(String src) {
        this.overwrittenMain = src;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.constants.iterator();
        while (i.hasNext()) {
            sb.append(i.next()).append('\n');
        }
        i = this.uniforms.iterator();
        while (i.hasNext()) {
            sb.append(i.next()).append('\n');
        }
        sb.append('\n');
        i = this.signatures.iterator();
        while (i.hasNext()) {
            sb.append(i.next()).append(';').append('\n');
        }
        sb.append('\n');
        if (this.overwrittenMain == null) {
            sb.append(this.scheme.src);
        } else {
            sb.append("void main() {\n").append(this.overwrittenMain).append('\n').append('}').append('\n');
        }
        for (Map.Entry<String, String> m : this.methods.entrySet()) {
            sb.append(m.getKey() + m.getValue()).append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum IntegrationScheme {
        EULER("void main(void) {  vec2 pos = gl_TexCoord[0].st;\n  vec4 pt = textureRect(values, pos);\n  vec4 res = pt + h*evaluateT0(pt);\n  if (r3) res.w = 1.;\n  gl_FragColor = res;\n}\n"),
        MIDPOINT("void main(void) {  vec2 pos = gl_TexCoord[0].st;\n  vec4 pt = textureRect(values, pos);\n  vec4 res = pt + h*evaluateT0_H2(pt);\n  if (r3) res.w = 1.;\n  gl_FragColor = res;\n}\n"),
        RK2("void main(void) {  vec2 pos = gl_TexCoord[0].st;\n  vec4 pt = textureRect(values, pos);\n  vec4 k1 = h * evaluateT0(pt);\n  vec4 k2 = h * evaluateT0_H2(pt+k1/2.);\n  vec4 res = pt + k2;\n  if (r3) res.w = 1.;\n  gl_FragColor = res;\n}\n"),
        RK4("void main(void) {  vec2 pos = gl_TexCoord[0].st;\n  vec4 pt = textureRect(values, pos);\n  vec4 k1 = h * evaluateT0(pt);\n  vec4 k2 = h * evaluateT0_H2(pt+k1/2.);\n  vec4 k3 = h * evaluateT0_H2(pt+k2/2.);\n  vec4 k4 = h * evaluateT0_H(pt+k3);\n  vec4 res = pt + (k1 + 2.*(k2 + k3) + k4)/6.;\n  if (r3) res.w = 1.;\n  gl_FragColor = res;\n}\n");

        String src;

        private IntegrationScheme(String src) {
            this.src = src;
        }
    }
}

